/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkParameterTypes", "function", "checkUninitializedParameter", "checkValOrVarParameter", "checkVarargParameters", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirFunctionParameterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFunctionParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n766#2:130\n857#2,2:131\n*S KotlinDebug\n*F\n+ 1 FirFunctionParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker\n*L\n57#1:130\n57#1:131,2\n*E\n"})
public final class FirFunctionParameterChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirFunctionParameterChecker INSTANCE = new FirFunctionParameterChecker();

    private FirFunctionParameterChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkVarargParameters(declaration, context, reporter);
        this.checkParameterTypes(declaration, context, reporter);
        this.checkUninitializedParameter(declaration, context, reporter);
        this.checkValOrVarParameter(declaration, context, reporter);
    }

    private final void checkParameterTypes(FirFunction function2, CheckerContext context, DiagnosticReporter reporter) {
        if (function2 instanceof FirAnonymousFunction) {
            return;
        }
        for (FirValueParameter valueParameter2 : function2.getValueParameters()) {
            ConeDiagnostic diagnostic;
            FirTypeRef returnTypeRef = valueParameter2.getReturnTypeRef();
            if (!(returnTypeRef instanceof FirErrorTypeRef)) continue;
            KtSourceElement ktSourceElement = returnTypeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE) || !((diagnostic = ((FirErrorTypeRef)returnTypeRef).getDiagnostic()) instanceof ConeSimpleDiagnostic) || ((ConeSimpleDiagnostic)diagnostic).getKind() != DiagnosticKind.ValueParameterWithNoTypeAnnotation) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getVALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION(), (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(FirFunction function2, CheckerContext context, DiagnosticReporter reporter) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = function2.getValueParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirValueParameter it = (FirValueParameter)element$iv$iv;
            boolean bl = false;
            if (!it.isVararg()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            for (FirValueParameter parameter2 : varargParameters) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirErrors.INSTANCE.getMULTIPLE_VARARG_PARAMETERS(), (DiagnosticContext)context, null, 8, null);
            }
        }
        ConeKotlinType nullableNothingType = FirTypeUtilsKt.getConeType(context.getSession().getBuiltinTypes().getNullableNothingType());
        for (FirValueParameter varargParameter : varargParameters) {
            ConeKotlinType varargParameterType;
            if (ArrayUtilsKt.arrayElementType(FirTypeUtilsKt.getConeType(varargParameter.getReturnTypeRef())) == null || !AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context.getSession()), (KotlinTypeMarker)varargParameterType, (KotlinTypeMarker)nullableNothingType, false, 8, null) && (!FirHelpersKt.isValueClass(varargParameterType, context.getSession()) || ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(varargParameterType))) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)varargParameter.getSource(), FirErrors.INSTANCE.getFORBIDDEN_VARARG_PARAMETER_TYPE(), (Object)varargParameterType, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkUninitializedParameter(FirFunction function2, CheckerContext context, DiagnosticReporter reporter) {
        Iterator<FirValueParameter> iterator2 = function2.getValueParameters().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            FirValueParameter parameter2 = iterator2.next();
            FirExpression firExpression2 = parameter2.getDefaultValue();
            if (firExpression2 == null) continue;
            firExpression2.accept(new FirVisitorVoid(function2, index2, reporter, context){
                final /* synthetic */ FirFunction $function;
                final /* synthetic */ int $index;
                final /* synthetic */ DiagnosticReporter $reporter;
                final /* synthetic */ CheckerContext $context;
                {
                    this.$function = $function;
                    this.$index = $index;
                    this.$reporter = $reporter;
                    this.$context = $context;
                }

                public void visitElement(@NotNull FirElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    element.acceptChildren(this);
                }

                public void visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression) {
                    Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
                    FirValueParameterSymbol firValueParameterSymbol = FirReferenceUtilsKt.toResolvedValueParameterSymbol$default(qualifiedAccessExpression.getCalleeReference(), false, 1, null);
                    if (firValueParameterSymbol == null) {
                        return;
                    }
                    FirValueParameterSymbol referredParameter = firValueParameterSymbol;
                    int referredParameterIndex = this.$function.getValueParameters().indexOf(referredParameter.getFir());
                    if (referredParameterIndex < 0) {
                        return;
                    }
                    if (this.$index <= referredParameterIndex) {
                        KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)qualifiedAccessExpression.getSource(), FirErrors.INSTANCE.getUNINITIALIZED_PARAMETER(), (Object)referredParameter, (DiagnosticContext)this.$context, null, 16, null);
                    }
                }

                public void visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression) {
                    Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
                    this.visitQualifiedAccessExpression(propertyAccessExpression);
                }
            });
        }
    }

    private final void checkValOrVarParameter(FirFunction function2, CheckerContext context, DiagnosticReporter reporter) {
        if (function2 instanceof FirConstructor && ((FirConstructor)function2).isPrimary()) {
            return;
        }
        for (FirValueParameter valueParameter2 : function2.getValueParameters()) {
            KtKeywordToken it;
            KtSourceElement source;
            KtSourceElement ktSourceElement = source = valueParameter2.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            if (FirKeywordUtilsKt.getValOrVarKeyword(source) == null) continue;
            boolean bl = false;
            if (function2 instanceof FirConstructor) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER(), (Object)it, (DiagnosticContext)context, null, 16, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_FUN_PARAMETER(), (Object)it, (DiagnosticContext)context, null, 16, null);
        }
    }
}

