/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FastStackAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackInterpreter;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackValue;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 '2\u00020\u0001:\u0002'(B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020\u0013J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0013J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0013J\u001a\u0010#\u001a\f\u0018\u00010$R\u00060\fR\u00020\u00002\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020\u0013J\b\u0010&\u001a\u00020\u001cH\u0002R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR6\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010j\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "skipBreakContinueGotoEdges", "", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;Z)V", "analyzer", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer;", "getContext", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "loopEntryPointMarkers", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/utils/SmartList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/HashMap;", "maxExtraStackSize", "", "getMaxExtraStackSize", "()I", "getMethod", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "analyze", "", "getActualStack", "", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackValue;", "location", "getActualStackSize", "getExpectedStackSize", "getFrame", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame;", "getStackToSpill", "recordLoopEntryPointMarkers", "Companion", "InternalAnalyzer", "backend"})
@SourceDebugExtension(value={"SMAP\nFixStackAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,223:1\n361#2,7:224\n*S KotlinDebug\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer\n*L\n85#1:224,7\n*E\n"})
public final class FixStackAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MethodNode method;
    @NotNull
    private final FixStackContext context;
    private final boolean skipBreakContinueGotoEdges;
    @NotNull
    private final HashMap<LabelNode, SmartList<AbstractInsnNode>> loopEntryPointMarkers;
    @NotNull
    private final InternalAnalyzer analyzer;
    public static final int DEAD_CODE_STACK_SIZE = -1;

    public FixStackAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull FixStackContext context, boolean skipBreakContinueGotoEdges) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.method = method;
        this.context = context;
        this.skipBreakContinueGotoEdges = skipBreakContinueGotoEdges;
        this.loopEntryPointMarkers = new HashMap();
        this.analyzer = new InternalAnalyzer(owner);
    }

    public /* synthetic */ FixStackAnalyzer(String string2, MethodNode methodNode, FixStackContext fixStackContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(string2, methodNode, fixStackContext, bl);
    }

    @NotNull
    public final MethodNode getMethod() {
        return this.method;
    }

    @NotNull
    public final FixStackContext getContext() {
        return this.context;
    }

    public final int getMaxExtraStackSize() {
        return this.analyzer.getMaxExtraStackSize();
    }

    @Nullable
    public final List<FixStackValue> getStackToSpill(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.analyzer.getSpilledStacks().get(location);
    }

    @Nullable
    public final List<FixStackValue> getActualStack(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        InternalAnalyzer.FixStackFrame fixStackFrame = this.getFrame(location);
        return fixStackFrame != null ? fixStackFrame.getStackContent() : null;
    }

    public final int getActualStackSize(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        InternalAnalyzer.FixStackFrame fixStackFrame = this.getFrame(location);
        return fixStackFrame != null ? fixStackFrame.getStackSizeWithExtra() : -1;
    }

    public final int getExpectedStackSize(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        SmartList smartList = (SmartList)((Map)this.loopEntryPointMarkers).get(location);
        List expectedStackSizeNodes = smartList != null ? (List)smartList : CollectionsKt.listOf((Object)location);
        for (AbstractInsnNode node : expectedStackSizeNodes) {
            InternalAnalyzer.FixStackFrame fixStackFrame = this.getFrame(node);
            if (fixStackFrame == null) continue;
            InternalAnalyzer.FixStackFrame frame = fixStackFrame;
            return frame.getStackSizeWithExtra();
        }
        return -1;
    }

    private final InternalAnalyzer.FixStackFrame getFrame(AbstractInsnNode location) {
        Frame frame = this.analyzer.getFrame(location);
        return frame instanceof InternalAnalyzer.FixStackFrame ? (InternalAnalyzer.FixStackFrame)frame : null;
    }

    public final void analyze() {
        this.recordLoopEntryPointMarkers();
        this.analyzer.analyze();
    }

    /*
     * WARNING - void declaration
     */
    private final void recordLoopEntryPointMarkers() {
        for (AbstractInsnNode marker : this.context.getFakeAlwaysFalseIfeqMarkers()) {
            Object object;
            LabelNode key$iv;
            void $this$getOrPut$iv;
            AbstractInsnNode next = marker.getNext();
            if (!(next instanceof JumpInsnNode)) continue;
            Map map = this.loopEntryPointMarkers;
            Intrinsics.checkNotNullExpressionValue((Object)((JumpInsnNode)next).label, (String)"next.label");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                SmartList answer$iv = new SmartList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((SmartList)object).add(marker);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$Companion;", "", "()V", "DEAD_CODE_STACK_SIZE", "", "backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0014J\u001c\u0010\u001c\u001a\u00020\u001d*\n0\u001eR\u00060\u0000R\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u001c\u0010 \u001a\u00020\u001d*\n0\u001eR\u00060\u0000R\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u001c\u0010!\u001a\u00020\u001d*\n0\u001eR\u00060\u0000R\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u001c\u0010\"\u001a\u00020\u001d*\n0\u001eR\u00060\u0000R\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u001c\u0010#\u001a\u00020\u001d*\n0\u001eR\u00060\u0000R\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rH\u0002R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR9\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\fj\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FastStackAnalyzer;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackValue;", "owner", "", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;Ljava/lang/String;)V", "<set-?>", "", "maxExtraStackSize", "getMaxExtraStackSize", "()I", "spilledStacks", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "", "Lkotlin/collections/HashMap;", "getSpilledStacks", "()Ljava/util/HashMap;", "indexOf", "node", "newFrame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "nLocals", "nStack", "visitControlFlowEdge", "", "insn", "successor", "executeAfterInlineCallMarker", "", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "executeBeforeInlineCallMarker", "executeRestoreStackInTryCatch", "executeSaveStackBeforeTry", "saveStackAndClear", "FixStackFrame", "backend"})
    private final class InternalAnalyzer
    extends FastStackAnalyzer<FixStackValue> {
        @NotNull
        private final HashMap<AbstractInsnNode, List<FixStackValue>> spilledStacks;
        private int maxExtraStackSize;

        public InternalAnalyzer(String owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner, FixStackAnalyzer.this.getMethod(), new FixStackInterpreter());
            this.spilledStacks = new HashMap();
        }

        @NotNull
        public final HashMap<AbstractInsnNode, List<FixStackValue>> getSpilledStacks() {
            return this.spilledStacks;
        }

        public final int getMaxExtraStackSize() {
            return this.maxExtraStackSize;
        }

        @Override
        protected boolean visitControlFlowEdge(int insn, int successor) {
            if (!FixStackAnalyzer.this.skipBreakContinueGotoEdges) {
                return true;
            }
            AbstractInsnNode insnNode = this.getInsnsArray()[insn];
            return !(insnNode instanceof JumpInsnNode) || !FixStackAnalyzer.this.getContext().getBreakContinueGotoNodes().contains(insnNode);
        }

        @Override
        @NotNull
        protected Frame<FixStackValue> newFrame(int nLocals, int nStack) {
            return new FixStackFrame(nLocals, nStack);
        }

        private final int indexOf(AbstractInsnNode node) {
            return this.getMethod().instructions.indexOf(node);
        }

        private final void executeBeforeInlineCallMarker(FixStackFrame $this$executeBeforeInlineCallMarker, AbstractInsnNode insn) {
            this.saveStackAndClear($this$executeBeforeInlineCallMarker, insn);
        }

        private final void saveStackAndClear(FixStackFrame $this$saveStackAndClear, AbstractInsnNode insn) {
            List<FixStackValue> savedValues = $this$saveStackAndClear.getStackContent();
            ((Map)this.spilledStacks).put(insn, savedValues);
            $this$saveStackAndClear.clearStack();
        }

        private final void executeAfterInlineCallMarker(FixStackFrame $this$executeAfterInlineCallMarker, AbstractInsnNode insn) {
            AbstractInsnNode beforeInlineMarker = FixStackAnalyzer.this.getContext().getOpeningInlineMethodMarker().get(insn);
            if ($this$executeAfterInlineCallMarker.getStackSize() > 0) {
                List savedValues;
                FixStackValue returnValue = $this$executeAfterInlineCallMarker.pop();
                $this$executeAfterInlineCallMarker.clearStack();
                List list2 = savedValues = (List)((Map)this.spilledStacks).get(beforeInlineMarker);
                Intrinsics.checkNotNull((Object)list2);
                $this$executeAfterInlineCallMarker.pushAll(list2);
                $this$executeAfterInlineCallMarker.push(returnValue);
            } else {
                List savedValues;
                List list3 = savedValues = (List)((Map)this.spilledStacks).get(beforeInlineMarker);
                Intrinsics.checkNotNull((Object)list3);
                $this$executeAfterInlineCallMarker.pushAll(list3);
            }
        }

        private final void executeRestoreStackInTryCatch(FixStackFrame $this$executeRestoreStackInTryCatch, AbstractInsnNode insn) {
            AbstractInsnNode saveNode = FixStackAnalyzer.this.getContext().getSaveStackMarkerForRestoreMarker().get(insn);
            Map map = this.spilledStacks;
            AbstractInsnNode abstractInsnNode = saveNode;
            Intrinsics.checkNotNull((Object)abstractInsnNode);
            Object v = map.get(abstractInsnNode);
            if (v == null) {
                boolean bl = false;
                throw new AssertionError((Object)(this.indexOf(insn) + ": Restore stack is unavailable for " + this.indexOf(saveNode)));
            }
            List savedValues = (List)v;
            $this$executeRestoreStackInTryCatch.pushAll(savedValues);
        }

        private final void executeSaveStackBeforeTry(FixStackFrame $this$executeSaveStackBeforeTry, AbstractInsnNode insn) {
            this.saveStackAndClear($this$executeSaveStackBeforeTry, insn);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001H\u0016J&\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0014\u0010\u001f\u001a\u00020\u000f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0002H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackValue;", "nLocals", "", "nStack", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer;II)V", "extraStack", "Lcom/intellij/util/containers/Stack;", "getExtraStack", "()Lcom/intellij/util/containers/Stack;", "stackSizeWithExtra", "getStackSizeWithExtra", "()I", "clearStack", "", "execute", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "getStackContent", "", "init", "src", "merge", "", "frame", "pop", "push", "value", "pushAll", "values", "", "setStack", "i", "backend"})
        @SourceDebugExtension(value={"SMAP\nFixStackAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1855#2,2:224\n*S KotlinDebug\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame\n*L\n161#1:224,2\n*E\n"})
        public final class FixStackFrame
        extends Frame<FixStackValue> {
            @NotNull
            private final Stack<FixStackValue> extraStack;

            public FixStackFrame(int nLocals, int nStack) {
                super(nLocals, nStack);
                this.extraStack = new Stack();
            }

            @NotNull
            public final Stack<FixStackValue> getExtraStack() {
                return this.extraStack;
            }

            @NotNull
            public Frame<FixStackValue> init(@NotNull Frame<? extends FixStackValue> src) {
                Intrinsics.checkNotNullParameter(src, (String)"src");
                this.extraStack.clear();
                this.extraStack.addAll((Collection)((FixStackFrame)src).extraStack);
                Frame frame = super.init(src);
                Intrinsics.checkNotNullExpressionValue((Object)frame, (String)"super.init(src)");
                return frame;
            }

            public void clearStack() {
                this.extraStack.clear();
                super.clearStack();
            }

            public void execute(@NotNull AbstractInsnNode insn, @NotNull Interpreter<FixStackValue> interpreter2) {
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
                if (PseudoInsn.SAVE_STACK_BEFORE_TRY.isa(insn)) {
                    InternalAnalyzer.this.executeSaveStackBeforeTry(this, insn);
                } else if (PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.isa(insn)) {
                    InternalAnalyzer.this.executeRestoreStackInTryCatch(this, insn);
                } else if (InlineCodegenUtilsKt.isBeforeInlineMarker(insn)) {
                    InternalAnalyzer.this.executeBeforeInlineCallMarker(this, insn);
                } else if (InlineCodegenUtilsKt.isAfterInlineMarker(insn)) {
                    InternalAnalyzer.this.executeAfterInlineCallMarker(this, insn);
                } else if (insn.getOpcode() == 177) {
                    return;
                }
                super.execute(insn, interpreter2);
            }

            public final int getStackSizeWithExtra() {
                return super.getStackSize() + this.extraStack.size();
            }

            @NotNull
            public final List<FixStackValue> getStackContent() {
                ArrayList<Value> savedStack = new ArrayList<Value>();
                int n = super.getStackSize();
                for (int i = 0; i < n; ++i) {
                    savedStack.add(super.getStack(i));
                }
                savedStack.addAll((Collection)this.extraStack);
                return savedStack;
            }

            public void push(@NotNull FixStackValue value2) {
                Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
                if (super.getStackSize() < this.getMaxStackSize()) {
                    super.push((Value)value2);
                } else {
                    this.extraStack.add((Object)value2);
                    InternalAnalyzer.this.maxExtraStackSize = Math.max(InternalAnalyzer.this.getMaxExtraStackSize(), this.extraStack.size());
                }
            }

            public final void pushAll(@NotNull Collection<? extends FixStackValue> values2) {
                Intrinsics.checkNotNullParameter(values2, (String)"values");
                Iterable $this$forEach$iv = values2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FixStackValue it = (FixStackValue)((Object)element$iv);
                    boolean bl = false;
                    this.push(it);
                }
            }

            @NotNull
            public FixStackValue pop() {
                FixStackValue fixStackValue;
                if (!((Collection)this.extraStack).isEmpty()) {
                    Object object = this.extraStack.pop();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                    ex\u2026k.pop()\n                }");
                    fixStackValue = (FixStackValue)((Object)object);
                } else {
                    Value value2 = super.pop();
                    Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"{\n                    su\u2026r.pop()\n                }");
                    fixStackValue = (FixStackValue)value2;
                }
                return fixStackValue;
            }

            public void setStack(int i, @NotNull FixStackValue value2) {
                Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
                if (i < super.getMaxStackSize()) {
                    super.setStack(i, (Value)value2);
                } else {
                    this.extraStack.set(i - this.getMaxStackSize(), (Object)value2);
                }
            }

            public boolean merge(@NotNull Frame<? extends FixStackValue> frame, @NotNull Interpreter<FixStackValue> interpreter2) {
                Intrinsics.checkNotNullParameter(frame, (String)"frame");
                Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
                throw new UnsupportedOperationException("Stack normalization should not merge frames");
            }
        }
    }
}

