/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0005H\u0002\u001a:\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0005\u001a\u0016\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0003\u00a8\u0006\u0014"}, d2={"appendElementFullName", "", "declaration", "Lorg/jetbrains/kotlin/ir/IrElement;", "expectActualTypesMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "typeAliasMap", "Lorg/jetbrains/kotlin/name/FqName;", "generateIrElementFullName", "", "reportManyInterfacesMembersNotImplemented", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "actualMember", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "reportMissingActual", "irElement", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrActualizerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrActualizerUtils.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class IrActualizerUtilsKt {
    @NotNull
    public static final String generateIrElementFullName(@NotNull IrElement declaration, @NotNull Map<IrSymbol, ? extends IrSymbol> expectActualTypesMap, @Nullable Map<FqName, FqName> typeAliasMap) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(expectActualTypesMap, (String)"expectActualTypesMap");
        StringBuilder $this$generateIrElementFullName_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        IrActualizerUtilsKt.appendElementFullName(declaration, expectActualTypesMap, $this$generateIrElementFullName_u24lambda_u240, typeAliasMap);
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply { \u2026ypeAliasMap) }.toString()");
        return string2;
    }

    public static /* synthetic */ String generateIrElementFullName$default(IrElement irElement, Map map, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = null;
        }
        return IrActualizerUtilsKt.generateIrElementFullName(irElement, map, map2);
    }

    private static final void appendElementFullName(IrElement declaration, Map<IrSymbol, ? extends IrSymbol> expectActualTypesMap, StringBuilder result2, Map<FqName, FqName> typeAliasMap) {
        if (!(declaration instanceof IrDeclarationBase)) {
            return;
        }
        FqName parentName = AdditionalIrUtilsKt.getKotlinFqName(((IrDeclarationBase)declaration).getParent());
        String string2 = parentName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parentName.asString()");
        if (((CharSequence)string2).length() > 0) {
            Map<FqName, FqName> map = typeAliasMap;
            if (map == null || (map = map.get(parentName)) == null) {
                String string3 = parentName.asString();
                map = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parentName.asString()");
            }
            result2.append(map);
            result2.append('.');
        }
        if (declaration instanceof IrDeclarationWithName) {
            result2.append(((IrDeclarationWithName)declaration).getName());
        }
        if (declaration instanceof IrFunction) {
            IrType extensionReceiverType2;
            IrValueParameter irValueParameter = ((IrFunction)declaration).getExtensionReceiverParameter();
            IrType irType = extensionReceiverType2 = irValueParameter != null ? irValueParameter.getType() : null;
            if (extensionReceiverType2 != null) {
                result2.append('[');
                IrActualizerUtilsKt.appendElementFullName$appendType(expectActualTypesMap, result2, extensionReceiverType2);
                result2.append(']');
            }
            result2.append('(');
            Iterator<IrValueParameter> iterator2 = ((IrFunction)declaration).getValueParameters().iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index2 = n++;
                IrValueParameter parameter2 = iterator2.next();
                IrActualizerUtilsKt.appendElementFullName$appendType(expectActualTypesMap, result2, parameter2.getType());
                if (index2 >= ((IrFunction)declaration).getValueParameters().size() - 1) continue;
                result2.append(',');
            }
            result2.append(')');
        }
    }

    static /* synthetic */ void appendElementFullName$default(IrElement irElement, Map map, StringBuilder stringBuilder2, Map map2, int n, Object object) {
        if ((n & 8) != 0) {
            map2 = null;
        }
        IrActualizerUtilsKt.appendElementFullName(irElement, map, stringBuilder2, map2);
    }

    public static final void reportMissingActual(@NotNull IrElement irElement) {
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        throw new AssertionError((Object)("Missing actual for " + RenderIrElementKt.render(irElement)));
    }

    public static final void reportManyInterfacesMembersNotImplemented(@NotNull IrClass declaration, @NotNull IrDeclarationWithName actualMember) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)actualMember, (String)"actualMember");
        throw new AssertionError((Object)(declaration.getName() + " must override " + actualMember.getName() + " because it inherits multiple interface methods of it"));
    }

    private static final void appendElementFullName$appendType(Map<IrSymbol, ? extends IrSymbol> $expectActualTypesMap, StringBuilder $result, IrType type2) {
        IrClassifierSymbol typeClassifier = IrTypesKt.getClassifierOrFail(type2);
        IrSymbol irSymbol2 = $expectActualTypesMap.get(typeClassifier);
        if (irSymbol2 == null) {
            irSymbol2 = typeClassifier;
        }
        IrSymbol actualizedTypeSymbol = irSymbol2;
        IrActualizerUtilsKt.appendElementFullName$default(actualizedTypeSymbol.getOwner(), $expectActualTypesMap, $result, null, 8, null);
    }
}

