/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualCollector;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualLinker;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizer;
import org.jetbrains.kotlin.backend.common.actualizer.MissingFakeOverridesAdder;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ>\u0010\t\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J*\u0010\u000f\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/IrActualizer;", "", "()V", "actualize", "", "mainFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependentFragments", "", "addMissingFakeOverrides", "expectActualMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "typeAliasMap", "Lorg/jetbrains/kotlin/name/FqName;", "linkExpectToActual", "mergeIrFragments", "removeExpectDeclaration", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrActualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrActualizer.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1#2:46\n1855#3,2:47\n1855#3,2:49\n1360#3:51\n1446#3,5:52\n*S KotlinDebug\n*F\n+ 1 IrActualizer.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizer\n*L\n35#1:47,2\n39#1:49,2\n43#1:51\n43#1:52,5\n*E\n"})
public final class IrActualizer {
    @NotNull
    public static final IrActualizer INSTANCE = new IrActualizer();

    private IrActualizer() {
    }

    public final void actualize(@NotNull IrModuleFragment mainFragment, @NotNull List<? extends IrModuleFragment> dependentFragments) {
        Intrinsics.checkNotNullParameter((Object)mainFragment, (String)"mainFragment");
        Intrinsics.checkNotNullParameter(dependentFragments, (String)"dependentFragments");
        Pair<Map<IrSymbol, IrSymbol>, Map<FqName, FqName>> pair = new ExpectActualCollector(mainFragment, dependentFragments).collect();
        Map expectActualMap = (Map)pair.component1();
        Map typeAliasMap = (Map)pair.component2();
        this.removeExpectDeclaration(dependentFragments);
        this.addMissingFakeOverrides(expectActualMap, dependentFragments, typeAliasMap);
        this.linkExpectToActual(expectActualMap, dependentFragments);
        this.mergeIrFragments(mainFragment, dependentFragments);
    }

    private final void removeExpectDeclaration(List<? extends IrModuleFragment> dependentFragments) {
        for (IrModuleFragment irModuleFragment : dependentFragments) {
            for (IrFile file2 : irModuleFragment.getFiles()) {
                CollectionsKt.removeAll(file2.getDeclarations(), (Function1)removeExpectDeclaration.1.INSTANCE);
            }
        }
    }

    private final void addMissingFakeOverrides(Map<IrSymbol, ? extends IrSymbol> expectActualMap, List<? extends IrModuleFragment> dependentFragments, Map<FqName, FqName> typeAliasMap) {
        MissingFakeOverridesAdder missingFakeOverridesAdder;
        MissingFakeOverridesAdder $this$addMissingFakeOverrides_u24lambda_u241 = missingFakeOverridesAdder = new MissingFakeOverridesAdder(expectActualMap, typeAliasMap);
        boolean bl = false;
        Iterable $this$forEach$iv = dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl2 = false;
            $this$addMissingFakeOverrides_u24lambda_u241.visitModuleFragment(it);
        }
    }

    private final void linkExpectToActual(Map<IrSymbol, ? extends IrSymbol> expectActualMap, List<? extends IrModuleFragment> dependentFragments) {
        ExpectActualLinker expectActualLinker2;
        ExpectActualLinker $this$linkExpectToActual_u24lambda_u243 = expectActualLinker2 = new ExpectActualLinker(expectActualMap);
        boolean bl = false;
        Iterable $this$forEach$iv = dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl2 = false;
            $this$linkExpectToActual_u24lambda_u243.actualize(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeIrFragments(IrModuleFragment mainFragment, List<? extends IrModuleFragment> dependentFragments) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = dependentFragments;
        int n = 0;
        List<IrFile> list2 = mainFragment.getFiles();
        boolean $i$f$flatMap = false;
        void var5_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        list2.addAll(n, list3);
    }
}

