/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirErrorImport;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedParentInImport;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\t*\u00020\tH\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0011H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\t*\u00020\tH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/psi/KtFile;", "()V", "checkPsiOrLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isClassIdPointingToEnumEntry", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "processErrorImport", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorImport;", "dotQualifiedExpression", "getOutermostClassName", "", "selectorExpression", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnresolvedInMiddleOfImportChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnresolvedInMiddleOfImportChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n90#3:98\n37#4:99\n1747#5,3:100\n*S KotlinDebug\n*F\n+ 1 FirUnresolvedInMiddleOfImportChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker\n*L\n89#1:98\n89#1:99\n90#1:100,3\n*E\n"})
public final class FirUnresolvedInMiddleOfImportChecker
extends FirDeclarationSyntaxChecker<FirFile, KtFile> {
    @NotNull
    public static final FirUnresolvedInMiddleOfImportChecker INSTANCE = new FirUnresolvedInMiddleOfImportChecker();

    private FirUnresolvedInMiddleOfImportChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirFile element, @NotNull KtSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirImport firImport : element.getImports()) {
            if (!(firImport instanceof FirErrorImport)) continue;
            this.processErrorImport((FirErrorImport)firImport, context, reporter);
        }
    }

    private final void processErrorImport(FirErrorImport firErrorImport, CheckerContext context, DiagnosticReporter reporter) {
        ConeDiagnostic diagnostic = firErrorImport.getDiagnostic();
        if (diagnostic instanceof ConeUnresolvedParentInImport) {
            KtSourceElement ktSourceElement;
            KtSourceElement ktSourceElement2 = firErrorImport.getSource();
            if (ktSourceElement2 == null) {
                return;
            }
            KtSourceElement source = ktSourceElement2;
            KtSourceElement ktSourceElement3 = this.dotQualifiedExpression(source);
            if (ktSourceElement3 == null) {
                return;
            }
            KtSourceElement segmentSource = ktSourceElement3;
            FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(context.getSession());
            ClassId parentClassId = ((ConeUnresolvedParentInImport)diagnostic).getParentClassId();
            if (firErrorImport.isAllUnder() && this.isClassIdPointingToEnumEntry(parentClassId, symbolProvider)) {
                AbstractKtSourceElement abstractKtSourceElement = source;
                KtDiagnosticFactory1<Name> ktDiagnosticFactory1 = FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON();
                Name name = parentClassId.getShortClassName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"parentClassId.shortClassName");
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)name, (DiagnosticContext)context, null, 16, null);
                return;
            }
            int errorSegmentIndexFromLast = firErrorImport.isAllUnder() ? 0 : 1;
            ClassId currentClassId = parentClassId.getParentClassId();
            while (currentClassId != null && symbolProvider.getClassLikeSymbolByClassId(currentClassId) == null) {
                currentClassId = currentClassId.getParentClassId();
                ++errorSegmentIndexFromLast;
            }
            int i = 1;
            int n = errorSegmentIndexFromLast;
            if (i <= n) {
                while (true) {
                    KtSourceElement ktSourceElement4 = segmentSource;
                    KtSourceElement ktSourceElement5 = segmentSource = ktSourceElement4 != null ? this.dotQualifiedExpression(ktSourceElement4) : null;
                    if (i == n) break;
                    ++i;
                }
            }
            if ((ktSourceElement = segmentSource) == null || (ktSourceElement = this.selectorExpression(ktSourceElement)) == null) {
                return;
            }
            KtSourceElement unresolvedSource = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unresolvedSource, FirErrors.INSTANCE.getUNRESOLVED_IMPORT(), (Object)this.getOutermostClassName(parentClassId), (DiagnosticContext)context, null, 16, null);
        }
    }

    private final String getOutermostClassName(ClassId $this$getOutermostClassName) {
        List<Name> list2 = $this$getOutermostClassName.getRelativeClassName().pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"relativeClassName.pathSegments()");
        String string2 = ((Name)CollectionsKt.first(list2)).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"relativeClassName.pathSe\u2026ents().first().asString()");
        return string2;
    }

    private final boolean isClassIdPointingToEnumEntry(ClassId classId, FirSymbolProvider symbolProvider) {
        boolean bl;
        block8: {
            Object object;
            block10: {
                block9: {
                    ClassId classId2 = classId.getParentClassId();
                    if (classId2 == null) {
                        return false;
                    }
                    ClassId enumClassId = classId2;
                    FirClassLikeSymbol<?> firClassLikeSymbol = symbolProvider.getClassLikeSymbolByClassId(enumClassId);
                    object = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                    if (object == null) break block9;
                    Object object2 = object;
                    FirRegularClassSymbol it = object2;
                    boolean bl2 = false;
                    FirClassSymbol $this$isEnumClass$iv = it;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    object = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS ? object2 : null;
                    if (object != null) break block10;
                }
                return false;
            }
            FirRegularClassSymbol enumClass2 = object;
            Iterable $this$any$iv = DeclarationUtilsKt.collectEnumEntries(enumClass2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getCallableId().getCallableName(), (Object)classId.getShortClassName())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final KtSourceElement dotQualifiedExpression(KtSourceElement $this$dotQualifiedExpression) {
        IElementType iElementType = KtNodeTypes.DOT_QUALIFIED_EXPRESSION;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"DOT_QUALIFIED_EXPRESSION");
        return FirSourceUtilsKt.getChild$default($this$dotQualifiedExpression, iElementType, 0, 1, false, 10, null);
    }

    private final KtSourceElement selectorExpression(KtSourceElement $this$selectorExpression) {
        IElementType iElementType = KtNodeTypes.REFERENCE_EXPRESSION;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"REFERENCE_EXPRESSION");
        return FirSourceUtilsKt.getChild$default($this$selectorExpression, iElementType, 0, 1, true, 2, null);
    }
}

