/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.deserialization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.deserialization.AbstractFirDeserializedSymbolProvider;
import org.jetbrains.kotlin.fir.deserialization.FirBuiltinAnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.deserialization.ModuleDataProvider;
import org.jetbrains.kotlin.fir.deserialization.PackagePartsCacheData;
import org.jetbrains.kotlin.fir.java.deserialization.ProviderUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.KotlinMetadataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPartProvider;
import org.jetbrains.kotlin.serialization.deserialization.MetadataUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014J\u001c\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014J\u0018\u0010,\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/MetadataSymbolProvider;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleDataProvider", "Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "packagePartProvider", "Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;", "kotlinClassFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;", "defaultDeserializationOrigin", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;)V", "annotationDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/FirBuiltinAnnotationDeserializer;", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder;", "constDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "metadataPartProvider", "Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPartProvider;", "computePackagePartsInfos", "", "Lorg/jetbrains/kotlin/fir/deserialization/PackagePartsCacheData;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "computePackageSetWithNonClassDeclarations", "", "", "extractClassMetadata", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "parentContext", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "getPackage", "", "fqName", "isNewPlaceForBodyGeneration", "", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "knownTopLevelClassesInPackage", "java"})
@SourceDebugExtension(value={"SMAP\nMetadataSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataSymbolProvider.kt\norg/jetbrains/kotlin/fir/java/deserialization/MetadataSymbolProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1603#2,9:86\n1855#2:95\n1856#2:97\n1612#2:98\n1#3:96\n*S KotlinDebug\n*F\n+ 1 MetadataSymbolProvider.kt\norg/jetbrains/kotlin/fir/java/deserialization/MetadataSymbolProvider\n*L\n44#1:86,9\n44#1:95\n44#1:97\n44#1:98\n44#1:96\n*E\n"})
public final class MetadataSymbolProvider
extends AbstractFirDeserializedSymbolProvider {
    @NotNull
    private final PackagePartProvider packagePartProvider;
    @NotNull
    private final KotlinMetadataFinder kotlinClassFinder;
    @NotNull
    private final MetadataPartProvider metadataPartProvider;
    @NotNull
    private final MetadataClassDataFinder classDataFinder;
    @NotNull
    private final FirBuiltinAnnotationDeserializer annotationDeserializer;
    @NotNull
    private final FirConstDeserializer constDeserializer;

    public MetadataSymbolProvider(@NotNull FirSession session, @NotNull ModuleDataProvider moduleDataProvider, @NotNull FirKotlinScopeProvider kotlinScopeProvider, @NotNull PackagePartProvider packagePartProvider, @NotNull KotlinMetadataFinder kotlinClassFinder, @NotNull FirDeclarationOrigin defaultDeserializationOrigin) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)moduleDataProvider, (String)"moduleDataProvider");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider, (String)"kotlinScopeProvider");
        Intrinsics.checkNotNullParameter((Object)packagePartProvider, (String)"packagePartProvider");
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        Intrinsics.checkNotNullParameter((Object)defaultDeserializationOrigin, (String)"defaultDeserializationOrigin");
        super(session, moduleDataProvider, kotlinScopeProvider, defaultDeserializationOrigin, BuiltInSerializerProtocol.INSTANCE);
        this.packagePartProvider = packagePartProvider;
        this.kotlinClassFinder = kotlinClassFinder;
        PackagePartProvider packagePartProvider2 = this.packagePartProvider;
        Intrinsics.checkNotNull((Object)packagePartProvider2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.serialization.deserialization.MetadataPartProvider");
        this.metadataPartProvider = (MetadataPartProvider)((Object)packagePartProvider2);
        this.classDataFinder = new MetadataClassDataFinder(this.kotlinClassFinder);
        this.annotationDeserializer = new FirBuiltinAnnotationDeserializer(session);
        this.constDeserializer = new FirConstDeserializer(session, BuiltInSerializerProtocol.INSTANCE);
    }

    public /* synthetic */ MetadataSymbolProvider(FirSession firSession, ModuleDataProvider moduleDataProvider, FirKotlinScopeProvider firKotlinScopeProvider, PackagePartProvider packagePartProvider, KotlinMetadataFinder kotlinMetadataFinder, FirDeclarationOrigin firDeclarationOrigin, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            firDeclarationOrigin = FirDeclarationOrigin.Library.INSTANCE;
        }
        this(firSession, moduleDataProvider, firKotlinScopeProvider, packagePartProvider, kotlinMetadataFinder, firDeclarationOrigin);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<PackagePartsCacheData> computePackagePartsInfos(@NotNull FqName packageFqName) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        String string2 = packageFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageFqName.asString()");
        Iterable $this$mapNotNull$iv = this.metadataPartProvider.findMetadataPackageParts(string2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PackagePartsCacheData packagePartsCacheData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String partName = (String)element$iv$iv;
            boolean bl2 = false;
            if (ProviderUtilsKt.getKotlinBuiltins().contains(partName)) {
                packagePartsCacheData = null;
            } else {
                ClassId classId = new ClassId(packageFqName, Name.identifier(partName));
                if (this.kotlinClassFinder.findMetadata(classId) == null) {
                    packagePartsCacheData = null;
                } else {
                    InputStream stream;
                    Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> triple = MetadataUtilKt.readProto(stream);
                    ProtoBuf.PackageFragment proto = (ProtoBuf.PackageFragment)triple.component1();
                    NameResolverImpl nameResolver2 = (NameResolverImpl)triple.component2();
                    ProtoBuf.Package package_ = proto.getPackage();
                    Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"proto.`package`");
                    FirDeserializationContext context = FirDeserializationContext.Companion.createForPackage(packageFqName, package_, nameResolver2, (FirModuleData)CollectionsKt.last((Iterable)this.getModuleDataProvider().getAllModuleData()), this.annotationDeserializer, this.constDeserializer, null);
                    ProtoBuf.Package package_2 = proto.getPackage();
                    Intrinsics.checkNotNullExpressionValue((Object)package_2, (String)"proto.`package`");
                    packagePartsCacheData = new PackagePartsCacheData(package_2, context);
                }
            }
            if (packagePartsCacheData == null) continue;
            PackagePartsCacheData it$iv$iv = packagePartsCacheData;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected Set<String> computePackageSetWithNonClassDeclarations() {
        return this.packagePartProvider.computePackageSetWithNonClassDeclarations();
    }

    @Override
    @Nullable
    protected Set<String> knownTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return this.kotlinClassFinder.findMetadataTopLevelClassesInPackage(packageFqName);
    }

    @Override
    @Nullable
    protected AbstractFirDeserializedSymbolProvider.ClassMetadataFindResult extractClassMetadata(@NotNull ClassId classId, @Nullable FirDeserializationContext parentContext) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        ClassData classData = this.classDataFinder.findClassData(classId);
        if (classData == null) {
            return null;
        }
        ClassData classData2 = classData;
        return new AbstractFirDeserializedSymbolProvider.ClassMetadataFindResult.Metadata(classData2.getNameResolver(), classData2.getClassProto(), null, (FirModuleData)CollectionsKt.last((Iterable)this.getModuleDataProvider().getAllModuleData()), null, null);
    }

    @Override
    protected boolean isNewPlaceForBodyGeneration(@NotNull ProtoBuf.Class classProto) {
        Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
        return false;
    }

    @Nullable
    public Void getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return null;
    }
}

