/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import com.intellij.psi.PsiElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationUnit;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationRuntimeException;
import org.jetbrains.kotlin.js.facade.exceptions.UnsupportedFeatureException;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.FileDeclarationVisitor;
import org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AstGenerationResult;
import org.jetbrains.kotlin.js.translate.general.NormalizeImportTagsKt;
import org.jetbrains.kotlin.js.translate.general.SourceFileTranslationResult;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.test.JSTestGenerator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.AssignToExpressionMutator;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.constants.UnsignedValueConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.js.ast.JsAstProtoBuf;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public final class Translation {
    private static final String ENUM_SIGNATURE = "kotlin$Enum";

    private Translation() {
    }

    @NotNull
    public static PatternTranslator patternTranslator(@NotNull TranslationContext context) {
        if (context == null) {
            Translation.$$$reportNull$$$0(0);
        }
        PatternTranslator patternTranslator = PatternTranslator.newInstance(context);
        if (patternTranslator == null) {
            Translation.$$$reportNull$$$0(1);
        }
        return patternTranslator;
    }

    @NotNull
    public static JsNode translateExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(2);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(3);
        }
        return Translation.translateExpression(expression2, context, context.dynamicContext().jsBlock());
    }

    @NotNull
    public static JsNode translateExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context, @NotNull JsBlock block) {
        JsExpression constantResult;
        KotlinType type2;
        JsExpression aliasForExpression;
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(4);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(5);
        }
        if (block == null) {
            Translation.$$$reportNull$$$0(6);
        }
        if ((aliasForExpression = context.aliasingContext().getAliasForExpression(expression2)) != null) {
            JsExpression jsExpression = aliasForExpression;
            if (jsExpression == null) {
                Translation.$$$reportNull$$$0(7);
            }
            return jsExpression;
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, context.bindingContext());
        if (compileTimeValue != null && !compileTimeValue.getUsesNonConstValAsConstant() && (type2 = context.bindingContext().getType(expression2)) != null && (KotlinBuiltIns.isLong(type2) || KotlinBuiltIns.isInt(type2)) && (constantResult = Translation.translateConstant(compileTimeValue, expression2, context)) != null) {
            constantResult.setSource(expression2);
            if (KotlinBuiltIns.isLong(type2)) {
                DeclarationDescriptor descriptor2;
                KtSimpleNameExpression referenceExpression2 = PsiUtils.getSimpleName(expression2);
                if (referenceExpression2 != null && (descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), referenceExpression2)) != null) {
                    JsExpression jsExpression = context.declareConstantValue(descriptor2, referenceExpression2, constantResult);
                    if (jsExpression == null) {
                        Translation.$$$reportNull$$$0(8);
                    }
                    return jsExpression;
                }
                String name2 = NameSuggestion.sanitizeName("L" + compileTimeValue.getValue(type2).toString());
                JsExpression jsExpression = context.declareConstantValue(name2, "constant:" + name2, constantResult, null);
                if (jsExpression == null) {
                    Translation.$$$reportNull$$$0(9);
                }
                return jsExpression;
            }
            if (KotlinBuiltIns.isInt(type2)) {
                JsExpression jsExpression = constantResult;
                if (jsExpression == null) {
                    Translation.$$$reportNull$$$0(10);
                }
                return jsExpression;
            }
        }
        TranslationContext innerContext = context.innerBlock();
        JsNode result2 = Translation.doTranslateExpression(expression2, innerContext);
        context.moveVarsFrom(innerContext);
        block.getStatements().addAll(innerContext.dynamicContext().jsBlock().getStatements());
        JsNode jsNode = result2;
        if (jsNode == null) {
            Translation.$$$reportNull$$$0(11);
        }
        return jsNode;
    }

    @Nullable
    public static JsExpression translateConstant(@NotNull CompileTimeConstant compileTimeValue, @NotNull KtExpression expression2, @NotNull TranslationContext context) {
        KotlinType expectedType;
        ConstantValue constant;
        JsExpression result2;
        if (compileTimeValue == null) {
            Translation.$$$reportNull$$$0(12);
        }
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(13);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(14);
        }
        if ((result2 = Translation.translateConstantWithoutType(constant = compileTimeValue.toConstantValue((expectedType = context.bindingContext().getType(expression2)) != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE), context)) != null) {
            MetadataProperties.setType(result2, expectedType);
        }
        return result2;
    }

    @Nullable
    private static JsExpression translateConstantWithoutType(@NotNull ConstantValue<?> constant, @NotNull TranslationContext context) {
        if (constant == null) {
            Translation.$$$reportNull$$$0(15);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(16);
        }
        if (constant instanceof NullValue) {
            return new JsNullLiteral();
        }
        if (constant instanceof UnsignedValueConstant) {
            return Translation.translateUnsignedConstant((UnsignedValueConstant)constant, context);
        }
        Object value2 = constant.getValue();
        if (value2 instanceof Integer || value2 instanceof Short || value2 instanceof Byte) {
            return new JsIntLiteral(((Number)value2).intValue());
        }
        if (value2 instanceof Long) {
            return JsAstUtils.newLong((Long)value2);
        }
        if (value2 instanceof Float) {
            float floatValue = ((Float)value2).floatValue();
            double doubleValue = Float.isInfinite(floatValue) || Float.isNaN(floatValue) ? (double)floatValue : Double.parseDouble(Float.toString(floatValue));
            return new JsDoubleLiteral(doubleValue);
        }
        if (value2 instanceof Number) {
            return new JsDoubleLiteral(((Number)value2).doubleValue());
        }
        if (value2 instanceof Boolean) {
            return new JsBooleanLiteral((Boolean)value2);
        }
        if (value2 instanceof String) {
            return new JsStringLiteral((String)value2);
        }
        if (value2 instanceof Character) {
            return new JsIntLiteral(((Character)value2).charValue());
        }
        return null;
    }

    @Nullable
    private static JsExpression translateUnsignedConstant(@NotNull UnsignedValueConstant<?> unsignedConstant, @NotNull TranslationContext context) {
        if (unsignedConstant == null) {
            Translation.$$$reportNull$$$0(17);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(18);
        }
        if (unsignedConstant instanceof UByteValue) {
            return JsAstUtils.byteToUByte((Byte)((UByteValue)unsignedConstant).getValue(), context);
        }
        if (unsignedConstant instanceof UShortValue) {
            return JsAstUtils.shortToUShort((Short)((UShortValue)unsignedConstant).getValue(), context);
        }
        if (unsignedConstant instanceof UIntValue) {
            return JsAstUtils.intToUInt((Integer)((UIntValue)unsignedConstant).getValue(), context);
        }
        if (unsignedConstant instanceof ULongValue) {
            Long value2 = (Long)((ULongValue)unsignedConstant).getValue();
            JsExpression longExpression = JsAstUtils.newLong(value2);
            return JsAstUtils.longToULong(longExpression, context);
        }
        return null;
    }

    @NotNull
    private static JsNode doTranslateExpression(KtExpression expression2, TranslationContext context) {
        JsNode jsNode;
        try {
            jsNode = expression2.accept(new ExpressionVisitor(), context);
        }
        catch (TranslationRuntimeException e) {
            throw e;
        }
        catch (AssertionError | RuntimeException e) {
            throw new TranslationRuntimeException((PsiElement)expression2, (Throwable)e);
        }
        if (jsNode == null) {
            Translation.$$$reportNull$$$0(19);
        }
        return jsNode;
    }

    @NotNull
    public static JsExpression translateAsExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(20);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(21);
        }
        return Translation.translateAsExpression(expression2, context, context.dynamicContext().jsBlock());
    }

    @NotNull
    public static JsExpression translateAsExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context, @NotNull JsBlock block) {
        JsNode jsNode;
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(22);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(23);
        }
        if (block == null) {
            Translation.$$$reportNull$$$0(24);
        }
        if ((jsNode = Translation.translateExpression(expression2, context, block)) instanceof JsExpression) {
            JsExpression jsExpression = (JsExpression)jsNode;
            KotlinType type2 = context.bindingContext().getType(expression2);
            if (MetadataProperties.getType(jsExpression) == null) {
                MetadataProperties.setType(jsExpression, type2);
            } else if (type2 != null) {
                jsExpression = TranslationUtils.coerce(context, jsExpression, type2);
            }
            JsExpression jsExpression2 = jsExpression;
            if (jsExpression2 == null) {
                Translation.$$$reportNull$$$0(25);
            }
            return jsExpression2;
        }
        assert (jsNode instanceof JsStatement) : "Unexpected node of type: " + jsNode.getClass().toString();
        if (BindingContextUtilsKt.isUsedAsExpression(expression2, context.bindingContext())) {
            TemporaryVariable result2 = context.declareTemporary(null, expression2);
            AssignToExpressionMutator saveResultToTemporaryMutator = new AssignToExpressionMutator(result2.reference());
            block.getStatements().add(LastExpressionMutator.mutateLastExpression(jsNode, saveResultToTemporaryMutator));
            JsNameRef tmpVar = result2.reference();
            MetadataProperties.setType(tmpVar, context.bindingContext().getType(expression2));
            JsNameRef jsNameRef = tmpVar;
            if (jsNameRef == null) {
                Translation.$$$reportNull$$$0(26);
            }
            return jsNameRef;
        }
        block.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        JsExpression jsExpression = new JsNullLiteral().source(expression2);
        if (jsExpression == null) {
            Translation.$$$reportNull$$$0(27);
        }
        return jsExpression;
    }

    @NotNull
    public static JsStatement translateAsStatement(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(28);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(29);
        }
        return Translation.translateAsStatement(expression2, context, context.dynamicContext().jsBlock());
    }

    @NotNull
    public static JsStatement translateAsStatement(@NotNull KtExpression expression2, @NotNull TranslationContext context, @NotNull JsBlock block) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(30);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(31);
        }
        if (block == null) {
            Translation.$$$reportNull$$$0(32);
        }
        JsStatement jsStatement = JsAstUtils.convertToStatement(Translation.translateExpression(expression2, context, block));
        if (jsStatement == null) {
            Translation.$$$reportNull$$$0(33);
        }
        return jsStatement;
    }

    @NotNull
    public static JsStatement translateAsStatementAndMergeInBlockIfNeeded(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(34);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(35);
        }
        JsBlock block = new JsBlock();
        JsNode node = Translation.translateExpression(expression2, context, block);
        JsStatement jsStatement = JsAstUtils.mergeStatementInBlockIfNeeded(JsAstUtils.convertToStatement(node), block);
        if (jsStatement == null) {
            Translation.$$$reportNull$$$0(36);
        }
        return jsStatement;
    }

    @NotNull
    public static AstGenerationResult generateAst(@NotNull BindingTrace bindingTrace, @NotNull Collection<TranslationUnit> units, @NotNull MainCallParameters mainCallParameters, @NotNull ModuleDescriptor moduleDescriptor, @NotNull JsConfig config, @NotNull SourceFilePathResolver sourceFilePathResolver) throws TranslationException {
        if (bindingTrace == null) {
            Translation.$$$reportNull$$$0(37);
        }
        if (units == null) {
            Translation.$$$reportNull$$$0(38);
        }
        if (mainCallParameters == null) {
            Translation.$$$reportNull$$$0(39);
        }
        if (moduleDescriptor == null) {
            Translation.$$$reportNull$$$0(40);
        }
        if (config == null) {
            Translation.$$$reportNull$$$0(41);
        }
        if (sourceFilePathResolver == null) {
            Translation.$$$reportNull$$$0(42);
        }
        try {
            return Translation.doGenerateAst(bindingTrace, units, mainCallParameters, moduleDescriptor, config, sourceFilePathResolver);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFeatureException("Unsupported feature used.", e);
        }
        catch (Throwable e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
    }

    @NotNull
    private static AstGenerationResult doGenerateAst(@NotNull BindingTrace bindingTrace, @NotNull Collection<TranslationUnit> units, @NotNull MainCallParameters mainCallParameters, @NotNull ModuleDescriptor moduleDescriptor, @NotNull JsConfig config, @NotNull SourceFilePathResolver sourceFilePathResolver) throws IOException {
        if (bindingTrace == null) {
            Translation.$$$reportNull$$$0(43);
        }
        if (units == null) {
            Translation.$$$reportNull$$$0(44);
        }
        if (mainCallParameters == null) {
            Translation.$$$reportNull$$$0(45);
        }
        if (moduleDescriptor == null) {
            Translation.$$$reportNull$$$0(46);
        }
        if (config == null) {
            Translation.$$$reportNull$$$0(47);
        }
        if (sourceFilePathResolver == null) {
            Translation.$$$reportNull$$$0(48);
        }
        HashMap<String, TranslationUnit> inlineFunctionTagMap = new HashMap<String, TranslationUnit>();
        LinkedHashMap<KtFile, SourceFileTranslationResult> translatedSourceFiles = new LinkedHashMap<KtFile, SourceFileTranslationResult>();
        for (TranslationUnit unit2 : units) {
            if (unit2 instanceof TranslationUnit.SourceFile) {
                TranslationUnit.SourceFile sourceFileUnit = (TranslationUnit.SourceFile)unit2;
                KtFile file2 = sourceFileUnit.getFile();
                StaticContext staticContext = new StaticContext(bindingTrace, config, moduleDescriptor, sourceFilePathResolver, file2.getPackageFqName().asString());
                TranslationContext context = TranslationContext.rootContext(staticContext);
                ArrayList<DeclarationDescriptor> fileMemberScope = new ArrayList<DeclarationDescriptor>();
                Translation.translateFile(context, file2, fileMemberScope);
                JsProgramFragment fragment = staticContext.getFragment();
                for (String tag : staticContext.getInlineFunctionTags()) {
                    assert (!inlineFunctionTagMap.containsKey(tag)) : "Duplicate inline function tag found: '" + tag + "'";
                    inlineFunctionTagMap.put(tag, unit2);
                }
                NormalizeImportTagsKt.normalizeImportTags(fragment);
                fragment.setTests(Translation.mayBeGenerateTests(context, file2, fileMemberScope));
                fragment.setMainFunction(Translation.maybeGenerateCallToMain(context, config, moduleDescriptor, fileMemberScope, mainCallParameters));
                translatedSourceFiles.put(file2, new SourceFileTranslationResult(fragment, staticContext.getInlineFunctionTags(), fileMemberScope));
                continue;
            }
            if (!(unit2 instanceof TranslationUnit.BinaryAst)) continue;
            byte[] inlineDataArray = ((TranslationUnit.BinaryAst)unit2).getInlineData();
            JsAstProtoBuf.InlineData h = JsAstProtoBuf.InlineData.parseFrom(CodedInputStream.newInstance(inlineDataArray));
            for (String tag : h.getInlineFunctionTagsList()) {
                assert (!inlineFunctionTagMap.containsKey(tag)) : "Duplicate inline function tag found: '" + tag + "'";
                inlineFunctionTagMap.put(tag, unit2);
            }
        }
        return new AstGenerationResult(units, translatedSourceFiles, inlineFunctionTagMap, moduleDescriptor, config);
    }

    private static void translateFile(@NotNull TranslationContext context, @NotNull KtFile file2, @NotNull List<DeclarationDescriptor> fileMemberScope) {
        if (context == null) {
            Translation.$$$reportNull$$$0(49);
        }
        if (file2 == null) {
            Translation.$$$reportNull$$$0(50);
        }
        if (fileMemberScope == null) {
            Translation.$$$reportNull$$$0(51);
        }
        FileDeclarationVisitor fileVisitor = new FileDeclarationVisitor(context);
        try {
            for (KtDeclaration declaration : file2.getDeclarations()) {
                DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForElement(context.bindingContext(), declaration);
                fileMemberScope.add(descriptor2);
                if (AnnotationsUtils.isPredefinedObject(descriptor2)) continue;
                declaration.accept(fileVisitor, context);
            }
        }
        catch (TranslationRuntimeException e) {
            throw e;
        }
        catch (AssertionError | RuntimeException e) {
            throw new TranslationRuntimeException((PsiElement)file2, (Throwable)e);
        }
    }

    @Nullable
    private static JsStatement mayBeGenerateTests(@NotNull TranslationContext context, @NotNull KtFile file2, @NotNull List<DeclarationDescriptor> fileMemberScope) {
        if (context == null) {
            Translation.$$$reportNull$$$0(52);
        }
        if (file2 == null) {
            Translation.$$$reportNull$$$0(53);
        }
        if (fileMemberScope == null) {
            Translation.$$$reportNull$$$0(54);
        }
        return new JSTestGenerator(context).generateTestCalls(file2, fileMemberScope);
    }

    @Nullable
    private static JsStatement maybeGenerateCallToMain(@NotNull TranslationContext context, @NotNull JsConfig config, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<DeclarationDescriptor> fileMemberScope, @NotNull MainCallParameters mainCallParameters) {
        if (context == null) {
            Translation.$$$reportNull$$$0(55);
        }
        if (config == null) {
            Translation.$$$reportNull$$$0(56);
        }
        if (moduleDescriptor == null) {
            Translation.$$$reportNull$$$0(57);
        }
        if (fileMemberScope == null) {
            Translation.$$$reportNull$$$0(58);
        }
        if (mainCallParameters == null) {
            Translation.$$$reportNull$$$0(59);
        }
        if (!mainCallParameters.shouldBeGenerated()) {
            return null;
        }
        MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(context.bindingContext(), config.getLanguageVersionSettings());
        CallableDescriptor functionDescriptor = null;
        for (DeclarationDescriptor d : fileMemberScope) {
            if (!mainFunctionDetector.isMain(d)) continue;
            functionDescriptor = (FunctionDescriptor)d;
        }
        if (functionDescriptor == null) {
            return null;
        }
        int parameterCount = functionDescriptor.getValueParameters().size();
        assert (parameterCount <= 1);
        ArrayList<JsExpression> args = new ArrayList<JsExpression>();
        if (parameterCount != 0) {
            args.add(new JsArrayLiteral(JsAstUtils.toStringLiteralList(mainCallParameters.arguments())));
        }
        if (functionDescriptor.isSuspend()) {
            MemberScope scope2 = moduleDescriptor.getPackage(new FqNameUnsafe("kotlin.coroutines.js.internal").toSafe()).getMemberScope();
            PropertyDescriptor emptyContinuation = DescriptorUtils.getPropertyByName(scope2, Name.identifier("EmptyContinuation"));
            args.add(ReferenceTranslator.translateAsValueReference(emptyContinuation, context));
            args.add(new JsBooleanLiteral(false));
        }
        JsExpression call2 = CallTranslator.INSTANCE.buildCall(context, (FunctionDescriptor)functionDescriptor, args, null);
        return call2.makeStmt();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 36: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/general/Translation";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 20: 
            case 22: 
            case 28: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileTimeValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsignedConstant";
                break;
            }
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingTrace";
                break;
            }
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "units";
                break;
            }
            case 39: 
            case 45: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainCallParameters";
                break;
            }
            case 40: 
            case 46: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 41: 
            case 47: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePathResolver";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 51: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileMemberScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/general/Translation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "patternTranslator";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExpression";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doTranslateExpression";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsExpression";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsStatement";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsStatementAndMergeInBlockIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "patternTranslator";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 36: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "translateExpression";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "translateConstant";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "translateConstantWithoutType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "translateUnsignedConstant";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "translateAsExpression";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "translateAsStatement";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "translateAsStatementAndMergeInBlockIfNeeded";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateAst";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateAst";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "translateFile";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "mayBeGenerateTests";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "maybeGenerateCallToMain";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 36: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

