/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.AppendableDataExternalizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B'\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u00a2\u0006\u0002\u0010\tJ*\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/CollectionExternalizer;", "T", "Lorg/jetbrains/kotlin/incremental/storage/AppendableDataExternalizer;", "", "elementExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "newCollection", "Lkotlin/Function0;", "", "(Lcom/intellij/util/io/DataExternalizer;Lkotlin/jvm/functions/Function0;)V", "append", "currentValue", "appendData", "createNil", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "value", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nexternalizers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 externalizers.kt\norg/jetbrains/kotlin/incremental/storage/CollectionExternalizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,475:1\n1855#2,2:476\n*S KotlinDebug\n*F\n+ 1 externalizers.kt\norg/jetbrains/kotlin/incremental/storage/CollectionExternalizer\n*L\n309#1:476,2\n*E\n"})
public class CollectionExternalizer<T>
implements AppendableDataExternalizer<Collection<? extends T>> {
    @NotNull
    private final DataExternalizer<T> elementExternalizer;
    @NotNull
    private final Function0<Collection<T>> newCollection;

    public CollectionExternalizer(@NotNull DataExternalizer<T> elementExternalizer, @NotNull Function0<? extends Collection<T>> newCollection) {
        Intrinsics.checkNotNullParameter(elementExternalizer, (String)"elementExternalizer");
        Intrinsics.checkNotNullParameter(newCollection, (String)"newCollection");
        this.elementExternalizer = elementExternalizer;
        this.newCollection = newCollection;
    }

    @NotNull
    public Collection<T> read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Collection result2 = (Collection)this.newCollection.invoke();
        DataInputStream stream = (DataInputStream)input;
        while (stream.available() > 0) {
            result2.add(this.elementExternalizer.read((DataInput)stream));
        }
        return result2;
    }

    public void save(@NotNull DataOutput output, @NotNull Collection<? extends T> value2) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Iterable $this$forEach$iv = value2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            this.elementExternalizer.save(output, it);
        }
    }

    @Override
    @NotNull
    public Collection<T> createNil() {
        return (Collection)this.newCollection.invoke();
    }

    @Override
    @NotNull
    public Collection<T> append(@NotNull Collection<? extends T> currentValue, @NotNull Collection<? extends T> appendData) {
        Collection<? extends T> collection;
        Intrinsics.checkNotNullParameter(currentValue, (String)"currentValue");
        Intrinsics.checkNotNullParameter(appendData, (String)"appendData");
        if (TypeIntrinsics.isMutableCollection(currentValue)) {
            TypeIntrinsics.asMutableCollection(currentValue).addAll(appendData);
            collection = currentValue;
        } else {
            collection = CollectionsKt.plus(currentValue, (Iterable)appendData);
        }
        return collection;
    }
}

