/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.references.ReferenceAccess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/references/SyntheticPropertyAccessorReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "expression", "getter", "", "(Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;Z)V", "getGetter", "()Z", "resolvesByNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "canBeReferenceTo", "candidateTarget", "Lcom/intellij/psi/PsiElement;", "canRename", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "isAccessorName", "name", "", "kt-references"})
public abstract class SyntheticPropertyAccessorReference
extends KtSimpleReference<KtNameReferenceExpression> {
    private final boolean getter;

    public SyntheticPropertyAccessorReference(@NotNull KtNameReferenceExpression expression2, boolean getter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super((KtReferenceExpression)expression2);
        this.getter = getter2;
    }

    public final boolean getGetter() {
        return this.getter;
    }

    protected final boolean isAccessorName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (this.getter) {
            return StringsKt.startsWith$default((String)name2, (String)"get", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"is", (boolean)false, (int)2, null);
        }
        return StringsKt.startsWith$default((String)name2, (String)"set", (boolean)false, (int)2, null);
    }

    @Override
    protected boolean canBeReferenceTo(@NotNull PsiElement candidateTarget) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)candidateTarget, (String)"candidateTarget");
                if (!(candidateTarget instanceof PsiMethod)) break block4;
                String string2 = ((PsiMethod)candidateTarget).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"candidateTarget.name");
                if (this.isAccessorName(string2)) break block5;
            }
            return false;
        }
        if (this.getter && !LightClassUtilsKt.getCanHaveSyntheticGetter((PsiMethod)candidateTarget) || !this.getter && !LightClassUtilsKt.getCanHaveSyntheticSetter((PsiMethod)candidateTarget)) {
            return false;
        }
        return this.getter || ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)this.getExpression(), true) != ReferenceAccess.READ;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, ((KtNameReferenceExpression)this.getExpression()).getTextLength());
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        return CollectionsKt.listOf((Object)((KtNameReferenceExpression)this.getElement()).getReferencedNameAsName());
    }
}

