/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirArrayOfCallTransformer;
import org.jetbrains.kotlin.fir.serialization.constant.ConstantValueUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0016J)\u0010\u0017\u001a\u00020\u0002\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010+J\u001d\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010/J\u001d\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u00103J\u001d\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u00107J\u001d\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020:2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010;R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueChecker;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "()V", "constantIntrinsicCalls", "", "", "supportedConstKinds", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitArrayOfCall", "arrayOfCall", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayOfCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirArrayOfCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitConstExpression", "T", "constExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitNamedArgumentExpression", "namedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nFirToConstantValueTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,295:1\n1726#2,3:296\n1726#2,3:300\n1726#2,3:308\n1726#2,3:311\n47#3:299\n47#3:307\n20#4:303\n44#5:304\n17#5,2:305\n*S KotlinDebug\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueChecker\n*L\n236#1:296,3\n240#1:300,3\n283#1:308,3\n288#1:311,3\n240#1:299\n283#1:307\n248#1:303\n258#1:304\n260#1:305,2\n*E\n"})
public final class FirToConstantValueChecker
extends FirDefaultVisitor<Boolean, FirSession> {
    @NotNull
    public static final FirToConstantValueChecker INSTANCE = new FirToConstantValueChecker();
    @NotNull
    private static final Set<ConstantValueKind<?>> supportedConstKinds;
    @NotNull
    private static final Set<String> constantIntrinsicCalls;

    private FirToConstantValueChecker() {
    }

    @Override
    @NotNull
    public Boolean visitElement(@NotNull FirElement element, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return false;
    }

    @Override
    @NotNull
    public <T> Boolean visitConstExpression(@NotNull FirConstExpression<T> constExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(constExpression, (String)"constExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return supportedConstKinds.contains(constExpression.getKind());
    }

    @Override
    @NotNull
    public Boolean visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall, @NotNull FirSession data2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)stringConcatenationCall, (String)"stringConcatenationCall");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Iterable $this$all$iv = stringConcatenationCall.getArgumentList().getArguments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(this, data2)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitArrayOfCall(@NotNull FirArrayOfCall arrayOfCall, @NotNull FirSession data2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)arrayOfCall, (String)"arrayOfCall");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirCall $this$arguments$iv = arrayOfCall;
            boolean $i$f$getArguments = false;
            Iterable $this$all$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(this, data2)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitAnnotation(@NotNull FirAnnotation annotation2, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return true;
    }

    @Override
    @NotNull
    public Boolean visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return true;
    }

    @Override
    @NotNull
    public Boolean visitGetClassCall(@NotNull FirGetClassCall getClassCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FirTypeRef $this$coneTypeUnsafe$iv = getClassCall.getArgument().getTypeRef();
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        return ConstantValueUtilsKt.create(coneKotlinType) != null;
    }

    @Override
    @NotNull
    public Boolean visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull FirSession data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(qualifiedAccessExpression);
        if (firCallableSymbol == null) {
            return false;
        }
        FirCallableSymbol<?> symbol2 = firCallableSymbol;
        FirCallableDeclaration fir = (FirCallableDeclaration)symbol2.getFir();
        if (symbol2.getFir() instanceof FirEnumEntry) {
            bl = symbol2.getCallableId().getClassId() != null;
        } else if (symbol2 instanceof FirPropertySymbol) {
            FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)((FirPropertySymbol)symbol2).getFir();
            boolean $i$f$isConst = false;
            bl = $this$isConst$iv.getStatus().isConst();
        } else if (fir instanceof FirJavaField) {
            Modality modality$iv;
            FirMemberDeclaration $this$isFinal$iv = (FirMemberDeclaration)symbol2.getFir();
            boolean $i$f$isFinal = false;
            Modality modality = $this$isFinal$iv.getStatus().getModality();
            bl = modality == null ? true : (modality$iv = modality) == Modality.FINAL;
        } else if (symbol2 instanceof FirConstructorSymbol) {
            Object object = ClassMembersKt.containingClassLookupTag(symbol2);
            bl = (object != null && (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, data2)) != null ? ((FirClassSymbol)object).getClassKind() : null) == ClassKind.ANNOTATION_CLASS;
        } else if (Intrinsics.areEqual((Object)symbol2.getCallableId().getPackageName().asString(), (Object)"kotlin")) {
            FirExpression dispatchReceiver = qualifiedAccessExpression.getDispatchReceiver();
            String string2 = symbol2.getCallableId().getCallableName().asString();
            bl = !constantIntrinsicCalls.contains(string2) ? false : (Boolean)dispatchReceiver.accept(this, data2);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)propertyAccessExpression, data2);
    }

    @Override
    @NotNull
    public Boolean visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (FirArrayOfCallTransformer.Companion.isArrayOfCall(functionCall)) {
            boolean bl;
            block4: {
                FirCall $this$arguments$iv = functionCall;
                boolean $i$f$getArguments = false;
                Iterable $this$all$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl2 = false;
                        if (((Boolean)it.accept(this, data2)).booleanValue()) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)functionCall, data2);
    }

    @Override
    @NotNull
    public Boolean visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @NotNull FirSession data2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)varargArgumentsExpression, (String)"varargArgumentsExpression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Iterable $this$all$iv = varargArgumentsExpression.getArguments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(this, data2)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)namedArgumentExpression, (String)"namedArgumentExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (Boolean)namedArgumentExpression.getExpression().accept(this, data2);
    }

    static {
        Object[] objectArray = new ConstantValueKind[]{ConstantValueKind.Boolean.INSTANCE, ConstantValueKind.Char.INSTANCE, ConstantValueKind.String.INSTANCE, ConstantValueKind.Float.INSTANCE, ConstantValueKind.Double.INSTANCE, ConstantValueKind.Byte.INSTANCE, ConstantValueKind.UnsignedByte.INSTANCE, ConstantValueKind.Short.INSTANCE, ConstantValueKind.UnsignedShort.INSTANCE, ConstantValueKind.Int.INSTANCE, ConstantValueKind.UnsignedInt.INSTANCE, ConstantValueKind.Long.INSTANCE, ConstantValueKind.UnsignedLong.INSTANCE};
        supportedConstKinds = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"toByte", "toLong", "toShort", "toFloat", "toDouble", "toChar", "unaryMinus"};
        constantIntrinsicCalls = SetsKt.setOf((Object[])objectArray);
    }
}

