/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter;", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "baseDirFile", "Ljava/io/File;", "(Ljava/io/File;)V", "baseDirPath", "", "toFile", "path", "toPath", "file", "Companion", "kotlin-build-common"})
public class RelativeFileToPathConverter
implements FileToPathConverter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String baseDirPath;
    @NotNull
    private static final String PROJECT_DIR_PLACEHOLDER = "$PROJECT_DIR$";

    public RelativeFileToPathConverter(@Nullable File baseDirFile) {
        File file2 = baseDirFile;
        this.baseDirPath = file2 != null && (file2 = FilesKt.normalize((File)file2)) != null ? FilesKt.getInvariantSeparatorsPath((File)file2) : null;
    }

    @Override
    @NotNull
    public String toPath(@NotNull File file2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String path2 = FilesKt.getInvariantSeparatorsPath((File)FilesKt.normalize((File)file2));
        if (this.baseDirPath != null && StringsKt.startsWith$default((String)path2, (String)this.baseDirPath, (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder2 = new StringBuilder().append(PROJECT_DIR_PLACEHOLDER);
            String string3 = path2.substring(this.baseDirPath.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            string2 = stringBuilder2.append(string3).toString();
        } else {
            string2 = path2;
        }
        return string2;
    }

    @Override
    @NotNull
    public File toFile(@NotNull String path2) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (StringsKt.startsWith$default((String)path2, (String)PROJECT_DIR_PLACEHOLDER, (boolean)false, (int)2, null)) {
            String string2 = this.baseDirPath;
            if (string2 == null) {
                throw new IllegalStateException("Could not get project root dir".toString());
            }
            String basePath = string2;
            StringBuilder stringBuilder2 = new StringBuilder().append(basePath);
            String string3 = path2.substring(13);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            file2 = new File(stringBuilder2.append(string3).toString());
        } else {
            file2 = new File(path2);
        }
        return file2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter$Companion;", "", "()V", "PROJECT_DIR_PLACEHOLDER", "", "kotlin-build-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

