/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.storage.CachingLazyStorage;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004B1\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0015\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/BasicMap;", "K", "", "V", "", "storageFile", "Ljava/io/File;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "(Ljava/io/File;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "getIcContext", "()Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "getPathConverter", "()Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "storage", "Lorg/jetbrains/kotlin/incremental/storage/LazyStorage;", "getStorage", "()Lorg/jetbrains/kotlin/incremental/storage/LazyStorage;", "getStorageFile$kotlin_build_common", "()Ljava/io/File;", "clean", "", "close", "closeForTest", "dump", "", "dumpKey", "key", "(Ljava/lang/Comparable;)Ljava/lang/String;", "dumpValue", "value", "(Ljava/lang/Object;)Ljava/lang/String;", "flush", "memoryCachesOnly", "", "kotlin-build-common"})
public abstract class BasicMap<K extends Comparable<? super K>, V> {
    @NotNull
    private final File storageFile;
    @NotNull
    private final IncrementalCompilationContext icContext;
    @NotNull
    private final LazyStorage<K, V> storage;

    public BasicMap(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        this.storageFile = storageFile;
        this.icContext = icContext;
        this.storage = new CachingLazyStorage<K, V>(this.storageFile, keyDescriptor, valueExternalizer);
    }

    @NotNull
    public final File getStorageFile$kotlin_build_common() {
        return this.storageFile;
    }

    @NotNull
    protected final IncrementalCompilationContext getIcContext() {
        return this.icContext;
    }

    @NotNull
    protected final LazyStorage<K, V> getStorage() {
        return this.storage;
    }

    @NotNull
    protected final FileToPathConverter getPathConverter() {
        return this.icContext.getPathConverter();
    }

    public final void clean() {
        this.storage.clean();
    }

    public final void flush(boolean memoryCachesOnly) {
        this.storage.flush(memoryCachesOnly);
    }

    public final void close() {
        this.storage.close();
    }

    public final void closeForTest() {
        this.close();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump() {
        void var1_1;
        StringBuilder $this$dump_u24lambda_u241 = new StringBuilder();
        boolean bl = false;
        Printer $this$dump_u24lambda_u241_u24lambda_u240 = new Printer($this$dump_u24lambda_u241);
        boolean bl2 = false;
        Object[] objectArray = new Object[]{this.getClass().getSimpleName()};
        $this$dump_u24lambda_u241_u24lambda_u240.println(objectArray);
        $this$dump_u24lambda_u241_u24lambda_u240.pushIndent();
        for (Comparable key : CollectionsKt.sorted((Iterable)this.storage.getKeys())) {
            Object[] objectArray2 = new Object[1];
            StringBuilder stringBuilder2 = new StringBuilder().append(this.dumpKey(key)).append(" -> ");
            V v = this.storage.get(key);
            Intrinsics.checkNotNull(v);
            objectArray2[0] = stringBuilder2.append(this.dumpValue(v)).toString();
            $this$dump_u24lambda_u241_u24lambda_u240.println(objectArray2);
        }
        $this$dump_u24lambda_u241_u24lambda_u240.popIndent();
        String string2 = var1_1.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"with(StringBuilder()) {\n\u2026this\n        }.toString()");
        return string2;
    }

    @NotNull
    protected abstract String dumpKey(@NotNull K var1);

    @NotNull
    protected abstract String dumpValue(V var1);
}

