/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImplStub;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.KtTokenSets;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u00192\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u00020\u00012\u00020\u0003:\u0001\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\u0002\u00a2\u0006\u0002\u0010\bJ5\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u00132\u0006\u0010\u0014\u001a\u0002H\u0011H\u0016\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00172\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\u0002H\u0002\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "Lorg/jetbrains/kotlin/psi/KtExpressionImplStub;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;)V", "receiverExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getReceiverExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "selectorExpression", "getSelectorExpression", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getChildExpressionsByStub", "", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;)[Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "psi"})
public final class KtDotQualifiedExpression
extends KtExpressionImplStub<KotlinPlaceHolderStub<KtDotQualifiedExpression>>
implements KtQualifiedExpression {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public KtDotQualifiedExpression(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public KtDotQualifiedExpression(@NotNull KotlinPlaceHolderStub<KtDotQualifiedExpression> stub) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        super((StubElement)stub, KtStubElementTypes.DOT_QUALIFIED_EXPRESSION);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitDotQualifiedExpression(this, data2);
    }

    @Override
    @NotNull
    public KtExpression getReceiverExpression() {
        KtExpression[] childExpressionsByStub;
        KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)this.getStub();
        if (stub != null && (childExpressionsByStub = this.getChildExpressionsByStub(stub)) != null) {
            return childExpressionsByStub[0];
        }
        return KtQualifiedExpression.super.getReceiverExpression();
    }

    @Override
    @Nullable
    public KtExpression getSelectorExpression() {
        KtExpression[] childExpressionsByStub;
        KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)this.getStub();
        if (stub != null && (childExpressionsByStub = this.getChildExpressionsByStub(stub)) != null && childExpressionsByStub.length == 2) {
            return childExpressionsByStub[1];
        }
        return KtQualifiedExpression.super.getSelectorExpression();
    }

    private final KtExpression[] getChildExpressionsByStub(KotlinPlaceHolderStub<KtDotQualifiedExpression> stub) {
        if (stub.getParentStubOfType(KtImportDirective.class) == null && stub.getParentStubOfType(KtPackageDirective.class) == null && stub.getParentStubOfType(KtValueArgument.class) == null) {
            LOG.error("KtDotQualifiedExpression should only have stubs inside import, argument or package directives.\nStubs were created for:\n" + this.getText() + "\nFile text:\n" + this.getContainingFile().getText());
            return null;
        }
        PsiElement[] psiElementArray = stub.getChildrenByType(KtTokenSets.INSIDE_DIRECTIVE_EXPRESSIONS, KtExpression.ARRAY_FACTORY);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"stub.getChildrenByType(I\u2026Expression.ARRAY_FACTORY)");
        KtExpression[] expressions = (KtExpression[])psiElementArray;
        int n = expressions.length;
        if (!(1 <= n ? n < 3 : false)) {
            LOG.error((Throwable)new KotlinExceptionWithAttachments("Invalid stub structure. DOT_QUALIFIED_EXPRESSION must have one or two children. Was: " + expressions.length + '\n').withPsiAttachment("file.kt", (PsiElement)this.getContainingFile()));
            return null;
        }
        return expressions;
    }

    static {
        Logger logger = Logger.getInstance(KtDotQualifiedExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(KtDotQualifiedExpression::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

