/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.optimizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.optimizations.FoldConstantLowering;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0003\"#$B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J.\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\f\u0010 \u001a\u00020!*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "floatSpecial", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "buildIrConstant", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "v", "", "coerceToDouble", "irConst", "fromFloatConstSafe", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "tryFoldingBinaryOps", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "tryFoldingBuiltinBinaryOps", "tryFoldingUnaryOps", "typeConstructorName", "", "BinaryOp", "Companion", "PrimitiveTypeName", "ir.backend.common"})
public final class FoldConstantLowering
extends IrElementTransformerVoid
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    private final boolean floatSpecial;
    @NotNull
    private static final PrimitiveTypeName<Integer> INT = new PrimitiveTypeName("Int");
    @NotNull
    private static final PrimitiveTypeName<Long> LONG = new PrimitiveTypeName("Long");
    @NotNull
    private static final PrimitiveTypeName<Double> DOUBLE = new PrimitiveTypeName("Double");
    @NotNull
    private static final PrimitiveTypeName<Float> FLOAT = new PrimitiveTypeName("Float");
    @NotNull
    private static final HashMap<BinaryOp, Function2<Object, Object, Object>> BINARY_OP_TO_EVALUATOR = new HashMap();

    public FoldConstantLowering(@NotNull CommonBackendContext context, boolean floatSpecial) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.floatSpecial = floatSpecial;
    }

    public /* synthetic */ FoldConstantLowering(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }

    private final IrConst<?> fromFloatConstSafe(int startOffset, int endOffset, IrType type2, Object v) {
        IrConst irConst;
        if (!this.floatSpecial) {
            Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Number");
            irConst = IrConstImpl.Companion.float(startOffset, endOffset, type2, ((Number)v).floatValue());
        } else if (v instanceof Float) {
            irConst = IrConstImpl.Companion.float(startOffset, endOffset, type2, ((Number)v).floatValue());
        } else if (v instanceof Double) {
            irConst = IrConstImpl.Companion.double(startOffset, endOffset, type2, ((Number)v).doubleValue());
        } else {
            throw new IllegalStateException("Unexpected constant type".toString());
        }
        return irConst;
    }

    private final IrConst<?> buildIrConstant(int startOffset, int endOffset, IrType type2, Object v) {
        IrConst irConst;
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(type2);
        switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
            case 1: {
                IrType irType = this.context.getIrBuiltIns().getBooleanType();
                Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Boolean");
                irConst = IrConstImpl.Companion.boolean(startOffset, endOffset, irType, (Boolean)v);
                break;
            }
            case 2: {
                IrType irType = this.context.getIrBuiltIns().getCharType();
                Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Char");
                irConst = IrConstImpl.Companion.char(startOffset, endOffset, irType, ((Character)v).charValue());
                break;
            }
            case 3: {
                IrType irType = this.context.getIrBuiltIns().getByteType();
                Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Number");
                irConst = IrConstImpl.Companion.byte(startOffset, endOffset, irType, ((Number)v).byteValue());
                break;
            }
            case 4: {
                IrType irType = this.context.getIrBuiltIns().getShortType();
                Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Number");
                irConst = IrConstImpl.Companion.short(startOffset, endOffset, irType, ((Number)v).shortValue());
                break;
            }
            case 5: {
                IrType irType = this.context.getIrBuiltIns().getIntType();
                Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Number");
                irConst = IrConstImpl.Companion.int(startOffset, endOffset, irType, ((Number)v).intValue());
                break;
            }
            case 6: {
                irConst = this.fromFloatConstSafe(startOffset, endOffset, this.context.getIrBuiltIns().getFloatType(), v);
                break;
            }
            case 7: {
                IrType irType = this.context.getIrBuiltIns().getLongType();
                Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Number");
                irConst = IrConstImpl.Companion.long(startOffset, endOffset, irType, ((Number)v).longValue());
                break;
            }
            case 8: {
                IrType irType = this.context.getIrBuiltIns().getDoubleType();
                Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Number");
                irConst = IrConstImpl.Companion.double(startOffset, endOffset, irType, ((Number)v).doubleValue());
                break;
            }
            default: {
                if (!IrTypePredicatesKt.isStringClassType(type2)) {
                    throw new IllegalArgumentException("Unexpected IrCall return type");
                }
                IrType irType = this.context.getIrBuiltIns().getStringType();
                Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.String");
                irConst = IrConstImpl.Companion.string(startOffset, endOffset, irType, (String)v);
            }
        }
        return irConst;
    }

    private final IrExpression tryFoldingUnaryOps(IrCall call2) {
        Object object;
        IrExpression irExpression = call2.getDispatchReceiver();
        IrConst irConst = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        if (irConst == null) {
            return call2;
        }
        IrConst operand = irConst;
        String string2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"call.symbol.owner.name.toString()");
        String operationName = string2;
        if (Intrinsics.areEqual((Object)operationName, (Object)"toString")) {
            object = FoldConstantLowering.Companion.constToString(operand, this.floatSpecial);
        } else {
            if (Intrinsics.areEqual((Object)operationName, (Object)"toFloat") && this.floatSpecial) {
                return call2;
            }
            if (Intrinsics.areEqual(operand.getKind(), (Object)IrConstKind.Null.INSTANCE)) {
                return call2;
            }
            String string3 = operand.getKind().toString();
            Object t = operand.getValue();
            Intrinsics.checkNotNull(t);
            object = ConstantExpressionEvaluatorKt.evaluateUnary(operationName, string3, t);
            if (object == null) {
                return call2;
            }
        }
        String evaluated = object;
        return this.buildIrConstant(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), evaluated);
    }

    private final IrConst<?> coerceToDouble(IrConst<?> irConst) {
        if (!this.floatSpecial) {
            return irConst;
        }
        if (Intrinsics.areEqual(irConst.getKind(), (Object)IrConstKind.Float.INSTANCE)) {
            IrConst<?> $this$coerceToDouble_u24lambda_u240 = irConst;
            boolean bl = false;
            return new IrConstImpl<Double>($this$coerceToDouble_u24lambda_u240.getStartOffset(), $this$coerceToDouble_u24lambda_u240.getEndOffset(), this.context.getIrBuiltIns().getDoubleType(), IrConstKind.Double.INSTANCE, Double.parseDouble(String.valueOf($this$coerceToDouble_u24lambda_u240.getValue())));
        }
        return irConst;
    }

    private final String typeConstructorName(IrType $this$typeConstructorName) {
        Intrinsics.checkNotNull((Object)$this$typeConstructorName, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleType $this$typeConstructorName_u24lambda_u242 = (IrSimpleType)$this$typeConstructorName;
        boolean bl = false;
        IrClassifierSymbol irClassifierSymbol = $this$typeConstructorName_u24lambda_u242.getClassifier();
        Intrinsics.checkNotNull((Object)irClassifierSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
        IrClassSymbol $this$typeConstructorName_u24lambda_u242_u24lambda_u241 = (IrClassSymbol)irClassifierSymbol;
        boolean bl2 = false;
        String string2 = ((IrClass)$this$typeConstructorName_u24lambda_u242_u24lambda_u241.getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"owner.name.asString()");
        return string2;
    }

    private final IrExpression tryFoldingBinaryOps(IrCall call2) {
        IrExpression irExpression = call2.getDispatchReceiver();
        IrConst irConst = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        if (irConst == null) {
            return call2;
        }
        IrConst<?> lhs = this.coerceToDouble(irConst);
        Object object = call2.getValueArgument(0);
        IrConst irConst2 = object instanceof IrConst ? (IrConst)object : null;
        if (irConst2 == null) {
            return call2;
        }
        IrConst<?> rhs = this.coerceToDouble(irConst2);
        if (Intrinsics.areEqual(lhs.getKind(), (Object)IrConstKind.Null.INSTANCE) || Intrinsics.areEqual(rhs.getKind(), (Object)IrConstKind.Null.INSTANCE)) {
            return call2;
        }
        try {
            String string2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"call.symbol.owner.name.toString()");
            String string3 = lhs.getKind().toString();
            Object object2 = FoldConstantLowering.Companion.normalizeUnsignedValue(lhs);
            Intrinsics.checkNotNull((Object)object2);
            String string4 = this.typeConstructorName(((IrSimpleFunction)call2.getSymbol().getOwner()).getValueParameters().get(0).getType());
            Object object3 = FoldConstantLowering.Companion.normalizeUnsignedValue(rhs);
            Intrinsics.checkNotNull((Object)object3);
            Object object4 = ConstantExpressionEvaluatorKt.evaluateBinary(string2, string3, object2, string4, object3);
            if (object4 == null) {
                return call2;
            }
            object = object4;
        }
        catch (Exception e) {
            return call2;
        }
        Object evaluated = object;
        return this.buildIrConstant(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), evaluated);
    }

    private final IrExpression tryFoldingBuiltinBinaryOps(IrCall call2) {
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(call2.getSymbol().getOwner());
        if (!Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.parent() : null), (Object)IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN())) {
            return call2;
        }
        IrExpression irExpression = call2.getValueArgument(0);
        IrConst irConst = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        if (irConst == null) {
            return call2;
        }
        IrConst lhs = irConst;
        Object object = call2.getValueArgument(1);
        IrConst irConst2 = object instanceof IrConst ? (IrConst)object : null;
        if (irConst2 == null) {
            return call2;
        }
        IrConst rhs = irConst2;
        if (Intrinsics.areEqual(lhs.getKind(), (Object)IrConstKind.Null.INSTANCE) || Intrinsics.areEqual(rhs.getKind(), (Object)IrConstKind.Null.INSTANCE)) {
            return call2;
        }
        try {
            String string2 = lhs.getKind().toString();
            String string3 = rhs.getKind().toString();
            String string4 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"call.symbol.owner.name.toString()");
            Function2<Object, Object, Object> function2 = BINARY_OP_TO_EVALUATOR.get(new BinaryOp(string2, string3, string4));
            if (function2 == null) {
                return call2;
            }
            Function2<Object, Object, Object> evaluator = function2;
            Object t = lhs.getValue();
            Intrinsics.checkNotNull(t);
            Object t2 = rhs.getValue();
            Intrinsics.checkNotNull(t2);
            object = evaluator.invoke(t, t2);
        }
        catch (Exception e) {
            return call2;
        }
        Object evaluated = object;
        return this.buildIrConstant(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), evaluated);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ FoldConstantLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                return expression2.getExtensionReceiver() != null ? (IrExpression)expression2 : (expression2.getDispatchReceiver() != null && expression2.getValueArgumentsCount() == 0 ? FoldConstantLowering.access$tryFoldingUnaryOps(this.this$0, expression2) : (expression2.getDispatchReceiver() != null && expression2.getValueArgumentsCount() == 1 ? FoldConstantLowering.access$tryFoldingBinaryOps(this.this$0, expression2) : (expression2.getDispatchReceiver() == null && expression2.getValueArgumentsCount() == 2 ? FoldConstantLowering.access$tryFoldingBuiltinBinaryOps(this.this$0, expression2) : (IrExpression)expression2)));
            }

            @NotNull
            public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                return FoldConstantLowering.Companion.tryToFold(expression2, FoldConstantLowering.access$getContext$p(this.this$0), FoldConstantLowering.access$getFloatSpecial$p(this.this$0));
            }

            @NotNull
            public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                IrExpression argument2 = expression2.getArgument();
                return argument2 instanceof IrConst && expression2.getOperator() == IrTypeOperator.IMPLICIT_INTEGER_COERCION ? (IrExpression)FoldConstantLowering.access$buildIrConstant(this.this$0, expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), ((IrConst)argument2).getValue()) : (IrExpression)expression2;
            }
        });
    }

    public static final /* synthetic */ IrExpression access$tryFoldingUnaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingUnaryOps(call2);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingBinaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingBinaryOps(call2);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingBuiltinBinaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingBuiltinBinaryOps(call2);
    }

    public static final /* synthetic */ CommonBackendContext access$getContext$p(FoldConstantLowering $this) {
        return $this.context;
    }

    public static final /* synthetic */ boolean access$getFloatSpecial$p(FoldConstantLowering $this) {
        return $this.floatSpecial;
    }

    public static final /* synthetic */ IrConst access$buildIrConstant(FoldConstantLowering $this, int startOffset, int endOffset, IrType type2, Object v) {
        return $this.buildIrConstant(startOffset, endOffset, type2, v);
    }

    static {
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "less", Companion.1.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "lessOrEqual", Companion.2.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "greater", Companion.3.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "greaterOrEqual", Companion.4.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "ieee754equals", Companion.5.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "less", Companion.6.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "lessOrEqual", Companion.7.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "greater", Companion.8.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "greaterOrEqual", Companion.9.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "ieee754equals", Companion.10.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "less", Companion.11.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "lessOrEqual", Companion.12.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "greater", Companion.13.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "greaterOrEqual", Companion.14.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "EQEQ", Companion.15.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "less", Companion.16.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "lessOrEqual", Companion.17.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "greater", Companion.18.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "greaterOrEqual", Companion.19.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "EQEQ", Companion.20.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            try {
                nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.INT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00012\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J>\u0010\u0018\u001a\u00020\u0019\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\t2\u0006\u0010\u001c\u001a\u00020\u00122\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u00010\u0006H\u0002J\u001a\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016RV\u0010\u0003\u001aJ\u0012\u0004\u0012\u00020\u0005\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u00060\u0004j$\u0012\u0004\u0012\u00020\u0005\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$Companion;", "", "()V", "BINARY_OP_TO_EVALUATOR", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$BinaryOp;", "Lkotlin/Function2;", "Lkotlin/collections/HashMap;", "DOUBLE", "Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$PrimitiveTypeName;", "", "FLOAT", "", "INT", "", "LONG", "", "constToString", "", "const", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "floatSpecial", "", "normalizeUnsignedValue", "registerBuiltinBinaryOp", "", "T", "operandType", "operatorName", "f", "tryToFold", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> void registerBuiltinBinaryOp(PrimitiveTypeName<T> operandType, String operatorName, Function2<? super T, ? super T, ? extends Object> f) {
            Map map = BINARY_OP_TO_EVALUATOR;
            BinaryOp binaryOp = new BinaryOp(operandType.getName(), operandType.getName(), operatorName);
            Intrinsics.checkNotNull(f, (String)"null cannot be cast to non-null type kotlin.Function2<kotlin.Any?, kotlin.Any?, kotlin.Any>");
            map.put(binaryOp, (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(f, (int)2));
        }

        @NotNull
        public final IrExpression tryToFold(@NotNull IrStringConcatenation $this$tryToFold, @NotNull CommonBackendContext context, boolean floatSpecial) {
            Intrinsics.checkNotNullParameter((Object)$this$tryToFold, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            List folded = new ArrayList();
            for (IrExpression next : $this$tryToFold.getArguments()) {
                IrExpression last = (IrExpression)CollectionsKt.lastOrNull((List)folded);
                if (!(next instanceof IrConst)) {
                    ((Collection)folded).add(next);
                    continue;
                }
                if (!(last instanceof IrConst)) {
                    ((Collection)folded).add(IrConstImpl.Companion.string(next.getStartOffset(), next.getEndOffset(), context.getIrBuiltIns().getStringType(), this.constToString((IrConst)next, floatSpecial)));
                    continue;
                }
                folded.set(folded.size() - 1, IrConstImpl.Companion.string(Math.min(((IrConst)last).getStartOffset(), next.getStartOffset()), Math.max(((IrConst)last).getEndOffset(), next.getEndOffset()), context.getIrBuiltIns().getStringType(), this.constToString((IrConst)last, floatSpecial) + this.constToString((IrConst)next, floatSpecial)));
            }
            Object object = CollectionsKt.singleOrNull((List)folded);
            IrConst irConst = object instanceof IrConst ? (IrConst)object : null;
            return irConst != null ? (IrExpression)irConst : (IrExpression)new IrStringConcatenationImpl($this$tryToFold.getStartOffset(), $this$tryToFold.getEndOffset(), $this$tryToFold.getType(), folded);
        }

        private final String constToString(IrConst<?> irConst, boolean floatSpecial) {
            if (floatSpecial) {
                double d;
                IrConstKind<?> kind = irConst.getKind();
                if (kind instanceof IrConstKind.Float) {
                    float f = ((Number)((IrConstKind.Float)kind).valueOf(irConst)).floatValue();
                    if (!Float.isInfinite(f) && (float)Math.floor(f) == f) {
                        return String.valueOf((int)f);
                    }
                } else if (kind instanceof IrConstKind.Double && !Double.isInfinite(d = ((Number)((IrConstKind.Double)kind).valueOf(irConst)).doubleValue()) && Math.floor(d) == d) {
                    return String.valueOf((long)d);
                }
            }
            return String.valueOf(this.normalizeUnsignedValue(irConst));
        }

        private final Object normalizeUnsignedValue(IrConst<?> irConst) {
            if (IrTypeUtilsKt.isUnsigned(irConst.getType())) {
                IrConstKind<?> kind = irConst.getKind();
                if (kind instanceof IrConstKind.Byte) {
                    return UByte.box-impl((byte)UByte.constructor-impl((byte)((Number)((IrConstKind.Byte)kind).valueOf(irConst)).byteValue()));
                }
                if (kind instanceof IrConstKind.Short) {
                    return UShort.box-impl((short)UShort.constructor-impl((short)((Number)((IrConstKind.Short)kind).valueOf(irConst)).shortValue()));
                }
                if (kind instanceof IrConstKind.Int) {
                    return UInt.box-impl((int)UInt.constructor-impl((int)((Number)((IrConstKind.Int)kind).valueOf(irConst)).intValue()));
                }
                if (kind instanceof IrConstKind.Long) {
                    return ULong.box-impl((long)ULong.constructor-impl((long)((Number)((IrConstKind.Long)kind).valueOf(irConst)).longValue()));
                }
            }
            return irConst.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$BinaryOp;", "", "lhsType", "", "rhsType", "operatorName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLhsType", "()Ljava/lang/String;", "getOperatorName", "getRhsType", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.backend.common"})
    private static final class BinaryOp {
        @NotNull
        private final String lhsType;
        @NotNull
        private final String rhsType;
        @NotNull
        private final String operatorName;

        public BinaryOp(@NotNull String lhsType, @NotNull String rhsType, @NotNull String operatorName) {
            Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
            Intrinsics.checkNotNullParameter((Object)rhsType, (String)"rhsType");
            Intrinsics.checkNotNullParameter((Object)operatorName, (String)"operatorName");
            this.lhsType = lhsType;
            this.rhsType = rhsType;
            this.operatorName = operatorName;
        }

        @NotNull
        public final String getLhsType() {
            return this.lhsType;
        }

        @NotNull
        public final String getRhsType() {
            return this.rhsType;
        }

        @NotNull
        public final String getOperatorName() {
            return this.operatorName;
        }

        @NotNull
        public final String component1() {
            return this.lhsType;
        }

        @NotNull
        public final String component2() {
            return this.rhsType;
        }

        @NotNull
        public final String component3() {
            return this.operatorName;
        }

        @NotNull
        public final BinaryOp copy(@NotNull String lhsType, @NotNull String rhsType, @NotNull String operatorName) {
            Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
            Intrinsics.checkNotNullParameter((Object)rhsType, (String)"rhsType");
            Intrinsics.checkNotNullParameter((Object)operatorName, (String)"operatorName");
            return new BinaryOp(lhsType, rhsType, operatorName);
        }

        public static /* synthetic */ BinaryOp copy$default(BinaryOp binaryOp, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = binaryOp.lhsType;
            }
            if ((n & 2) != 0) {
                string3 = binaryOp.rhsType;
            }
            if ((n & 4) != 0) {
                string4 = binaryOp.operatorName;
            }
            return binaryOp.copy(string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "BinaryOp(lhsType=" + this.lhsType + ", rhsType=" + this.rhsType + ", operatorName=" + this.operatorName + ')';
        }

        public int hashCode() {
            int result2 = this.lhsType.hashCode();
            result2 = result2 * 31 + this.rhsType.hashCode();
            result2 = result2 * 31 + this.operatorName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BinaryOp)) {
                return false;
            }
            BinaryOp binaryOp = (BinaryOp)other;
            if (!Intrinsics.areEqual((Object)this.lhsType, (Object)binaryOp.lhsType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rhsType, (Object)binaryOp.rhsType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.operatorName, (Object)binaryOp.operatorName);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$PrimitiveTypeName;", "T", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.backend.common"})
    private static final class PrimitiveTypeName<T> {
        @NotNull
        private final String name;

        public PrimitiveTypeName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final PrimitiveTypeName<T> copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new PrimitiveTypeName<T>(name);
        }

        public static /* synthetic */ PrimitiveTypeName copy$default(PrimitiveTypeName primitiveTypeName, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = primitiveTypeName.name;
            }
            return primitiveTypeName.copy(string2);
        }

        @NotNull
        public String toString() {
            return "PrimitiveTypeName(name=" + this.name + ')';
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PrimitiveTypeName)) {
                return false;
            }
            PrimitiveTypeName primitiveTypeName = (PrimitiveTypeName)other;
            return Intrinsics.areEqual((Object)this.name, (Object)primitiveTypeName.name);
        }
    }
}

