/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.NullableMap;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.resolve.FirOuterClassManager;
import org.jetbrains.kotlin.fir.resolve.FirSamConversionTransformerExtension;
import org.jetbrains.kotlin.fir.resolve.FirSamConversionTransformerExtensionKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SAMInfo;
import org.jetbrains.kotlin.fir.resolve.SamResolutionKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirFakeOverrideGenerator;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001fJ\u0018\u0010&\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010'\u001a\u00020\u000bH\u0002J\u0010\u0010(\u001a\u00020)*\u0006\u0012\u0002\b\u00030\u0011H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f0\nX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000eR&\u0010\u000f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "outerClassManager", "Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;)V", "resolvedFunctionType", "Lorg/jetbrains/kotlin/fir/caches/NullableMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/resolve/SAMInfo;", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "Ljava/util/Map;", "samConstructorsCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "samConversionTransformers", "", "Lorg/jetbrains/kotlin/fir/resolve/FirSamConversionTransformerExtension;", "buildSamConstructorForRegularClass", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "buildSamConstructorForTypeAlias", "typeAliasSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "getFunctionTypeForPossibleSamType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSamConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firClassOrTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "isSamType", "", "resolveFunctionTypeIfSamInterface", "firRegularClass", "createSyntheticConstructorSymbol", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirSyntheticFunctionSymbol;", "resolve"})
@SourceDebugExtension(value={"SMAP\nSamResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SamResolution.kt\norg/jetbrains/kotlin/fir/resolve/FirSamResolver\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 6 FirSimpleFunctionBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirSimpleFunctionBuilderKt\n+ 7 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 9 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 10 NullableMap.kt\norg/jetbrains/kotlin/fir/caches/NullableMapKt\n+ 11 NullableMap.kt\norg/jetbrains/kotlin/fir/caches/NullableMap\n*L\n1#1,438:1\n25#2,4:439\n21#2:489\n1#3:443\n1549#4:444\n1620#4,3:445\n1549#4:448\n1620#4,3:449\n1549#4:452\n1620#4,3:453\n1549#4:456\n1620#4,2:457\n1622#4:463\n1549#4:471\n1620#4,3:472\n1549#4:490\n1620#4,3:491\n1549#4:494\n1620#4,3:495\n1726#4,3:498\n51#5,4:459\n51#5,4:477\n51#5,4:485\n97#6,4:464\n21#7:468\n34#7:469\n33#7:470\n37#8,2:475\n96#9,4:481\n43#10:501\n44#10,2:504\n46#10:508\n27#11,2:502\n35#11,2:506\n29#11,3:509\n*S KotlinDebug\n*F\n+ 1 SamResolution.kt\norg/jetbrains/kotlin/fir/resolve/FirSamResolver\n*L\n104#1:439,4\n215#1:489\n117#1:444\n117#1:445,3\n135#1:448\n135#1:449,3\n139#1:452\n139#1:453,3\n146#1:456\n146#1:457,2\n146#1:463\n176#1:471\n176#1:472,3\n226#1:490\n226#1:491,3\n229#1:494\n229#1:495,3\n232#1:498,3\n147#1:459,4\n184#1:477,4\n193#1:485,4\n154#1:464,4\n159#1:468\n165#1:469\n166#1:470\n181#1:475,2\n189#1:481,4\n259#1:501\n259#1:504,2\n259#1:508\n259#1:502,2\n259#1:506,2\n259#1:509,3\n*E\n"})
public final class FirSamResolver {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @Nullable
    private final FirOuterClassManager outerClassManager;
    @NotNull
    private final Map<K, Object> resolvedFunctionType;
    @NotNull
    private final FirCache<FirClassLikeSymbol<?>, FirNamedFunctionSymbol, FirSamResolver> samConstructorsCache;
    @NotNull
    private final List<FirSamConversionTransformerExtension> samConversionTransformers;

    public FirSamResolver(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @Nullable FirOuterClassManager outerClassManager) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.session = session;
        this.scopeSession = scopeSession;
        this.outerClassManager = outerClassManager;
        this.resolvedFunctionType = NullableMap.constructor-impl$default(null, 1, null);
        this.samConstructorsCache = SamResolutionKt.access$getSamConstructorStorage(this.session).getSamConstructors();
        this.samConversionTransformers = FirSamConversionTransformerExtensionKt.getSamConversionTransformers(FirExtensionServiceKt.getExtensionService(this.session));
    }

    public /* synthetic */ FirSamResolver(FirSession firSession, ScopeSession scopeSession, FirOuterClassManager firOuterClassManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            firOuterClassManager = null;
        }
        this(firSession, scopeSession, firOuterClassManager);
    }

    public final boolean isSamType(@NotNull ConeKotlinType type2) {
        FirClassLikeSymbol<?> symbol2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneKotlinType = type2;
        return coneKotlinType instanceof ConeClassLikeType ? (symbol2 = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, this.session, null, 2, null).getLookupTag(), this.session)) instanceof FirRegularClassSymbol && this.resolveFunctionTypeIfSamInterface((FirRegularClass)((FirRegularClassSymbol)symbol2).getFir()) != null : (coneKotlinType instanceof ConeFlexibleType ? this.isSamType(((ConeFlexibleType)type2).getLowerBound()) && this.isSamType(((ConeFlexibleType)type2).getUpperBound()) : false);
    }

    @Nullable
    public final ConeKotlinType getFunctionTypeForPossibleSamType(@NotNull ConeKotlinType type2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneKotlinType2 = type2;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = this.getFunctionTypeForPossibleSamType(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, this.session, null, 2, null));
        } else if (coneKotlinType2 instanceof ConeFlexibleType) {
            ConeKotlinType coneKotlinType3 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getLowerBound());
            if (coneKotlinType3 == null) {
                return null;
            }
            ConeKotlinType lowerType = coneKotlinType3;
            ConeKotlinType coneKotlinType4 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getUpperBound());
            if (coneKotlinType4 == null) {
                return null;
            }
            ConeKotlinType upperType = coneKotlinType4;
            coneKotlinType = new ConeFlexibleType(ConeTypeUtilsKt.lowerBoundIfFlexible(lowerType), ConeTypeUtilsKt.upperBoundIfFlexible(upperType));
        } else if (coneKotlinType2 instanceof ConeStubType) {
            coneKotlinType = null;
        } else if (((((coneKotlinType2 instanceof ConeTypeParameterType ? true : coneKotlinType2 instanceof ConeTypeVariableType) ? true : coneKotlinType2 instanceof ConeCapturedType) ? true : coneKotlinType2 instanceof ConeDefinitelyNotNullType) ? true : coneKotlinType2 instanceof ConeIntersectionType) ? true : coneKotlinType2 instanceof ConeIntegerLiteralType) {
            coneKotlinType = null;
        } else if (coneKotlinType2 instanceof ConeLookupTagBasedType) {
            coneKotlinType = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    private final ConeLookupTagBasedType getFunctionTypeForPossibleSamType(ConeClassLikeType type2) {
        Object functionType;
        FirRegularClass firRegularClass = LookupTagUtilsKt.toFirRegularClass(type2.getLookupTag(), this.session);
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass firRegularClass2 = firRegularClass;
        SAMInfo<ConeLookupTagBasedType> sAMInfo = this.resolveFunctionTypeIfSamInterface(firRegularClass2);
        if (sAMInfo == null) {
            return null;
        }
        ConeLookupTagBasedType unsubstitutedFunctionType = sAMInfo.component2();
        Object object = SamResolutionKt.access$buildSubstitutorForSamTypeAlias(firRegularClass2, this.session, type2);
        if (object == null || (object = ((ConeSubstitutor)object).substituteOrNull(unsubstitutedFunctionType)) == null) {
            object = unsubstitutedFunctionType;
        }
        if (!((functionType = object) instanceof ConeLookupTagBasedType)) {
            boolean bl = false;
            String string2 = "Function type should always be ConeLookupTagBasedType, but " + Reflection.getOrCreateKotlinClass(functionType.getClass()) + " was found";
            throw new IllegalArgumentException(string2.toString());
        }
        return (ConeLookupTagBasedType)TypeUtilsKt.withNullability$default((ConeKotlinType)functionType, ConeNullability.Companion.create(ConeTypeUtilsKt.isMarkedNullable(type2)), TypeComponentsKt.getTypeContext(this.session), null, 4, null);
    }

    @Nullable
    public final FirSimpleFunction getSamConstructor(@NotNull FirClassLikeDeclaration firClassOrTypeAlias) {
        Intrinsics.checkNotNullParameter((Object)firClassOrTypeAlias, (String)"firClassOrTypeAlias");
        if (firClassOrTypeAlias instanceof FirTypeAlias) {
            FirClassLikeSymbol<?> firClassLikeSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag;
            ConeClassLikeType coneClassLikeType;
            ConeClassLikeType coneClassLikeType2;
            FirTypeRef $this$coneTypeSafe$iv = ((FirTypeAlias)firClassOrTypeAlias).getExpandedTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType2 = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) != null && (coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType2, this.session, null, 2, null)) != null && (coneClassLikeLookupTag = coneClassLikeType.getLookupTag()) != null && (firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, this.session)) != null) {
                FirClassLikeSymbol<?> it = firClassLikeSymbol;
                boolean bl = false;
                this.samConstructorsCache.getValue(it, this);
            }
        }
        FirNamedFunctionSymbol firNamedFunctionSymbol = this.samConstructorsCache.getValue(firClassOrTypeAlias.getSymbol(), this);
        return firNamedFunctionSymbol != null ? (FirSimpleFunction)firNamedFunctionSymbol.getFir() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirNamedFunctionSymbol buildSamConstructorForRegularClass(@NotNull FirRegularClassSymbol classSymbol) {
        FirSimpleFunction firSimpleFunction;
        void $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        FirValueParameterBuilder firValueParameterBuilder;
        void $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2410;
        void $this$mapTo$iv$iv;
        void $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u248;
        FirSimpleFunctionBuilder $i$f$map42;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        void $this$mapTo$iv$iv2;
        Iterator $this$map$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        Collection collection;
        void $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter((Object)classSymbol, (String)"classSymbol");
        FirRegularClass firRegularClass = (FirRegularClass)classSymbol.getFir();
        SAMInfo<ConeLookupTagBasedType> sAMInfo = this.resolveFunctionTypeIfSamInterface(firRegularClass);
        if (sAMInfo == null) {
            return null;
        }
        SAMInfo<ConeLookupTagBasedType> sAMInfo2 = sAMInfo;
        FirNamedFunctionSymbol functionSymbol = sAMInfo2.component1$resolve();
        ConeLookupTagBasedType functionType = sAMInfo2.component2();
        FirSyntheticFunctionSymbol syntheticFunctionSymbol = this.createSyntheticConstructorSymbol(classSymbol);
        Iterable $this$map$iv3 = firRegularClass.getTypeParameters();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            FirTypeParameterBuilder firTypeParameterBuilder;
            void typeParameter2;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirTypeParameter declaredTypeParameter = (FirTypeParameter)typeParameter2.getSymbol().getFir();
            FirTypeParameterBuilder $this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242 = firTypeParameterBuilder = new FirTypeParameterBuilder();
            boolean bl2 = false;
            $this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242.setSource(declaredTypeParameter.getSource());
            $this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242.setModuleData(FirModuleDataKt.getModuleData(this.session));
            $this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
            $this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242.setResolvePhase(FirResolvePhase.Companion.getDECLARATIONS());
            $this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242.setName(declaredTypeParameter.getName());
            $this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242.setSymbol(new FirTypeParameterSymbol());
            $this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242.setVariance(Variance.INVARIANT);
            $this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242.setReified(false);
            CollectionsKt.addAll((Collection)$this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242.getAnnotations(), (Iterable)declaredTypeParameter.getAnnotations());
            $this$buildSamConstructorForRegularClass_u24lambda_u243_u24lambda_u242.setContainingDeclarationSymbol(syntheticFunctionSymbol);
            collection.add(firTypeParameterBuilder);
        }
        List newTypeParameters = (List)destination$iv$iv;
        Iterable $i$f$map22 = newTypeParameters;
        boolean $i$f$map32 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            FirTypeParameterBuilder bl = (FirTypeParameterBuilder)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(new ConeTypeParameterTypeImpl(it.getSymbol().toLookupTag(), false, null, 4, null));
        }
        List newTypeParameterTypes = (List)destination$iv$iv2;
        Iterable $i$f$map32 = firRegularClass.getTypeParameters();
        boolean $i$f$map42 = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            FirTypeParameterRef bl3 = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv3), (Iterable)newTypeParameterTypes)), this.session);
        for (Pair $i$f$map42 : CollectionsKt.zip((Iterable)newTypeParameters, (Iterable)firRegularClass.getTypeParameters())) {
            void $this$mapTo$iv$iv5;
            Object item$iv$iv;
            FirTypeParameterBuilder newTypeParameter = (FirTypeParameterBuilder)$i$f$map42.component1();
            FirTypeParameterRef oldTypeParameter = (FirTypeParameterRef)$i$f$map42.component2();
            FirTypeParameter declared = (FirTypeParameter)oldTypeParameter.getSymbol().getFir();
            item$iv$iv = newTypeParameter.getBounds();
            Iterable $this$map$iv4 = declared.getSymbol().getResolvedBounds();
            boolean $i$f$map5 = false;
            Iterable bl = $this$map$iv4;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv5) {
                void typeRef;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv2;
                collection = destination$iv$iv4;
                boolean bl4 = false;
                boolean $i$f$buildResolvedTypeRef = false;
                firAnnotationContainerBuilder = new FirResolvedTypeRefBuilder();
                FirResolvedTypeRefBuilder $this$buildSamConstructorForRegularClass_u24lambda_u247_u24lambda_u246 = firAnnotationContainerBuilder;
                boolean bl5 = false;
                $this$buildSamConstructorForRegularClass_u24lambda_u247_u24lambda_u246.setSource(typeRef.getSource());
                $this$buildSamConstructorForRegularClass_u24lambda_u247_u24lambda_u246.setType(substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType((FirTypeRef)typeRef)));
                collection.add(((FirResolvedTypeRefBuilder)firAnnotationContainerBuilder).build());
            }
            $this$map$iv4 = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)item$iv$iv, (Iterable)$this$map$iv4);
        }
        boolean $i$f$buildSimpleFunction = false;
        FirSimpleFunctionBuilder $this$buildSamConstructorForRegularClass_u24lambda_u2413 = $i$f$map42 = new FirSimpleFunctionBuilder();
        boolean bl = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2413.setModuleData(FirModuleDataKt.getModuleData(this.session));
        $this$buildSamConstructorForRegularClass_u24lambda_u2413.setSource(firRegularClass.getSource());
        $this$buildSamConstructorForRegularClass_u24lambda_u2413.setName(syntheticFunctionSymbol.getName());
        $this$buildSamConstructorForRegularClass_u24lambda_u2413.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        Object $this$visibility$iv = firRegularClass;
        boolean $i$f$getVisibility22 = false;
        Visibility visibility2 = ((FirMemberDeclaration)$this$visibility$iv).getStatus().getVisibility();
        $this$visibility$iv = new FirResolvedDeclarationStatusImpl(visibility2, Modality.FINAL, EffectiveVisibility.Local.INSTANCE);
        FirPureAbstractElement $i$f$getVisibility22 = $this$visibility$iv;
        Object object = $this$buildSamConstructorForRegularClass_u24lambda_u2413;
        boolean bl6 = false;
        FirMemberDeclaration $this$isExpect$iv = firRegularClass;
        boolean $i$f$isExpect = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u248.setExpect($this$isExpect$iv.getStatus().isExpect());
        Object $this$isActual$iv = firRegularClass;
        boolean $i$f$isActual = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u248.setActual(((FirMemberDeclaration)$this$isActual$iv).getStatus().isActual());
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u248.setOverride(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u248.setOperator(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u248.setInfix(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u248.setExternal(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u248.setInline(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u248.setSuspend(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u248.setTailRec(false);
        ((FirSimpleFunctionBuilder)object).setStatus((FirDeclarationStatus)$this$visibility$iv);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413.setSymbol(syntheticFunctionSymbol);
        $this$visibility$iv = $this$buildSamConstructorForRegularClass_u24lambda_u2413.getTypeParameters();
        Iterable $this$map$iv5 = newTypeParameters;
        boolean $i$f$map6 = false;
        $this$isActual$iv = $this$map$iv5;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterBuilder bl4 = (FirTypeParameterBuilder)item$iv$iv;
            object = destination$iv$iv5;
            boolean bl7 = false;
            object.add(it.build());
        }
        $this$map$iv5 = (List)destination$iv$iv5;
        CollectionsKt.addAll((Collection)$this$visibility$iv, (Iterable)$this$map$iv5);
        ConeKotlinType substitutedFunctionType = substitutor2.substituteOrSelf(functionType);
        Collection $this$toTypedArray$iv = newTypeParameterTypes;
        boolean $i$f$toTypedArray22 = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        ConeClassLikeTypeImpl substitutedReturnType = new ConeClassLikeTypeImpl(firRegularClass.getSymbol().toLookupTag(), thisCollection$iv.toArray(new ConeTypeParameterTypeImpl[0]), false, null, 8, null);
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $i$f$toTypedArray22 = new FirResolvedTypeRefBuilder();
        thisCollection$iv = $i$f$toTypedArray22;
        object = $this$buildSamConstructorForRegularClass_u24lambda_u2413;
        boolean bl8 = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2410.setSource(null);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2410.setType(substitutedReturnType);
        ((FirSimpleFunctionBuilder)object).setReturnTypeRef($i$f$toTypedArray22.build());
        Collection collection2 = $this$buildSamConstructorForRegularClass_u24lambda_u2413.getValueParameters();
        boolean $i$f$buildValueParameter = false;
        FirValueParameterBuilder $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412 = firValueParameterBuilder = new FirValueParameterBuilder();
        boolean bl9 = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412.setModuleData(FirModuleDataKt.getModuleData(this.session));
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412.setContainingFunctionSymbol(syntheticFunctionSymbol);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        boolean $i$f$buildResolvedTypeRef2 = false;
        FirResolvedTypeRefBuilder bl7 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        firAnnotationContainerBuilder = $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412;
        boolean bl10 = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.setSource(firRegularClass.getSource());
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.setType(substitutedFunctionType);
        ((FirValueParameterBuilder)firAnnotationContainerBuilder).setReturnTypeRef(firResolvedTypeRefBuilder.build());
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412.setName(SamResolutionKt.access$getSAM_PARAMETER_NAME$p());
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412.setSymbol(new FirValueParameterSymbol(SamResolutionKt.access$getSAM_PARAMETER_NAME$p()));
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412.setCrossinline(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412.setNoinline(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412.setVararg(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2413_u24lambda_u2412.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        FirValueParameter firValueParameter = firValueParameterBuilder.build();
        collection2.add(firValueParameter);
        CollectionsKt.addAll((Collection)$this$buildSamConstructorForRegularClass_u24lambda_u2413.getAnnotations(), (Iterable)functionSymbol.getAnnotations());
        $this$buildSamConstructorForRegularClass_u24lambda_u2413.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        FirSimpleFunction $this$buildSamConstructorForRegularClass_u24lambda_u2414 = firSimpleFunction = $i$f$map42.build();
        boolean bl11 = false;
        Object object2 = this.outerClassManager;
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$buildSamConstructorForRegularClass_u24lambda_u2414, object2 != null && (object2 = ((FirOuterClassManager)object2).outerClass(firRegularClass.getSymbol())) != null ? ((FirClassLikeSymbol)object2).toLookupTag() : null);
        return firSimpleFunction.getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirNamedFunctionSymbol buildSamConstructorForTypeAlias(@NotNull FirTypeAliasSymbol typeAliasSymbol) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)typeAliasSymbol, (String)"typeAliasSymbol");
        FirTypeRef $this$coneTypeUnsafe$iv = ((FirTypeAlias)typeAliasSymbol.getFir()).getExpandedTypeRef();
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
        }
        ConeClassLikeType type2 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)), this.session, null, 2, null);
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(type2.getLookupTag(), this.session);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass expansionRegularClass = firRegularClass;
        FirSimpleFunction firSimpleFunction = this.getSamConstructor(expansionRegularClass);
        if (firSimpleFunction == null) {
            return null;
        }
        FirSimpleFunction samConstructorForClass = firSimpleFunction;
        ConeSubstitutor coneSubstitutor = SamResolutionKt.access$buildSubstitutorForSamTypeAlias(samConstructorForClass, this.session, type2);
        if (coneSubstitutor == null) {
            return samConstructorForClass.getSymbol();
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        ConeKotlinType newReturnType = substitutor2.substituteOrNull(FirTypeUtilsKt.getConeType(samConstructorForClass.getReturnTypeRef()));
        Iterable $this$map$iv = samConstructorForClass.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(substitutor2.substituteOrNull(FirTypeUtilsKt.getConeType(it.getReturnTypeRef())));
        }
        List newParameterTypes = (List)destination$iv$iv;
        Iterable $this$map$iv2 = samConstructorForClass.getContextReceivers();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirContextReceiver bl = (FirContextReceiver)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(substitutor2.substituteOrNull(FirTypeUtilsKt.getConeType(it.getTypeRef())));
        }
        List newContextReceiverTypes = (List)destination$iv$iv2;
        if (newReturnType == null) {
            boolean bl;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block15: {
                $this$all$iv = newParameterTypes;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl3 = false;
                        if (it == null) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            if (bl) {
                boolean bl4;
                block16: {
                    $this$all$iv = newContextReceiverTypes;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            ConeKotlinType it = (ConeKotlinType)element$iv;
                            boolean bl5 = false;
                            if (it == null) continue;
                            bl4 = false;
                            break block16;
                        }
                        bl4 = true;
                    }
                }
                if (bl4) {
                    return samConstructorForClass.getSymbol();
                }
            }
        }
        FirFakeOverrideGenerator firFakeOverrideGenerator = FirFakeOverrideGenerator.INSTANCE;
        FirSyntheticFunctionSymbol firSyntheticFunctionSymbol = this.createSyntheticConstructorSymbol(typeAliasSymbol);
        Iterator iterator2 = this.session;
        FirDeclarationOrigin.SamConstructor samConstructor = FirDeclarationOrigin.SamConstructor.INSTANCE;
        List<FirTypeParameter> list2 = ((FirTypeAlias)typeAliasSymbol.getFir()).getTypeParameters();
        return FirFakeOverrideGenerator.createCopyForFirFunction$default(firFakeOverrideGenerator, firSyntheticFunctionSymbol, samConstructorForClass, null, iterator2, samConstructor, false, null, newParameterTypes, list2, null, newContextReceiverTypes, newReturnType, null, null, null, 28704, null).getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    private final FirSyntheticFunctionSymbol createSyntheticConstructorSymbol(FirClassLikeSymbol<?> $this$createSyntheticConstructorSymbol) {
        void it;
        FqName fqName2;
        FqName fqName3 = $this$createSyntheticConstructorSymbol.getClassId().getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"classId.packageFqName");
        FqName fqName4 = fqName2 = $this$createSyntheticConstructorSymbol.getClassId().getRelativeClassName().parent();
        FqName fqName5 = fqName3;
        boolean bl = false;
        boolean bl2 = !it.isRoot();
        FqName fqName6 = bl2 ? fqName2 : null;
        Name name = $this$createSyntheticConstructorSymbol.getClassId().getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classId.shortClassName");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        FqName fqName7 = null;
        Name name2 = name;
        FqName fqName8 = fqName6;
        FqName fqName9 = fqName5;
        CallableId callableId = new CallableId(fqName9, fqName8, name2, fqName7, n, defaultConstructorMarker);
        return new FirSyntheticFunctionSymbol(callableId);
    }

    private final SAMInfo<ConeLookupTagBasedType> resolveFunctionTypeIfSamInterface(FirRegularClass firRegularClass) {
        Object object;
        Map<FirRegularClass, Object> $this$getOrPut_u2dLcU4HiU$iv = this.resolvedFunctionType;
        boolean bl = false;
        boolean bl2 = false;
        Object value$iv$iv = $this$getOrPut_u2dLcU4HiU$iv.get(firRegularClass);
        if (value$iv$iv == null) {
            NullableMap.NullValue nullValue;
            Object object2;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!firRegularClass.getStatus().isFun()) {
                object2 = null;
            } else {
                FirSimpleFunction firSimpleFunction = SamResolutionKt.access$getSingleAbstractMethodOrNull(firRegularClass, this.session, this.scopeSession);
                if (firSimpleFunction == null) {
                    object2 = null;
                } else {
                    ConeLookupTagBasedType coneLookupTagBasedType;
                    FirSimpleFunction abstractMethod;
                    block9: {
                        abstractMethod = firSimpleFunction;
                        for (FirSamConversionTransformerExtension it : (Iterable)this.samConversionTransformers) {
                            boolean bl5 = false;
                            ConeLookupTagBasedType coneLookupTagBasedType2 = it.getCustomFunctionalTypeForSamConversion(abstractMethod);
                            if (coneLookupTagBasedType2 == null) continue;
                            coneLookupTagBasedType = coneLookupTagBasedType2;
                            break block9;
                        }
                        coneLookupTagBasedType = null;
                    }
                    ConeLookupTagBasedType typeFromExtension = coneLookupTagBasedType;
                    FirNamedFunctionSymbol firNamedFunctionSymbol = abstractMethod.getSymbol();
                    ConeLookupTagBasedType coneLookupTagBasedType3 = typeFromExtension;
                    if (coneLookupTagBasedType3 == null) {
                        coneLookupTagBasedType3 = SamResolutionKt.access$getFunctionTypeForAbstractMethod(abstractMethod);
                    }
                    object2 = new SAMInfo<ConeKotlinType>(firNamedFunctionSymbol, coneLookupTagBasedType3);
                }
            }
            NullableMap.NullValue it$iv = nullValue = object2;
            boolean bl6 = false;
            boolean bl7 = false;
            NullableMap.NullValue nullValue2 = it$iv;
            if (nullValue2 == null) {
                nullValue2 = NullableMap.NullValue.INSTANCE;
            }
            $this$getOrPut_u2dLcU4HiU$iv.put(firRegularClass, nullValue2);
            object = nullValue;
        } else {
            object = Intrinsics.areEqual((Object)value$iv$iv, (Object)NullableMap.NullValue.INSTANCE) ? null : value$iv$iv;
        }
        return (SAMInfo)object;
    }
}

