/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DumpKotlinLikeKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0014\u0018\u00002\u00060\u0001j\u0002`\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/common/CompilationException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "ir", "", "cause", "", "(Ljava/lang/String;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Ljava/lang/Object;Ljava/lang/Throwable;)V", "column", "", "getColumn", "()I", "content", "getContent", "()Ljava/lang/String;", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "setFile", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getIr", "()Ljava/lang/Object;", "irStartOffset", "getIrStartOffset", "()Ljava/lang/Integer;", "line", "getLine", "getMessage", "path", "getPath", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nCompilationException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationException.kt\norg/jetbrains/kotlin/backend/common/CompilationException\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class CompilationException
extends RuntimeException {
    @Nullable
    private IrFile file;
    @Nullable
    private final Object ir;

    public CompilationException(@NotNull String message, @Nullable IrFile file2, @Nullable Object ir, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message, cause);
        this.file = file2;
        this.ir = ir;
    }

    public /* synthetic */ CompilationException(String string2, IrFile irFile, Object object, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            throwable = null;
        }
        this(string2, irFile, object, throwable);
    }

    @Nullable
    public final IrFile getFile() {
        return this.file;
    }

    public final void setFile(@Nullable IrFile irFile) {
        this.file = irFile;
    }

    @Nullable
    public final Object getIr() {
        return this.ir;
    }

    @Override
    @NotNull
    public String getMessage() {
        CharSequence charSequence2;
        try {
            StringBuilder stringBuilder2;
            StringBuilder stringBuilder3;
            String it;
            StringBuilder $this$_get_message__u24lambda_u242 = charSequence2 = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder4 = $this$_get_message__u24lambda_u242.append("Back-end: Please report this problem https://kotl.in/issue");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            String string2 = this.getPath();
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                StringBuilder stringBuilder5 = $this$_get_message__u24lambda_u242.append(it + ':' + this.getLine() + ':' + this.getColumn());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                StringBuilder stringBuilder6 = stringBuilder5.append('\n');
                stringBuilder3 = stringBuilder6;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append('\\n')");
            } else {
                stringBuilder3 = null;
            }
            String string3 = this.getContent();
            if (string3 != null) {
                it = string3;
                boolean bl3 = false;
                StringBuilder stringBuilder7 = $this$_get_message__u24lambda_u242.append("Problem with `" + it + '`');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
                StringBuilder stringBuilder8 = stringBuilder7.append('\n');
                stringBuilder2 = stringBuilder8;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append('\\n')");
            } else {
                stringBuilder2 = null;
            }
            $this$_get_message__u24lambda_u242.append("Details: " + super.getMessage());
            String string4 = charSequence2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
            charSequence2 = string4;
        }
        catch (Throwable e) {
            IllegalStateException illegalStateException;
            IllegalStateException it = illegalStateException = new IllegalStateException("Problem with constructing exception message");
            boolean bl = false;
            it.setStackTrace(this.getStackTrace());
            throw (Throwable)illegalStateException;
        }
        return charSequence2;
    }

    public final int getLine() {
        Integer n = this.getIrStartOffset();
        if (n == null) {
            return -1;
        }
        int irStartOffset = n;
        if (irStartOffset == -1) {
            return -1;
        }
        Object object = this.file;
        if (object == null || (object = ((IrFile)object).getFileEntry()) == null) {
            return -1;
        }
        int lineNumber = object.getLineNumber(irStartOffset);
        return lineNumber + 1;
    }

    public final int getColumn() {
        Integer n = this.getIrStartOffset();
        if (n == null) {
            return -1;
        }
        int irStartOffset = n;
        if (irStartOffset == -1) {
            return -1;
        }
        Object object = this.file;
        if (object == null || (object = ((IrFile)object).getFileEntry()) == null) {
            return -1;
        }
        int columnNumber = object.getColumnNumber(irStartOffset);
        return columnNumber + 1;
    }

    private final Integer getIrStartOffset() {
        Object object = this.ir;
        IrElement irElement = object instanceof IrElement ? (IrElement)object : null;
        return irElement != null ? Integer.valueOf(irElement.getStartOffset()) : null;
    }

    @Nullable
    public final String getPath() {
        IrFile irFile = this.file;
        return irFile != null ? IrDeclarationsKt.getPath(irFile) : null;
    }

    @Nullable
    public final String getContent() {
        Object object = this.ir;
        return object instanceof IrElement ? DumpKotlinLikeKt.dumpKotlinLike$default((IrElement)this.ir, null, 1, null) : (object instanceof IrType ? DumpKotlinLikeKt.dumpKotlinLike((IrType)this.ir) : null);
    }
}

