/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.IndexedParametersSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmSyntheticAssignmentChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmSyntheticAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSyntheticAssignmentChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSyntheticAssignmentChecker\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,55:1\n125#2:56\n37#3,2:57\n*S KotlinDebug\n*F\n+ 1 JvmSyntheticAssignmentChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSyntheticAssignmentChecker\n*L\n32#1:56\n48#1:57,2\n*E\n"})
public final class JvmSyntheticAssignmentChecker
implements CallChecker {
    @NotNull
    public static final JvmSyntheticAssignmentChecker INSTANCE = new JvmSyntheticAssignmentChecker();

    private JvmSyntheticAssignmentChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        void $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(resultingDescriptor, (String)"resultingDescriptor");
        if (!TowerUtilsKt.isSynthesized(resultingDescriptor)) {
            return;
        }
        if (!(resultingDescriptor instanceof SyntheticJavaPropertyDescriptor)) {
            return;
        }
        if (!(reportOn instanceof KtNameReferenceExpression)) {
            return;
        }
        PsiElement psiElement = reportOn;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtBinaryExpression.class, (boolean)strict$iv);
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!BasicExpressionTypingVisitor.isLValue((KtSimpleNameExpression)reportOn, (PsiElement)binaryExpression)) {
            return;
        }
        Object object = resolvedCall2.getExtensionReceiver();
        if (object == null || (object = object.getType()) == null) {
            return;
        }
        Object receiverType = object;
        Annotated annotated = resolvedCall2.getCandidateDescriptor().getExtensionReceiverParameter();
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return;
        }
        Annotated unsubstitutedReceiverType = annotated;
        if (((KotlinType)receiverType).getConstructor() != ((KotlinType)unsubstitutedReceiverType).getConstructor()) {
            return;
        }
        KotlinType kotlinType = resolvedCall2.getCandidateDescriptor().getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType propertyType = kotlinType;
        List substitutionParameters = new ArrayList();
        List substitutionArguments = new ArrayList();
        for (Pair pair : CollectionsKt.zip((Iterable)((KotlinType)unsubstitutedReceiverType).getArguments(), (Iterable)((KotlinType)receiverType).getArguments())) {
            TypeParameterDescriptor typeParameter2;
            TypeProjection unsubstitutedArgument = (TypeProjection)pair.component1();
            TypeProjection substitutedArgument = (TypeProjection)pair.component2();
            ClassifierDescriptor classifierDescriptor = unsubstitutedArgument.getType().getConstructor().getDeclarationDescriptor();
            if ((classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null) == null) continue;
            typeParameter2 = typeParameter2;
            ((Collection)substitutionParameters).add(typeParameter2);
            ((Collection)substitutionArguments).add(substitutedArgument);
        }
        Collection $this$toTypedArray$iv = substitutionParameters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = substitutionArguments;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new IndexedParametersSubstitution(thisCollection$iv.toArray(new TypeParameterDescriptor[0]), thisCollection$iv.toArray(new TypeProjection[0]), true));
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(\n            Inde\u2026e\n            )\n        )");
        TypeSubstitutor substitutor2 = typeSubstitutor2;
        KotlinType substitutedPropertyType = substitutor2.substitute(propertyType.unwrap(), Variance.IN_VARIANCE);
        if (substitutedPropertyType == null || !TypeUtilsKt.isNothing(substitutedPropertyType)) {
            return;
        }
        BindingTrace bindingTrace = context.getTrace();
        KtExpression ktExpression = binaryExpression.getLeft();
        if (ktExpression == null) {
            ktExpression = (KtExpression)reportOn;
        }
        bindingTrace.report(ErrorsJvm.SYNTHETIC_SETTER_PROJECTED_OUT.on((KtExpression)((PsiElement)ktExpression), (DeclarationDescriptor)resultingDescriptor));
    }
}

