/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.DeserializerForClassfileDecompilerKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.ResolverForDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.BuildDecompiledTextForClassFileKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.BuildDecompiledTextKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByDescriptorIndexer;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByJvmSignatureIndexerKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledTextIndexer;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"decompilerRendererForClassFiles", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextForClassFile", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/ResolverForDecompiler;", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nbuildDecompiledTextForClassFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 buildDecompiledTextForClassFile.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextForClassFileKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1360#2:61\n1446#2,5:62\n*S KotlinDebug\n*F\n+ 1 buildDecompiledTextForClassFile.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextForClassFileKt\n*L\n47#1:61\n47#1:62,5\n*E\n"})
public final class BuildDecompiledTextForClassFileKt {
    @NotNull
    private static final DescriptorRenderer decompilerRendererForClassFiles = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)decompilerRendererForClassFiles.1.INSTANCE));

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DecompiledText buildDecompiledTextForClassFile(@NotNull VirtualFile classFile, @NotNull ResolverForDecompiler resolver) {
        DecompiledText decompiledText2;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = ClsKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(ClsKotlinBinaryClassCache.Companion.getInstance(), classFile, null, 2, null);
        if (kotlinBinaryClassHeaderData == null) {
            throw new IllegalStateException(("Decompiled data factory shouldn't be called on an unsupported file: " + classFile).toString());
        }
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData classHeader = kotlinBinaryClassHeaderData;
        ClassId classId = classHeader.getClassId();
        if (!classHeader.getMetadataVersion().isCompatible()) {
            return IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)JvmMetadataVersion.INSTANCE, (BinaryVersion)classHeader.getMetadataVersion());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[classHeader.getKind().ordinal()]) {
            case 1: 
            case 2: {
                FqName fqName2 = classId.asSingleFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.asSingleFqName()");
                decompiledText2 = BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile$buildText(classHeader, resolver.resolveDeclarationsInFacade(fqName2));
                break;
            }
            case 3: {
                decompiledText2 = BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile$buildText(classHeader, CollectionsKt.listOfNotNull((Object)resolver.resolveTopLevelClass(classId)));
                break;
            }
            case 4: {
                void $this$flatMapTo$iv$iv;
                List<KotlinJvmBinaryClass> partClasses = ClsClassFinder.INSTANCE.findMultifileClassParts(classFile, classId, classHeader.getPartNamesIfMultifileFacade());
                Iterable $this$flatMap$iv = partClasses;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    KotlinJvmBinaryClass partClass = (KotlinJvmBinaryClass)element$iv$iv;
                    boolean bl = false;
                    FqName fqName3 = partClass.getClassId().asSingleFqName();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"partClass.classId.asSingleFqName()");
                    Iterable list$iv$iv = resolver.resolveDeclarationsInFacade(fqName3);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List partMembers = (List)destination$iv$iv;
                decompiledText2 = BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile$buildText(classHeader, partMembers);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown header kind: " + classHeader + ", class " + classId);
            }
        }
        return decompiledText2;
    }

    public static /* synthetic */ DecompiledText buildDecompiledTextForClassFile$default(VirtualFile virtualFile, ResolverForDecompiler resolverForDecompiler, int n, Object object) {
        if ((n & 2) != 0) {
            resolverForDecompiler = DeserializerForClassfileDecompilerKt.DeserializerForClassfileDecompiler(virtualFile);
        }
        return BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile(virtualFile, resolverForDecompiler);
    }

    private static final DecompiledText buildDecompiledTextForClassFile$buildText(ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData classHeader, List<? extends DeclarationDescriptor> declarations2) {
        Object[] objectArray = new DecompiledTextIndexer[]{ByDescriptorIndexer.INSTANCE, ByJvmSignatureIndexerKt.getBySignatureIndexer()};
        return BuildDecompiledTextKt.buildDecompiledText(classHeader.getPackageNameWithFallback(), declarations2, decompilerRendererForClassFiles, CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            try {
                nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

