/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.LateinitIntrinsicApplicabilityChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/LateinitIntrinsicApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "isWarningInPre19", "", "(Z)V", "ACCESSIBLE_LATEINIT_PROPERTY_LITERAL", "Lorg/jetbrains/kotlin/name/FqName;", "()Z", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isBackingFieldAccessible", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "frontend"})
@SourceDebugExtension(value={"SMAP\nLateinitIntrinsicApplicabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LateinitIntrinsicApplicabilityChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/LateinitIntrinsicApplicabilityChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class LateinitIntrinsicApplicabilityChecker
implements CallChecker {
    private final boolean isWarningInPre19;
    @NotNull
    private final FqName ACCESSIBLE_LATEINIT_PROPERTY_LITERAL;

    public LateinitIntrinsicApplicabilityChecker(boolean isWarningInPre19) {
        this.isWarningInPre19 = isWarningInPre19;
        this.ACCESSIBLE_LATEINIT_PROPERTY_LITERAL = new FqName("kotlin.internal.AccessibleLateinitPropertyLiteral");
    }

    public final boolean isWarningInPre19() {
        return this.isWarningInPre19;
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        KtExpression expression2;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"isInitialized")) {
            return;
        }
        Object object = descriptor2.getExtensionReceiverParameter();
        if (!(object != null && (object = object.getAnnotations()) != null ? object.hasAnnotation(this.ACCESSIBLE_LATEINIT_PROPERTY_LITERAL) : false)) {
            return;
        }
        ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
        Object object2 = receiverValue instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null;
        if (object2 != null && (object2 = object2.getExpression()) != null) {
            Object p0 = object2;
            boolean bl = false;
            ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)p0);
        } else {
            ktExpression = expression2 = null;
        }
        if (!(expression2 instanceof KtCallableReferenceExpression)) {
            DiagnosticFactory0<PsiElement> diagnostic = LateinitIntrinsicApplicabilityChecker.check$chooseDiagnostic(this, context, Errors.LATEINIT_INTRINSIC_CALL_ON_NON_LITERAL_WARNING, Errors.LATEINIT_INTRINSIC_CALL_ON_NON_LITERAL);
            context.getTrace().report(diagnostic.on(reportOn));
        } else {
            KtElement ktElement = ((KtCallableReferenceExpression)expression2).getCallableReference();
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall3 == null) {
                return;
            }
            ResolvedCall<? extends CallableDescriptor> propertyReferenceResolvedCall = resolvedCall3;
            CallableDescriptor referencedProperty = propertyReferenceResolvedCall.getResultingDescriptor();
            if (!(referencedProperty instanceof PropertyDescriptor)) {
                throw new IllegalStateException(("Lateinit intrinsic is incorrectly resolved not to a property: " + referencedProperty).toString());
            }
            if (!((PropertyDescriptor)referencedProperty).isLateInit()) {
                DiagnosticFactory0<PsiElement> diagnostic = LateinitIntrinsicApplicabilityChecker.check$chooseDiagnostic(this, context, Errors.LATEINIT_INTRINSIC_CALL_ON_NON_LATEINIT_WARNING, Errors.LATEINIT_INTRINSIC_CALL_ON_NON_LATEINIT);
                context.getTrace().report(diagnostic.on(reportOn));
            } else if (!this.isBackingFieldAccessible((PropertyDescriptor)referencedProperty, context)) {
                DiagnosticFactory1<PsiElement, PropertyDescriptor> diagnostic = LateinitIntrinsicApplicabilityChecker.check$chooseDiagnostic(this, context, Errors.LATEINIT_INTRINSIC_CALL_ON_NON_ACCESSIBLE_PROPERTY_WARNING, Errors.LATEINIT_INTRINSIC_CALL_ON_NON_ACCESSIBLE_PROPERTY);
                context.getTrace().report(diagnostic.on(reportOn, (PropertyDescriptor)referencedProperty));
            } else {
                DeclarationDescriptor declarationDescriptor = context.getScope().getOwnerDescriptor();
                FunctionDescriptor functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                boolean bl = functionDescriptor != null ? functionDescriptor.isInline() : false;
                if (bl) {
                    DiagnosticFactory0<PsiElement> diagnostic = LateinitIntrinsicApplicabilityChecker.check$chooseDiagnostic(this, context, Errors.LATEINIT_INTRINSIC_CALL_IN_INLINE_FUNCTION_WARNING, Errors.LATEINIT_INTRINSIC_CALL_IN_INLINE_FUNCTION);
                    context.getTrace().report(diagnostic.on(reportOn));
                }
            }
        }
    }

    private final boolean isBackingFieldAccessible(PropertyDescriptor descriptor2, CallCheckerContext context) {
        Set<CallableMemberDescriptor> set = OverridingUtil.filterOutOverridden(OverridingUtil.getOverriddenDeclarations(descriptor2));
        Intrinsics.checkNotNullExpressionValue(set, (String)"filterOutOverridden(Over\u2026Declarations(descriptor))");
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)set);
        if (callableMemberDescriptor == null) {
            return false;
        }
        CallableMemberDescriptor declaration = callableMemberDescriptor;
        KtFile ktFile = DescriptorToSourceUtils.getContainingFile(declaration);
        if (ktFile == null) {
            return false;
        }
        KtFile declarationSourceFile = ktFile;
        KtFile ktFile2 = DescriptorToSourceUtils.getContainingFile(context.getScope().getOwnerDescriptor());
        if (ktFile2 == null) {
            return false;
        }
        KtFile usageSourceFile = ktFile2;
        if (!Intrinsics.areEqual((Object)declarationSourceFile, (Object)usageSourceFile)) {
            return false;
        }
        Sequence sequence2 = SequencesKt.generateSequence((Object)context.getScope().getOwnerDescriptor(), (Function1)isBackingFieldAccessible.1.INSTANCE);
        DeclarationDescriptor declarationDescriptor = declaration.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"declaration.containingDeclaration");
        return SequencesKt.contains((Sequence)sequence2, (Object)declarationDescriptor);
    }

    private static final <T> T check$chooseDiagnostic(LateinitIntrinsicApplicabilityChecker this$0, CallCheckerContext $context, T ifWarning, T ifError) {
        return this$0.isWarningInPre19 && !$context.getLanguageVersionSettings().supportsFeature(LanguageFeature.NativeJsProhibitLateinitIsInitalizedIntrinsicWithoutPrivateAccess) ? ifWarning : ifError;
    }
}

