/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.scopes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSessionKey;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirClassSubstitutionScope;
import org.jetbrains.kotlin.fir.scopes.jvm.JvmMappedScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a0\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u001e\u0010\u0000\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"PLATFORM_TYPE_PARAMETERS_SUBSTITUTION_SCOPE_KEY", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSessionKey;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "wrapScopeWithJvmMapped", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "declaredMemberScope", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "wrapSubstitutionScopeIfNeed", "session", "useSiteMemberScope", "declaration", "builder", "derivedClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "java"})
@SourceDebugExtension(value={"SMAP\nJvmMappedScopes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmMappedScopes.kt\norg/jetbrains/kotlin/fir/resolve/scopes/JvmMappedScopesKt\n+ 2 ScopeSession.kt\norg/jetbrains/kotlin/fir/resolve/ScopeSession\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 SupertypeUtils.kt\norg/jetbrains/kotlin/fir/resolve/SupertypeUtilsKt\n*L\n1#1,91:1\n18#2:92\n19#2:96\n20#2,2:101\n361#3,3:93\n364#3,4:97\n140#4:103\n*S KotlinDebug\n*F\n+ 1 JvmMappedScopes.kt\norg/jetbrains/kotlin/fir/resolve/scopes/JvmMappedScopesKt\n*L\n72#1:92\n72#1:96\n72#1:101,2\n72#1:93,3\n72#1:97,4\n89#1:103\n*E\n"})
public final class JvmMappedScopesKt {
    @NotNull
    private static final ScopeSessionKey<FirClassSymbol<?>, FirTypeScope> PLATFORM_TYPE_PARAMETERS_SUBSTITUTION_SCOPE_KEY;

    @NotNull
    public static final FirContainingNamesAwareScope wrapScopeWithJvmMapped(@NotNull FirClass klass, @NotNull FirContainingNamesAwareScope declaredMemberScope, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        FirContainingNamesAwareScope firContainingNamesAwareScope;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)declaredMemberScope, (String)"declaredMemberScope");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        ClassId classId = FirDeclarationUtilKt.getClassId(klass);
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"classId.asSingleFqName().toUnsafe()");
        FqNameUnsafe kotlinUnsafeFqName = fqNameUnsafe;
        ClassId classId2 = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(kotlinUnsafeFqName);
        if (classId2 == null) {
            return declaredMemberScope;
        }
        ClassId javaClassId = classId2;
        FirSymbolProvider symbolProvider2 = FirSymbolProviderKt.getSymbolProvider(useSiteSession);
        FirClassLikeSymbol<?> firClassLikeSymbol = symbolProvider2.getClassLikeSymbolByClassId(javaClassId);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        if (firRegularClass == null) {
            return declaredMemberScope;
        }
        FirRegularClass javaClass = firRegularClass;
        JvmMappedScope.Companion.Signatures preparedSignatures = JvmMappedScope.Companion.prepareSignatures(javaClass, JavaToKotlinClassMap.INSTANCE.isMutable(kotlinUnsafeFqName));
        if (preparedSignatures.isNotEmpty()) {
            FirTypeScope javaClassUseSiteScope = FirKotlinScopeProviderKt.unsubstitutedScope(javaClass, useSiteSession, scopeSession, false);
            boolean bl = false;
            JvmMappedScope jvmMappedScope = new JvmMappedScope(useSiteSession, klass, javaClass, declaredMemberScope, javaClassUseSiteScope, preparedSignatures);
            firContainingNamesAwareScope = !(klass instanceof FirRegularClass) ? (FirTypeScope)jvmMappedScope : JvmMappedScopesKt.wrapSubstitutionScopeIfNeed(useSiteSession, jvmMappedScope, klass, scopeSession, (FirRegularClass)klass);
        } else {
            firContainingNamesAwareScope = declaredMemberScope;
        }
        return firContainingNamesAwareScope;
    }

    /*
     * WARNING - void declaration
     */
    private static final FirTypeScope wrapSubstitutionScopeIfNeed(FirSession session, FirTypeScope useSiteMemberScope, FirClass declaration, ScopeSession builder2, FirRegularClass derivedClass) {
        Object object;
        Object object2;
        void id$iv;
        void this_$iv;
        if (declaration.getTypeParameters().isEmpty()) {
            return useSiteMemberScope;
        }
        ScopeSession scopeSession = builder2;
        FirClassSymbol<? extends FirClass> firClassSymbol = declaration.getSymbol();
        ScopeSessionKey<FirClassSymbol<?>, FirTypeScope> key$iv = PLATFORM_TYPE_PARAMETERS_SUBSTITUTION_SCOPE_KEY;
        boolean $i$f$getOrBuild = false;
        Map $this$getOrPut$iv$iv = this_$iv.scopes();
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(id$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            HashMap answer$iv$iv = new HashMap();
            $this$getOrPut$iv$iv.put(id$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        $this$getOrPut$iv$iv = (Map)object2;
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
        if (value$iv$iv == null) {
            FirTypeScope firTypeScope;
            boolean bl = false;
            boolean bl2 = false;
            FirRegularClass firRegularClass = FirPlatformClassMapperKt.getPlatformClassMapper(session).getCorrespondingPlatformClass(declaration);
            if (firRegularClass == null) {
                firTypeScope = useSiteMemberScope;
            } else {
                FirRegularClass platformClass = firRegularClass;
                List<FirTypeParameterRef> platformTypeParameters = platformClass.getTypeParameters();
                Map<FirTypeParameterSymbol, ConeKotlinType> platformSubstitution = SupertypeUtilsKt.createSubstitution(platformTypeParameters, ScopeUtilsKt.defaultType(declaration), session);
                ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(platformSubstitution, session);
                firTypeScope = new FirClassSubstitutionScope(session, useSiteMemberScope, PLATFORM_TYPE_PARAMETERS_SUBSTITUTION_SCOPE_KEY, substitutor2, ScopeUtilsKt.defaultType(derivedClass), true, false, derivedClass.getSymbol().toLookupTag(), 64, null);
            }
            FirTypeScope answer$iv$iv = firTypeScope;
            $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.scopes.FirTypeScope");
        }
        return (FirTypeScope)object;
    }

    static {
        boolean $i$f$scopeSessionKey = false;
        PLATFORM_TYPE_PARAMETERS_SUBSTITUTION_SCOPE_KEY = new ScopeSessionKey<FirClassSymbol<?>, FirTypeScope>(){};
    }
}

