/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAssignmentOperatorStatement;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.Stack;
import org.jetbrains.kotlin.fir.resolve.dfa.StackKt;
import org.jetbrains.kotlin.fir.resolve.dfa.UtilKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0006\u0010\u0018\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000eJ\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00062\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0012R \u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer;", "", "()V", "assignedLocalVariablesByFunction", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$FunctionFork;", "functionScopes", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Stack;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "postponedLambdas", "", "", "rootFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "enterFunction", "", "function", "enterFunctionCall", "lambdaArgs", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "exitFunction", "exitFunctionCall", "callCompleted", "getInfoForLocalFunction", "symbol", "isAccessToUnstableLocalVariable", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "reset", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n1747#2,2:392\n1749#2:397\n1603#2,9:399\n1855#2:408\n1856#2:410\n1612#2:411\n1285#2,4:412\n1285#2,4:416\n187#3,3:394\n1#4:398\n1#4:409\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer\n*L\n60#1:392,2\n60#1:397\n135#1:399,9\n135#1:408\n135#1:410\n135#1:411\n135#1:412,4\n156#1:416,4\n64#1:394,3\n135#1:409\n*E\n"})
public final class FirLocalVariableAssignmentAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FirFunction rootFunction;
    @Nullable
    private Map<FirFunctionSymbol<?>, Companion.FunctionFork> assignedLocalVariablesByFunction;
    @NotNull
    private final Stack<Pair<Companion.FunctionFork, Set<FirProperty>>> functionScopes = StackKt.stackOf(new Pair[0]);
    @NotNull
    private final Stack<Map<Companion.FunctionFork, Boolean>> postponedLambdas = StackKt.stackOf(new Map[0]);

    public final void reset() {
        this.rootFunction = null;
        this.assignedLocalVariablesByFunction = null;
        this.postponedLambdas.reset();
        this.functionScopes.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAccessToUnstableLocalVariable(@NotNull FirExpression fir) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        if (this.assignedLocalVariablesByFunction == null) {
            return false;
        }
        FirElement firElement = UtilKt.unwrapElement(fir);
        if (!(firElement instanceof FirQualifiedAccessExpression)) return false;
        FirQualifiedAccessExpression firQualifiedAccessExpression = (FirQualifiedAccessExpression)firElement;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression realFir = firQualifiedAccessExpression;
        FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(realFir.getCalleeReference(), false, 1, null);
        Object object = firPropertySymbol;
        if (firPropertySymbol == null) return false;
        if ((object = (FirProperty)((FirBasedSymbol)object).getFir()) == null) {
            return false;
        }
        Object property2 = object;
        if (((Set)this.functionScopes.top().getSecond()).contains(property2)) return true;
        Iterable $this$any$iv = this.postponedLambdas.all();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Map lambdas = (Map)element$iv;
            boolean bl2 = false;
            Map $this$any$iv2 = lambdas;
            boolean $i$f$any2 = false;
            if ($this$any$iv2.isEmpty()) {
                bl = false;
                continue;
            }
            Iterator iterator3 = $this$any$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator3.next();
                boolean bl3 = false;
                Companion.FunctionFork lambda2 = (Companion.FunctionFork)entry.getKey();
                boolean dataFlowOnly = (Boolean)entry.getValue();
                if (dataFlowOnly && lambda2.getAssignedInside().contains(property2)) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final Companion.FunctionFork getInfoForLocalFunction(FirFunctionSymbol<?> symbol2) {
        FirFunction firFunction = this.rootFunction;
        if (firFunction == null) {
            return null;
        }
        FirFunction root = firFunction;
        if (Intrinsics.areEqual(root.getSymbol(), symbol2)) {
            return null;
        }
        Map<FirFunctionSymbol<?>, Companion.FunctionFork> map = this.assignedLocalVariablesByFunction;
        if (map == null) {
            Map<FirFunctionSymbol<?>, Companion.FunctionFork> map2;
            FirLocalVariableAssignmentAnalyzer $this$getInfoForLocalFunction_u24lambda_u243 = this;
            boolean bl = false;
            Companion.MiniCfgBuilder.MiniCfgData data2 = new Companion.MiniCfgBuilder.MiniCfgData();
            new Companion.MiniCfgBuilder().visitElement((FirElement)root, data2);
            Map<FirFunctionSymbol<?>, Companion.FunctionFork> it = map2 = data2.getFunctionForks();
            boolean bl2 = false;
            $this$getInfoForLocalFunction_u24lambda_u243.assignedLocalVariablesByFunction = it;
            map = map2;
        }
        Map<FirFunctionSymbol<?>, Companion.FunctionFork> cachedMap = map;
        return cachedMap.get(symbol2);
    }

    public final void enterFunction(@NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Object object = StackKt.topOrNull(this.functionScopes);
        if (object == null || (object = (Set)object.getSecond()) == null || (object = CollectionsKt.toMutableSet((Iterable)((Iterable)object))) == null) {
            Set object2 = new LinkedHashSet();
            Set set = object2;
            boolean bl = false;
            this.rootFunction = function2;
            object = object2;
        }
        Pair<Companion.FunctionFork, Set<FirProperty>> prohibitSmartCasts = object;
        Companion.FunctionFork info = this.getInfoForLocalFunction(function2.getSymbol());
        for (Map<Companion.FunctionFork, Boolean> map : this.postponedLambdas.all()) {
            for (Map.Entry entry : map.entrySet()) {
                Companion.FunctionFork otherLambda = (Companion.FunctionFork)entry.getKey();
                boolean dataFlowOnly = (Boolean)entry.getValue();
                if (dataFlowOnly || Intrinsics.areEqual((Object)otherLambda, (Object)info)) continue;
                CollectionsKt.addAll((Collection)((Collection)prohibitSmartCasts), (Iterable)otherLambda.getAssignedInside());
            }
        }
        if (!(function2 instanceof FirAnonymousFunction) || !EventOccurrencesRangeKt.isInPlace(((FirAnonymousFunction)function2).getInvocationKind())) {
            for (Pair pair : this.functionScopes.all()) {
                Companion.FunctionFork outerInfo = (Companion.FunctionFork)pair.component1();
                Set set = (Set)pair.component2();
                if (info != null) {
                    set.addAll((Collection)info.getAssignedInside());
                }
                if (outerInfo == null) continue;
                CollectionsKt.addAll((Collection)((Collection)prohibitSmartCasts), (Iterable)outerInfo.getAssignedLater());
            }
            if (info != null) {
                prohibitSmartCasts.addAll(info.getAssignedLater());
                prohibitSmartCasts.addAll(info.getAssignedInside());
            }
        }
        this.functionScopes.push((Pair<Companion.FunctionFork, Set<FirProperty>>)TuplesKt.to((Object)info, prohibitSmartCasts));
    }

    public final void exitFunction() {
        this.functionScopes.pop();
        if (StackKt.isEmpty(this.functionScopes)) {
            this.rootFunction = null;
            this.assignedLocalVariablesByFunction = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void enterFunctionCall(@NotNull Collection<? extends FirAnonymousFunction> lambdaArgs) {
        void var3_5;
        void $this$associateWithTo$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(lambdaArgs, (String)"lambdaArgs");
        if (this.rootFunction == null) {
            return;
        }
        Iterable iterable = lambdaArgs;
        Stack<Map<Companion.FunctionFork, Boolean>> stack = this.postponedLambdas;
        boolean $i$f$mapNotNull22 = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Companion.FunctionFork $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Companion.FunctionFork it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnonymousFunction it = (FirAnonymousFunction)element$iv$iv;
            boolean bl2 = false;
            if (this.getInfoForLocalFunction(it.getSymbol()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Map $i$f$mapNotNull22 = new LinkedHashMap();
        boolean $i$f$associateWithTo = false;
        for (Object element$iv : $this$associateWithTo$iv) {
            void destination$iv;
            $this$forEach$iv$iv$iv = (Companion.FunctionFork)element$iv;
            Object t = element$iv;
            void var18_21 = destination$iv;
            boolean bl = false;
            Boolean bl4 = false;
            var18_21.put(t, bl4);
        }
        stack.push((Map<Companion.FunctionFork, Boolean>)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final void exitFunctionCall(boolean callCompleted) {
        if (this.rootFunction == null) {
            return;
        }
        Map<Companion.FunctionFork, Boolean> lambdasInCall = this.postponedLambdas.pop();
        if (!callCompleted) {
            void $this$associateWithTo$iv;
            Iterable iterable = lambdasInCall.keySet();
            Map<Companion.FunctionFork, Boolean> map = StackKt.topOrNull(this.postponedLambdas);
            if (map == null) {
                return;
            }
            Map<Companion.FunctionFork, Boolean> destination$iv = map;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv) {
                Companion.FunctionFork functionFork = (Companion.FunctionFork)element$iv;
                Object t = element$iv;
                Map<Companion.FunctionFork, Boolean> map2 = destination$iv;
                boolean bl = false;
                Boolean bl2 = true;
                map2.put((Companion.FunctionFork)t, bl2);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion;", "", "()V", "FunctionFork", "MiniCfgBuilder", "MiniFlow", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$FunctionFork;", "", "assignedLater", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "assignedInside", "(Ljava/util/Set;Ljava/util/Set;)V", "getAssignedInside", "()Ljava/util/Set;", "getAssignedLater", "resolve"})
        public static final class FunctionFork {
            @NotNull
            private final Set<FirProperty> assignedLater;
            @NotNull
            private final Set<FirProperty> assignedInside;

            public FunctionFork(@NotNull Set<? extends FirProperty> assignedLater, @NotNull Set<? extends FirProperty> assignedInside) {
                Intrinsics.checkNotNullParameter(assignedLater, (String)"assignedLater");
                Intrinsics.checkNotNullParameter(assignedInside, (String)"assignedInside");
                this.assignedLater = assignedLater;
                this.assignedInside = assignedInside;
            }

            @NotNull
            public final Set<FirProperty> getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final Set<FirProperty> getAssignedInside() {
                return this.assignedInside;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "", "parents", "", "(Ljava/util/Set;)V", "assignedLater", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getAssignedLater", "()Ljava/util/Set;", "getParents", "fork", "Companion", "resolve"})
        private static final class MiniFlow {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Set<MiniFlow> parents;
            @NotNull
            private final Set<FirProperty> assignedLater;

            public MiniFlow(@NotNull Set<MiniFlow> parents2) {
                Intrinsics.checkNotNullParameter(parents2, (String)"parents");
                this.parents = parents2;
                this.assignedLater = new LinkedHashSet();
            }

            @NotNull
            public final Set<MiniFlow> getParents() {
                return this.parents;
            }

            @NotNull
            public final Set<FirProperty> getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final MiniFlow fork() {
                return new MiniFlow(SetsKt.setOf((Object)this));
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow$Companion;", "", "()V", "start", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "resolve"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final MiniFlow start() {
                    return new MiniFlow(SetsKt.emptySet());
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0012\u00102\u001a\u000203*\b\u0012\u0004\u0012\u0002030\"H\u0002J\u0014\u00104\u001a\u00020\u0002*\u00020\u00032\u0006\u00105\u001a\u000206H\u0002J\u001a\u00107\u001a\u00020\u0002*\u0002032\f\u00108\u001a\b\u0012\u0004\u0012\u00020 0\"H\u0002\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "()V", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "data", "visitAssignmentOperatorStatement", "assignmentOperatorStatement", "Lorg/jetbrains/kotlin/fir/expressions/FirAssignmentOperatorStatement;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "visitDoWhileLoop", "doWhileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitLoop", "loop", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRepeatableElement", "", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTryExpression", "tryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "visitVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "visitWhenExpression", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "visitWhileLoop", "whileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;", "join", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "recordAssignment", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "recordAssignments", "properties", "MiniCfgData", "resolve"})
        @SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n1446#2,5:392\n1620#2,3:398\n1620#2,3:401\n1855#2,2:404\n3190#2,10:406\n1855#2,2:416\n1855#2,2:418\n533#2,6:420\n1855#2,2:426\n1#3:397\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder\n*L\n261#1:392,5\n287#1:398,3\n298#1:401,3\n333#1:404,2\n337#1:406,10\n338#1:416,2\n339#1:418,2\n372#1:420,6\n380#1:426,2\n*E\n"})
        private static final class MiniCfgBuilder
        extends FirVisitor<Unit, MiniCfgData> {
            @Override
            public void visitElement(@NotNull FirElement element, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                element.acceptChildren(this, data2);
            }

            /*
             * WARNING - void declaration
             */
            private final Set<FirProperty> visitRepeatableElement(FirElement element, MiniCfgData data2) {
                void destination$iv;
                void $this$flatMapTo$iv;
                MiniFlow flow = MiniFlow.Companion.start();
                Set<FirProperty> set = (Set<FirProperty>)data2.getVariableDeclarations();
                Collection collection = new LinkedHashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    Map it = (Map)element$iv;
                    boolean bl = false;
                    Iterable list$iv = it.values();
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                Set freeVariables = (Set)destination$iv;
                data2.setFlow(flow);
                element.acceptChildren(this, data2);
                Set<FirProperty> $this$visitRepeatableElement_u24lambda_u241 = set = flow.getAssignedLater();
                boolean bl = false;
                $this$visitRepeatableElement_u24lambda_u241.retainAll(freeVariables);
                return set;
            }

            @Override
            public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction2, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)anonymousFunction2, (String)"anonymousFunction");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitFunction((FirFunction)anonymousFunction2, data2);
            }

            @Override
            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitFunction((FirFunction)simpleFunction, data2);
            }

            @Override
            public void visitFunction(@NotNull FirFunction function2, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                MiniFlow flow = data2.getFlow();
                Set<FirProperty> assignedInside = this.visitRepeatableElement(function2, data2);
                this.recordAssignments(flow, assignedInside);
                data2.setFlow(flow.fork());
                data2.getFunctionForks().put(function2.getSymbol(), new FunctionFork(data2.getFlow().getAssignedLater(), assignedInside));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitWhenExpression(@NotNull FirWhenExpression whenExpression, @NotNull MiniCfgData data2) {
                void var13_13;
                void destination$iv;
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                FirVariable firVariable = whenExpression.getSubjectVariable();
                FirElement firElement = firVariable != null ? (FirElement)firVariable : (FirElement)whenExpression.getSubject();
                if (firElement != null) {
                    ((FirStatement)firElement).accept(this, data2);
                }
                MiniFlow flow = data2.getFlow();
                Iterable iterable = whenExpression.getBranches();
                Object object = new MiniFlow[]{flow};
                object = SetsKt.mutableSetOf((Object[])object);
                MiniCfgBuilder miniCfgBuilder = this;
                MiniCfgData miniCfgData = data2;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FirWhenBranch firWhenBranch = (FirWhenBranch)item$iv;
                    var13_13 = destination$iv;
                    boolean bl = false;
                    data2.setFlow(flow);
                    it.accept(this, data2);
                    var13_13.add(data2.getFlow());
                }
                var13_13 = destination$iv;
                miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitTryExpression(@NotNull FirTryExpression tryExpression, @NotNull MiniCfgData data2) {
                block1: {
                    void var13_13;
                    void destination$iv;
                    void $this$mapTo$iv;
                    Intrinsics.checkNotNullParameter((Object)tryExpression, (String)"tryExpression");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    tryExpression.getTryBlock().accept(this, data2);
                    MiniFlow flow = data2.getFlow();
                    Iterable iterable = tryExpression.getCatches();
                    Object object = new MiniFlow[]{flow};
                    object = SetsKt.mutableSetOf((Object[])object);
                    MiniCfgBuilder miniCfgBuilder = this;
                    MiniCfgData miniCfgData = data2;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        FirCatch firCatch = (FirCatch)item$iv;
                        var13_13 = destination$iv;
                        boolean bl = false;
                        data2.setFlow(flow);
                        it.accept(this, data2);
                        var13_13.add(data2.getFlow());
                    }
                    var13_13 = destination$iv;
                    miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
                    FirBlock firBlock = tryExpression.getFinallyBlock();
                    if (firBlock == null) break block1;
                    firBlock.accept(this, data2);
                }
            }

            private final MiniFlow join(Set<MiniFlow> $this$join) {
                MiniFlow miniFlow = (MiniFlow)CollectionsKt.singleOrNull((Iterable)$this$join);
                if (miniFlow == null) {
                    miniFlow = new MiniFlow($this$join);
                }
                return miniFlow;
            }

            @Override
            public void visitLoop(@NotNull FirLoop loop2, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                MiniFlow entry = data2.getFlow();
                Set<FirProperty> assignedInside = this.visitRepeatableElement(loop2, data2);
                this.recordAssignments(data2.getFlow(), assignedInside);
                Object[] objectArray = new MiniFlow[]{entry, data2.getFlow()};
                data2.setFlow(this.join(SetsKt.setOf((Object[])objectArray)));
            }

            @Override
            public void visitWhileLoop(@NotNull FirWhileLoop whileLoop, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)whileLoop, (String)"whileLoop");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLoop((FirLoop)whileLoop, data2);
            }

            @Override
            public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)doWhileLoop, (String)"doWhileLoop");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLoop((FirLoop)doWhileLoop, data2);
            }

            @Override
            public void visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull MiniCfgData data2) {
                FirExpression it;
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                MiniCfgBuilder visitor2 = this;
                FirFunctionCall $this$visitFunctionCall_u24lambda_u248 = functionCall;
                boolean bl = false;
                FirExpression[] firExpressionArray = new FirExpression[]{$this$visitFunctionCall_u24lambda_u248.getExplicitReceiver(), $this$visitFunctionCall_u24lambda_u248.getDispatchReceiver(), $this$visitFunctionCall_u24lambda_u248.getExtensionReceiver()};
                Iterable $this$forEach$iv = SetsKt.setOfNotNull((Object[])firExpressionArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirExpression it2 = (FirExpression)element$iv;
                    boolean bl2 = false;
                    it2.accept(visitor2, data2);
                }
                Iterable $this$partition$iv = $this$visitFunctionCall_u24lambda_u248.getArgumentList().getArguments();
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    it = (FirExpression)element$iv;
                    boolean bl3 = false;
                    if (it instanceof FirAnonymousFunctionExpression) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                firExpressionArray = new Pair(first$iv, second$iv);
                List postponedFunctionArgs = (List)firExpressionArray.component1();
                List normalArgs = (List)firExpressionArray.component2();
                Iterable $this$forEach$iv2 = normalArgs;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl4 = false;
                    it.accept(visitor2, data2);
                }
                $this$forEach$iv2 = postponedFunctionArgs;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl5 = false;
                    it.accept(visitor2, data2);
                }
                $this$visitFunctionCall_u24lambda_u248.getCalleeReference().accept(visitor2, data2);
            }

            @Override
            public void visitBlock(@NotNull FirBlock block, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                data2.getVariableDeclarations().addLast((Object)new LinkedHashMap());
                this.visitElement((FirElement)block, data2);
                data2.getVariableDeclarations().removeLast();
            }

            @Override
            public void visitProperty(@NotNull FirProperty property2, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitElement((FirElement)property2, data2);
                if (property2.isLocal()) {
                    ((Map)data2.getVariableDeclarations().last()).put(property2.getName(), property2);
                }
            }

            @Override
            public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitElement((FirElement)variableAssignment, data2);
                if (variableAssignment.getExplicitReceiver() != null) {
                    return;
                }
                this.recordAssignment(data2, variableAssignment.getLValue());
            }

            @Override
            public void visitAssignmentOperatorStatement(@NotNull FirAssignmentOperatorStatement assignmentOperatorStatement, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)assignmentOperatorStatement, (String)"assignmentOperatorStatement");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitElement((FirElement)assignmentOperatorStatement, data2);
                FirExpression firExpression2 = assignmentOperatorStatement.getLeftArgument();
                FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
                if (firQualifiedAccessExpression == null) {
                    return;
                }
                FirQualifiedAccessExpression lhs = firQualifiedAccessExpression;
                if (lhs.getExplicitReceiver() != null) {
                    return;
                }
                this.recordAssignment(data2, lhs.getCalleeReference());
            }

            private final void recordAssignment(MiniCfgData $this$recordAssignment, FirReference reference) {
                Object object;
                Object v1;
                Object name;
                block3: {
                    Object object2 = reference instanceof FirNamedReference ? (FirNamedReference)reference : null;
                    if (object2 == null || (object2 = ((FirNamedReference)object2).getName()) == null) {
                        return;
                    }
                    name = object2;
                    List $this$lastOrNull$iv = (List)$this$recordAssignment.getVariableDeclarations();
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        Map it = (Map)element$iv;
                        boolean bl = false;
                        if (!it.containsKey(name)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                if ((object = (Map)v1) == null || (object = (FirProperty)object.get(name)) == null) {
                    return;
                }
                Object property2 = object;
                this.recordAssignments($this$recordAssignment.getFlow(), SetsKt.setOf((Object)property2));
            }

            private final void recordAssignments(MiniFlow $this$recordAssignments, Set<? extends FirProperty> properties2) {
                if (!$this$recordAssignments.getAssignedLater().addAll((Collection<FirProperty>)properties2)) {
                    return;
                }
                Iterable $this$forEach$iv = $this$recordAssignments.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignments(it, properties2);
                }
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\n0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "", "()V", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "getFlow", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "setFlow", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;)V", "functionForks", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$FunctionFork;", "getFunctionForks", "()Ljava/util/Map;", "variableDeclarations", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getVariableDeclarations", "()Lkotlin/collections/ArrayDeque;", "resolve"})
            public static final class MiniCfgData {
                @NotNull
                private MiniFlow flow = MiniFlow.Companion.start();
                @NotNull
                private final ArrayDeque<Map<Name, FirProperty>> variableDeclarations = new ArrayDeque((Collection)CollectionsKt.listOf((Object)new LinkedHashMap()));
                @NotNull
                private final Map<FirFunctionSymbol<?>, FunctionFork> functionForks = new LinkedHashMap();

                @NotNull
                public final MiniFlow getFlow() {
                    return this.flow;
                }

                public final void setFlow(@NotNull MiniFlow miniFlow) {
                    Intrinsics.checkNotNullParameter((Object)miniFlow, (String)"<set-?>");
                    this.flow = miniFlow;
                }

                @NotNull
                public final ArrayDeque<Map<Name, FirProperty>> getVariableDeclarations() {
                    return this.variableDeclarations;
                }

                @NotNull
                public final Map<FirFunctionSymbol<?>, FunctionFork> getFunctionForks() {
                    return this.functionForks;
                }
            }
        }
    }
}

