/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.java.JavaVisibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyAccessor;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.calls.FirSimpleSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\b\u001a\u00020\tH\u0014JT\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\t2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/java/FirJavaVisibilityChecker;", "Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "()V", "platformOverrideVisibilityCheck", "", "candidateInDerivedClass", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "symbolInBaseClass", "visibilityInBaseClass", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "platformVisibilityCheck", "declarationVisibility", "symbol", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isCallToPropertySetter", "supertypeSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "isInPackage", "expected", "Lorg/jetbrains/kotlin/name/FqName;", "java"})
@SourceDebugExtension(value={"SMAP\nFirJavaVisibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaVisibilityChecker.kt\norg/jetbrains/kotlin/fir/java/FirJavaVisibilityChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,72:1\n24#2:73\n*S KotlinDebug\n*F\n+ 1 FirJavaVisibilityChecker.kt\norg/jetbrains/kotlin/fir/java/FirJavaVisibilityChecker\n*L\n50#1:73\n*E\n"})
public final class FirJavaVisibilityChecker
extends FirVisibilityChecker {
    @NotNull
    public static final FirJavaVisibilityChecker INSTANCE = new FirJavaVisibilityChecker();

    private FirJavaVisibilityChecker() {
    }

    @Override
    protected boolean platformVisibilityCheck(@NotNull Visibility declarationVisibility, @NotNull FirBasedSymbol<?> symbol2, @NotNull FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations, @Nullable ReceiverValue dispatchReceiver, @NotNull FirSession session, boolean isCallToPropertySetter, @NotNull SupertypeSupplier supertypeSupplier) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declarationVisibility, (String)"declarationVisibility");
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)useSiteFile, (String)"useSiteFile");
        Intrinsics.checkNotNullParameter(containingDeclarations, (String)"containingDeclarations");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)supertypeSupplier, (String)"supertypeSupplier");
        Visibility visibility2 = declarationVisibility;
        if (Intrinsics.areEqual((Object)visibility2, (Object)JavaVisibilities.ProtectedAndPackage.INSTANCE) ? true : Intrinsics.areEqual((Object)visibility2, (Object)JavaVisibilities.ProtectedStaticVisibility.INSTANCE)) {
            if (Intrinsics.areEqual((Object)this.packageFqName(symbol2), (Object)UtilsKt.getPackageFqName(useSiteFile))) {
                bl = true;
            } else {
                Visibility visibility3;
                ConeClassLikeLookupTag coneClassLikeLookupTag = FirVisibilityCheckerKt.getOwnerLookupTag(symbol2);
                if (coneClassLikeLookupTag == null) {
                    return false;
                }
                ConeClassLikeLookupTag ownerLookupTag = coneClassLikeLookupTag;
                if (this.canSeeProtectedMemberOf(symbol2, containingDeclarations, dispatchReceiver, ownerLookupTag, session, FirVisibilityCheckerKt.isVariableOrNamedFunction(symbol2), symbol2.getFir() instanceof FirSyntheticPropertyAccessor, supertypeSupplier)) {
                    return true;
                }
                if (!isCallToPropertySetter || !(symbol2 instanceof FirSimpleSyntheticPropertySymbol)) {
                    return false;
                }
                FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirSimpleSyntheticPropertySymbol)symbol2).getSetterSymbol();
                if (firPropertyAccessorSymbol != null) {
                    FirCallableSymbol $this$visibility$iv = firPropertyAccessorSymbol;
                    boolean $i$f$getVisibility = false;
                    visibility3 = $this$visibility$iv.getResolvedStatus().getVisibility();
                } else {
                    visibility3 = null;
                }
                bl = Intrinsics.areEqual(visibility3, (Object)Visibilities.Public.INSTANCE);
            }
        } else {
            bl = Intrinsics.areEqual((Object)visibility2, (Object)JavaVisibilities.PackageVisibility.INSTANCE) ? this.isInPackage(symbol2, UtilsKt.getPackageFqName(useSiteFile)) : true;
        }
        return bl;
    }

    @Override
    protected boolean platformOverrideVisibilityCheck(@NotNull FirBasedSymbol<?> candidateInDerivedClass, @NotNull FirBasedSymbol<?> symbolInBaseClass, @NotNull Visibility visibilityInBaseClass) {
        Intrinsics.checkNotNullParameter(candidateInDerivedClass, (String)"candidateInDerivedClass");
        Intrinsics.checkNotNullParameter(symbolInBaseClass, (String)"symbolInBaseClass");
        Intrinsics.checkNotNullParameter((Object)visibilityInBaseClass, (String)"visibilityInBaseClass");
        Visibility visibility2 = visibilityInBaseClass;
        return (Intrinsics.areEqual((Object)visibility2, (Object)JavaVisibilities.ProtectedAndPackage.INSTANCE) ? true : Intrinsics.areEqual((Object)visibility2, (Object)JavaVisibilities.ProtectedStaticVisibility.INSTANCE)) ? true : (Intrinsics.areEqual((Object)visibility2, (Object)JavaVisibilities.PackageVisibility.INSTANCE) ? this.isInPackage(symbolInBaseClass, this.packageFqName(candidateInDerivedClass)) : true);
    }

    private final boolean isInPackage(FirBasedSymbol<?> $this$isInPackage, FqName expected) {
        Object object;
        return Intrinsics.areEqual((Object)this.packageFqName($this$isInPackage), (Object)expected) || $this$isInPackage.getFir() instanceof FirSyntheticPropertyAccessor && Intrinsics.areEqual((Object)((object = FirVisibilityCheckerKt.getOwnerLookupTag($this$isInPackage)) != null && (object = ((ConeClassLikeLookupTag)object).getClassId()) != null ? ((ClassId)object).getPackageFqName() : null), (Object)expected);
    }
}

