/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.FirJvmAnnotationHelperKt;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.FirJvmHelperKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.java.JvmDefaultModeContainerKt;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirInterfaceDefaultMethodCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "findContainingMember", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirInterfaceDefaultMethodCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInterfaceDefaultMethodCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirInterfaceDefaultMethodCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 5 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n+ 6 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,77:1\n126#2:78\n126#2:85\n34#3:79\n34#3:86\n34#3:88\n105#4,3:80\n110#4:84\n106#4,5:89\n105#5:83\n53#6:87\n*S KotlinDebug\n*F\n+ 1 FirInterfaceDefaultMethodCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirInterfaceDefaultMethodCallChecker\n*L\n42#1:78\n54#1:85\n42#1:79\n54#1:86\n57#1:88\n49#1:80,3\n49#1:84\n72#1:89,5\n49#1:83\n57#1:87\n*E\n"})
public final class FirInterfaceDefaultMethodCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirInterfaceDefaultMethodCallChecker INSTANCE = new FirInterfaceDefaultMethodCallChecker();

    private FirInterfaceDefaultMethodCallChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirElement firElement;
        boolean $i$f$isInterface;
        FirRegularClassSymbol typeSymbol;
        boolean supportsDefaults;
        FirSession session;
        Object classId;
        FirCallableSymbol symbol2;
        block16: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            symbol2 = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
            Object object = symbol2;
            if (object == null || (object = ((FirCallableSymbol)object).getCallableId()) == null || (object = ((CallableId)object).getClassId()) == null) {
                return;
            }
            classId = object;
            if (((ClassId)classId).isLocal()) {
                return;
            }
            session = context.getSession();
            supportsDefaults = !FirJvmHelperKt.isJvm6(context);
            typeSymbol = null;
            if (!supportsDefaults && FirCallableSymbolKt.isStatic(symbol2)) {
                FirRegularClassSymbol firRegularClassSymbol = FirInterfaceDefaultMethodCallChecker.check$getTypeSymbol(session, (ClassId)classId);
                if (firRegularClassSymbol == null) {
                    return;
                }
                typeSymbol = firRegularClassSymbol;
                FirClassSymbol $this$isInterface$iv = typeSymbol;
                boolean $i$f$isInterface2 = false;
                ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                $i$f$isInterface = false;
                boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
                if (bl && typeSymbol.getOrigin() instanceof FirDeclarationOrigin.Java) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getINTERFACE_STATIC_METHOD_CALL_FROM_JAVA6_TARGET(), (DiagnosticContext)context, null, 8, null);
                }
            }
            if (FirHelpersKt.explicitReceiverIsNotSuperReference(expression2)) {
                return;
            }
            CheckerContext $this$findClosest_u24default$iv = context;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirRegularClass)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirRegularClass)firDeclaration)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl = false;
                FirElement it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block16;
            }
            firElement = null;
        }
        FirRegularClass firRegularClass = (FirRegularClass)firElement;
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass containingDeclaration = firRegularClass;
        if (typeSymbol == null) {
            FirRegularClassSymbol firRegularClassSymbol = FirInterfaceDefaultMethodCallChecker.check$getTypeSymbol(session, (ClassId)classId);
            if (firRegularClassSymbol == null) {
                return;
            }
            typeSymbol = firRegularClassSymbol;
        }
        JvmDefaultMode jvmDefaultMode2 = JvmDefaultModeContainerKt.getJvmDefaultModeState(session);
        Object $this$isInterface$iv = typeSymbol;
        $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = ((FirClassSymbol)$this$isInterface$iv).getClassKind();
        boolean $i$f$isInterface3 = false;
        boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        if (bl && (typeSymbol.getOrigin() instanceof FirDeclarationOrigin.Java || FirJvmAnnotationHelperKt.isCompiledToJvmDefault(symbol2, session, jvmDefaultMode2))) {
            $this$isInterface$iv = containingDeclaration;
            $i$f$isInterface = false;
            $this$isInterface$iv$iv = ((FirClass)$this$isInterface$iv).getClassKind();
            $i$f$isInterface3 = false;
            boolean bl2 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            if (bl2) {
                FirCallableSymbol<? extends FirCallableDeclaration> containingMember;
                FirCallableDeclaration firCallableDeclaration = this.findContainingMember(context);
                FirCallableSymbol<? extends FirCallableDeclaration> firCallableSymbol = containingMember = firCallableDeclaration != null ? firCallableDeclaration.getSymbol() : null;
                boolean bl3 = firCallableSymbol != null ? !FirJvmAnnotationHelperKt.isCompiledToJvmDefault((FirBasedSymbol)firCallableSymbol, session, jvmDefaultMode2) : false;
                if (bl3) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getINTERFACE_CANT_CALL_DEFAULT_METHOD_VIA_SUPER(), (DiagnosticContext)context, null, 8, null);
                    return;
                }
            }
            if (!supportsDefaults) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getDEFAULT_METHOD_CALL_FROM_JAVA6_TARGET(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final FirCallableDeclaration findContainingMember(CheckerContext $this$findContainingMember) {
        FirElement firElement;
        block3: {
            CheckerContext $this$findClosest$iv = $this$findContainingMember;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirCallableDeclaration)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirCallableDeclaration)firDeclaration)) == null) continue;
                FirElement firElement2 = firElement;
                FirCallableDeclaration it = (FirCallableDeclaration)firElement2;
                boolean bl = false;
                firElement = it instanceof FirSimpleFunction && !Intrinsics.areEqual((Object)((FirSimpleFunction)it).getSymbol().getCallableId().getClassId(), (Object)FirClassLikeSymbolKt.getANONYMOUS_CLASS_ID()) || it instanceof FirProperty ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block3;
            }
            firElement = null;
        }
        return (FirCallableDeclaration)firElement;
    }

    private static final FirRegularClassSymbol check$getTypeSymbol(FirSession session, ClassId classId) {
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(session).getClassLikeSymbolByClassId(classId);
        return firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
    }
}

