/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "collectInitAssignments", "init", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Properties;", "assignments", "", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "AssignmentVisitor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyInitializationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyInitializationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1855#2,2:84\n*S KotlinDebug\n*F\n+ 1 FirPropertyInitializationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker\n*L\n38#1:84,2\n*E\n"})
public final class FirPropertyInitializationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirPropertyInitializationChecker INSTANCE = new FirPropertyInitializationChecker();

    private FirPropertyInitializationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Set properties2 = new LinkedHashSet();
        Set toReport = new LinkedHashSet();
        for (FirDeclaration decl : CollectionsKt.asReversed(declaration.getDeclarations())) {
            FirDeclaration firDeclaration = decl;
            if (firDeclaration instanceof FirProperty) {
                properties2.add(((FirProperty)decl).getSymbol());
                continue;
            }
            if (!(firDeclaration instanceof FirAnonymousInitializer) || !(!((Collection)properties2).isEmpty())) continue;
            this.collectInitAssignments((FirAnonymousInitializer)decl, properties2, toReport);
        }
        Iterable $this$forEach$iv = toReport;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirCallableSymbol propertySymbol;
            FirVariableAssignment exp = (FirVariableAssignment)element$iv;
            boolean bl = false;
            if (FirReferenceUtilsKt.toResolvedCallableSymbol$default(exp.getLValue(), false, 1, null) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)exp.getLValue().getSource(), FirErrors.INSTANCE.getINITIALIZATION_BEFORE_DECLARATION(), (Object)propertySymbol, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void collectInitAssignments(FirAnonymousInitializer init2, Set<? extends FirPropertySymbol> properties2, Set<FirVariableAssignment> assignments) {
        Object object = init2.getControlFlowGraphReference();
        if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph = object;
        AssignmentVisitor visitor2 = new AssignmentVisitor(properties2, (Function1<? super FirVariableAssignment, Unit>)((Function1)new Function1<FirVariableAssignment, Unit>(assignments){
            final /* synthetic */ Set<FirVariableAssignment> $assignments;
            {
                this.$assignments = $assignments;
                super(1);
            }

            public final void invoke(@NotNull FirVariableAssignment it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$assignments.add(it);
            }
        }));
        CfgTraverserKt.collectDataForNode((ControlFlowGraph)graph, TraverseDirection.Forward, SetsKt.emptySet(), visitor2, false);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u000024\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004\u0012 \u0012\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00060\u00050\u0001B+\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJB\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00042\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\"\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00060\u0005H\u0016JU\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004\"\u0010\b\u0000\u0010\u0013*\u0006\u0012\u0002\b\u00030\u0010*\u00020\u00142\u0006\u0010\u000f\u001a\u0002H\u00132\"\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\u0015J>\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00042\u0006\u0010\u000f\u001a\u00020\u00172\"\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00060\u0005H\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker$AssignmentVisitor;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Properties;", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "interestingProperties", "acceptor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "", "(Ljava/util/Set;Lkotlin/jvm/functions/Function1;)V", "visitNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "data", "visitUnionNode", "T", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/UnionNodeMarker;", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;Ljava/util/Collection;)Ljava/util/Set;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirPropertyInitializationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyInitializationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker$AssignmentVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1549#2:84\n1620#2,3:85\n2661#2,7:88\n1549#2:95\n1620#2,3:96\n2661#2,7:99\n*S KotlinDebug\n*F\n+ 1 FirPropertyInitializationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker$AssignmentVisitor\n*L\n59#1:84\n59#1:85,3\n59#1:88,7\n66#1:95\n66#1:96,3\n66#1:99,7\n*E\n"})
    private static final class AssignmentVisitor
    extends ControlFlowGraphVisitor<Set<? extends FirPropertySymbol>, Collection<? extends Pair<? extends EdgeLabel, ? extends Set<? extends FirPropertySymbol>>>> {
        @NotNull
        private final Set<FirPropertySymbol> interestingProperties;
        @NotNull
        private final Function1<FirVariableAssignment, Unit> acceptor;

        public AssignmentVisitor(@NotNull Set<? extends FirPropertySymbol> interestingProperties, @NotNull Function1<? super FirVariableAssignment, Unit> acceptor) {
            Intrinsics.checkNotNullParameter(interestingProperties, (String)"interestingProperties");
            Intrinsics.checkNotNullParameter(acceptor, (String)"acceptor");
            this.interestingProperties = interestingProperties;
            this.acceptor = acceptor;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<FirPropertySymbol> visitNode(@NotNull CFGNode<?> node, @NotNull Collection<? extends Pair<? extends EdgeLabel, ? extends Set<? extends FirPropertySymbol>>> data2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            if (data2.isEmpty()) {
                return SetsKt.emptySet();
            }
            Iterable $this$map$iv = data2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((Set)it.getSecond());
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void r;
                Set $i$f$mapTo2 = (Set)iterator$iv.next();
                Set l = (Set)accumulator$iv;
                boolean bl = false;
                accumulator$iv = CollectionsKt.intersect((Iterable)l, (Iterable)((Iterable)r));
            }
            return (Set)accumulator$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public <T extends CFGNode<?>> Set<FirPropertySymbol> visitUnionNode(@NotNull T node, @NotNull Collection<? extends Pair<? extends EdgeLabel, ? extends Set<? extends FirPropertySymbol>>> data2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            if (data2.isEmpty()) {
                return SetsKt.emptySet();
            }
            Iterable $this$map$iv = data2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((Set)it.getSecond());
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void r;
                Set $i$f$mapTo2 = (Set)iterator$iv.next();
                Set l = (Set)accumulator$iv;
                boolean bl = false;
                accumulator$iv = SetsKt.plus((Set)l, (Iterable)((Iterable)r));
            }
            return (Set)accumulator$iv;
        }

        @Override
        @NotNull
        public Set<FirPropertySymbol> visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, ? extends Set<? extends FirPropertySymbol>>> data2) {
            Set set;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            Set input = this.visitNode((CFGNode)node, data2);
            FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(node.getFir().getLValue(), false, 1, null);
            FirPropertySymbol firPropertySymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
            if (firPropertySymbol == null) {
                return input;
            }
            FirPropertySymbol propertySymbol = firPropertySymbol;
            if (this.interestingProperties.contains(propertySymbol) && !input.contains(propertySymbol)) {
                this.acceptor.invoke((Object)node.getFir());
                set = SetsKt.plus(input, (Object)propertySymbol);
            } else {
                set = input;
            }
            return set;
        }
    }
}

