/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumClassSimpleChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirEnumClassSimpleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirEnumClassSimpleChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumClassSimpleChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,31:1\n56#2:32\n37#3:33\n*S KotlinDebug\n*F\n+ 1 FirEnumClassSimpleChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumClassSimpleChecker\n*L\n18#1:32\n18#1:33\n*E\n"})
public final class FirEnumClassSimpleChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirEnumClassSimpleChecker INSTANCE = new FirEnumClassSimpleChecker();

    private FirEnumClassSimpleChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirClass $this$isEnumClass$iv = declaration;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
            return;
        }
        FirTypeRef firTypeRef = FirHelpersKt.findNonInterfaceSupertype(declaration, context);
        if (firTypeRef != null) {
            FirTypeRef it = firTypeRef;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirErrors.INSTANCE.getCLASS_IN_SUPERTYPE_FOR_ENUM(), (DiagnosticContext)context, null, 8, null);
        }
        if (!((Collection)declaration.getTypeParameters()).isEmpty()) {
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)CollectionsKt.firstOrNull(declaration.getTypeParameters());
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firTypeParameterRef != null ? firTypeParameterRef.getSource() : null), FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_ENUM(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

