/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ValueClassDeclarationCheckerKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ValueClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isParameterAcceptableForInlineClass", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/types/KotlinType;", "isInapplicableParameterType", "frontend"})
@SourceDebugExtension(value={"SMAP\nValueClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ValueClassDeclarationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n1#2:288\n1229#3,2:289\n288#4,2:291\n661#4,11:293\n800#4,11:304\n*S KotlinDebug\n*F\n+ 1 ValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ValueClassDeclarationChecker\n*L\n162#1:289,2\n178#1:291,2\n180#1:293,11\n175#1:304,11\n*E\n"})
public final class ValueClassDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final ValueClassDeclarationChecker INSTANCE = new ValueClassDeclarationChecker();

    private ValueClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block34: {
            Object v11;
            KtNamedFunction typedEquals;
            BindingTrace trace;
            block33: {
                Object v10;
                block32: {
                    boolean bl;
                    KtModifierList inlineOrValueKeyword;
                    block31: {
                        PsiElement modalityModifier;
                        PsiElement valueKeyword;
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        if (!(declaration instanceof KtClass)) {
                            return;
                        }
                        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isInline() && !((ClassDescriptor)descriptor2).isValue()) {
                            return;
                        }
                        if (((ClassDescriptor)descriptor2).getKind() != ClassKind.CLASS) {
                            return;
                        }
                        trace = context.getTrace();
                        KtModifierList ktModifierList = ((KtClass)declaration).getModifierList();
                        Object object = valueKeyword = ktModifierList != null ? ktModifierList.getModifier(KtTokens.VALUE_KEYWORD) : null;
                        if (valueKeyword != null && !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmInlineValueClasses) && !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClasses)) {
                            trace.report(Errors.UNSUPPORTED_FEATURE.on(valueKeyword, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.JvmInlineValueClasses), (Object)context.getLanguageVersionSettings())));
                            return;
                        }
                        KtModifierList ktModifierList2 = ((KtClass)declaration).getModifierList();
                        if (ktModifierList2 == null || (ktModifierList2 = ktModifierList2.getModifier(KtTokens.INLINE_KEYWORD)) == null) {
                            ktModifierList2 = valueKeyword;
                        }
                        if (!((inlineOrValueKeyword = ktModifierList2) != null)) {
                            boolean $i$a$-require-ValueClassDeclarationChecker$check$22 = false;
                            String $i$a$-require-ValueClassDeclarationChecker$check$22 = "Declaration of inline class must have 'inline' keyword";
                            throw new IllegalArgumentException($i$a$-require-ValueClassDeclarationChecker$check$22.toString());
                        }
                        if (((ClassDescriptor)descriptor2).isInner() || DescriptorUtils.isLocal(descriptor2)) {
                            trace.report(Errors.VALUE_CLASS_NOT_TOP_LEVEL.on((PsiElement)inlineOrValueKeyword));
                            return;
                        }
                        if (!((Collection)((KtClass)declaration).getContextReceivers()).isEmpty()) {
                            KtContextReceiverList contextReceiverList = ((KtClass)declaration).getContextReceiverList();
                            if (contextReceiverList == null) {
                                boolean $i$a$-requireNotNull-ValueClassDeclarationChecker$check$32 = false;
                                String $i$a$-requireNotNull-ValueClassDeclarationChecker$check$32 = "Declaration cannot have context receivers with no context receiver list";
                                throw new IllegalArgumentException($i$a$-requireNotNull-ValueClassDeclarationChecker$check$32.toString());
                            }
                            trace.report(Errors.VALUE_CLASS_CANNOT_HAVE_CONTEXT_RECEIVERS.on((KtContextReceiverList)((PsiElement)contextReceiverList)));
                        }
                        if ((modalityModifier = KtPsiUtilKt.modalityModifier(declaration)) != null && ((ClassDescriptor)descriptor2).getModality() != Modality.FINAL) {
                            trace.report(Errors.VALUE_CLASS_NOT_FINAL.on(modalityModifier));
                            return;
                        }
                        KtPrimaryConstructor primaryConstructor2 = ((KtClass)declaration).getPrimaryConstructor();
                        if (primaryConstructor2 == null) {
                            trace.report(Errors.ABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_VALUE_CLASS.on((PsiElement)inlineOrValueKeyword));
                            return;
                        }
                        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClasses)) {
                            if (primaryConstructor2.getValueParameters().isEmpty()) {
                                KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
                                KtElementImplStub it = ktParameterList != null ? (KtElementImplStub)ktParameterList : (KtElementImplStub)((Object)declaration);
                                boolean bl2 = false;
                                trace.report(Errors.VALUE_CLASS_EMPTY_CONSTRUCTOR.on((KtElement)((PsiElement)it)));
                                return;
                            }
                        } else if (primaryConstructor2.getValueParameters().size() != 1) {
                            KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
                            KtElementImplStub it = ktParameterList != null ? (KtElementImplStub)ktParameterList : (KtElementImplStub)((Object)declaration);
                            boolean bl3 = false;
                            trace.report(Errors.INLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE.on((KtElement)((PsiElement)it)));
                            return;
                        }
                        boolean baseParametersOk = true;
                        Object object2 = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
                        if (object2 == null || (object2 = object2.getDefaultType()) == null || (object2 = InlineClassesUtilsKt.substitutedUnderlyingTypes((KotlinType)object2)) == null) {
                            object2 = CollectionsKt.emptyList();
                        }
                        List<KotlinType> baseParameterTypes = object2;
                        for (Pair pair : CollectionsKt.zip((Iterable)primaryConstructor2.getValueParameters(), (Iterable)baseParameterTypes)) {
                            KtParameter baseParameter = (KtParameter)pair.component1();
                            KotlinType baseParameterType = (KotlinType)pair.component2();
                            Intrinsics.checkNotNullExpressionValue((Object)baseParameter, (String)"baseParameter");
                            if (!this.isParameterAcceptableForInlineClass(baseParameter)) {
                                trace.report(Errors.VALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER.on((KtParameter)((PsiElement)baseParameter)));
                                baseParametersOk = false;
                                continue;
                            }
                            KtTypeReference baseParameterTypeReference = baseParameter.getTypeReference();
                            if (baseParameterType == null || baseParameterTypeReference == null) continue;
                            if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.GenericInlineClassParameter) && (TypeUtilsKt.isTypeParameter(baseParameterType) || this.isGenericArrayOfTypeParameter(baseParameterType))) {
                                trace.report(Errors.UNSUPPORTED_FEATURE.on(baseParameterTypeReference, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.GenericInlineClassParameter), (Object)context.getLanguageVersionSettings())));
                                baseParametersOk = false;
                                continue;
                            }
                            if (this.isInapplicableParameterType(baseParameterType)) {
                                trace.report(Errors.VALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE.on((KtTypeReference)((PsiElement)baseParameterTypeReference), baseParameterType));
                                baseParametersOk = false;
                                continue;
                            }
                            if (InlineClassesUtilsKt.isRecursiveInlineOrValueClassType(baseParameterType)) {
                                trace.report(Errors.VALUE_CLASS_CANNOT_BE_RECURSIVE.on((KtTypeReference)((PsiElement)baseParameterTypeReference)));
                                baseParametersOk = false;
                                continue;
                            }
                            if (!InlineClassesUtilsKt.isMultiFieldValueClass(descriptor2) || baseParameter.getDefaultValue() == null) continue;
                            KtExpression ktExpression = baseParameter.getDefaultValue();
                            Intrinsics.checkNotNull((Object)ktExpression);
                            trace.report(Errors.MULTI_FIELD_VALUE_CLASS_PRIMARY_CONSTRUCTOR_DEFAULT_PARAMETER.on((KtExpression)((PsiElement)ktExpression)));
                        }
                        if (!baseParametersOk) {
                            return;
                        }
                        for (KtSuperTypeListEntry supertypeEntry : ((KtClass)declaration).getSuperTypeListEntries()) {
                            ClassifierDescriptor typeDescriptor;
                            KotlinType type2;
                            Object typeReference;
                            if (supertypeEntry.getTypeReference() == null || (KotlinType)trace.get(BindingContext.TYPE, typeReference) == null) continue;
                            if (supertypeEntry instanceof KtDelegatedSuperTypeEntry) {
                                ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                                KtElement ktElement = ((KtDelegatedSuperTypeEntry)supertypeEntry).getDelegateExpression();
                                BindingContext bindingContext = trace.getBindingContext();
                                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                                if (CallUtilKt.getResolvedCall(ktElement, bindingContext) == null || context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClassImplementationByDelegation) && resolvedCall2.getResultingDescriptor() instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getContainingDeclaration(), (Object)trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, primaryConstructor2))) continue;
                                trace.report(Errors.VALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION.on((PsiElement)supertypeEntry));
                                return;
                            }
                            if (type2.getConstructor().getDeclarationDescriptor() == null || DescriptorUtils.isInterface(typeDescriptor)) continue;
                            trace.report(Errors.VALUE_CLASS_CANNOT_EXTEND_CLASSES.on((KtTypeReference)((PsiElement)typeReference)));
                            return;
                        }
                        Sequence<ClassifierDescriptor> $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)descriptor2);
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            ClassifierDescriptor it = (ClassifierDescriptor)element$iv;
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(it), (Object)StandardNames.FqNames.cloneable) || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(it), (Object)ValueClassDeclarationCheckerKt.access$getJavaLangCloneable$p()))) continue;
                            bl = true;
                            break block31;
                        }
                        bl = false;
                    }
                    if (bl) {
                        trace.report(Errors.VALUE_CLASS_CANNOT_BE_CLONEABLE.on((PsiElement)inlineOrValueKeyword));
                        return;
                    }
                    if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.CustomEqualsInValueClasses)) break block34;
                    Iterable $this$firstOrNull$iv = ValueClassDeclarationChecker.check$namedFunctions((KtClass)declaration);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtNamedFunction it = (KtNamedFunction)element$iv;
                        boolean bl5 = false;
                        if (!ValueClassDeclarationChecker.check$isTypedEquals(context, it)) continue;
                        v10 = element$iv;
                        break block32;
                    }
                    v10 = null;
                }
                typedEquals = v10;
                Iterable $this$singleOrNull$iv = ValueClassDeclarationChecker.check$namedFunctions((KtClass)declaration);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KtNamedFunction it = (KtNamedFunction)element$iv;
                    boolean bl = false;
                    if (!ValueClassDeclarationChecker.check$isUntypedEquals(context, it)) continue;
                    if (found$iv) {
                        v11 = null;
                        break block33;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v11 = !found$iv ? null : single$iv;
            }
            KtNamedFunction ktNamedFunction = v11;
            if (ktNamedFunction != null) {
                KtNamedFunction ktNamedFunction2;
                KtNamedFunction $this$check_u24lambda_u247 = ktNamedFunction2 = ktNamedFunction;
                boolean bl = false;
                if (typedEquals == null) {
                    PsiElement psiElement = $this$check_u24lambda_u247;
                    SimpleType simpleType2 = ((ClassDescriptor)descriptor2).getDefaultType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"descriptor.defaultType");
                    trace.report(Errors.INEFFICIENT_EQUALS_OVERRIDING_IN_VALUE_CLASS.on((KtNamedFunction)psiElement, TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType2)));
                }
            }
        }
    }

    private final boolean isInapplicableParameterType(KotlinType $this$isInapplicableParameterType) {
        return TypeUtilsKt.isUnit($this$isInapplicableParameterType) || TypeUtilsKt.isNothing($this$isInapplicableParameterType);
    }

    private final boolean isGenericArrayOfTypeParameter(KotlinType $this$isGenericArrayOfTypeParameter) {
        if (!KotlinBuiltIns.isArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        TypeProjection argument0 = $this$isGenericArrayOfTypeParameter.getArguments().get(0);
        if (argument0.isStarProjection()) {
            return false;
        }
        KotlinType kotlinType = argument0.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"argument0.type");
        KotlinType argument0type = kotlinType;
        return TypeUtilsKt.isTypeParameter(argument0type) || this.isGenericArrayOfTypeParameter(argument0type);
    }

    private final boolean isParameterAcceptableForInlineClass(KtParameter parameter) {
        PsiElement psiElement = KtPsiUtilKt.modalityModifier(parameter);
        boolean isOpen = Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)((Object)KtTokens.OPEN_KEYWORD));
        return parameter.hasValOrVar() && !parameter.isMutable() && !parameter.isVarArg() && !isOpen;
    }

    private static final SimpleFunctionDescriptor check$getFunctionDescriptor(DeclarationCheckerContext $context, KtNamedFunction declaration) {
        return (SimpleFunctionDescriptor)$context.getTrace().getBindingContext().get(BindingContext.FUNCTION, declaration);
    }

    private static final boolean check$isUntypedEquals(DeclarationCheckerContext $context, KtNamedFunction declaration) {
        SimpleFunctionDescriptor simpleFunctionDescriptor = ValueClassDeclarationChecker.check$getFunctionDescriptor($context, declaration);
        return simpleFunctionDescriptor != null ? DescriptorUtilKt.overridesEqualsFromAny(simpleFunctionDescriptor) : false;
    }

    private static final boolean check$isTypedEquals(DeclarationCheckerContext $context, KtNamedFunction declaration) {
        SimpleFunctionDescriptor simpleFunctionDescriptor = ValueClassDeclarationChecker.check$getFunctionDescriptor($context, declaration);
        return simpleFunctionDescriptor != null ? DescriptorUtilKt.isTypedEqualsInValueClass(simpleFunctionDescriptor) : false;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtNamedFunction> check$namedFunctions(KtClass $this$check_u24namedFunctions) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$check_u24namedFunctions.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

