/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInMarkedDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOptInMarkedDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirOptInMarkedDeclarationChecker INSTANCE = new FirOptInMarkedDeclarationChecker();

    private FirOptInMarkedDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirAnnotation annotation2 : declaration.getAnnotations()) {
            FirRegularClassSymbol annotationClass;
            if (FirAnnotationHelpersKt.getAnnotationClassForOptInMarker(annotation2, context.getSession()) == null) continue;
            AnnotationUseSiteTarget useSiteTarget = annotation2.getUseSiteTarget();
            if (declaration instanceof FirPropertyAccessor && ((FirPropertyAccessor)declaration).isGetter() || useSiteTarget == AnnotationUseSiteTarget.PROPERTY_GETTER) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"getter", (DiagnosticContext)context, null, 16, null);
            }
            if (useSiteTarget == AnnotationUseSiteTarget.SETTER_PARAMETER || useSiteTarget != AnnotationUseSiteTarget.PROPERTY && useSiteTarget != AnnotationUseSiteTarget.PROPERTY_SETTER && declaration instanceof FirValueParameter && FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotationClass).contains((Object)KotlinTarget.VALUE_PARAMETER)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"parameter", (DiagnosticContext)context, null, 16, null);
            }
            if (declaration instanceof FirProperty && ((FirProperty)declaration).isLocal()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"variable", (DiagnosticContext)context, null, 16, null);
            }
            if (useSiteTarget != AnnotationUseSiteTarget.FIELD && useSiteTarget != AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"field", (DiagnosticContext)context, null, 16, null);
        }
        if (!(declaration instanceof FirCallableDeclaration)) {
            return;
        }
        FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)declaration).getReceiverParameter();
        if (firReceiverParameter == null) {
            return;
        }
        FirReceiverParameter receiver = firReceiverParameter;
        for (FirAnnotation annotation3 : receiver.getAnnotations()) {
            if (FirAnnotationHelpersKt.getAnnotationClassForOptInMarker(annotation3, context.getSession()) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation3.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"parameter", (DiagnosticContext)context, null, 16, null);
        }
    }
}

