/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.PropertyInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "()V", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationInfoData;", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "capturedWrites", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "isInitialized", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "PropertyReporter", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyInitializationAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyInitializationAnalyzer.kt\norg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n847#2,2:92\n*S KotlinDebug\n*F\n+ 1 FirPropertyInitializationAnalyzer.kt\norg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer\n*L\n38#1:92,2\n*E\n"})
public final class FirPropertyInitializationAnalyzer
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final FirPropertyInitializationAnalyzer INSTANCE = new FirPropertyInitializationAnalyzer();

    private FirPropertyInitializationAnalyzer() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull ControlFlowGraph graph, @NotNull DiagnosticReporter reporter, @NotNull PropertyInitializationInfoData data2, @NotNull Set<? extends FirPropertySymbol> properties2, @NotNull Set<? extends FirVariableAssignment> capturedWrites, @NotNull CheckerContext context) {
        void destination$iv;
        void $this$filterNotTo$iv;
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(properties2, (String)"properties");
        Intrinsics.checkNotNullParameter(capturedWrites, (String)"capturedWrites");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable iterable = properties2;
        Collection collection = new LinkedHashSet();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv : $this$filterNotTo$iv) {
            FirPropertySymbol it = (FirPropertySymbol)element$iv;
            boolean bl = false;
            if (INSTANCE.isInitialized(it)) continue;
            destination$iv.add(element$iv);
        }
        Set localProperties = (Set)destination$iv;
        PropertyReporter reporterVisitor = new PropertyReporter(data2, localProperties, capturedWrites, reporter, context);
        CfgTraverserKt.traverse(graph, TraverseDirection.Forward, reporterVisitor);
    }

    private final boolean isInitialized(FirVariableSymbol<?> $this$isInitialized) {
        return ((FirVariable)$this$isInitialized.getFir()).getInitializer() != null || ((FirVariable)$this$isInitialized.getFir()).getDelegate() != null || $this$isInitialized instanceof FirPropertySymbol && Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter((FirProperty)((FirPropertySymbol)$this$isInitialized).getFir()), (Object)true);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001fH\u0016J'\u0010 \u001a\u00020\u001c\"\u0010\b\u0000\u0010!*\u0006\u0012\u0002\b\u00030\u0018*\u00020\"2\u0006\u0010\u001d\u001a\u0002H!H\u0016\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020%H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer$PropertyReporter;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationInfoData;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "capturedWrites", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationInfoData;Ljava/util/Set;Ljava/util/Set;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "getCapturedWrites", "()Ljava/util/Set;", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getData", "()Lorg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationInfoData;", "getLocalProperties", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "propertySymbol", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "getPropertySymbol", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "visitNode", "", "node", "visitQualifiedAccessNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "visitUnionNode", "T", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/UnionNodeMarker;", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)V", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirPropertyInitializationAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyInitializationAnalyzer.kt\norg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer$PropertyReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,91:1\n1747#2,3:92\n1726#2,3:96\n45#3:95\n*S KotlinDebug\n*F\n+ 1 FirPropertyInitializationAnalyzer.kt\norg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer$PropertyReporter\n*L\n76#1:92,3\n84#1:96,3\n83#1:95\n*E\n"})
    private static final class PropertyReporter
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final PropertyInitializationInfoData data;
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private final Set<FirVariableAssignment> capturedWrites;
        @NotNull
        private final DiagnosticReporter reporter;
        @NotNull
        private final CheckerContext context;

        public PropertyReporter(@NotNull PropertyInitializationInfoData data2, @NotNull Set<? extends FirPropertySymbol> localProperties, @NotNull Set<? extends FirVariableAssignment> capturedWrites, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            Intrinsics.checkNotNullParameter(capturedWrites, (String)"capturedWrites");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.data = data2;
            this.localProperties = localProperties;
            this.capturedWrites = capturedWrites;
            this.reporter = reporter;
            this.context = context;
        }

        @NotNull
        public final PropertyInitializationInfoData getData() {
            return this.data;
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Set<FirVariableAssignment> getCapturedWrites() {
            return this.capturedWrites;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public <T extends CFGNode<?>> void visitUnionNode(@NotNull T node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        private final FirPropertySymbol getPropertySymbol(CFGNode<?> $this$propertySymbol) {
            Object obj = $this$propertySymbol.getFir();
            FirElement firElement = obj instanceof FirQualifiedAccess ? (FirQualifiedAccess)obj : null;
            return firElement != null && (firElement = firElement.getCalleeReference()) != null ? FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)firElement, false, 1, null) : null;
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirPropertySymbol firPropertySymbol = this.getPropertySymbol(node);
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            if (!((FirProperty)symbol2.getFir()).isVal()) {
                return;
            }
            if (this.capturedWrites.contains(node.getFir())) {
                if (((FirProperty)symbol2.getFir()).isLocal()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), FirErrors.INSTANCE.getCAPTURED_VAL_INITIALIZATION(), (Object)symbol2, (DiagnosticContext)this.context, null, 16, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), FirErrors.INSTANCE.getCAPTURED_MEMBER_VAL_INITIALIZATION(), (Object)symbol2, (DiagnosticContext)this.context, null, 16, null);
                }
            } else {
                boolean bl;
                block10: {
                    Iterable $this$any$iv = this.data.getValue(node).values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PropertyInitializationInfo it = (PropertyInitializationInfo)element$iv;
                            boolean bl2 = false;
                            EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)it.get(symbol2));
                            boolean bl3 = eventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited(eventOccurrencesRange) : false;
                            if (!bl3) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), (Object)symbol2, (DiagnosticContext)this.context, null, 16, null);
                }
            }
        }

        @Override
        public void visitQualifiedAccessNode(@NotNull QualifiedAccessNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirPropertySymbol firPropertySymbol = this.getPropertySymbol(node);
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            if (this.localProperties.contains(symbol2)) {
                FirMemberDeclaration $this$isLateInit$iv = (FirMemberDeclaration)symbol2.getFir();
                boolean $i$f$isLateInit = false;
                if (!$this$isLateInit$iv.getStatus().isLateInit() && !(symbol2 instanceof FirSyntheticPropertySymbol)) {
                    boolean bl;
                    block7: {
                        Iterable $this$all$iv = this.data.getValue(node).values();
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                PropertyInitializationInfo it = (PropertyInitializationInfo)element$iv;
                                boolean bl2 = false;
                                EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)it.get(symbol2));
                                if (eventOccurrencesRange != null ? EventOccurrencesRangeKt.isDefinitelyVisited(eventOccurrencesRange) : false) continue;
                                bl = false;
                                break block7;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) {
                        KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)node.getFir().getSource(), FirErrors.INSTANCE.getUNINITIALIZED_VARIABLE(), (Object)symbol2, (DiagnosticContext)this.context, null, 16, null);
                    }
                }
            }
        }
    }
}

