/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.AssignmentTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

public final class OverloadedAssignmentTranslator
extends AssignmentTranslator {
    @NotNull
    private final ResolvedCall<? extends FunctionDescriptor> resolvedCall;

    @NotNull
    public static JsExpression doTranslate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$1(0);
        }
        if (context == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$1(1);
        }
        if (expression2 == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$0(1);
        }
        return new OverloadedAssignmentTranslator(expression2, context).translate();
    }

    private OverloadedAssignmentTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$1(2);
        }
        if (context == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$1(3);
        }
        if (expression2 == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$0(3);
        }
        super(expression2, context);
        this.resolvedCall = CallUtilKt.getFunctionResolvedCallWithAssert(expression2, context.bindingContext());
    }

    @NotNull
    private JsExpression translate() {
        if (this.isVariableReassignment) {
            return this.reassignment();
        }
        KtExpression left = this.expression.getLeft();
        assert (left != null);
        return this.overloadedMethodInvocation(AccessTranslationUtils.getAccessTranslator(left, this.context()));
    }

    @NotNull
    private JsExpression reassignment() {
        KtExpression left = this.expression.getLeft();
        assert (left != null);
        AccessTranslator accessTranslator = AccessTranslationUtils.getAccessTranslator(left, this.context()).getCached();
        JsExpression newValue2 = this.overloadedMethodInvocation(accessTranslator);
        JsExpression jsExpression = accessTranslator.translateAsSet(newValue2);
        if (jsExpression == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$0(4);
        }
        if (jsExpression == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$1(4);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression overloadedMethodInvocation(AccessTranslator accessTranslator) {
        JsBlock innerBlock = new JsBlock();
        TranslationContext innerContext = this.context().innerBlock(innerBlock);
        JsExpression oldValue = accessTranslator.translateAsGet();
        JsBlock argumentBlock = new JsBlock();
        TranslationContext argumentContext = innerContext.innerBlock(argumentBlock);
        KtExpression argumentPsi = this.expression.getRight();
        assert (argumentPsi != null);
        JsExpression argument2 = Translation.translateAsExpression(argumentPsi, argumentContext);
        if (!argumentBlock.isEmpty()) {
            oldValue = innerContext.defineTemporary(oldValue);
            innerContext.addStatementsToCurrentBlockFrom(argumentBlock);
        }
        HashMap<KtExpression, JsExpression> aliases = new HashMap<KtExpression, JsExpression>();
        aliases.put(argumentPsi, argument2);
        innerContext = innerContext.innerContextWithAliasesForExpressions(aliases);
        JsExpression result2 = CallTranslator.translate(innerContext, this.resolvedCall, oldValue);
        this.context().addStatementsToCurrentBlockFrom(innerBlock);
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$0(5);
        }
        if (jsExpression == null) {
            OverloadedAssignmentTranslator.$$$reportNull$$$1(5);
        }
        return jsExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "reassignment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "overloadedMethodInvocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTranslate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "reassignment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "overloadedMethodInvocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTranslate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

