/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProvider;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J)\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompanionGenerationTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "generatedDeclarationProvider", "Lorg/jetbrains/kotlin/fir/extensions/FirSwitchableExtensionDeclarationsSymbolProvider;", "getGeneratedDeclarationProvider", "()Lorg/jetbrains/kotlin/fir/extensions/FirSwitchableExtensionDeclarationsSymbolProvider;", "setGeneratedDeclarationProvider", "(Lorg/jetbrains/kotlin/fir/extensions/FirSwitchableExtensionDeclarationsSymbolProvider;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "generateCompanion", "", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "resolve"})
public final class FirCompanionGenerationTransformer
extends FirTransformer {
    @NotNull
    private final FirSession session;
    public FirSwitchableExtensionDeclarationsSymbolProvider generatedDeclarationProvider;

    public FirCompanionGenerationTransformer(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirSwitchableExtensionDeclarationsSymbolProvider getGeneratedDeclarationProvider() {
        FirSwitchableExtensionDeclarationsSymbolProvider firSwitchableExtensionDeclarationsSymbolProvider = this.generatedDeclarationProvider;
        if (firSwitchableExtensionDeclarationsSymbolProvider != null) {
            return firSwitchableExtensionDeclarationsSymbolProvider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"generatedDeclarationProvider");
        return null;
    }

    public final void setGeneratedDeclarationProvider(@NotNull FirSwitchableExtensionDeclarationsSymbolProvider firSwitchableExtensionDeclarationsSymbolProvider) {
        Intrinsics.checkNotNullParameter((Object)firSwitchableExtensionDeclarationsSymbolProvider, (String)"<set-?>");
        this.generatedDeclarationProvider = firSwitchableExtensionDeclarationsSymbolProvider;
    }

    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FirSwitchableExtensionDeclarationsSymbolProvider firSwitchableExtensionDeclarationsSymbolProvider = FirSwitchableExtensionDeclarationsSymbolProviderKt.getGeneratedDeclarationsSymbolProvider(this.session);
        if (firSwitchableExtensionDeclarationsSymbolProvider == null) {
            return file2;
        }
        this.setGeneratedDeclarationProvider(firSwitchableExtensionDeclarationsSymbolProvider);
        return file2.transformDeclarations(this, data2);
    }

    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        this.generateCompanion(regularClass);
        return regularClass.transformDeclarations(this, data2);
    }

    private final void generateCompanion(FirRegularClass regularClass) {
        FirSwitchableExtensionDeclarationsSymbolProvider firSwitchableExtensionDeclarationsSymbolProvider = FirSwitchableExtensionDeclarationsSymbolProviderKt.getGeneratedDeclarationsSymbolProvider(this.session);
        if (firSwitchableExtensionDeclarationsSymbolProvider == null) {
            return;
        }
        this.setGeneratedDeclarationProvider(firSwitchableExtensionDeclarationsSymbolProvider);
        ClassId classId = FirDeclarationUtilKt.getClassId(regularClass).createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"regularClass.classId.cre\u2026AME_FOR_COMPANION_OBJECT)");
        ClassId companionClassId = classId;
        FirClassLikeSymbol<?> generatedCompanion = this.getGeneratedDeclarationProvider().getClassLikeSymbolByClassId(companionClassId);
        if (generatedCompanion != null) {
            if (generatedCompanion instanceof FirRegularClassSymbol) {
                if (regularClass.getCompanionObjectSymbol() != null) {
                    throw new IllegalStateException(("Plugin generated companion object for class " + regularClass + ", but it is already present in class").toString());
                }
                regularClass.replaceCompanionObjectSymbol((FirRegularClassSymbol)generatedCompanion);
            } else {
                throw new IllegalStateException("Plugin generated non regular class as companion object".toString());
            }
        }
    }
}

