/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessorKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTransformerBasedResolveProcessor;
import org.jetbrains.kotlin.util.AnalysisExceptionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirTotalResolveProcessor;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "processors", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirResolveProcessor;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "process", "", "files", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirTotalResolveProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTotalResolveProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirTotalResolveProcessor\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 AnalysisExceptions.kt\norg/jetbrains/kotlin/util/AnalysisExceptionsKt\n*L\n1#1,93:1\n140#2,2:94\n139#2:96\n58#3,4:97\n*S KotlinDebug\n*F\n+ 1 FirTotalResolveProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirTotalResolveProcessor\n*L\n35#1:94,2\n35#1:96\n35#1:97,4\n*E\n"})
public final class FirTotalResolveProcessor {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final List<FirResolveProcessor> processors;

    public FirTotalResolveProcessor(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.scopeSession = new ScopeSession();
        this.processors = FirTotalResolveProcessorKt.createAllCompilerResolveProcessors(this.session, this.scopeSession);
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void process(@NotNull List<? extends FirFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        for (FirResolveProcessor processor2 : this.processors) {
            processor2.beforePhase();
            try {
                FirResolveProcessor firResolveProcessor = processor2;
                if (firResolveProcessor instanceof FirTransformerBasedResolveProcessor) {
                    for (FirFile firFile : files2) {
                        boolean $i$f$withFileAnalysisExceptionWrapping = false;
                        KtSourceFile ktSourceFile = firFile.getSourceFile();
                        String string2 = ktSourceFile != null ? ktSourceFile.getPath() : null;
                        AbstractKtSourceElement abstractKtSourceElement = firFile.getSource();
                        boolean $i$f$withFileAnalysisExceptionWrapping2 = false;
                        try {
                            boolean bl = false;
                            ((FirTransformerBasedResolveProcessor)processor2).processFile(firFile);
                            Unit unit2 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable$iv$iv) {
                            void fileSource$iv$iv;
                            void filePath$iv$iv;
                            throw AnalysisExceptionsKt.wrapIntoFileAnalysisExceptionIfNeeded(throwable$iv$iv, (String)filePath$iv$iv, (AbstractKtSourceElement)fileSource$iv$iv, (Function1<? super Integer, Pair<Integer, Integer>>)((Function1)new Function1<Integer, Pair<? extends Integer, ? extends Integer>>(firFile){
                                final /* synthetic */ FirFile $file$inlined;
                                {
                                    this.$file$inlined = firFile;
                                    super(1);
                                }

                                @Nullable
                                public final Pair<Integer, Integer> invoke(int it) {
                                    int it2 = it;
                                    boolean bl = false;
                                    KtSourceFileLinesMapping ktSourceFileLinesMapping = this.$file$inlined.getSourceFileLinesMapping();
                                    return ktSourceFileLinesMapping != null ? ktSourceFileLinesMapping.getLineAndColumnByOffset(it2) : null;
                                }
                            }));
                        }
                    }
                    continue;
                }
                if (!(firResolveProcessor instanceof FirGlobalResolveProcessor)) continue;
                ((FirGlobalResolveProcessor)processor2).process((Collection<? extends FirFile>)files2);
            }
            finally {
                processor2.afterPhase();
            }
        }
    }
}

