/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.RangeHeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.ComparableRangeInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.FloatingPointRangeHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionDirection;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.UnsignedProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UtilsKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J&\u0010 \u001a\u0004\u0018\u00010\u001f*\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020\u001b*\u0004\u0018\u00010(H\u0002J\u000e\u0010)\u001a\u00020\u001b*\u0004\u0018\u00010*H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/Transformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;)V", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/RangeHeaderInfoBuilder;", "computeComparisonClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "lowerType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "upperType", "argumentType", "getScopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "leastCommonPrimitiveNumericType", "t1", "t2", "matchStdlibExtensionContainsCall", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "buildContainsComparison", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "headerInfo", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "argument", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "isPromotableToInt", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "isPromotableToUInt", "Lorg/jetbrains/kotlin/builtins/UnsignedType;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nRangeContainsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeContainsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/Transformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,440:1\n381#2,11:441\n377#3,13:452\n98#4,2:465\n*S KotlinDebug\n*F\n+ 1 RangeContainsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/Transformer\n*L\n297#1:441,11\n344#1:452,13\n344#1:465,2\n*E\n"})
final class Transformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrSymbolOwner container;
    @NotNull
    private final RangeHeaderInfoBuilder headerInfoBuilder;

    public Transformer(@NotNull CommonBackendContext context, @NotNull IrSymbolOwner container) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.context = context;
        this.container = container;
        this.headerInfoBuilder = new RangeHeaderInfoBuilder(this.context, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>((Object)this){

            @NotNull
            public final IrSymbol invoke() {
                return ((Transformer)this.receiver).getScopeOwnerSymbol();
            }

            @NotNull
            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }

            @NotNull
            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Transformer.class);
            }
        }));
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSymbolOwner getContainer() {
        return this.container;
    }

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        Object object = this.getCurrentScope();
        if (object == null || (object = ((ScopeWithIr)object).getScope()) == null || (object = ((Scope)object).getScopeOwnerSymbol()) == null) {
            object = this.container.getSymbol();
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchStdlibExtensionContainsCall(IrCall expression2) {
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (callee.getValueParameters().size() != 1) return false;
        IrValueParameter irValueParameter = callee.getExtensionReceiverParameter();
        IrAnnotationContainer irAnnotationContainer = irValueParameter;
        if (irValueParameter == null) return false;
        IrType irType = irAnnotationContainer.getType();
        irAnnotationContainer = irType;
        if (irType == null) return false;
        if (!IrTypeUtilsKt.isSubtypeOfClass((IrType)irAnnotationContainer, this.context.getIr().getSymbols().getClosedRange())) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getKotlinFqName(callee), (Object)new FqName("kotlin.ranges." + OperatorNameConventions.CONTAINS))) return false;
        return true;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression receiver;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrStatementOrigin origin = expression2.getOrigin();
        if (!Intrinsics.areEqual((Object)origin, (Object)IrStatementOrigin.IN.INSTANCE) && !Intrinsics.areEqual((Object)origin, (Object)IrStatementOrigin.NOT_IN.INSTANCE)) {
            return super.visitCall(expression2);
        }
        if (Intrinsics.areEqual((Object)origin, (Object)IrStatementOrigin.NOT_IN.INSTANCE) && Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.context.getIrBuiltIns().getBooleanNotSymbol())) {
            return super.visitCall(expression2);
        }
        if (expression2.getExtensionReceiver() != null && !this.matchStdlibExtensionContainsCall(expression2)) {
            return super.visitCall(expression2);
        }
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression == null) {
            irExpression = expression2.getExtensionReceiver();
        }
        if ((object = (receiver = irExpression)) == null || (object = (HeaderInfo)object.accept(this.headerInfoBuilder, expression2)) == null) {
            return super.visitCall(expression2);
        }
        Object headerInfo = object;
        IrExpression irExpression2 = expression2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression2);
        IrExpression argument2 = irExpression2;
        if (IrTypeUtilsKt.isNullable(argument2.getType())) {
            return super.visitCall(expression2);
        }
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        IrExpression irExpression3 = this.buildContainsComparison(builder2, (HeaderInfo)headerInfo, argument2, origin);
        if (irExpression3 == null) {
            irExpression3 = super.visitCall(expression2);
        }
        return irExpression3;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression buildContainsComparison(DeclarationIrBuilder $this$buildContainsComparison, HeaderInfo headerInfo, IrExpression argument2, IrStatementOrigin origin) {
        IrExpression irExpression;
        Object object;
        Object lowerClause;
        Object $this$buildContainsComparison_u24lambda_u243;
        Object object2;
        IrFunctionAccessExpression $this$buildContainsComparison_u24lambda_u242_u24lambda_u241;
        Object v6;
        Object it2;
        Object object3;
        Object $this$singleOrNull$iv;
        IrSimpleFunctionSymbol upperCompFun;
        IrSimpleFunctionSymbol lowerCompFun;
        boolean useLowerClauseOnLeftSide;
        IrExpression upperExpression;
        IrExpression lowerExpression;
        IrExpression argExpression;
        List additionalStatements2;
        boolean useCompareTo;
        block40: {
            IrExpression tmpLowerExpression;
            IrVariable lowerVar;
            Pair pair;
            IrClass comparisonClass;
            IrClass irClass2;
            IrExpression lower2 = null;
            IrExpression upper = null;
            boolean isUpperInclusive = false;
            boolean shouldUpperComeFirst = false;
            useCompareTo = false;
            boolean isNumericRange = false;
            additionalStatements2 = new ArrayList();
            HeaderInfo headerInfo2 = headerInfo;
            if (headerInfo2 instanceof NumericHeaderInfo) {
                NumericHeaderInfo numericHeaderInfo = (NumericHeaderInfo)headerInfo;
                if (numericHeaderInfo instanceof ProgressionHeaderInfo) {
                    additionalStatements2.addAll((Collection)((ProgressionHeaderInfo)headerInfo).getAdditionalStatements());
                } else if (numericHeaderInfo instanceof IndexedGetHeaderInfo) {
                    throw new IllegalStateException("Unexpected IndexedGetHeaderInfo returned by RangeHeaderInfoBuilder".toString());
                }
                switch (WhenMappings.$EnumSwitchMapping$0[((NumericHeaderInfo)headerInfo).getDirection().ordinal()]) {
                    case 1: {
                        Long l = UtilsKt.getConstLongValue(((NumericHeaderInfo)headerInfo).getStep());
                        long l2 = 1L;
                        if (l == null || l != l2) {
                            return null;
                        }
                        lower2 = ((NumericHeaderInfo)headerInfo).getFirst();
                        upper = ((NumericHeaderInfo)headerInfo).getLast();
                        shouldUpperComeFirst = ((NumericHeaderInfo)headerInfo).isReversed();
                        break;
                    }
                    case 2: {
                        Long l = UtilsKt.getConstLongValue(((NumericHeaderInfo)headerInfo).getStep());
                        long l2 = -1L;
                        if (l == null || l != l2) {
                            return null;
                        }
                        lower2 = ((NumericHeaderInfo)headerInfo).getLast();
                        upper = ((NumericHeaderInfo)headerInfo).getFirst();
                        shouldUpperComeFirst = !((NumericHeaderInfo)headerInfo).isReversed();
                        break;
                    }
                    case 3: {
                        return null;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                useCompareTo = ((NumericHeaderInfo)headerInfo).getProgressionType() instanceof UnsignedProgressionType;
                isUpperInclusive = ((NumericHeaderInfo)headerInfo).isLastInclusive();
                isNumericRange = true;
            } else if (headerInfo2 instanceof FloatingPointRangeHeaderInfo) {
                lower2 = ((FloatingPointRangeHeaderInfo)headerInfo).getStart();
                upper = ((FloatingPointRangeHeaderInfo)headerInfo).getEndInclusive();
                isUpperInclusive = true;
                shouldUpperComeFirst = false;
                useCompareTo = false;
                isNumericRange = true;
            } else if (headerInfo2 instanceof ComparableRangeInfo) {
                lower2 = ((ComparableRangeInfo)headerInfo).getStart();
                upper = ((ComparableRangeInfo)headerInfo).getEndInclusive();
                isUpperInclusive = true;
                shouldUpperComeFirst = false;
                useCompareTo = true;
                isNumericRange = false;
            } else {
                return null;
            }
            IrExpression arg = argument2;
            IrBuiltIns builtIns = $this$buildContainsComparison.getContext().getIrBuiltIns();
            if (isNumericRange) {
                irClass2 = this.computeComparisonClass(this.context.getIr().getSymbols(), lower2.getType(), upper.getType(), arg.getType());
                if (irClass2 == null) {
                    return null;
                }
            } else {
                boolean bl = headerInfo instanceof ComparableRangeInfo;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                irClass2 = comparisonClass = (IrClass)this.context.getIr().getSymbols().getComparable().getOwner();
            }
            if (isNumericRange) {
                arg = UtilsKt.castIfNecessary(arg, comparisonClass);
            }
            Pair pair2 = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, arg, "containsArg", null, false, 12, null);
            IrVariable argVar = (IrVariable)pair2.component1();
            argExpression = (IrExpression)pair2.component2();
            lowerExpression = null;
            upperExpression = null;
            useLowerClauseOnLeftSide = false;
            if (argVar != null) {
                pair = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, lower2, "containsLower", null, false, 12, null);
                lowerVar = (IrVariable)pair.component1();
                tmpLowerExpression = (IrExpression)pair.component2();
                Pair pair3 = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, upper, "containsUpper", null, false, 12, null);
                IrVariable upperVar = (IrVariable)pair3.component1();
                IrExpression tmpUpperExpression = (IrExpression)pair3.component2();
                if (shouldUpperComeFirst) {
                    CollectionsKt.addIfNotNull(additionalStatements2, upperVar);
                    CollectionsKt.addIfNotNull(additionalStatements2, lowerVar);
                } else {
                    CollectionsKt.addIfNotNull(additionalStatements2, lowerVar);
                    CollectionsKt.addIfNotNull(additionalStatements2, upperVar);
                }
                lowerExpression = IrUtilsKt.shallowCopy(tmpLowerExpression);
                upperExpression = IrUtilsKt.shallowCopy(tmpUpperExpression);
                useLowerClauseOnLeftSide = true;
            } else if (UtilsKt.getCanHaveSideEffects(lower2) && UtilsKt.getCanHaveSideEffects(upper)) {
                if (shouldUpperComeFirst) {
                    pair = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, upper, "containsUpper", null, false, 12, null);
                    IrVariable upperVar = (IrVariable)pair.component1();
                    IrExpression tmpUpperExpression = (IrExpression)pair.component2();
                    IrVariable irVariable2 = upperVar;
                    Intrinsics.checkNotNull((Object)irVariable2);
                    additionalStatements2.add(irVariable2);
                    lowerExpression = lower2;
                    upperExpression = IrUtilsKt.shallowCopy(tmpUpperExpression);
                    useLowerClauseOnLeftSide = true;
                } else {
                    pair = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, lower2, "containsLower", null, false, 12, null);
                    lowerVar = (IrVariable)pair.component1();
                    tmpLowerExpression = (IrExpression)pair.component2();
                    IrVariable irVariable3 = lowerVar;
                    Intrinsics.checkNotNull((Object)irVariable3);
                    additionalStatements2.add(irVariable3);
                    lowerExpression = IrUtilsKt.shallowCopy(tmpLowerExpression);
                    upperExpression = upper;
                    useLowerClauseOnLeftSide = false;
                }
            } else {
                lowerExpression = lower2;
                upperExpression = upper;
                useLowerClauseOnLeftSide = true;
            }
            CollectionsKt.addIfNotNull(additionalStatements2, argVar);
            if (isNumericRange) {
                lowerExpression = UtilsKt.castIfNecessary(lowerExpression, comparisonClass);
                upperExpression = UtilsKt.castIfNecessary(upperExpression, comparisonClass);
            }
            lowerCompFun = (IrSimpleFunctionSymbol)MapsKt.getValue(builtIns.getLessOrEqualFunByOperandType(), (Object)(useCompareTo ? builtIns.getIntClass() : comparisonClass.getSymbol()));
            upperCompFun = (IrSimpleFunctionSymbol)MapsKt.getValue(isUpperInclusive ? builtIns.getLessOrEqualFunByOperandType() : builtIns.getLessFunByOperandType(), (Object)(useCompareTo ? builtIns.getIntClass() : comparisonClass.getSymbol()));
            $this$singleOrNull$iv = IrUtilsKt.getFunctions(comparisonClass);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            object3 = $this$singleOrNull$iv.iterator();
            while (object3.hasNext()) {
                Object element$iv = object3.next();
                it2 = (IrSimpleFunction)element$iv;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it2.getName(), (Object)OperatorNameConventions.COMPARE_TO) && ((IrFunction)it2).getDispatchReceiverParameter() != null && ((IrFunction)it2).getExtensionReceiverParameter() == null && ((IrFunction)it2).getValueParameters().size() == 1 && (!isNumericRange || Intrinsics.areEqual((Object)((IrFunction)it2).getValueParameters().get(0).getType(), (Object)IrUtilsKt.getDefaultType(comparisonClass)));
                if (!bl2) continue;
                if (found$iv) {
                    v6 = null;
                    break block40;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v6 = !found$iv ? null : single$iv;
        }
        IrSimpleFunction irSimpleFunction = v6;
        if (irSimpleFunction == null) {
            return null;
        }
        IrSimpleFunction compareToFun = irSimpleFunction;
        if (useCompareTo) {
            Object $this$buildContainsComparison_u24lambda_u242 = $this$singleOrNull$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, lowerCompFun);
            boolean bl = false;
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u242).putValueArgument(0, ExpressionHelpersKt.irInt$default($this$buildContainsComparison, 0, null, 2, null));
            IrFunctionAccessExpression found$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, compareToFun);
            object3 = found$iv;
            int element$iv = 1;
            it2 = $this$buildContainsComparison_u24lambda_u242;
            boolean bl3 = false;
            $this$buildContainsComparison_u24lambda_u242_u24lambda_u241.setDispatchReceiver(IrUtilsKt.shallowCopy(argExpression));
            $this$buildContainsComparison_u24lambda_u242_u24lambda_u241.putValueArgument(0, lowerExpression);
            Unit unit2 = Unit.INSTANCE;
            ((IrMemberAccessExpression)it2).putValueArgument(element$iv, found$iv);
            object2 = $this$singleOrNull$iv;
        } else {
            $this$buildContainsComparison_u24lambda_u243 = $this$singleOrNull$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, lowerCompFun);
            boolean bl = false;
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u243).putValueArgument(0, lowerExpression);
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u243).putValueArgument(1, IrUtilsKt.shallowCopy(argExpression));
            object2 = lowerClause = $this$singleOrNull$iv;
        }
        if (useCompareTo) {
            void $this$buildContainsComparison_u24lambda_u245_u24lambda_u244;
            Object $this$buildContainsComparison_u24lambda_u245 = $this$buildContainsComparison_u24lambda_u243 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, upperCompFun);
            boolean bl = false;
            IrFunctionAccessExpression element$iv = $this$buildContainsComparison_u24lambda_u242_u24lambda_u241 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, compareToFun);
            int it2 = 0;
            Object bl3 = $this$buildContainsComparison_u24lambda_u245;
            boolean bl4 = false;
            $this$buildContainsComparison_u24lambda_u245_u24lambda_u244.setDispatchReceiver(IrUtilsKt.shallowCopy(argExpression));
            $this$buildContainsComparison_u24lambda_u245_u24lambda_u244.putValueArgument(0, upperExpression);
            Unit unit3 = Unit.INSTANCE;
            ((IrMemberAccessExpression)bl3).putValueArgument(it2, $this$buildContainsComparison_u24lambda_u242_u24lambda_u241);
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u245).putValueArgument(1, ExpressionHelpersKt.irInt$default($this$buildContainsComparison, 0, null, 2, null));
            object = $this$buildContainsComparison_u24lambda_u243;
        } else {
            Object $this$buildContainsComparison_u24lambda_u246 = $this$buildContainsComparison_u24lambda_u243 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, upperCompFun);
            boolean bl = false;
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u246).putValueArgument(0, IrUtilsKt.shallowCopy(argExpression));
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u246).putValueArgument(1, upperExpression);
            object = $this$buildContainsComparison_u24lambda_u243;
        }
        Object upperClause = object;
        IrWhen contains = PrimitivesKt.andand($this$buildContainsComparison.getContext(), (IrExpression)(useLowerClauseOnLeftSide ? lowerClause : upperClause), (IrExpression)(useLowerClauseOnLeftSide ? upperClause : lowerClause), origin);
        if (additionalStatements2.isEmpty()) {
            irExpression = contains;
        } else {
            void this_$iv$iv;
            IrBuilderWithScope $this$irBlock_u24default$iv = $this$buildContainsComparison;
            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder bl4 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$buildContainsComparison_u24lambda_u247 = this_$iv$iv;
            boolean bl = false;
            for (IrStatement stmt : additionalStatements2) {
                $this$buildContainsComparison_u24lambda_u247.unaryPlus(stmt);
            }
            $this$buildContainsComparison_u24lambda_u247.unaryPlus(contains);
            irExpression = this_$iv$iv.doBuild();
        }
        return irExpression;
    }

    private final IrClass computeComparisonClass(Symbols symbols, IrType lowerType, IrType upperType, IrType argumentType) {
        IrType irType = this.leastCommonPrimitiveNumericType(symbols, lowerType, upperType);
        if (irType == null) {
            return null;
        }
        IrType commonBoundType = irType;
        IrType irType2 = this.leastCommonPrimitiveNumericType(symbols, argumentType, commonBoundType);
        return irType2 != null ? IrTypesKt.getClass(irType2) : null;
    }

    private final IrType leastCommonPrimitiveNumericType(Symbols symbols, IrType t1, IrType t2) {
        IrClassSymbol irClassSymbol;
        PrimitiveType primitive1 = IrTypePredicatesKt.getPrimitiveType(t1);
        PrimitiveType primitive2 = IrTypePredicatesKt.getPrimitiveType(t2);
        UnsignedType unsigned1 = IrTypePredicatesKt.getUnsignedType(t1);
        UnsignedType unsigned2 = IrTypePredicatesKt.getUnsignedType(t2);
        if (primitive1 == PrimitiveType.DOUBLE || primitive2 == PrimitiveType.DOUBLE) {
            irClassSymbol = symbols.getDouble();
        } else if (primitive1 == PrimitiveType.FLOAT || primitive2 == PrimitiveType.FLOAT) {
            irClassSymbol = symbols.getFloat();
        } else if (unsigned1 == UnsignedType.ULONG || unsigned2 == UnsignedType.ULONG) {
            IrClassSymbol irClassSymbol2 = symbols.getULong();
            irClassSymbol = irClassSymbol2;
            Intrinsics.checkNotNull((Object)irClassSymbol2);
        } else if (this.isPromotableToUInt(unsigned1) || this.isPromotableToUInt(unsigned2)) {
            IrClassSymbol irClassSymbol3 = symbols.getUInt();
            irClassSymbol = irClassSymbol3;
            Intrinsics.checkNotNull((Object)irClassSymbol3);
        } else if (primitive1 == PrimitiveType.LONG || primitive2 == PrimitiveType.LONG) {
            irClassSymbol = symbols.getLong();
        } else if (this.isPromotableToInt(primitive1) || this.isPromotableToInt(primitive2)) {
            irClassSymbol = symbols.getInt();
        } else if (primitive1 == PrimitiveType.CHAR || primitive2 == PrimitiveType.CHAR) {
            irClassSymbol = symbols.getChar();
        } else {
            throw new IllegalStateException(("Unexpected types: t1=" + RenderIrElementKt.render(t1) + ", t2=" + RenderIrElementKt.render(t2)).toString());
        }
        return IrTypesKt.getDefaultType(irClassSymbol);
    }

    private final boolean isPromotableToInt(PrimitiveType $this$isPromotableToInt) {
        return $this$isPromotableToInt == PrimitiveType.INT || $this$isPromotableToInt == PrimitiveType.SHORT || $this$isPromotableToInt == PrimitiveType.BYTE;
    }

    private final boolean isPromotableToUInt(UnsignedType $this$isPromotableToUInt) {
        return $this$isPromotableToUInt == UnsignedType.UINT || $this$isPromotableToUInt == UnsignedType.USHORT || $this$isPromotableToUInt == UnsignedType.UBYTE;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProgressionDirection.values().length];
            try {
                nArray[ProgressionDirection.INCREASING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressionDirection.DECREASING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressionDirection.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

