/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumCompanionInEnumConstructorCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumEntryChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "Visitor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirEnumCompanionInEnumConstructorCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirEnumCompanionInEnumConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumCompanionInEnumConstructorCallChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,79:1\n56#2,11:80\n20#2,2:91\n*S KotlinDebug\n*F\n+ 1 FirEnumCompanionInEnumConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumCompanionInEnumConstructorCallChecker\n*L\n28#1:80,11\n28#1:91,2\n*E\n"})
public final class FirEnumCompanionInEnumConstructorCallChecker
extends FirDeclarationChecker<FirEnumEntry> {
    @NotNull
    public static final FirEnumCompanionInEnumConstructorCallChecker INSTANCE = new FirEnumCompanionInEnumConstructorCallChecker();

    private FirEnumCompanionInEnumConstructorCallChecker() {
    }

    @Override
    public void check(@NotNull FirEnumEntry declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Object v0;
        block10: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Iterable $this$lastIsInstanceOrNull$iv = context.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Object element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirRegularClass)) continue;
                        v0 = element$iv;
                        break block10;
                    } while (0 <= n);
                }
                v0 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirRegularClass)) continue;
                    v0 = element$iv$iv;
                    break block10;
                }
                v0 = null;
            }
        }
        FirRegularClass firRegularClass = v0;
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass enumClass2 = firRegularClass;
        if (enumClass2.getClassKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = enumClass2.getCompanionObjectSymbol();
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol companionOfEnumSymbol = firRegularClassSymbol;
        FirExpression $this$firstIsInstanceOrNull$iv$iv = declaration.getInitializer();
        FirPureAbstractElement firPureAbstractElement = $this$firstIsInstanceOrNull$iv$iv instanceof FirAnonymousObjectExpression ? (FirAnonymousObjectExpression)$this$firstIsInstanceOrNull$iv$iv : null;
        if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getAnonymousObject()) == null) {
            return;
        }
        FirPureAbstractElement initializerObject = firPureAbstractElement;
        Object object = DeclarationUtilsKt.primaryConstructorIfAny((FirClass)initializerObject, context.getSession());
        if (object == null || (object = ((FirConstructorSymbol)object).getResolvedDelegatedConstructorCall()) == null) {
            return;
        }
        Object delegatingConstructorCall = object;
        Visitor visitor2 = new Visitor(context, reporter, companionOfEnumSymbol);
        ((FirDelegatedConstructorCall)delegatingConstructorCall).getArgumentList().acceptChildren(visitor2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumCompanionInEnumConstructorCallChecker$Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "companionSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)V", "getCompanionSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkQualifiedAccess", "", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "checkReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "receiverExpression", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirEnumCompanionInEnumConstructorCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirEnumCompanionInEnumConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumCompanionInEnumConstructorCallChecker$Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
    private static final class Visitor
    extends FirVisitorVoid {
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final DiagnosticReporter reporter;
        @NotNull
        private final FirRegularClassSymbol companionSymbol;

        public Visitor(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClassSymbol companionSymbol) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)companionSymbol, (String)"companionSymbol");
            this.context = context;
            this.reporter = reporter;
            this.companionSymbol = companionSymbol;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @NotNull
        public final FirRegularClassSymbol getCompanionSymbol() {
            return this.companionSymbol;
        }

        @Override
        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this);
        }

        @Override
        public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                boolean needVisitReceiver = this.checkQualifiedAccess(functionCall);
                functionCall.getArgumentList().acceptChildren(this);
                if (!needVisitReceiver) break block1;
                FirExpression firExpression2 = functionCall.getExplicitReceiver();
                if (firExpression2 != null) {
                    firExpression2.accept(this);
                }
            }
        }

        @Override
        public void visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
                boolean needVisitReceiver = this.checkQualifiedAccess(propertyAccessExpression);
                if (!needVisitReceiver) break block1;
                FirExpression firExpression2 = propertyAccessExpression.getExplicitReceiver();
                if (firExpression2 != null) {
                    firExpression2.accept(this);
                }
            }
        }

        private final boolean checkQualifiedAccess(FirQualifiedAccessExpression expression2) {
            FirExpression firExpression2 = this.checkReceiver(expression2.getExtensionReceiver());
            if (firExpression2 == null && (firExpression2 = this.checkReceiver(expression2.getDispatchReceiver())) == null) {
                return true;
            }
            FirExpression companionReceiver = firExpression2;
            KtSourceElement ktSourceElement = companionReceiver.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = expression2.getSource();
            }
            KtSourceElement source2 = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getUNINITIALIZED_ENUM_COMPANION(), (Object)this.companionSymbol, (DiagnosticContext)this.context, null, 16, null);
            return false;
        }

        private final FirExpression checkReceiver(FirExpression receiverExpression) {
            FirExpression firExpression2;
            if (!(receiverExpression instanceof FirResolvedQualifier) && !(receiverExpression instanceof FirThisReceiverExpression)) {
                return null;
            }
            FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(receiverExpression.getTypeRef()), this.context.getSession());
            if (firRegularClassSymbol == null) {
                return null;
            }
            FirRegularClassSymbol receiverSymbol = firRegularClassSymbol;
            FirExpression it = firExpression2 = receiverExpression;
            boolean bl = false;
            return Intrinsics.areEqual((Object)receiverSymbol, (Object)this.companionSymbol) ? firExpression2 : null;
        }
    }
}

