/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirSupertypeGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirSupertypeGenerationExtensionKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphBuilderKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeParameterSupertype;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirProviderInterceptor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypeResolverVisitor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationSession;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.LocalClassesNavigationInfo;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ImportingScopesKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001Bc\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\u0004\u0018\u00010\u00122\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u001a\u0010+\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`,2\u0006\u0010-\u001a\u00020\u0012H\u0002J\u001a\u0010.\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`,2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u001a\u0010/\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`,2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00101\u001a\u00020\u001eH\u0002J.\u00102\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002030\u00142\u000e\b\u0002\u00104\u001a\b\u0012\u0004\u0012\u00020\u001e05H\u0002J<\u00106\u001a\b\u0012\u0004\u0012\u0002030\u00142\u0006\u00101\u001a\u00020\u001e2$\u00107\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020:09\u0012\u0004\u0012\u00020:\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001408H\u0002J\"\u00106\u001a\b\u0012\u0004\u0012\u0002030\u00142\u0006\u00101\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002030\u0014J\u001a\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010?\u001a\u00020\u00022\u0006\u0010@\u001a\u00020\u00152\b\u0010>\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010A\u001a\u00020\u00022\u0006\u0010B\u001a\u00020C2\b\u0010>\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010D\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u00122\b\u0010>\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010E\u001a\u00020\u00022\u0006\u0010F\u001a\u00020G2\b\u0010>\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010H\u001a\u00020\u00022\u0006\u0010I\u001a\u00020J2\b\u0010>\u001a\u0004\u0018\u00010\u0003H\u0016J*\u0010K\u001a\u0002HL\"\u0004\b\u0000\u0010L2\u0006\u0010-\u001a\u00020\u00122\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HL0NH\u0082\b\u00a2\u0006\u0002\u0010OJ\u001e\u0010P\u001a\b\u0012\u0004\u0012\u0002HQ0\u0014\"\u0004\b\u0000\u0010Q*\b\u0012\u0004\u0012\u0002HQ0\u0014H\u0002J\u0012\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002030\u0014*\u00020\u001eH\u0002R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSupertypeResolverVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "supertypeComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeForLocalClass", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "localClassesNavigationInfo", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;", "firProviderInterceptor", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirProviderInterceptor;", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lkotlinx/collections/immutable/PersistentList;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;Lorg/jetbrains/kotlin/fir/resolve/transformers/FirProviderInterceptor;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/util/List;)V", "classDeclarationsStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "supertypeGenerationExtensions", "Lorg/jetbrains/kotlin/fir/extensions/FirSupertypeGenerationExtension;", "addSupertypesFromExtensions", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "supertypeRefs", "", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "calculateScopes", "withCompanionScopes", "", "getFirClassifierByFqName", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFirClassifierContainerFileIfAny", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "prepareFileScopes", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopePersistentList;", "file", "prepareScopeForCompanion", "prepareScopeForNestedClasses", "prepareScopes", "classLikeDeclaration", "resolveAllSupertypes", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "visited", "", "resolveSpecificClassLikeSupertypes", "resolveSuperTypeRefs", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "visitDeclarationContent", "declaration", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFile", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "withFile", "R", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createCopy", "T", "resolve"})
public class FirSupertypeResolverVisitor
extends FirDefaultVisitor<Unit, Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final SupertypeComputationSession supertypeComputationSession;
    @NotNull
    private final ScopeSession scopeSession;
    @Nullable
    private final PersistentList<FirScope> scopeForLocalClass;
    @Nullable
    private final LocalClassesNavigationInfo localClassesNavigationInfo;
    @Nullable
    private final FirProviderInterceptor firProviderInterceptor;
    @Nullable
    private FirFile useSiteFile;
    @NotNull
    private final List<FirSupertypeGenerationExtension> supertypeGenerationExtensions;
    @NotNull
    private final ArrayDeque<FirClass> classDeclarationsStack;

    public FirSupertypeResolverVisitor(@NotNull FirSession session, @NotNull SupertypeComputationSession supertypeComputationSession, @NotNull ScopeSession scopeSession, @Nullable PersistentList<? extends FirScope> scopeForLocalClass, @Nullable LocalClassesNavigationInfo localClassesNavigationInfo, @Nullable FirProviderInterceptor firProviderInterceptor, @Nullable FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)supertypeComputationSession, (String)"supertypeComputationSession");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter(containingDeclarations, (String)"containingDeclarations");
        this.session = session;
        this.supertypeComputationSession = supertypeComputationSession;
        this.scopeSession = scopeSession;
        this.scopeForLocalClass = scopeForLocalClass;
        this.localClassesNavigationInfo = localClassesNavigationInfo;
        this.firProviderInterceptor = firProviderInterceptor;
        this.useSiteFile = useSiteFile;
        this.supertypeGenerationExtensions = FirSupertypeGenerationExtensionKt.getSupertypeGenerators(FirExtensionServiceKt.getExtensionService(this.session));
        this.classDeclarationsStack = new ArrayDeque();
        Iterable $this$forEach$iv = containingDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirClass)) continue;
            this.classDeclarationsStack.add((Object)it);
        }
    }

    public /* synthetic */ FirSupertypeResolverVisitor(FirSession firSession, SupertypeComputationSession supertypeComputationSession, ScopeSession scopeSession, PersistentList persistentList, LocalClassesNavigationInfo localClassesNavigationInfo, FirProviderInterceptor firProviderInterceptor, FirFile firFile, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            persistentList = null;
        }
        if ((n & 0x10) != 0) {
            localClassesNavigationInfo = null;
        }
        if ((n & 0x20) != 0) {
            firProviderInterceptor = null;
        }
        if ((n & 0x40) != 0) {
            firFile = null;
        }
        if ((n & 0x80) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(firSession, supertypeComputationSession, scopeSession, (PersistentList<? extends FirScope>)persistentList, localClassesNavigationInfo, firProviderInterceptor, firFile, list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R withFile(FirFile file2, Function0<? extends R> block) {
        boolean $i$f$withFile = false;
        FirFile oldFile = this.useSiteFile;
        try {
            this.useSiteFile = file2;
            Object object = block.invoke();
            return (R)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.useSiteFile = oldFile;
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final FirFile getFirClassifierContainerFileIfAny(FirClassLikeSymbol<?> symbol2) {
        return this.firProviderInterceptor != null ? this.firProviderInterceptor.getFirClassifierContainerFileIfAny(symbol2) : FirProviderKt.getFirProvider(this.session).getFirClassifierContainerFileIfAny(symbol2.getClassId());
    }

    private final FirClassLikeDeclaration getFirClassifierByFqName(ClassId classId) {
        return this.firProviderInterceptor != null ? this.firProviderInterceptor.getFirClassifierByFqName(classId) : FirProviderKt.getFirProvider(this.session).getFirClassifierByFqName(classId);
    }

    @Override
    public void visitElement(@NotNull FirElement element, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    private final PersistentList<FirScope> prepareFileScopes(FirFile file2) {
        return this.supertypeComputationSession.getOrPutFileScope(file2, (Function0<? extends PersistentList<? extends FirScope>>)((Function0)new Function0<PersistentList<? extends FirScope>>(file2, this){
            final /* synthetic */ FirFile $file;
            final /* synthetic */ FirSupertypeResolverVisitor this$0;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PersistentList<FirScope> invoke() {
                return ExtensionsKt.toPersistentList((Iterable)CollectionsKt.asReversed((List)ImportingScopesKt.createImportingScopes$default(this.$file, FirSupertypeResolverVisitor.access$getSession$p(this.this$0), FirSupertypeResolverVisitor.access$getScopeSession$p(this.this$0), false, 8, null)));
            }
        }));
    }

    private final PersistentList<FirScope> prepareScopeForNestedClasses(FirClass klass) {
        return this.supertypeComputationSession.getOrPutScopeForNestedClasses(klass, (Function0<? extends PersistentList<? extends FirScope>>)((Function0)new Function0<PersistentList<? extends FirScope>>(this, klass){
            final /* synthetic */ FirSupertypeResolverVisitor this$0;
            final /* synthetic */ FirClass $klass;
            {
                this.this$0 = $receiver;
                this.$klass = $klass;
                super(0);
            }

            @NotNull
            public final PersistentList<FirScope> invoke() {
                return FirSupertypeResolverVisitor.access$calculateScopes(this.this$0, this.$klass, true);
            }
        }));
    }

    private final PersistentList<FirScope> prepareScopeForCompanion(FirClass klass) {
        return this.supertypeComputationSession.getOrPutScopeForCompanion(klass, (Function0<? extends PersistentList<? extends FirScope>>)((Function0)new Function0<PersistentList<? extends FirScope>>(this, klass){
            final /* synthetic */ FirSupertypeResolverVisitor this$0;
            final /* synthetic */ FirClass $klass;
            {
                this.this$0 = $receiver;
                this.$klass = $klass;
                super(0);
            }

            @NotNull
            public final PersistentList<FirScope> invoke() {
                return FirSupertypeResolverVisitor.access$calculateScopes(this.this$0, this.$klass, false);
            }
        }));
    }

    private final PersistentList<FirScope> calculateScopes(FirClass klass, boolean withCompanionScopes) {
        FirSupertypeResolverVisitor.resolveAllSupertypes$default(this, klass, klass.getSuperTypeRefs(), null, 4, null);
        return FirSupertypesResolutionKt.access$pushAll(this.prepareScopes(klass), FirSupertypesResolutionKt.access$createOtherScopesForNestedClassesOrCompanion(klass, this.session, this.scopeSession, this.supertypeComputationSession, withCompanionScopes));
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveAllSupertypes(FirClassLikeDeclaration classLikeDeclaration, List<? extends FirTypeRef> supertypeRefs, Set<FirClassLikeDeclaration> visited2) {
        void $this$mapTo$iv$iv;
        if (!visited2.add(classLikeDeclaration)) {
            return;
        }
        Iterable $this$map$iv = this.resolveSpecificClassLikeSupertypes(classLikeDeclaration, supertypeRefs);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it));
        }
        List supertypes2 = (List)destination$iv$iv;
        for (ConeKotlinType supertype2 : supertypes2) {
            FirClassLikeDeclaration fir;
            if (!(supertype2 instanceof ConeClassLikeType) || this.getFirClassifierByFqName(((ConeClassLikeType)supertype2).getLookupTag().getClassId()) == null) continue;
            this.resolveAllSupertypes(fir, this.supertypeRefs(fir), visited2);
        }
    }

    static /* synthetic */ void resolveAllSupertypes$default(FirSupertypeResolverVisitor firSupertypeResolverVisitor, FirClassLikeDeclaration firClassLikeDeclaration, List list2, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveAllSupertypes");
        }
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        firSupertypeResolverVisitor.resolveAllSupertypes(firClassLikeDeclaration, list2, set);
    }

    private final List<FirTypeRef> supertypeRefs(FirClassLikeDeclaration $this$supertypeRefs) {
        FirClassLikeDeclaration firClassLikeDeclaration = $this$supertypeRefs;
        return firClassLikeDeclaration instanceof FirRegularClass ? ((FirRegularClass)$this$supertypeRefs).getSuperTypeRefs() : (firClassLikeDeclaration instanceof FirTypeAlias ? CollectionsKt.listOf((Object)((FirTypeAlias)$this$supertypeRefs).getExpandedTypeRef()) : CollectionsKt.emptyList());
    }

    private final PersistentList<FirScope> prepareScopes(FirClassLikeDeclaration classLikeDeclaration) {
        Object object;
        block18: {
            block21: {
                block20: {
                    FirClassLikeDeclaration firClassLikeDeclaration;
                    FirRegularClass outerClassFir;
                    FirClassLikeDeclaration firClassLikeDeclaration2;
                    ClassId classId;
                    block19: {
                        FirClassLikeDeclaration firClassLikeDeclaration3;
                        boolean bl;
                        block17: {
                            classId = classLikeDeclaration.getSymbol().getClassId();
                            if (!classId.isLocal()) break block17;
                            if (this.localClassesNavigationInfo == null) {
                                return ExtensionsKt.persistentListOf();
                            }
                            FirClassLikeDeclaration parent2 = this.localClassesNavigationInfo.getParentForClass().get(classLikeDeclaration);
                            if (parent2 != null && parent2 instanceof FirClass) {
                                object = this.prepareScopeForNestedClasses((FirClass)parent2);
                            } else {
                                object = this.scopeForLocalClass;
                                if (object == null) {
                                    return ExtensionsKt.persistentListOf();
                                }
                            }
                            break block18;
                        }
                        FirClassLikeDeclaration $this$safeAs$iv = classLikeDeclaration;
                        boolean $i$f$safeAs = false;
                        FirClassLikeDeclaration firClassLikeDeclaration4 = $this$safeAs$iv;
                        if (!(firClassLikeDeclaration4 instanceof FirRegularClass)) {
                            firClassLikeDeclaration4 = null;
                        }
                        FirRegularClass firRegularClass = (FirRegularClass)firClassLikeDeclaration4;
                        if (firRegularClass != null) {
                            FirRegularClass $this$isCompanion$iv = firRegularClass;
                            boolean $i$f$isCompanion = false;
                            bl = $this$isCompanion$iv.getStatus().isCompanion();
                        } else {
                            bl = false;
                        }
                        if (!bl) break block19;
                        ClassId classId2 = classId.getOuterClassId();
                        if (classId2 != null) {
                            ClassId p0 = classId2;
                            boolean bl2 = false;
                            firClassLikeDeclaration3 = this.getFirClassifierByFqName(p0);
                        } else {
                            firClassLikeDeclaration3 = null;
                        }
                        firClassLikeDeclaration2 = firClassLikeDeclaration3;
                        FirRegularClass firRegularClass2 = outerClassFir = firClassLikeDeclaration2 instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration2 : null;
                        if (firRegularClass2 == null) {
                            return ExtensionsKt.persistentListOf();
                        }
                        object = this.prepareScopeForCompanion(firRegularClass2);
                        break block18;
                    }
                    if (!classId.isNestedClass()) break block20;
                    ClassId classId3 = classId.getOuterClassId();
                    if (classId3 != null) {
                        ClassId p0 = classId3;
                        boolean bl = false;
                        firClassLikeDeclaration = this.getFirClassifierByFqName(p0);
                    } else {
                        firClassLikeDeclaration = null;
                    }
                    firClassLikeDeclaration2 = firClassLikeDeclaration;
                    FirRegularClass firRegularClass = outerClassFir = firClassLikeDeclaration2 instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration2 : null;
                    if (firRegularClass == null) {
                        return ExtensionsKt.persistentListOf();
                    }
                    object = this.prepareScopeForNestedClasses(firRegularClass);
                    break block18;
                }
                object = this.getFirClassifierContainerFileIfAny(classLikeDeclaration.getSymbol());
                if (object == null) break block21;
                Object p0 = object;
                boolean bl = false;
                PersistentList<FirScope> persistentList = this.prepareFileScopes((FirFile)p0);
                object = persistentList;
                if (persistentList != null) break block18;
            }
            object = ExtensionsKt.persistentListOf();
        }
        PersistentList<FirScope> result2 = object;
        return FirSupertypesResolutionKt.access$pushIfNotNull(result2, FirSupertypesResolutionKt.access$typeParametersScope(classLikeDeclaration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<FirTypeRef> resolveSpecificClassLikeSupertypes(FirClassLikeDeclaration classLikeDeclaration, Function2<? super FirTransformer<? super ScopeClassDeclaration>, ? super ScopeClassDeclaration, ? extends List<? extends FirResolvedTypeRef>> resolveSuperTypeRefs) {
        List list2;
        void this_$iv;
        FirSpecificTypeResolverTransformer transformer2;
        SupertypeComputationStatus status2 = this.supertypeComputationSession.getSupertypesComputationStatus(classLikeDeclaration);
        if (status2 instanceof SupertypeComputationStatus.Computed) {
            return ((SupertypeComputationStatus.Computed)status2).getSupertypeRefs();
        }
        if (status2 instanceof SupertypeComputationStatus.Computing) {
            return CollectionsKt.listOf((Object)FirSupertypesResolutionKt.access$createErrorTypeRef(classLikeDeclaration, "Loop in supertype definition for " + classLikeDeclaration.getSymbol().getClassId(), classLikeDeclaration instanceof FirTypeAlias ? DiagnosticKind.RecursiveTypealiasExpansion : DiagnosticKind.LoopInSupertype));
        }
        if (Intrinsics.areEqual((Object)status2, (Object)SupertypeComputationStatus.NotComputed.INSTANCE)) {
            // empty if block
        }
        this.supertypeComputationSession.startComputingSupertypes(classLikeDeclaration);
        PersistentList<FirScope> scopes = this.prepareScopes(classLikeDeclaration);
        FirSpecificTypeResolverTransformer firSpecificTypeResolverTransformer = transformer2 = new FirSpecificTypeResolverTransformer(this.session, false, this.supertypeComputationSession.getSupertypesSupplier(), 2, null);
        FirFile file$iv = this.useSiteFile;
        boolean $i$f$withFile = false;
        FirFile oldValue$iv = this_$iv.currentFile;
        this_$iv.currentFile = file$iv;
        try {
            void $this$resolveSpecificClassLikeSupertypes_u24lambda_u2d4 = this_$iv;
            boolean bl = false;
            list2 = (List)resolveSuperTypeRefs.invoke((Object)transformer2, (Object)new ScopeClassDeclaration((List)scopes, (List)this.classDeclarationsStack, null, 4, null));
        }
        finally {
            this_$iv.currentFile = oldValue$iv;
        }
        List resolvedTypesRefs = list2;
        this.supertypeComputationSession.storeSupertypes(classLikeDeclaration, resolvedTypesRefs);
        return resolvedTypesRefs;
    }

    public void visitDeclarationContent(@NotNull FirDeclaration declaration, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        declaration.acceptChildren(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        ArrayDeque<FirClass> classDeclarations$iv = this.classDeclarationsStack;
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast((Object)regularClass);
        try {
            boolean bl = false;
            this.resolveSpecificClassLikeSupertypes((FirClassLikeDeclaration)regularClass, regularClass.getSuperTypeRefs());
            this.visitDeclarationContent(regularClass, null);
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            classDeclarations$iv.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        ArrayDeque<FirClass> classDeclarations$iv = this.classDeclarationsStack;
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast((Object)anonymousObject);
        try {
            boolean bl = false;
            this.resolveSpecificClassLikeSupertypes((FirClassLikeDeclaration)anonymousObject, anonymousObject.getSuperTypeRefs());
            this.visitDeclarationContent(anonymousObject, null);
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            classDeclarations$iv.removeLast();
        }
    }

    @NotNull
    public final List<FirTypeRef> resolveSpecificClassLikeSupertypes(@NotNull FirClassLikeDeclaration classLikeDeclaration, @NotNull List<? extends FirTypeRef> supertypeRefs) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        Intrinsics.checkNotNullParameter(supertypeRefs, (String)"supertypeRefs");
        return this.resolveSpecificClassLikeSupertypes(classLikeDeclaration, (Function2<? super FirTransformer<? super ScopeClassDeclaration>, ? super ScopeClassDeclaration, ? extends List<? extends FirResolvedTypeRef>>)((Function2)new Function2<FirTransformer<? super ScopeClassDeclaration>, ScopeClassDeclaration, List<? extends FirResolvedTypeRef>>(classLikeDeclaration, this, supertypeRefs){
            final /* synthetic */ FirClassLikeDeclaration $classLikeDeclaration;
            final /* synthetic */ FirSupertypeResolverVisitor this$0;
            final /* synthetic */ List<FirTypeRef> $supertypeRefs;
            {
                this.$classLikeDeclaration = $classLikeDeclaration;
                this.this$0 = $receiver;
                this.$supertypeRefs = $supertypeRefs;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<FirResolvedTypeRef> invoke(@NotNull FirTransformer<? super ScopeClassDeclaration> transformer2, @NotNull ScopeClassDeclaration scopeDeclaration) {
                void destination$iv;
                void $this$mapTo$iv;
                Object it;
                Object object;
                Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
                Intrinsics.checkNotNullParameter((Object)scopeDeclaration, (String)"scopeDeclaration");
                if (!ControlFlowGraphBuilderKt.isLocalClassOrAnonymousObject(this.$classLikeDeclaration)) {
                    FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(FirSupertypeResolverVisitor.access$getSession$p(this.this$0));
                    if (firLookupTrackerComponent != null) {
                        object = firLookupTrackerComponent;
                        FirSupertypeResolverVisitor firSupertypeResolverVisitor = this.this$0;
                        FirClassLikeDeclaration firClassLikeDeclaration = this.$classLikeDeclaration;
                        List<FirTypeRef> list2 = this.$supertypeRefs;
                        it = object;
                        boolean bl = false;
                        FirFile firFile = FirSupertypeResolverVisitor.access$getFirClassifierContainerFileIfAny(firSupertypeResolverVisitor, firClassLikeDeclaration.getSymbol());
                        KtSourceElement fileSource = firFile != null ? firFile.getSource() : null;
                        for (FirTypeRef supertypeRef : list2) {
                            void $this$flatMapTo$iv$iv;
                            Iterable $this$flatMap$iv = scopeDeclaration.getScopes();
                            boolean $i$f$flatMap = false;
                            Iterable iterable = $this$flatMap$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$flatMapTo = false;
                            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                FirScope scope2 = (FirScope)element$iv$iv;
                                boolean bl2 = false;
                                Iterable list$iv$iv = scope2.getScopeOwnerLookupNames();
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                            }
                            List scopeOwnerLookupNames2 = (List)destination$iv$iv;
                            FirLookupTrackerComponentKt.recordTypeLookup((FirLookupTrackerComponent)it, supertypeRef, scopeOwnerLookupNames2, fileSource);
                        }
                    }
                }
                Iterable iterable = FirSupertypeResolverVisitor.access$createCopy(this.this$0, this.$supertypeRefs);
                object = new ArrayList<E>();
                boolean $i$f$mapTo = false;
                for (E item$iv : $this$mapTo$iv) {
                    FirResolvedTypeRef firResolvedTypeRef;
                    FirTypeRef superTypeRef;
                    it = (FirTypeRef)item$iv;
                    void var23_31 = destination$iv;
                    boolean bl = false;
                    FirTypeRef $this$coneTypeSafe$iv = superTypeRef = transformer2.transformTypeRef((FirTypeRef)it, scopeDeclaration);
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getType() : null;
                    if (!(coneKotlinType instanceof ConeTypeParameterType)) {
                        coneKotlinType = null;
                    }
                    ConeTypeParameterType typeParameterType = (ConeTypeParameterType)((ConeKotlinType)((ConeTypeParameterType)coneKotlinType));
                    if (typeParameterType != null) {
                        FirErrorTypeRefBuilder firErrorTypeRefBuilder;
                        boolean $i$f$buildErrorTypeRef = false;
                        FirErrorTypeRefBuilder $this$invoke_u24lambda_u2d3_u24lambda_u2d2 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u2d3_u24lambda_u2d2.setSource(superTypeRef.getSource());
                        $this$invoke_u24lambda_u2d3_u24lambda_u2d2.setDiagnostic(new ConeTypeParameterSupertype(typeParameterType.getLookupTag().getTypeParameterSymbol()));
                        firResolvedTypeRef = firErrorTypeRefBuilder.build();
                    } else {
                        firResolvedTypeRef = !(superTypeRef instanceof FirResolvedTypeRef) ? (FirResolvedTypeRef)FirSupertypesResolutionKt.access$createErrorTypeRef(superTypeRef, "Unresolved super-type: " + FirRendererKt.render$default(superTypeRef, null, 1, null), DiagnosticKind.UnresolvedSupertype) : (FirResolvedTypeRef)superTypeRef;
                    }
                    var23_31.add(firResolvedTypeRef);
                }
                iterable = destination$iv;
                object = this.this$0;
                FirClassLikeDeclaration firClassLikeDeclaration = this.$classLikeDeclaration;
                List it2 = (List)iterable;
                boolean bl = false;
                FirSupertypeResolverVisitor.access$addSupertypesFromExtensions((FirSupertypeResolverVisitor)object, firClassLikeDeclaration, it2);
                return (List)iterable;
            }
        }));
    }

    private final <T> List<T> createCopy(List<? extends T> $this$createCopy) {
        return new ArrayList($this$createCopy);
    }

    private final void addSupertypesFromExtensions(FirClassLikeDeclaration klass, List<FirResolvedTypeRef> supertypeRefs) {
        if (this.supertypeGenerationExtensions.isEmpty()) {
            return;
        }
        for (FirSupertypeGenerationExtension extension : this.supertypeGenerationExtensions) {
            if (!extension.needTransformSupertypes(klass)) continue;
            CollectionsKt.addAll((Collection)supertypeRefs, (Iterable)extension.computeAdditionalSupertypes(klass, supertypeRefs));
        }
    }

    @Override
    public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        if (typeAlias.getExpandedTypeRef() instanceof FirResolvedTypeRef) {
            return;
        }
        this.resolveSpecificClassLikeSupertypes((FirClassLikeDeclaration)typeAlias, (Function2<? super FirTransformer<? super ScopeClassDeclaration>, ? super ScopeClassDeclaration, ? extends List<? extends FirResolvedTypeRef>>)((Function2)new Function2<FirTransformer<? super ScopeClassDeclaration>, ScopeClassDeclaration, List<? extends FirResolvedTypeRef>>(typeAlias, this){
            final /* synthetic */ FirTypeAlias $typeAlias;
            final /* synthetic */ FirSupertypeResolverVisitor this$0;
            {
                this.$typeAlias = $typeAlias;
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final List<FirResolvedTypeRef> invoke(@NotNull FirTransformer<? super ScopeClassDeclaration> transformer2, @NotNull ScopeClassDeclaration scope2) {
                Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
                Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                FirTypeRef firTypeRef = transformer2.transformTypeRef(this.$typeAlias.getExpandedTypeRef(), scope2);
                FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
                if (firResolvedTypeRef == null) {
                    return CollectionsKt.listOf((Object)FirSupertypesResolutionKt.access$createErrorTypeRef(this.$typeAlias.getExpandedTypeRef(), "Unresolved expanded typeRef for " + this.$typeAlias.getSymbol().getClassId(), DiagnosticKind.UnresolvedExpandedType));
                }
                FirResolvedTypeRef resolvedTypeRef = firResolvedTypeRef;
                visitTypeAlias.1.invoke$visitNestedTypeAliases(this.this$0, resolvedTypeRef.getType());
                return CollectionsKt.listOf((Object)resolvedTypeRef);
            }

            private static final void invoke$visitNestedTypeAliases(FirSupertypeResolverVisitor this$0, TypeArgumentMarker type2) {
                if (type2 instanceof ConeClassLikeType) {
                    FirClassLikeSymbol<?> symbol2 = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)type2).getLookupTag(), FirSupertypeResolverVisitor.access$getSession$p(this$0));
                    if (symbol2 instanceof FirTypeAliasSymbol) {
                        this$0.visitTypeAlias((FirTypeAlias)((FirTypeAliasSymbol)symbol2).getFir(), (Object)null);
                    } else if (symbol2 != null) {
                        for (ConeTypeProjection typeArgument : ((ConeClassLikeType)type2).getTypeArguments()) {
                            visitTypeAlias.1.invoke$visitNestedTypeAliases(this$0, typeArgument);
                        }
                    }
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitFile(@NotNull FirFile file2, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FirSupertypeResolverVisitor this_$iv = this;
        boolean $i$f$withFile = false;
        FirFile oldFile$iv = this_$iv.useSiteFile;
        try {
            this_$iv.useSiteFile = file2;
            boolean bl = false;
            this.visitDeclarationContent(file2, null);
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            this_$iv.useSiteFile = oldFile$iv;
        }
    }

    public static final /* synthetic */ FirSession access$getSession$p(FirSupertypeResolverVisitor $this) {
        return $this.session;
    }

    public static final /* synthetic */ ScopeSession access$getScopeSession$p(FirSupertypeResolverVisitor $this) {
        return $this.scopeSession;
    }

    public static final /* synthetic */ PersistentList access$calculateScopes(FirSupertypeResolverVisitor $this, FirClass klass, boolean withCompanionScopes) {
        return $this.calculateScopes(klass, withCompanionScopes);
    }

    public static final /* synthetic */ List access$createCopy(FirSupertypeResolverVisitor $this, List $receiver) {
        return $this.createCopy($receiver);
    }

    public static final /* synthetic */ FirFile access$getFirClassifierContainerFileIfAny(FirSupertypeResolverVisitor $this, FirClassLikeSymbol symbol2) {
        return $this.getFirClassifierContainerFileIfAny(symbol2);
    }

    public static final /* synthetic */ void access$addSupertypesFromExtensions(FirSupertypeResolverVisitor $this, FirClassLikeDeclaration klass, List supertypeRefs) {
        $this.addSupertypesFromExtensions(klass, supertypeRefs);
    }
}

