/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.BinaryAndExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.BinaryOrExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.BlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CatchClauseEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CatchClauseExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FinallyBlockEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FinallyBlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.JumpNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.TryMainBlockEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.TryMainBlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.WhenBranchResultExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.WhenExitNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTailrecFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasMoreFollowingInstructions", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "tailrecFunction", "checkers"})
public final class FirTailrecFunctionChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirTailrecFunctionChecker INSTANCE = new FirTailrecFunctionChecker();

    private FirTailrecFunctionChecker() {
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isTailRec$iv = declaration;
        boolean $i$f$isTailRec = false;
        if (!$this$isTailRec$iv.getStatus().isTailRec()) {
            return;
        }
        if (!DeclarationUtilsKt.isEffectivelyFinal(declaration, context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getTAILREC_ON_VIRTUAL_MEMBER_ERROR(), (DiagnosticContext)context2, null, 8, null);
        }
        if ((object = declaration.getControlFlowGraphReference()) == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph2 = object;
        Ref.IntRef tryScopeCount = new Ref.IntRef();
        Ref.IntRef catchScopeCount = new Ref.IntRef();
        Ref.IntRef finallyScopeCount = new Ref.IntRef();
        Ref.IntRef tailrecCount = new Ref.IntRef();
        CfgTraverserKt.traverse((ControlFlowGraph)graph2, TraverseDirection.Forward, new ControlFlowGraphVisitorVoid(tryScopeCount, catchScopeCount, finallyScopeCount, declaration, reporter, context2, tailrecCount){
            final /* synthetic */ Ref.IntRef $tryScopeCount;
            final /* synthetic */ Ref.IntRef $catchScopeCount;
            final /* synthetic */ Ref.IntRef $finallyScopeCount;
            final /* synthetic */ FirSimpleFunction $declaration;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ Ref.IntRef $tailrecCount;
            {
                this.$tryScopeCount = $tryScopeCount;
                this.$catchScopeCount = $catchScopeCount;
                this.$finallyScopeCount = $finallyScopeCount;
                this.$declaration = $declaration;
                this.$reporter = $reporter;
                this.$context = $context;
                this.$tailrecCount = $tailrecCount;
            }

            public void visitNode(@NotNull CFGNode<?> node) {
                Intrinsics.checkNotNullParameter(node, (String)"node");
            }

            public void visitTryMainBlockEnterNode(@NotNull TryMainBlockEnterNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n = this.$tryScopeCount.element;
                this.$tryScopeCount.element = n + 1;
            }

            public void visitTryMainBlockExitNode(@NotNull TryMainBlockExitNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n = this.$tryScopeCount.element;
                this.$tryScopeCount.element = n + -1;
            }

            public void visitCatchClauseEnterNode(@NotNull CatchClauseEnterNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n = this.$catchScopeCount.element;
                this.$catchScopeCount.element = n + 1;
            }

            public void visitCatchClauseExitNode(@NotNull CatchClauseExitNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n = this.$catchScopeCount.element;
                this.$catchScopeCount.element = n + -1;
            }

            public void visitFinallyBlockEnterNode(@NotNull FinallyBlockEnterNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n = this.$finallyScopeCount.element;
                this.$finallyScopeCount.element = n + 1;
            }

            public void visitFinallyBlockExitNode(@NotNull FinallyBlockExitNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n = this.$finallyScopeCount.element;
                this.$finallyScopeCount.element = n + -1;
            }

            /*
             * Unable to fully structure code
             */
            public void visitFunctionCallNode(@NotNull FunctionCallNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                functionCall = node.getFir();
                var5_3 = FirExpressionUtilKt.toResolvedCallableSymbol(functionCall.getCalleeReference());
                v0 = var5_3 instanceof FirNamedFunctionSymbol != false ? (FirNamedFunctionSymbol)var5_3 : null;
                if (v0 == null) {
                    return;
                }
                resolvedSymbol = v0;
                if (!Intrinsics.areEqual((Object)resolvedSymbol, (Object)this.$declaration.getSymbol())) {
                    return;
                }
                $this$arguments$iv = functionCall;
                $i$f$getArguments = false;
                if ($this$arguments$iv.getArgumentList().getArguments().size() != resolvedSymbol.getValueParameterSymbols().size()) {
                    $this$isOverride$iv = resolvedSymbol;
                    $i$f$isOverride = false;
                    if ($this$isOverride$iv.getResolvedStatus().isOverride()) {
                        KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)functionCall.getSource(), FirErrors.INSTANCE.getNON_TAIL_RECURSIVE_CALL(), (DiagnosticContext)this.$context, null, 8, null);
                        return;
                    }
                }
                dispatchReceiver = functionCall.getDispatchReceiver();
                v1 = this.$declaration.getDispatchReceiverType();
                var6_8 = v1 != null ? TypeUtilsKt.toSymbol(v1, this.$context.getSession()) : null;
                v2 = dispatchReceiverOwner = var6_8 instanceof FirClassSymbol != false ? (FirClassSymbol)var6_8 : null;
                if (dispatchReceiver instanceof FirNoReceiverExpression || dispatchReceiver instanceof FirThisReceiverExpression && Intrinsics.areEqual(((FirThisReceiverExpression)dispatchReceiver).getCalleeReference().getBoundSymbol(), (Object)dispatchReceiverOwner)) ** GOTO lbl-1000
                v3 = dispatchReceiverOwner;
                v4 = v3 != null && (v3 = v3.getClassKind()) != null ? v3.isSingleton() : false;
                if (v4) lbl-1000:
                // 2 sources

                {
                    v5 = true;
                } else {
                    v5 = sameReceiver = false;
                }
                if (!sameReceiver) {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)functionCall.getSource(), FirErrors.INSTANCE.getNON_TAIL_RECURSIVE_CALL(), (DiagnosticContext)this.$context, null, 8, null);
                } else if (this.$tryScopeCount.element > 0 || this.$catchScopeCount.element > 0 || this.$finallyScopeCount.element > 0) {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)functionCall.getSource(), FirErrors.INSTANCE.getTAIL_RECURSION_IN_TRY_IS_NOT_SUPPORTED(), (DiagnosticContext)this.$context, null, 8, null);
                } else if (FirTailrecFunctionChecker.access$hasMoreFollowingInstructions(FirTailrecFunctionChecker.INSTANCE, node, this.$declaration)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)functionCall.getSource(), FirErrors.INSTANCE.getNON_TAIL_RECURSIVE_CALL(), (DiagnosticContext)this.$context, null, 8, null);
                } else if (!node.isDead()) {
                    var7_10 = this.$tailrecCount.element;
                    this.$tailrecCount.element = var7_10 + 1;
                }
            }
        });
        if (tailrecCount.element == 0) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNO_TAIL_CALLS_FOUND(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean hasMoreFollowingInstructions(CFGNode<?> $this$hasMoreFollowingInstructions, FirSimpleFunction tailrecFunction) {
        for (CFGNode<?> next : $this$hasMoreFollowingInstructions.getFollowingNodes()) {
            Edge edge = (Edge)MapsKt.getValue($this$hasMoreFollowingInstructions.getOutgoingEdges(), next);
            if (!edge.getKind().getUsedInCfa() || edge.getKind().isDead()) continue;
            if (edge.getKind().isBack()) {
                return true;
            }
            CFGNode<?> cFGNode = next;
            if (cFGNode instanceof FunctionExitNode) {
                return !Intrinsics.areEqual((Object)((FunctionExitNode)next).getFir(), (Object)tailrecFunction);
            }
            if (!(((((cFGNode instanceof JumpNode ? true : cFGNode instanceof BinaryAndExitNode) ? true : cFGNode instanceof BinaryOrExitNode) ? true : cFGNode instanceof WhenBranchResultExitNode) ? true : cFGNode instanceof WhenExitNode) ? true : cFGNode instanceof BlockExitNode)) {
                return true;
            }
            boolean hasMore = this.hasMoreFollowingInstructions(next, tailrecFunction);
            if (!hasMore) continue;
            return hasMore;
        }
        return false;
    }

    public static final /* synthetic */ boolean access$hasMoreFollowingInstructions(FirTailrecFunctionChecker $this, CFGNode $receiver, FirSimpleFunction tailrecFunction) {
        return $this.hasMoreFollowingInstructions($receiver, tailrecFunction);
    }
}

