/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020#H\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010(\u001a\u00020#J\b\u0010+\u001a\u00020'H\u0016R$\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u0002`\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R.\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\u0013j\u0004\u0018\u0001`\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "value", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "getFields", "()Ljava/util/Map;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Field;", "getOuterClass", "()Lkotlin/Pair;", "setOuterClass", "(Lkotlin/Pair;)V", "receiverClass", "Ljava/lang/Class;", "superWrapperClass", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "getValue", "()Ljava/lang/Object;", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getJavaOriginalName", "", "irFunction", "getMethod", "Ljava/lang/invoke/MethodHandle;", "toString", "Companion", "ir.interpreter"})
public final class Wrapper
implements Complex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object value;
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Pair<? extends IrSymbol, ? extends State> outerClass;
    @NotNull
    private final Class<? extends Object> receiverClass;
    @NotNull
    private static final Map<String, Object> companionObjectValue = MapsKt.mapOf((Pair)TuplesKt.to((Object)"kotlin.text.Regex$Companion", (Object)Regex.Companion));
    @NotNull
    private static final Set<String> intrinsicClasses;
    @NotNull
    private static final Map<String, String> intrinsicFunctionToHandler;

    /*
     * WARNING - void declaration
     */
    public Wrapper(@NotNull Object value2, @NotNull IrClass irClass2, @NotNull IrInterpreterEnvironment environment) {
        IrClass mutableMap;
        Object[] $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.value = value2;
        this.irClass = irClass2;
        this.fields = new LinkedHashMap();
        this.receiverClass = Wrapper.Companion.getClass(IrUtilsKt.getDefaultType(this.getIrClass()), true);
        Class<?> javaClass = this.value.getClass();
        if (Intrinsics.areEqual(javaClass, HashMap.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Pair $this$filterIsInstance$iv;
            Map<Class<?>, IrClass> $this$single$iv2;
            void $this$mapNotNullTo$iv$iv;
            Class<?>[] classArray = javaClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"javaClass.declaredClasses");
            $this$single$iv = classArray;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv22 = false;
            for (Object element$iv : $this$single$iv) {
                Class it = (Class)element$iv;
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"$Node", (boolean)false, (int)2, null)) continue;
                if (found$iv22) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv22 = true;
            }
            if (!found$iv22) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Class nodeClass = (Class)single$iv;
            Iterable $this$mapNotNull$iv = this.getIrClass().getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable found$iv22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo22 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                IrClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl2 = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl3 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it);
                if ((irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$single22 = false;
            Object single$iv2 = null;
            boolean found$iv32 = false;
            Iterator $i$f$mapNotNullTo22 = $this$single$iv2.iterator();
            while ($i$f$mapNotNullTo22.hasNext()) {
                Object element$iv;
                element$iv = $i$f$mapNotNullTo22.next();
                IrClass it = (IrClass)element$iv;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)StandardNames.FqNames.mutableMap.shortName())) continue;
                if (found$iv32) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv2 = element$iv;
                found$iv32 = true;
            }
            if (!found$iv32) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mutableMap = (IrClass)single$iv2;
            $this$single$iv2 = environment.getJavaClassToIrClass$ir_interpreter();
            Iterable $i$f$single22 = mutableMap.getDeclarations();
            Class clazz = nodeClass;
            boolean $i$f$filterIsInstance = false;
            void found$iv32 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = TuplesKt.to((Object)clazz, (Object)CollectionsKt.single((List)((List)destination$iv$iv2)));
            $this$single$iv2.put((Class<?>)$this$filterIsInstance$iv.getFirst(), (IrClass)$this$filterIsInstance$iv.getSecond());
        } else if (Intrinsics.areEqual(javaClass, LinkedHashMap.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Pair $this$filterIsInstance$iv2;
            Map<Class<?>, IrClass> $this$single$iv3;
            void $this$mapNotNullTo$iv$iv;
            Class<?>[] classArray = javaClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"javaClass.declaredClasses");
            $this$single$iv = classArray;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv42 = false;
            for (Object element$iv : $this$single$iv) {
                Class it = (Class)element$iv;
                boolean bl = false;
                String string3 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name");
                if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"$Entry", (boolean)false, (int)2, null)) continue;
                if (found$iv42) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv42 = true;
            }
            if (!found$iv42) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Class entryClass = (Class)single$iv;
            Iterable $this$mapNotNull$iv = this.getIrClass().getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable found$iv42 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo32 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                IrClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl6 = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl7 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it);
                if ((irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$single32 = false;
            Object single$iv3 = null;
            boolean found$iv52 = false;
            Iterator $i$f$mapNotNullTo32 = $this$single$iv3.iterator();
            while ($i$f$mapNotNullTo32.hasNext()) {
                Object element$iv;
                element$iv = $i$f$mapNotNullTo32.next();
                IrClass it = (IrClass)element$iv;
                boolean bl9 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)StandardNames.FqNames.mutableMap.shortName())) continue;
                if (found$iv52) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv3 = element$iv;
                found$iv52 = true;
            }
            if (!found$iv52) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mutableMap = (IrClass)single$iv3;
            $this$single$iv3 = environment.getJavaClassToIrClass$ir_interpreter();
            Iterable $i$f$single32 = mutableMap.getDeclarations();
            Class clazz = entryClass;
            boolean $i$f$filterIsInstance = false;
            void found$iv52 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filterIsInstance$iv2 = TuplesKt.to((Object)clazz, (Object)CollectionsKt.single((List)((List)destination$iv$iv3)));
            $this$single$iv3.put((Class<?>)$this$filterIsInstance$iv2.getFirst(), (IrClass)$this$filterIsInstance$iv2.getSecond());
        } else if (Intrinsics.areEqual((Object)javaClass.getCanonicalName(), (Object)"java.util.Collections.SingletonMap")) {
            void $this$filterIsInstanceTo$iv$iv;
            Map<Class<?>, IrClass> $this$filterIsInstance$iv = this.getIrClass().getDeclarations();
            boolean $i$f$filterIsInstance22 = false;
            Iterable $this$filterIsInstance$iv2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            IrClass irClassMapEntry = (IrClass)CollectionsKt.single((List)((List)destination$iv$iv));
            $this$filterIsInstance$iv = environment.getJavaClassToIrClass$ir_interpreter();
            Pair $i$f$filterIsInstance22 = TuplesKt.to(AbstractMap.SimpleEntry.class, (Object)irClassMapEntry);
            $this$filterIsInstance$iv.put((Class<?>)$i$f$filterIsInstance22.getFirst(), (IrClass)$i$f$filterIsInstance22.getSecond());
            $this$filterIsInstance$iv = environment.getJavaClassToIrClass$ir_interpreter();
            $i$f$filterIsInstance22 = TuplesKt.to(AbstractMap.SimpleImmutableEntry.class, (Object)irClassMapEntry);
            $this$filterIsInstance$iv.put((Class<?>)$i$f$filterIsInstance22.getFirst(), (IrClass)$i$f$filterIsInstance22.getSecond());
        }
        IrClass it = environment.getJavaClassToIrClass$ir_interpreter().get(this.value.getClass());
        boolean bl = false;
        boolean bl10 = it == null || IrUtilsKt.isSubclassOf(this.getIrClass(), it);
        if (bl10) {
            environment.getJavaClassToIrClass$ir_interpreter().put(this.value.getClass(), this.getIrClass());
        }
    }

    @NotNull
    public final Object getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Pair<IrSymbol, State> getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Pair<? extends IrSymbol, ? extends State> pair) {
        this.outerClass = pair;
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MethodHandle getMethod(@NotNull IrFunction irFunction2) {
        Object v4;
        block4: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            Object object = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
            String propertyName = object != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null && (object = object.getName()) != null ? ((Name)object).asString() : null;
            Object object2 = new String[2];
            object2[0] = propertyName;
            String string2 = propertyName;
            object2[1] = "get" + (string2 != null ? CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string2) : null);
            object2 = CollectionsKt.listOfNotNull((Object[])object2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block3: {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Method[] methodArray = this.receiverClass.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"receiverClass.methods");
                    Object[] $this$any$iv = methodArray;
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        Method method = (Method)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)method.getName(), (Object)it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v4 = element$iv;
                break block4;
            }
            v4 = null;
        }
        String propertyCall = v4;
        String intrinsicName = this.getJavaOriginalName(irFunction2);
        String string3 = intrinsicName;
        if (string3 == null && (string3 = propertyCall) == null) {
            String string4 = irFunction2.getName().toString();
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"irFunction.name.toString()");
        }
        String methodName = string3;
        MethodType methodType = Wrapper.Companion.getMethodType(irFunction2);
        return MethodHandles.lookup().findVirtual(this.receiverClass, methodName, methodType);
    }

    private final String getJavaOriginalName(IrFunction irFunction2) {
        String string2;
        switch (UtilsKt.getFqName(UtilsKt.getLastOverridden(irFunction2))) {
            case "kotlin.collections.Map.<get-entries>": {
                string2 = "entrySet";
                break;
            }
            case "kotlin.collections.Map.<get-keys>": {
                string2 = "keySet";
                break;
            }
            case "kotlin.CharSequence.get": {
                string2 = "charAt";
                break;
            }
            case "kotlin.collections.MutableList.removeAt": {
                string2 = "remove";
                break;
            }
            default: {
                string2 = null;
            }
        }
        return string2;
    }

    @NotNull
    public String toString() {
        return this.value.toString();
    }

    @Override
    @NotNull
    public String irClassFqName() {
        return Complex.DefaultImpls.irClassFqName(this);
    }

    @Override
    @NotNull
    public IrSimpleFunction getRealFunction(@NotNull IrSimpleFunction owner) {
        return Complex.DefaultImpls.getRealFunction(this, owner);
    }

    @Override
    public void loadOuterClassesInto(@NotNull CallStack callStack, @Nullable IrValueSymbol receiver) {
        Complex.DefaultImpls.loadOuterClassesInto(this, callStack, receiver);
    }

    @Override
    @Nullable
    public State getField(@NotNull IrSymbol symbol2) {
        return Complex.DefaultImpls.getField(this, symbol2);
    }

    @Override
    public void setField(@NotNull IrSymbol symbol2, @NotNull State state) {
        Complex.DefaultImpls.setField(this, symbol2, state);
    }

    static {
        Object[] objectArray = new String[]{"kotlin.text.StringBuilder", "kotlin.Pair", "kotlin.collections.ArrayList", "kotlin.collections.HashMap", "kotlin.collections.LinkedHashMap", "kotlin.collections.HashSet", "kotlin.collections.LinkedHashSet", "kotlin.text.RegexOption", "kotlin.text.Regex", "kotlin.text.Regex.Companion", "kotlin.text.MatchGroup"};
        intrinsicClasses = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"Array.kotlin.collections.asList()", (Object)"kotlin.collections.ArraysKt"), TuplesKt.to((Object)"kotlin.collections.mutableListOf(Array)", (Object)"kotlin.collections.CollectionsKt"), TuplesKt.to((Object)"kotlin.collections.arrayListOf(Array)", (Object)"kotlin.collections.CollectionsKt"), TuplesKt.to((Object)"Char.kotlin.text.isWhitespace()", (Object)"kotlin.text.CharsKt"), TuplesKt.to((Object)"Array.kotlin.collections.toMutableList()", (Object)"kotlin.collections.ArraysKt"), TuplesKt.to((Object)"Array.kotlin.collections.copyToArrayOfAny(Boolean)", (Object)"kotlin.collections.CollectionsKt")};
        intrinsicFunctionToHandler = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001c\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010 *\u00020!2\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010\u0005*\u00020\u0012H\u0002J\f\u0010$\u001a\u00020%*\u00020\u0012H\u0002J\u0012\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'*\u00020\u0012H\u0002J\f\u0010)\u001a\u00020\u0005*\u00020\u0012H\u0002J\f\u0010*\u001a\u00020\u001c*\u00020\u0012H\u0002J\f\u0010+\u001a\u00020\u001c*\u00020\u0012H\u0002J\u0014\u0010,\u001a\u00020\u001c*\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion;", "", "()V", "companionObjectValue", "", "", "intrinsicClasses", "", "intrinsicFunctionToHandler", "getCompanionObject", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getConstructorMethod", "Ljava/lang/invoke/MethodHandle;", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getEnumEntry", "irEnumClass", "getReflectionMethod", "irFunction", "getStaticGetter", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getStaticMethod", "mustBeHandledWithWrapper", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "getJvmClassName", "getMethodType", "Ljava/lang/invoke/MethodType;", "getOriginalOverriddenSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getSignature", "isExtensionReceiverPrimitive", "isReturnTypePrimitiveAsObject", "isValueParameterPrimitiveAsObject", "index", "", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        private final String getSignature(IrFunction $this$getSignature) {
            Object object;
            String fqName2;
            block5: {
                block4: {
                    fqName2 = UtilsKt.getFqName($this$getSignature);
                    Object object2 = $this$getSignature.getDispatchReceiverParameter();
                    if (object2 == null) {
                        object2 = object = $this$getSignature.getExtensionReceiverParameter();
                    }
                    if (object2 == null || (object = ((IrValueDeclaration)object).getType()) == null || (object = UtilsKt.getOnlyName((IrType)object)) == null) break block4;
                    Object it = object;
                    boolean bl = false;
                    String string2 = (String)it + '.';
                    object = string2;
                    if (string2 != null) break block5;
                }
                object = "";
            }
            Object receiver = object;
            return CollectionsKt.joinToString$default((Iterable)$this$getSignature.getValueParameters(), null, (CharSequence)((String)receiver + fqName2 + '('), (CharSequence)")", (int)0, null, (Function1)getSignature.1.INSTANCE, (int)25, null);
        }

        private final String getJvmClassName(IrFunction $this$getJvmClassName) {
            return (String)intrinsicFunctionToHandler.get(this.getSignature($this$getJvmClassName));
        }

        public final boolean mustBeHandledWithWrapper(@NotNull IrDeclarationWithName declaration) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (declaration instanceof IrFunction) {
                bl = intrinsicFunctionToHandler.containsKey(this.getSignature((IrFunction)declaration));
            } else {
                String it = UtilsKt.getFqName(declaration);
                boolean bl2 = false;
                bl = intrinsicClasses.contains(it) || StringsKt.startsWith$default((String)it, (String)"java", (boolean)false, (int)2, null);
            }
            return bl;
        }

        @NotNull
        public final MethodHandle getReflectionMethod(@NotNull IrFunction irFunction2) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            Class<? extends Object> receiverClass = this.getClass(irValueParameter.getType(), true);
            MethodType methodType = this.getMethodType(irFunction2);
            if (irFunction2 instanceof IrSimpleFunction) {
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)irFunction2).getCorrespondingPropertySymbol();
                IrProperty property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
                IrProperty irProperty2 = property2;
                if (Intrinsics.areEqual((Object)(irProperty2 != null ? irProperty2.getGetter() : null), (Object)irFunction2)) {
                    StringBuilder stringBuilder2 = new StringBuilder().append("get");
                    String string3 = property2.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"property.name.asString()");
                    string2 = stringBuilder2.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string3)).toString();
                } else {
                    IrProperty irProperty3 = property2;
                    if (Intrinsics.areEqual((Object)(irProperty3 != null ? irProperty3.getSetter() : null), (Object)irFunction2)) {
                        StringBuilder stringBuilder3 = new StringBuilder().append("set");
                        String string4 = property2.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"property.name.asString()");
                        string2 = stringBuilder3.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string4)).toString();
                    } else {
                        String string5 = irFunction2.getName().asString();
                        string2 = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"irFunction.name.asString()");
                    }
                }
            } else {
                String string6 = irFunction2.getName().asString();
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"irFunction.name.asString()");
            }
            String methodName = string2;
            MethodHandle methodHandle = MethodHandles.lookup().findVirtual(receiverClass, methodName, methodType);
            Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"lookup().findVirtual(rec\u2026, methodName, methodType)");
            return methodHandle;
        }

        @NotNull
        public final Wrapper getCompanionObject(@NotNull IrClass irClass2, @NotNull IrInterpreterEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            String objectName = UtilsKt.internalName(irClass2);
            Object v = companionObjectValue.get(objectName);
            if (v == null) {
                throw new InternalError("Companion object " + objectName + " cannot be interpreted");
            }
            Object objectValue = v;
            return new Wrapper(objectValue, irClass2, environment);
        }

        @Nullable
        public final MethodHandle getConstructorMethod(@NotNull IrFunction irConstructor2) {
            Intrinsics.checkNotNullParameter((Object)irConstructor2, (String)"irConstructor");
            String intrinsicValue = UtilsKt.internalName(IrUtilsKt.getParentAsClass(irConstructor2));
            if (Intrinsics.areEqual((Object)intrinsicValue, (Object)"kotlin.Char") || Intrinsics.areEqual((Object)intrinsicValue, (Object)"kotlin.Long")) {
                return null;
            }
            MethodType methodType = this.getMethodType(irConstructor2);
            return MethodHandles.lookup().findConstructor(this.getClass(irConstructor2.getReturnType(), true), methodType);
        }

        @Nullable
        public final MethodHandle getStaticMethod(@NotNull IrFunction irFunction2) {
            String intrinsicName;
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            String string2 = intrinsicName = this.getJvmClassName(irFunction2);
            if (!(string2 != null ? !(((CharSequence)string2).length() == 0) : false)) {
                return null;
            }
            Class<?> jvmClass = Class.forName(intrinsicName);
            MethodType methodType = this.getMethodType(irFunction2);
            return MethodHandles.lookup().findStatic(jvmClass, irFunction2.getName().asString(), methodType);
        }

        @NotNull
        public final MethodHandle getStaticGetter(@NotNull IrField field2) {
            Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
            Class<? extends Object> jvmClass = this.getClass(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(field2)), true);
            IrType it = field2.getType();
            boolean bl = false;
            Class<? extends Object> returnType2 = Companion.getClass(it, ((IrSimpleType)it).getHasQuestionMark());
            MethodHandle methodHandle = MethodHandles.lookup().findStaticGetter(jvmClass, field2.getName().asString(), returnType2);
            Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"lookup().findStaticGette\u2026e.asString(), returnType)");
            return methodHandle;
        }

        @NotNull
        public final MethodHandle getEnumEntry(@NotNull IrClass irEnumClass) {
            Intrinsics.checkNotNullParameter((Object)irEnumClass, (String)"irEnumClass");
            String intrinsicName = UtilsKt.internalName(irEnumClass);
            Class<?> jvmEnumClass = Class.forName(intrinsicName);
            MethodType methodType = MethodType.methodType(jvmEnumClass, String.class);
            MethodHandle methodHandle = MethodHandles.lookup().findStatic(jvmEnumClass, StandardNames.ENUM_VALUE_OF.getIdentifier(), methodType);
            Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"lookup().findStatic(jvmE\u2026F.identifier, methodType)");
            return methodHandle;
        }

        /*
         * WARNING - void declaration
         */
        private final MethodType getMethodType(IrFunction $this$getMethodType) {
            MethodType methodType;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$getMethodType.getValueParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.getClass(it.getType(), Companion.isValueParameterPrimitiveAsObject($this$getMethodType, it.getIndex())));
            }
            List argsClasses = (List)destination$iv$iv;
            if ($this$getMethodType instanceof IrSimpleFunction) {
                Class<? extends Object> returnClass = this.getClass($this$getMethodType.getReturnType(), this.isReturnTypePrimitiveAsObject($this$getMethodType));
                IrAnnotationContainer irAnnotationContainer = $this$getMethodType.getExtensionReceiverParameter();
                Class<? extends Object> extensionClass = irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? this.getClass((IrType)irAnnotationContainer, this.isExtensionReceiverPrimitive($this$getMethodType)) : null;
                MethodType methodType2 = MethodType.methodType(returnClass, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(extensionClass), (Iterable)argsClasses));
                methodType = methodType2;
                Intrinsics.checkNotNullExpressionValue((Object)methodType2, (String)"{\n                // for\u2026rgsClasses)\n            }");
            } else {
                MethodType methodType3 = MethodType.methodType(Void.TYPE, argsClasses);
                methodType = methodType3;
                Intrinsics.checkNotNullExpressionValue((Object)methodType3, (String)"{\n                // for\u2026rgsClasses)\n            }");
            }
            return methodType;
        }

        private final Class<? extends Object> getClass(IrType $this$getClass, boolean asObject) {
            Class<Object> clazz;
            IrClass owner;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getClass);
            IrClass irClass2 = owner = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
            String fqName2 = irClass2 != null ? UtilsKt.getFqName(irClass2) : null;
            IrType notNullType = IrTypesKt.makeNotNull($this$getClass);
            if (IrTypePredicatesKt.isPrimitiveType$default(notNullType, false, 1, null) || IrTypePredicatesKt.isString(notNullType)) {
                Class<?> clazz2 = UtilsKt.getPrimitiveClass(notNullType, asObject);
                clazz = clazz2;
                Intrinsics.checkNotNull(clazz2);
            } else if (IrTypePredicatesKt.isArray(notNullType)) {
                Class clazz3;
                Object object = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)$this$getClass).getArguments()));
                String argumentFqName = object != null && (object = IrTypesKt.getClassOrNull((IrType)object)) != null && (object = (IrClass)object.getOwner()) != null ? UtilsKt.getFqName((IrElement)object) : null;
                if (argumentFqName != null && !Intrinsics.areEqual((Object)argumentFqName, (Object)"kotlin.Any")) {
                    String it = argumentFqName;
                    boolean bl = false;
                    clazz3 = Class.forName("[L" + it + ';');
                } else {
                    clazz3 = Object[].class;
                }
                Class<Object[]> clazz4 = clazz3;
                Intrinsics.checkNotNullExpressionValue(clazz4, (String)"{\n                    va\u2026      }\n                }");
                clazz = clazz4;
            } else if (IrTypePredicatesKt.isNothing(notNullType)) {
                clazz = Void.class;
            } else if (IrTypePredicatesKt.isAny(notNullType)) {
                clazz = Object.class;
            } else if (IrTypePredicatesKt.isUnit(notNullType)) {
                if (asObject) {
                    clazz = Void.class;
                } else {
                    Class<Void> clazz5 = Void.TYPE;
                    clazz = clazz5;
                    Intrinsics.checkNotNull(clazz5);
                }
            } else if (IrTypePredicatesKt.isNumber(notNullType)) {
                clazz = Number.class;
            } else if (IrTypePredicatesKt.isCharSequence(notNullType)) {
                clazz = CharSequence.class;
            } else if (IrTypePredicatesKt.isComparable(notNullType)) {
                clazz = Comparable.class;
            } else if (UtilsKt.isThrowable(notNullType)) {
                clazz = Throwable.class;
            } else if (IrTypePredicatesKt.isIterable(notNullType)) {
                clazz = Iterable.class;
            } else if (UtilsKt.isKFunction(notNullType)) {
                Class<?> clazz6 = Class.forName("kotlin.reflect.KFunction");
                clazz = clazz6;
                Intrinsics.checkNotNullExpressionValue(clazz6, (String)"forName(\"kotlin.reflect.KFunction\")");
            } else {
                if (UtilsKt.isFunction(notNullType)) {
                    Class<?> clazz7;
                    String string2 = fqName2;
                    Integer arity = string2 != null && (string2 = StringsKt.removePrefix((String)string2, (CharSequence)"kotlin.Function")) != null ? StringsKt.toIntOrNull((String)string2) : null;
                    if (arity == null || arity >= 23) {
                        Class<?> clazz8 = Class.forName("kotlin.jvm.functions.FunctionN");
                        clazz7 = clazz8;
                        Intrinsics.checkNotNullExpressionValue(clazz8, (String)"forName(\"kotlin.jvm.functions.FunctionN\")");
                    } else {
                        Class<?> clazz9 = Class.forName("kotlin.jvm.functions." + StringsKt.removePrefix((String)fqName2, (CharSequence)"kotlin."));
                        clazz7 = clazz9;
                        Intrinsics.checkNotNullExpressionValue(clazz9, (String)"forName(\"kotlin.jvm.func\u2026emovePrefix(\"kotlin.\")}\")");
                    }
                    return clazz7;
                }
                if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.Enum")) {
                    clazz = Enum.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Collection") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableCollection")) {
                    clazz = Collection.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.List") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableList")) {
                    clazz = List.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Set") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableSet")) {
                    clazz = Set.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Map") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableMap")) {
                    clazz = Map.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.ListIterator") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableListIterator")) {
                    clazz = ListIterator.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Iterator") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableIterator")) {
                    clazz = Iterator.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Map.Entry") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableMap.MutableEntry")) {
                    clazz = Map.Entry.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.ArrayList")) {
                    clazz = ArrayList.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.HashMap")) {
                    clazz = HashMap.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.HashSet")) {
                    clazz = HashSet.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.LinkedHashMap")) {
                    clazz = LinkedHashMap.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.LinkedHashSet")) {
                    clazz = LinkedHashSet.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.text.StringBuilder")) {
                    clazz = StringBuilder.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.text.Appendable")) {
                    clazz = Appendable.class;
                } else if (fqName2 == null) {
                    clazz = Object.class;
                } else {
                    Class<?> clazz10 = Class.forName(UtilsKt.internalName(owner));
                    clazz = clazz10;
                    Intrinsics.checkNotNullExpressionValue(clazz10, (String)"forName(owner.internalName())");
                }
            }
            return clazz;
        }

        private final List<IrFunctionSymbol> getOriginalOverriddenSymbols(IrFunction $this$getOriginalOverriddenSymbols) {
            List overriddenSymbols2 = new ArrayList();
            if ($this$getOriginalOverriddenSymbols instanceof IrSimpleFunction) {
                List pool = CollectionsKt.toMutableList((Collection)((IrSimpleFunction)$this$getOriginalOverriddenSymbols).getOverriddenSymbols());
                ListIterator<IrSimpleFunctionSymbol> iterator2 = pool.listIterator();
                Iterator iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    IrSimpleFunctionSymbol symbol2 = (IrSimpleFunctionSymbol)iterator3.next();
                    if (((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols().isEmpty()) {
                        ((Collection)overriddenSymbols2).add(symbol2);
                        iterator2.remove();
                        continue;
                    }
                    Iterable $this$forEach$iv = ((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl = false;
                        iterator2.add(it);
                    }
                }
            }
            if (overriddenSymbols2.isEmpty()) {
                overriddenSymbols2.add($this$getOriginalOverriddenSymbols.getSymbol());
            }
            return overriddenSymbols2;
        }

        private final boolean isExtensionReceiverPrimitive(IrFunction $this$isExtensionReceiverPrimitive) {
            IrAnnotationContainer irAnnotationContainer = $this$isExtensionReceiverPrimitive.getExtensionReceiverParameter();
            return irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? !IrTypePredicatesKt.isPrimitiveType$default((IrType)irAnnotationContainer, false, 1, null) : false;
        }

        private final boolean isReturnTypePrimitiveAsObject(IrFunction $this$isReturnTypePrimitiveAsObject) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isReturnTypePrimitiveAsObject)) {
                if (UtilsKt.isTypeParameter(symbol2.getOwner().getReturnType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getReturnType())) continue;
                return false;
            }
            return true;
        }

        private final boolean isValueParameterPrimitiveAsObject(IrFunction $this$isValueParameterPrimitiveAsObject, int index2) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isValueParameterPrimitiveAsObject)) {
                if (UtilsKt.isTypeParameter(symbol2.getOwner().getValueParameters().get(index2).getType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getValueParameters().get(index2).getType())) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

