/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.IrTranslationResultMap;
import org.jetbrains.kotlin.incremental.PackageMetadataMap;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDataProvider;
import org.jetbrains.kotlin.incremental.TranslationResultMap;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.incremental.js.IrTranslationResultValue;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesFqNameMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.SourceToFqNameMap;
import org.jetbrains.kotlin.incremental.storage.SourceToJsOutputMap;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001FB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\"\u0010/\u001a\u00020,2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000202012\u0006\u0010-\u001a\u00020.J\u0016\u00103\u001a\u00020,2\u0006\u00104\u001a\u0002052\u0006\u0010-\u001a\u00020.J\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\u0004072\u0006\u00108\u001a\u00020\u0004J\u0016\u00109\u001a\u00020,2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000407H\u0016J\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020<01J\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020201J\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020\u001201J\u0018\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u0002H\u0002J\u0014\u0010B\u001a\u00020,2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020E0DR\u0014\u0010\n\u001a\u00020\u000bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000fj\b\u0012\u0004\u0012\u00020\u0004`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache;", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Lorg/jetbrains/kotlin/name/FqName;", "cachesDir", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "dirtySources", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "value", "", "header", "getHeader", "()[B", "setHeader", "([B)V", "headerFile", "getHeaderFile", "()Ljava/io/File;", "inlineFunctions", "Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "irTranslationResults", "Lorg/jetbrains/kotlin/incremental/IrTranslationResultMap;", "packageMetadata", "Lorg/jetbrains/kotlin/incremental/PackageMetadataMap;", "protoData", "Lorg/jetbrains/kotlin/incremental/ProtoDataProvider;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "sourceToJsOutputsMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToJsOutputMap;", "translationResults", "Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "clearCacheForRemovedClasses", "", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "compare", "translatedFiles", "", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "compareAndUpdate", "incrementalResults", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumerImpl;", "getOutputsBySource", "", "sourceFile", "markDirty", "removedAndCompiledSources", "nonDirtyIrParts", "Lorg/jetbrains/kotlin/incremental/js/IrTranslationResultValue;", "nonDirtyPackageParts", "", "registerOutputForFile", "srcFile", "name", "updateSourceToOutputMap", "generatedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "Companion", "kotlin-build-common"})
public class IncrementalJsCache
extends AbstractIncrementalCache<FqName> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProtoDataProvider protoData;
    @NotNull
    private final SourceToFqNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesFqNameMap dirtyOutputClassesMap;
    @NotNull
    private final TranslationResultMap translationResults;
    @NotNull
    private final IrTranslationResultMap irTranslationResults;
    @NotNull
    private final InlineFunctionsMap inlineFunctions;
    @NotNull
    private final PackageMetadataMap packageMetadata;
    @NotNull
    private final SourceToJsOutputMap sourceToJsOutputsMap;
    @NotNull
    private final HashSet<File> dirtySources;
    @NotNull
    private static final String TRANSLATION_RESULT_MAP = "translation-result";
    @NotNull
    private static final String IR_TRANSLATION_RESULT_MAP = "ir-translation-result";
    @NotNull
    private static final String INLINE_FUNCTIONS = "inline-functions";
    @NotNull
    private static final String HEADER_FILE_NAME = "header.meta";
    @NotNull
    private static final String PACKAGE_META_FILE = "packages-meta";
    @NotNull
    private static final String SOURCE_TO_JS_OUTPUT = "source-to-js-output";

    public IncrementalJsCache(@NotNull File cachesDir, @NotNull FileToPathConverter pathConverter, @NotNull SerializerExtensionProtocol serializerProtocol) {
        Intrinsics.checkNotNullParameter((Object)cachesDir, (String)"cachesDir");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        Intrinsics.checkNotNullParameter((Object)serializerProtocol, (String)"serializerProtocol");
        super(cachesDir, pathConverter);
        this.protoData = new ProtoDataProvider(serializerProtocol);
        this.sourceToClassesMap = (SourceToFqNameMap)this.registerMap((BasicMap)new SourceToFqNameMap(this.getStorageFile(AbstractIncrementalCache.getSOURCE_TO_CLASSES()), pathConverter));
        this.dirtyOutputClassesMap = (DirtyClassesFqNameMap)this.registerMap((BasicMap)new DirtyClassesFqNameMap(this.getStorageFile(AbstractIncrementalCache.getDIRTY_OUTPUT_CLASSES())));
        this.translationResults = (TranslationResultMap)this.registerMap((BasicMap)new TranslationResultMap(this.getStorageFile(TRANSLATION_RESULT_MAP), pathConverter, this.protoData));
        this.irTranslationResults = (IrTranslationResultMap)this.registerMap((BasicMap)new IrTranslationResultMap(this.getStorageFile(IR_TRANSLATION_RESULT_MAP), pathConverter));
        this.inlineFunctions = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(INLINE_FUNCTIONS), pathConverter));
        this.packageMetadata = (PackageMetadataMap)this.registerMap((BasicMap)new PackageMetadataMap(this.getStorageFile(PACKAGE_META_FILE)));
        this.sourceToJsOutputsMap = (SourceToJsOutputMap)this.registerMap((BasicMap)new SourceToJsOutputMap(this.getStorageFile(SOURCE_TO_JS_OUTPUT), pathConverter));
        this.dirtySources = new HashSet();
    }

    @NotNull
    public SourceToFqNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesFqNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getHeaderFile() {
        return new File(this.getCachesDir(), HEADER_FILE_NAME);
    }

    @NotNull
    public final byte[] getHeader() {
        return FilesKt.readBytes((File)this.getHeaderFile());
    }

    public final void setHeader(@NotNull byte[] value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.getCachesDir().mkdirs();
        FilesKt.writeBytes((File)this.getHeaderFile(), (byte[])value2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void markDirty(@NotNull Collection<? extends File> removedAndCompiledSources) {
        Intrinsics.checkNotNullParameter(removedAndCompiledSources, (String)"removedAndCompiledSources");
        Iterable $this$forEach$iv = removedAndCompiledSources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            Object v1;
            void $this$mapTo$iv$iv;
            File sourceFile = (File)element$iv;
            boolean bl = false;
            this.sourceToJsOutputsMap.remove(sourceFile);
            Iterable $this$map$iv = this.getSourceToClassesMap$kotlin_build_common().get(sourceFile);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FqName fqName2 = (FqName)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object object = FqNamesUtilKt.parentOrNull((FqName)it2);
                if (object == null || (object = ((FqName)object).asString()) == null) {
                    object = "";
                }
                collection.add(object);
            }
            Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    String it3 = (String)minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = it3.length();
                    do {
                        Object e$iv = iterator$iv.next();
                        String it4 = (String)e$iv;
                        $i$a$-minByOrNull-IncrementalJsCache$markDirty$1$2 = false;
                        int v$iv = it4.length();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            if ((String)v1 == null) continue;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.packageMetadata.remove(it);
        }
        super.markDirty(removedAndCompiledSources);
        this.dirtySources.addAll(removedAndCompiledSources);
    }

    public final void compare(@NotNull Map<File, TranslationResultValue> translatedFiles, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter(translatedFiles, (String)"translatedFiles");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        for (Map.Entry<File, TranslationResultValue> entry : translatedFiles.entrySet()) {
            Object object;
            TranslationResultValue data;
            File srcFile;
            block5: {
                block4: {
                    srcFile = entry.getKey();
                    data = entry.getValue();
                    object = this.translationResults.get(srcFile);
                    if (object == null) break block4;
                    byte[] byArray = ((TranslationResultValue)object).getMetadata();
                    object = byArray;
                    if (byArray == null) break block4;
                    Map<ClassId, ProtoData> it = object;
                    boolean bl = false;
                    Map<ClassId, ProtoData> map = this.protoData.invoke(srcFile, (byte[])it);
                    object = map;
                    if (map != null) break block5;
                }
                object = MapsKt.emptyMap();
            }
            Map<ClassId, ProtoData> oldProtoMap = object;
            Map<ClassId, ProtoData> newProtoMap = this.protoData.invoke(srcFile, data.getMetadata());
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, oldProtoMap.get(classId), newProtoMap.get(classId), false, null, 12, null);
            }
        }
    }

    @NotNull
    public final Collection<File> getOutputsBySource(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.sourceToJsOutputsMap.get(sourceFile);
    }

    public final void compareAndUpdate(@NotNull IncrementalResultsConsumerImpl incrementalResults, @NotNull ChangesCollector changesCollector) {
        File srcFile;
        Intrinsics.checkNotNullParameter((Object)incrementalResults, (String)"incrementalResults");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Map<File, TranslationResultValue> translatedFiles = incrementalResults.getPackageParts();
        for (Map.Entry<File, TranslationResultValue> entry : translatedFiles.entrySet()) {
            Object object;
            byte[] inlineData;
            byte[] binaryAst;
            byte[] binaryMetadata;
            block9: {
                block8: {
                    srcFile = entry.getKey();
                    TranslationResultValue data = entry.getValue();
                    this.dirtySources.remove(srcFile);
                    binaryMetadata = data.component1();
                    binaryAst = data.component2();
                    inlineData = data.component3();
                    object = this.translationResults.get(srcFile);
                    if (object == null) break block8;
                    byte[] byArray = ((TranslationResultValue)object).getMetadata();
                    object = byArray;
                    if (byArray == null) break block8;
                    Map<ClassId, ProtoData> it = object;
                    boolean bl = false;
                    Map<ClassId, ProtoData> map = this.protoData.invoke(srcFile, (byte[])it);
                    object = map;
                    if (map != null) break block9;
                }
                object = MapsKt.emptyMap();
            }
            Map<ClassId, ProtoData> oldProtoMap = object;
            Map<ClassId, ProtoData> newProtoMap = this.protoData.invoke(srcFile, binaryMetadata);
            for (Map.Entry<ClassId, ProtoData> entry2 : newProtoMap.entrySet()) {
                ClassId classId = entry2.getKey();
                ProtoData protoData = entry2.getValue();
                FqName fqName2 = classId.asSingleFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.asSingleFqName()");
                this.registerOutputForFile(srcFile, fqName2);
                if (!(protoData instanceof ClassProtoData)) continue;
                this.addToClassStorage(((ClassProtoData)protoData).getProto(), ((ClassProtoData)protoData).getNameResolver(), srcFile);
            }
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, oldProtoMap.get(classId), newProtoMap.get(classId), false, null, 12, null);
            }
            this.translationResults.put(srcFile, binaryMetadata, binaryAst, inlineData);
        }
        for (Map.Entry<File, Object> entry : incrementalResults.getInlineFunctions().entrySet()) {
            srcFile = entry.getKey();
            Map inlineDeclarations = (Map)entry.getValue();
            this.inlineFunctions.process(srcFile, inlineDeclarations, changesCollector);
        }
        for (Map.Entry<Object, Object> entry : incrementalResults.getPackageMetadata().entrySet()) {
            String packageName = (String)entry.getKey();
            byte[] metadata = (byte[])entry.getValue();
            this.packageMetadata.put(packageName, metadata);
        }
        for (Map.Entry<Object, Object> entry : incrementalResults.getIrFileData().entrySet()) {
            srcFile = (File)entry.getKey();
            IrTranslationResultValue irData = (IrTranslationResultValue)entry.getValue();
            byte[] fileData = irData.component1();
            byte[] types2 = irData.component2();
            byte[] signatures2 = irData.component3();
            byte[] strings2 = irData.component4();
            byte[] declarations2 = irData.component5();
            byte[] bodies2 = irData.component6();
            byte[] fqn = irData.component7();
            byte[] debugInfos2 = irData.component8();
            this.irTranslationResults.put(srcFile, fileData, types2, signatures2, strings2, declarations2, bodies2, fqn, debugInfos2);
        }
    }

    private final void registerOutputForFile(File srcFile, FqName name) {
        this.getSourceToClassesMap$kotlin_build_common().add(srcFile, name);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(name);
    }

    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Iterable $this$forEach$iv = this.dirtySources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.translationResults.remove(it, changesCollector);
            this.irTranslationResults.remove(it);
            this.inlineFunctions.remove(it);
        }
        this.removeAllFromClassStorage(this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses(), changesCollector);
        this.dirtySources.clear();
        this.getDirtyOutputClassesMap$kotlin_build_common().clean();
    }

    @NotNull
    public final Map<File, TranslationResultValue> nonDirtyPackageParts() {
        HashMap<File, TranslationResultValue> hashMap;
        HashMap<File, TranslationResultValue> $this$nonDirtyPackageParts_u24lambda_u2d7 = hashMap = new HashMap<File, TranslationResultValue>();
        boolean bl = false;
        for (File file2 : this.translationResults.keys()) {
            if (this.dirtySources.contains(file2)) continue;
            TranslationResultValue translationResultValue = this.translationResults.get(file2);
            Intrinsics.checkNotNull((Object)translationResultValue);
            $this$nonDirtyPackageParts_u24lambda_u2d7.put(file2, translationResultValue);
        }
        return hashMap;
    }

    @NotNull
    public final Map<String, byte[]> packageMetadata() {
        HashMap<String, byte[]> hashMap;
        HashMap<String, byte[]> $this$packageMetadata_u24lambda_u2d8 = hashMap = new HashMap<String, byte[]>();
        boolean bl = false;
        for (String fqNameString : this.packageMetadata.keys()) {
            byte[] byArray = this.packageMetadata.get(fqNameString);
            Intrinsics.checkNotNull((Object)byArray);
            $this$packageMetadata_u24lambda_u2d8.put(fqNameString, byArray);
        }
        return hashMap;
    }

    @NotNull
    public final Map<File, IrTranslationResultValue> nonDirtyIrParts() {
        HashMap<File, IrTranslationResultValue> hashMap;
        HashMap<File, IrTranslationResultValue> $this$nonDirtyIrParts_u24lambda_u2d9 = hashMap = new HashMap<File, IrTranslationResultValue>();
        boolean bl = false;
        for (File file2 : this.irTranslationResults.keys()) {
            if (this.dirtySources.contains(file2)) continue;
            IrTranslationResultValue irTranslationResultValue = this.irTranslationResults.get(file2);
            Intrinsics.checkNotNull((Object)irTranslationResultValue);
            $this$nonDirtyIrParts_u24lambda_u2d9.put(file2, irTranslationResultValue);
        }
        return hashMap;
    }

    public final void updateSourceToOutputMap(@NotNull Iterable<? extends GeneratedFile> generatedFiles) {
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        for (GeneratedFile generatedFile : generatedFiles) {
            for (File source : generatedFile.getSourceFiles()) {
                if (!this.dirtySources.contains(source)) continue;
                this.sourceToJsOutputsMap.add(source, generatedFile.getOutputFile());
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache$Companion;", "", "()V", "HEADER_FILE_NAME", "", "INLINE_FUNCTIONS", "IR_TRANSLATION_RESULT_MAP", "PACKAGE_META_FILE", "SOURCE_TO_JS_OUTPUT", "TRANSLATION_RESULT_MAP", "hasHeaderFile", "", "cachesDir", "Ljava/io/File;", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasHeaderFile(@NotNull File cachesDir) {
            Intrinsics.checkNotNullParameter((Object)cachesDir, (String)"cachesDir");
            return new File(cachesDir, IncrementalJsCache.HEADER_FILE_NAME).exists();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

