/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u001e\u0010\u001e\u001a\u00020\b*\u00020\u00042\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0 \u001a.\u0010\u001e\u001a\u00020\b*\u00020\u00042\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"H\u0002\u001a\u001e\u0010#\u001a\u00020$*\u00020\u00042\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$0 \u001a\u001a\u0010&\u001a\u00020\b*\u00020\u00042\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a#\u0010(\u001a\u00020\b*\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010)\u001a\n\u0010*\u001a\u00020+*\u00020+\u001a\u0012\u0010,\u001a\u00020-*\u00020\u00042\u0006\u0010.\u001a\u00020/\u001a\u0012\u0010,\u001a\u00020-*\u00020\u00042\u0006\u00100\u001a\u000201\u001a\u001f\u00102\u001a\u00020+*\u00020+2\u000e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020-04\u00a2\u0006\u0002\u00105\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u0002*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0015\u0010\n\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\t\"\u0015\u0010\u000b\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0015\u0010\f\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\"\u0015\u0010\r\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\"\u0015\u0010\u000e\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\"\u0015\u0010\u000f\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\"\u0015\u0010\u0010\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\t\"\u0015\u0010\u0011\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\"\u0015\u0010\u0012\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\"\u0015\u0010\u0013\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\"\u0015\u0010\u0014\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\t\"\u0015\u0010\u0015\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\t\"\u0015\u0010\u0016\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\"\u0015\u0010\u0017\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\t\"\u0015\u0010\u0018\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\t\"\u0015\u0010\u0019\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\t\"\u0015\u0010\u001a\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\t\"\u0015\u0010\u001b\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\t\"\u0015\u0010\u001c\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\t\"\u0015\u0010\u001d\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\t\u00a8\u00066"}, d2={"builtinIntegerTypes", "", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getClassId", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/name/ClassId;", "isAny", "", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "isArrayType", "isBoolean", "isBooleanOrNullableBoolean", "isEnum", "isInt", "isIntegerTypeOrNullableIntegerTypeOfAnySize", "isMarkedNullable", "isNonPrimitiveArray", "isNothing", "isNullable", "isNullableAny", "isNullableBoolean", "isNullableNothing", "isPrimitive", "isPrimitiveArray", "isPrimitiveOrNullablePrimitive", "isString", "isUnit", "isUnsignedType", "isUnsignedTypeOrNullableUnsignedType", "contains", "predicate", "Lkotlin/Function1;", "visited", "Lorg/jetbrains/kotlin/utils/SmartSet;", "forEachType", "", "action", "isAnyOfBuiltinType", "classIds", "isBuiltinType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/name/ClassId;Ljava/lang/Boolean;)Z", "replaceArgumentsWithStarProjections", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "toTypeProjection", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "projectionKind", "Lorg/jetbrains/kotlin/fir/types/ProjectionKind;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "withArguments", "typeArguments", "", "(Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "cones"})
public final class ConeTypeUtilsKt {
    @NotNull
    private static final Set<ClassId> builtinIntegerTypes;

    public static final boolean isNullable(@NotNull ConeKotlinType $this$isNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullable, (String)"<this>");
        return $this$isNullable.getNullability() != ConeNullability.NOT_NULL;
    }

    public static final boolean isMarkedNullable(@NotNull ConeKotlinType $this$isMarkedNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedNullable, (String)"<this>");
        return $this$isMarkedNullable.getNullability() == ConeNullability.NULLABLE;
    }

    @Nullable
    public static final ClassId getClassId(@NotNull ConeKotlinType $this$classId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$classId, (String)"<this>");
        ConeKotlinType $this$safeAs$iv = $this$classId;
        boolean $i$f$safeAs = false;
        ConeKotlinType coneKotlinType = $this$safeAs$iv;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (object = (ConeClassLikeType)coneKotlinType) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null;
    }

    public static final void forEachType(@NotNull ConeKotlinType $this$forEachType, @NotNull Function1<? super ConeKotlinType, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachType, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke((Object)$this$forEachType);
        ConeKotlinType coneKotlinType = $this$forEachType;
        if (coneKotlinType instanceof ConeFlexibleType) {
            ConeTypeUtilsKt.forEachType(((ConeFlexibleType)$this$forEachType).getLowerBound(), action);
            ConeTypeUtilsKt.forEachType(((ConeFlexibleType)$this$forEachType).getUpperBound(), action);
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            ConeTypeUtilsKt.forEachType(((ConeDefinitelyNotNullType)$this$forEachType).getOriginal(), action);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            Iterable $this$forEach$iv = ((ConeIntersectionType)$this$forEachType).getIntersectedTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                ConeTypeUtilsKt.forEachType(it, action);
            }
        } else {
            ConeTypeProjection[] $this$forEach$iv = $this$forEachType.getTypeArguments();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!(it instanceof ConeKotlinTypeProjection)) continue;
                ConeTypeUtilsKt.forEachType(((ConeKotlinTypeProjection)it).getType(), action);
            }
        }
    }

    public static final boolean contains(@NotNull ConeKotlinType $this$contains, @NotNull Function1<? super ConeKotlinType, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return ConeTypeUtilsKt.contains($this$contains, predicate, SmartSet.Companion.create());
    }

    private static final boolean contains(ConeKotlinType $this$contains, Function1<? super ConeKotlinType, Boolean> predicate, SmartSet<ConeKotlinType> visited2) {
        boolean bl;
        block12: {
            if (visited2.contains($this$contains)) {
                return false;
            }
            if (((Boolean)predicate.invoke((Object)$this$contains)).booleanValue()) {
                return true;
            }
            ((Collection)visited2).add($this$contains);
            ConeKotlinType coneKotlinType = $this$contains;
            if (coneKotlinType instanceof ConeFlexibleType) {
                bl = ConeTypeUtilsKt.contains(((ConeFlexibleType)$this$contains).getLowerBound(), predicate, visited2) || ConeTypeUtilsKt.contains(((ConeFlexibleType)$this$contains).getUpperBound(), predicate, visited2);
            } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                bl = ConeTypeUtilsKt.contains(((ConeDefinitelyNotNullType)$this$contains).getOriginal(), predicate, visited2);
            } else if (coneKotlinType instanceof ConeIntersectionType) {
                Iterable $this$any$iv = ((ConeIntersectionType)$this$contains).getIntersectedTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!ConeTypeUtilsKt.contains(it, predicate, visited2)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            } else {
                ConeTypeProjection[] $this$any$iv = $this$contains.getTypeArguments();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it = element$iv = $this$any$iv[i];
                    boolean bl3 = false;
                    if (!(it instanceof ConeKotlinTypeProjection && ConeTypeUtilsKt.contains(((ConeKotlinTypeProjection)it).getType(), predicate, visited2))) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final ConeClassLikeType withArguments(@NotNull ConeClassLikeType $this$withArguments, @NotNull ConeTypeProjection[] typeArguments2) {
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter((Object)$this$withArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typeArguments2, (String)"typeArguments");
        ConeClassLikeType coneClassLikeType2 = $this$withArguments;
        if (coneClassLikeType2 instanceof ConeClassLikeTypeImpl) {
            coneClassLikeType = new ConeClassLikeTypeImpl($this$withArguments.getLookupTag(), typeArguments2, ConeTypeUtilsKt.isNullable($this$withArguments), $this$withArguments.getAttributes());
        } else if (coneClassLikeType2 instanceof ConeClassErrorType) {
            coneClassLikeType = $this$withArguments;
        } else {
            throw new IllegalStateException(("Unknown cone type: " + Reflection.getOrCreateKotlinClass($this$withArguments.getClass())).toString());
        }
        return coneClassLikeType;
    }

    @NotNull
    public static final ConeTypeProjection toTypeProjection(@NotNull ConeKotlinType $this$toTypeProjection, @NotNull Variance variance) {
        ConeTypeProjection coneTypeProjection;
        Intrinsics.checkNotNullParameter((Object)$this$toTypeProjection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)variance), (String)"variance");
        switch (WhenMappings.$EnumSwitchMapping$0[variance.ordinal()]) {
            case 1: {
                coneTypeProjection = $this$toTypeProjection;
                break;
            }
            case 2: {
                coneTypeProjection = new ConeKotlinTypeProjectionIn($this$toTypeProjection);
                break;
            }
            case 3: {
                coneTypeProjection = new ConeKotlinTypeProjectionOut($this$toTypeProjection);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneTypeProjection;
    }

    @NotNull
    public static final ConeTypeProjection toTypeProjection(@NotNull ConeKotlinType $this$toTypeProjection, @NotNull ProjectionKind projectionKind) {
        ConeTypeProjection coneTypeProjection;
        Intrinsics.checkNotNullParameter((Object)$this$toTypeProjection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)projectionKind), (String)"projectionKind");
        switch (WhenMappings.$EnumSwitchMapping$1[projectionKind.ordinal()]) {
            case 1: {
                coneTypeProjection = $this$toTypeProjection;
                break;
            }
            case 2: {
                coneTypeProjection = new ConeKotlinTypeProjectionIn($this$toTypeProjection);
                break;
            }
            case 3: {
                coneTypeProjection = new ConeKotlinTypeProjectionOut($this$toTypeProjection);
                break;
            }
            case 4: {
                coneTypeProjection = ConeStarProjection.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneTypeProjection;
    }

    @NotNull
    public static final ConeClassLikeType replaceArgumentsWithStarProjections(@NotNull ConeClassLikeType $this$replaceArgumentsWithStarProjections) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceArgumentsWithStarProjections, (String)"<this>");
        if ($this$replaceArgumentsWithStarProjections.getTypeArguments().length == 0) {
            return $this$replaceArgumentsWithStarProjections;
        }
        int n = 0;
        int n2 = $this$replaceArgumentsWithStarProjections.getTypeArguments().length;
        ConeStarProjection[] coneStarProjectionArray = new ConeStarProjection[n2];
        while (n < n2) {
            int n3 = n++;
            coneStarProjectionArray[n3] = ConeStarProjection.INSTANCE;
        }
        ConeStarProjection[] newArguments2 = coneStarProjectionArray;
        return ConeTypeUtilsKt.withArguments($this$replaceArgumentsWithStarProjections, newArguments2);
    }

    public static final boolean isAny(@NotNull ConeKotlinType $this$isAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isAny, (String)"<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isAny, StandardClassIds.INSTANCE.getAny(), false);
    }

    public static final boolean isNullableAny(@NotNull ConeKotlinType $this$isNullableAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableAny, (String)"<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isNullableAny, StandardClassIds.INSTANCE.getAny(), true);
    }

    public static final boolean isNothing(@NotNull ConeKotlinType $this$isNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isNothing, (String)"<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isNothing, StandardClassIds.INSTANCE.getNothing(), false);
    }

    public static final boolean isNullableNothing(@NotNull ConeKotlinType $this$isNullableNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableNothing, (String)"<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isNullableNothing, StandardClassIds.INSTANCE.getNothing(), true);
    }

    public static final boolean isUnit(@NotNull ConeKotlinType $this$isUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnit, (String)"<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isUnit, StandardClassIds.INSTANCE.getUnit(), false);
    }

    public static final boolean isBoolean(@NotNull ConeKotlinType $this$isBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$isBoolean, (String)"<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isBoolean, StandardClassIds.INSTANCE.getBoolean(), false);
    }

    public static final boolean isNullableBoolean(@NotNull ConeKotlinType $this$isNullableBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableBoolean, (String)"<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isNullableBoolean, StandardClassIds.INSTANCE.getBoolean(), true);
    }

    public static final boolean isBooleanOrNullableBoolean(@NotNull ConeKotlinType $this$isBooleanOrNullableBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$isBooleanOrNullableBoolean, (String)"<this>");
        return ConeTypeUtilsKt.isAnyOfBuiltinType($this$isBooleanOrNullableBoolean, SetsKt.setOf((Object)StandardClassIds.INSTANCE.getBoolean()));
    }

    public static final boolean isEnum(@NotNull ConeKotlinType $this$isEnum) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnum, (String)"<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isEnum, StandardClassIds.INSTANCE.getEnum(), false);
    }

    public static final boolean isString(@NotNull ConeKotlinType $this$isString) {
        Intrinsics.checkNotNullParameter((Object)$this$isString, (String)"<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isString, StandardClassIds.INSTANCE.getString(), false);
    }

    public static final boolean isInt(@NotNull ConeKotlinType $this$isInt) {
        Intrinsics.checkNotNullParameter((Object)$this$isInt, (String)"<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isInt, StandardClassIds.INSTANCE.getInt(), false);
    }

    public static final boolean isPrimitiveOrNullablePrimitive(@NotNull ConeKotlinType $this$isPrimitiveOrNullablePrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveOrNullablePrimitive, (String)"<this>");
        return ConeTypeUtilsKt.isAnyOfBuiltinType($this$isPrimitiveOrNullablePrimitive, StandardClassIds.INSTANCE.getPrimitiveTypes());
    }

    public static final boolean isPrimitive(@NotNull ConeKotlinType $this$isPrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitive, (String)"<this>");
        return ConeTypeUtilsKt.isPrimitiveOrNullablePrimitive($this$isPrimitive) && $this$isPrimitive.getNullability() == ConeNullability.NOT_NULL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isArrayType(@NotNull ConeKotlinType $this$isArrayType) {
        ClassId it;
        Intrinsics.checkNotNullParameter((Object)$this$isArrayType, (String)"<this>");
        if (ConeTypeUtilsKt.isBuiltinType($this$isArrayType, StandardClassIds.INSTANCE.getArray(), false)) return true;
        Iterable $this$any$iv = StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ClassId)element$iv;
            boolean bl = false;
        } while (!ConeTypeUtilsKt.isBuiltinType($this$isArrayType, it, false));
        return true;
    }

    public static final boolean isNonPrimitiveArray(@NotNull ConeKotlinType $this$isNonPrimitiveArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonPrimitiveArray, (String)"<this>");
        return $this$isNonPrimitiveArray instanceof ConeClassLikeType && Intrinsics.areEqual((Object)((ConeClassLikeType)$this$isNonPrimitiveArray).getLookupTag().getClassId(), (Object)StandardClassIds.INSTANCE.getArray());
    }

    public static final boolean isPrimitiveArray(@NotNull ConeKotlinType $this$isPrimitiveArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveArray, (String)"<this>");
        return $this$isPrimitiveArray instanceof ConeClassLikeType && StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values().contains(((ConeClassLikeType)$this$isPrimitiveArray).getLookupTag().getClassId());
    }

    public static final boolean isUnsignedTypeOrNullableUnsignedType(@NotNull ConeKotlinType $this$isUnsignedTypeOrNullableUnsignedType) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsignedTypeOrNullableUnsignedType, (String)"<this>");
        return ConeTypeUtilsKt.isAnyOfBuiltinType($this$isUnsignedTypeOrNullableUnsignedType, StandardClassIds.INSTANCE.getUnsignedTypes());
    }

    public static final boolean isUnsignedType(@NotNull ConeKotlinType $this$isUnsignedType) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsignedType, (String)"<this>");
        return ConeTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType($this$isUnsignedType) && $this$isUnsignedType.getNullability() == ConeNullability.NOT_NULL;
    }

    public static final boolean isIntegerTypeOrNullableIntegerTypeOfAnySize(@NotNull ConeKotlinType $this$isIntegerTypeOrNullableIntegerTypeOfAnySize) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntegerTypeOrNullableIntegerTypeOfAnySize, (String)"<this>");
        return ConeTypeUtilsKt.isAnyOfBuiltinType($this$isIntegerTypeOrNullableIntegerTypeOfAnySize, builtinIntegerTypes);
    }

    private static final boolean isBuiltinType(ConeKotlinType $this$isBuiltinType, ClassId classId, Boolean isNullable) {
        if (!($this$isBuiltinType instanceof ConeClassLikeType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((ConeClassLikeType)$this$isBuiltinType).getLookupTag().getClassId(), (Object)classId) && (isNullable == null || Intrinsics.areEqual((Object)ConeTypeUtilsKt.isNullable($this$isBuiltinType.getType()), (Object)isNullable));
    }

    private static final boolean isAnyOfBuiltinType(ConeKotlinType $this$isAnyOfBuiltinType, Set<ClassId> classIds) {
        if (!($this$isAnyOfBuiltinType instanceof ConeClassLikeType)) {
            return false;
        }
        return classIds.contains(((ConeClassLikeType)$this$isAnyOfBuiltinType).getLookupTag().getClassId());
    }

    static {
        Object[] objectArray = new ClassId[]{StandardClassIds.INSTANCE.getInt(), StandardClassIds.INSTANCE.getByte(), StandardClassIds.INSTANCE.getLong(), StandardClassIds.INSTANCE.getShort()};
        builtinIntegerTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProjectionKind.values().length];
            nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            nArray[ProjectionKind.IN.ordinal()] = 2;
            nArray[ProjectionKind.OUT.ordinal()] = 3;
            nArray[ProjectionKind.STAR.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

