/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.java.JavaTypeConversionKt;
import org.jetbrains.kotlin.fir.java.JavaTypeParameterStack;
import org.jetbrains.kotlin.fir.java.enhancement.JavaTypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractOverrideChecker;
import org.jetbrains.kotlin.fir.scopes.jvm.SignatureUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeRawType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0006\u0018\u00002\u00020\u0001B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J \u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J \u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J \u0010\u001b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0018\u0010#\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020$H\u0016J\u001e\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001d0&*\b\u0012\u0004\u0012\u00020)0(H\u0002J\u001a\u0010*\u001a\u00020+*\u00020\u00102\f\u0010,\u001a\b\u0012\u0004\u0012\u00020)0-H\u0002J\u001a\u0010*\u001a\u00020+*\u00020\u001d2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020)0-H\u0002J\u001a\u0010*\u001a\u00020+*\u00020 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020)0-H\u0002J\u0014\u0010.\u001a\u00020\t*\u00020\u00142\u0006\u0010/\u001a\u00020\u001dH\u0002J\u0014\u00100\u001a\u00020\t*\u00020\u001d2\u0006\u00101\u001a\u00020\tH\u0002J\f\u00102\u001a\u00020\t*\u00020\u0010H\u0002J\f\u00102\u001a\u00020\t*\u00020\u001dH\u0002J\u000e\u00102\u001a\u00020\t*\u0004\u0018\u00010 H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/java/scopes/JavaOverrideChecker;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractOverrideChecker;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "javaTypeParameterStack", "Lorg/jetbrains/kotlin/fir/java/JavaTypeParameterStack;", "baseScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "considerReturnTypeKinds", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/java/JavaTypeParameterStack;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Z)V", "context", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "buildTypeParametersSubstitutorIfCompatible", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "overrideCandidate", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "baseDeclaration", "doesReturnTypesHaveSameKind", "candidate", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "base", "isEqualArrayElementTypeProjections", "candidateTypeProjection", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "baseTypeProjection", "substitutor", "isEqualTypes", "candidateType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "baseType", "candidateTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "baseTypeRef", "isOverriddenFunction", "isOverriddenProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "buildErasure", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "extractTypeParametersTo", "", "result", "", "hasPrimitiveReturnTypeInJvm", "returnType", "isPrimitiveInJava", "isReturnType", "isTypeParameterDependent", "java"})
public final class JavaOverrideChecker
extends FirAbstractOverrideChecker {
    @NotNull
    private final FirSession session;
    @NotNull
    private final JavaTypeParameterStack javaTypeParameterStack;
    @Nullable
    private final FirTypeScope baseScope;
    private final boolean considerReturnTypeKinds;
    @NotNull
    private final ConeTypeContext context;

    public JavaOverrideChecker(@NotNull FirSession session, @NotNull JavaTypeParameterStack javaTypeParameterStack, @Nullable FirTypeScope baseScope, boolean considerReturnTypeKinds) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)javaTypeParameterStack, (String)"javaTypeParameterStack");
        this.session = session;
        this.javaTypeParameterStack = javaTypeParameterStack;
        this.baseScope = baseScope;
        this.considerReturnTypeKinds = considerReturnTypeKinds;
        this.context = TypeComponentsKt.getTypeContext(this.session);
    }

    private final boolean isEqualTypes(ConeKotlinType candidateType, ConeKotlinType baseType2, ConeSubstitutor substitutor2) {
        if (candidateType instanceof ConeRawType) {
            return Intrinsics.areEqual((Object)SignatureUtilsKt.computeJvmDescriptorRepresentation$default(candidateType, null, 1, null), (Object)SignatureUtilsKt.computeJvmDescriptorRepresentation$default(baseType2, null, 1, null));
        }
        if (candidateType instanceof ConeFlexibleType) {
            return this.isEqualTypes(((ConeFlexibleType)candidateType).getLowerBound(), baseType2, substitutor2);
        }
        if (baseType2 instanceof ConeFlexibleType) {
            return this.isEqualTypes(candidateType, ((ConeFlexibleType)baseType2).getLowerBound(), substitutor2);
        }
        if (candidateType instanceof ConeClassLikeType && baseType2 instanceof ConeClassLikeType) {
            ClassId baseTypeClassId;
            ClassId it = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)candidateType, this.session, null, 2, null).getLookupTag().getClassId();
            boolean bl = false;
            ClassId classId = JavaTypeUtilsKt.readOnlyToMutable(it);
            if (classId == null) {
                classId = it;
            }
            ClassId candidateTypeClassId = classId;
            ClassId it2 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)baseType2, this.session, null, 2, null).getLookupTag().getClassId();
            boolean bl2 = false;
            ClassId classId2 = JavaTypeUtilsKt.readOnlyToMutable(it2);
            if (classId2 == null) {
                classId2 = it2;
            }
            if (!Intrinsics.areEqual((Object)candidateTypeClassId, (Object)(baseTypeClassId = classId2))) {
                return false;
            }
            if (Intrinsics.areEqual((Object)candidateTypeClassId, (Object)StandardClassIds.INSTANCE.getArray())) {
                boolean bl3 = it = candidateType.getTypeArguments().length == 1;
                if (_Assertions.ENABLED && !it) {
                    boolean $i$a$-assert-JavaOverrideChecker$isEqualTypes$32 = false;
                    String $i$a$-assert-JavaOverrideChecker$isEqualTypes$32 = "Array type with unexpected number of type arguments: " + candidateType;
                    throw new AssertionError((Object)$i$a$-assert-JavaOverrideChecker$isEqualTypes$32);
                }
                boolean bl4 = it = baseType2.getTypeArguments().length == 1;
                if (_Assertions.ENABLED && !it) {
                    boolean bl5 = false;
                    String string2 = "Array type with unexpected number of type arguments: " + baseType2;
                    throw new AssertionError((Object)string2);
                }
                return this.isEqualArrayElementTypeProjections((ConeTypeProjection)ArraysKt.single((Object[])candidateType.getTypeArguments()), (ConeTypeProjection)ArraysKt.single((Object[])baseType2.getTypeArguments()), substitutor2);
            }
            return true;
        }
        ConeTypeContext $this$isEqualTypes_u24lambda_u2d4 = this.context;
        boolean bl = false;
        return $this$isEqualTypes_u24lambda_u2d4.areEqualTypeConstructors($this$isEqualTypes_u24lambda_u2d4.typeConstructor(substitutor2.substituteOrSelf(candidateType)), $this$isEqualTypes_u24lambda_u2d4.typeConstructor(substitutor2.substituteOrSelf(baseType2)));
    }

    private final boolean isEqualTypes(FirTypeRef candidateTypeRef, FirTypeRef baseTypeRef, ConeSubstitutor substitutor2) {
        ConeKotlinType candidateType = JavaTypeConversionKt.toConeKotlinTypeProbablyFlexible$default(candidateTypeRef, this.session, this.javaTypeParameterStack, null, 4, null);
        ConeKotlinType baseType2 = JavaTypeConversionKt.toConeKotlinTypeProbablyFlexible$default(baseTypeRef, this.session, this.javaTypeParameterStack, null, 4, null);
        if (this.isPrimitiveInJava(candidateType, false) != this.isPrimitiveInJava(baseType2, false)) {
            return false;
        }
        return this.isEqualTypes(candidateType, baseType2, substitutor2);
    }

    private final boolean doesReturnTypesHaveSameKind(FirSimpleFunction candidate2, FirSimpleFunction base) {
        FirTypeRef candidateTypeRef = candidate2.getReturnTypeRef();
        FirTypeRef baseTypeRef = base.getReturnTypeRef();
        ConeKotlinType candidateType = JavaTypeConversionKt.toConeKotlinTypeProbablyFlexible$default(candidateTypeRef, this.session, this.javaTypeParameterStack, null, 4, null);
        ConeKotlinType baseType2 = JavaTypeConversionKt.toConeKotlinTypeProbablyFlexible$default(baseTypeRef, this.session, this.javaTypeParameterStack, null, 4, null);
        boolean candidateHasPrimitiveReturnType = this.hasPrimitiveReturnTypeInJvm(candidate2, candidateType);
        if (candidateHasPrimitiveReturnType != this.hasPrimitiveReturnTypeInJvm(base, baseType2)) {
            return false;
        }
        if (!candidateHasPrimitiveReturnType) {
            return true;
        }
        ConeClassLikeType coneClassLikeType = candidateType instanceof ConeClassLikeType ? (ConeClassLikeType)candidateType : null;
        ConeClassLikeType coneClassLikeType2 = baseType2 instanceof ConeClassLikeType ? (ConeClassLikeType)baseType2 : null;
        return Intrinsics.areEqual((Object)(coneClassLikeType != null ? coneClassLikeType.getLookupTag() : null), (Object)(coneClassLikeType2 != null ? coneClassLikeType2.getLookupTag() : null));
    }

    private final boolean isPrimitiveInJava(ConeKotlinType $this$isPrimitiveInJava, boolean isReturnType) {
        ConeTypeContext $this$isPrimitiveInJava_u24lambda_u2d5 = this.context;
        boolean bl = false;
        if ($this$isPrimitiveInJava_u24lambda_u2d5.isNullableType($this$isPrimitiveInJava) || $this$isPrimitiveInJava.getAttributes().contains(CompilerConeAttributes.EnhancedNullability.INSTANCE)) {
            return false;
        }
        boolean isVoid = isReturnType && ConeTypeUtilsKt.isUnit($this$isPrimitiveInJava);
        return ConeTypeUtilsKt.isPrimitiveOrNullablePrimitive($this$isPrimitiveInJava) || isVoid;
    }

    private final boolean hasPrimitiveReturnTypeInJvm(FirSimpleFunction $this$hasPrimitiveReturnTypeInJvm, ConeKotlinType returnType2) {
        Ref.BooleanRef foundNonPrimitiveOverridden;
        block1: {
            if (!this.isPrimitiveInJava(returnType2, true)) {
                return false;
            }
            foundNonPrimitiveOverridden = new Ref.BooleanRef();
            FirTypeScope firTypeScope = this.baseScope;
            if (firTypeScope == null) break block1;
            FirTypeScopeKt.processOverriddenFunctions(firTypeScope, $this$hasPrimitiveReturnTypeInJvm.getSymbol(), (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(this, foundNonPrimitiveOverridden){
                final /* synthetic */ JavaOverrideChecker this$0;
                final /* synthetic */ Ref.BooleanRef $foundNonPrimitiveOverridden;
                {
                    this.this$0 = $receiver;
                    this.$foundNonPrimitiveOverridden = $foundNonPrimitiveOverridden;
                    super(1);
                }

                @NotNull
                public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol it) {
                    ProcessorAction processorAction;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ConeKotlinType type2 = JavaTypeConversionKt.toConeKotlinTypeProbablyFlexible$default(((FirSimpleFunction)it.getFir()).getReturnTypeRef(), JavaOverrideChecker.access$getSession$p(this.this$0), JavaOverrideChecker.access$getJavaTypeParameterStack$p(this.this$0), null, 4, null);
                    if (!JavaOverrideChecker.access$isPrimitiveInJava(this.this$0, type2, true)) {
                        this.$foundNonPrimitiveOverridden.element = true;
                        processorAction = ProcessorAction.STOP;
                    } else {
                        processorAction = ProcessorAction.NEXT;
                    }
                    return processorAction;
                }
            }));
        }
        return !foundNonPrimitiveOverridden.element;
    }

    private final boolean isEqualArrayElementTypeProjections(ConeTypeProjection candidateTypeProjection, ConeTypeProjection baseTypeProjection, ConeSubstitutor substitutor2) {
        return candidateTypeProjection instanceof ConeKotlinTypeProjection && baseTypeProjection instanceof ConeKotlinTypeProjection ? this.isEqualTypes(((ConeKotlinTypeProjection)candidateTypeProjection).getType(), ((ConeKotlinTypeProjection)baseTypeProjection).getType(), substitutor2) : candidateTypeProjection instanceof ConeStarProjection && baseTypeProjection instanceof ConeStarProjection;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<FirTypeParameterSymbol, ConeKotlinType> buildErasure(Collection<? extends FirTypeParameterRef> $this$buildErasure) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = $this$buildErasure;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            FirTypeParameterRef it = (FirTypeParameterRef)element$iv$iv;
            boolean bl = false;
            FirTypeParameterSymbol symbol2 = it.getSymbol();
            FirTypeRef firstBound = (FirTypeRef)CollectionsKt.first(((FirTypeParameter)symbol2.getFir()).getBounds());
            Pair pair = TuplesKt.to((Object)symbol2, (Object)JavaTypeConversionKt.toConeKotlinTypeProbablyFlexible$default(firstBound, this.session, this.javaTypeParameterStack, null, 4, null));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private final boolean isTypeParameterDependent(FirTypeRef $this$isTypeParameterDependent) {
        return $this$isTypeParameterDependent instanceof FirResolvedTypeRef && this.isTypeParameterDependent(ConeTypesKt.lowerBoundIfFlexible(((FirResolvedTypeRef)$this$isTypeParameterDependent).getType()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTypeParameterDependent(ConeKotlinType $this$isTypeParameterDependent) {
        if ($this$isTypeParameterDependent instanceof ConeTypeParameterType) return true;
        if (!($this$isTypeParameterDependent instanceof ConeClassLikeType)) return false;
        ConeTypeProjection[] $this$any$iv = $this$isTypeParameterDependent.getTypeArguments();
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            ConeTypeProjection element$iv;
            ConeTypeProjection argument2 = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (argument2 instanceof ConeKotlinTypeProjection && this.isTypeParameterDependent(((ConeKotlinTypeProjection)argument2).getType())) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTypeParameterDependent(FirCallableDeclaration $this$isTypeParameterDependent) {
        FirValueParameter it;
        if (!((Collection)$this$isTypeParameterDependent.getTypeParameters()).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (this.isTypeParameterDependent($this$isTypeParameterDependent.getReturnTypeRef())) return true;
        if (this.isTypeParameterDependent($this$isTypeParameterDependent.getReceiverTypeRef())) return true;
        if (!($this$isTypeParameterDependent instanceof FirSimpleFunction)) return false;
        Iterable $this$any$iv = ((FirSimpleFunction)$this$isTypeParameterDependent).getValueParameters();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (FirValueParameter)element$iv;
            boolean bl2 = false;
        } while (!this.isTypeParameterDependent(it.getReturnTypeRef()));
        return true;
    }

    private final void extractTypeParametersTo(FirTypeRef $this$extractTypeParametersTo, Collection<FirTypeParameterRef> result2) {
        if ($this$extractTypeParametersTo instanceof FirResolvedTypeRef) {
            this.extractTypeParametersTo(ConeTypesKt.lowerBoundIfFlexible(((FirResolvedTypeRef)$this$extractTypeParametersTo).getType()), result2);
        }
    }

    private final void extractTypeParametersTo(ConeKotlinType $this$extractTypeParametersTo, Collection<FirTypeParameterRef> result2) {
        ConeKotlinType coneKotlinType = $this$extractTypeParametersTo;
        if (coneKotlinType instanceof ConeTypeParameterType) {
            result2.add((FirTypeParameterRef)((ConeTypeParameterType)$this$extractTypeParametersTo).getLookupTag().getTypeParameterSymbol().getFir());
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            ConeTypeProjection[] $this$forEach$iv = $this$extractTypeParametersTo.getTypeArguments();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!(it instanceof ConeKotlinTypeProjection)) continue;
                this.extractTypeParametersTo(((ConeKotlinTypeProjection)it).getType(), result2);
            }
        }
    }

    private final void extractTypeParametersTo(FirCallableDeclaration $this$extractTypeParametersTo, Collection<FirTypeParameterRef> result2) {
        CollectionsKt.addAll(result2, (Iterable)$this$extractTypeParametersTo.getTypeParameters());
        this.extractTypeParametersTo($this$extractTypeParametersTo.getReturnTypeRef(), result2);
        FirTypeRef firTypeRef = $this$extractTypeParametersTo.getReceiverTypeRef();
        if (firTypeRef != null) {
            this.extractTypeParametersTo(firTypeRef, result2);
        }
        if ($this$extractTypeParametersTo instanceof FirSimpleFunction) {
            Iterable $this$forEach$iv = ((FirSimpleFunction)$this$extractTypeParametersTo).getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameter it = (FirValueParameter)element$iv;
                boolean bl = false;
                this.extractTypeParametersTo(it.getReturnTypeRef(), result2);
            }
        }
    }

    @Override
    @NotNull
    protected ConeSubstitutor buildTypeParametersSubstitutorIfCompatible(@NotNull FirCallableDeclaration overrideCandidate, @NotNull FirCallableDeclaration baseDeclaration) {
        Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
        FirPhaseManagerKt.ensureResolved(overrideCandidate, FirResolvePhase.TYPES);
        FirPhaseManagerKt.ensureResolved(baseDeclaration, FirResolvePhase.TYPES);
        if (!this.isTypeParameterDependent(overrideCandidate) && !this.isTypeParameterDependent(baseDeclaration)) {
            return ConeSubstitutor.Empty.INSTANCE;
        }
        LinkedHashSet typeParameters2 = new LinkedHashSet();
        this.extractTypeParametersTo(overrideCandidate, (Collection<FirTypeParameterRef>)typeParameters2);
        this.extractTypeParametersTo(baseDeclaration, (Collection<FirTypeParameterRef>)typeParameters2);
        return SubstitutorsKt.substitutorByMap(this.buildErasure(typeParameters2), this.session);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isOverriddenFunction(@NotNull FirSimpleFunction overrideCandidate, @NotNull FirSimpleFunction baseDeclaration) {
        boolean bl;
        block7: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
            Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
            FirMemberDeclaration $this$isStatic$iv = overrideCandidate;
            boolean $i$f$isStatic = false;
            boolean bl2 = $this$isStatic$iv.getStatus().isStatic();
            $this$isStatic$iv = baseDeclaration;
            $i$f$isStatic = false;
            if (bl2 != $this$isStatic$iv.getStatus().isStatic()) {
                return false;
            }
            FirPhaseManagerKt.ensureResolved(overrideCandidate, FirResolvePhase.TYPES);
            FirPhaseManagerKt.ensureResolved(baseDeclaration, FirResolvePhase.TYPES);
            FirTypeRef receiverTypeRef = baseDeclaration.getReceiverTypeRef();
            Iterable iterable = baseDeclaration.getValueParameters();
            Collection collection = CollectionsKt.listOfNotNull((Object)receiverTypeRef);
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(it.getReturnTypeRef());
            }
            List baseParameterTypes = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
            if (overrideCandidate.getValueParameters().size() != baseParameterTypes.size()) {
                return false;
            }
            ConeSubstitutor substitutor2 = this.buildTypeParametersSubstitutorIfCompatible(overrideCandidate, baseDeclaration);
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)overrideCandidate.getValueParameters(), (Iterable)baseParameterTypes);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl4 = false;
                    FirValueParameter paramFromJava = (FirValueParameter)pair.component1();
                    FirTypeRef baseType2 = (FirTypeRef)pair.component2();
                    if (this.isEqualTypes(paramFromJava.getReturnTypeRef(), baseType2, substitutor2)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (!bl) {
            return false;
        }
        return !this.considerReturnTypeKinds || this.doesReturnTypesHaveSameKind(overrideCandidate, baseDeclaration);
    }

    @Override
    public boolean isOverriddenProperty(@NotNull FirCallableDeclaration overrideCandidate, @NotNull FirProperty baseDeclaration) {
        Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
        FirMemberDeclaration $this$modality$iv = baseDeclaration;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() == Modality.FINAL) {
            return false;
        }
        FirPhaseManagerKt.ensureResolved(overrideCandidate, FirResolvePhase.TYPES);
        FirPhaseManagerKt.ensureResolved(baseDeclaration, FirResolvePhase.TYPES);
        FirTypeRef receiverTypeRef = baseDeclaration.getReceiverTypeRef();
        FirCallableDeclaration firCallableDeclaration = overrideCandidate;
        if (firCallableDeclaration instanceof FirSimpleFunction) {
            if (receiverTypeRef == null) {
                return ((FirSimpleFunction)overrideCandidate).getValueParameters().isEmpty();
            }
            if (((FirSimpleFunction)overrideCandidate).getValueParameters().size() != 1) {
                return false;
            }
            return this.isEqualTypes(receiverTypeRef, ((FirValueParameter)CollectionsKt.single(((FirSimpleFunction)overrideCandidate).getValueParameters())).getReturnTypeRef(), (ConeSubstitutor)ConeSubstitutor.Empty.INSTANCE);
        }
        if (firCallableDeclaration instanceof FirProperty) {
            FirTypeRef overrideReceiverTypeRef = overrideCandidate.getReceiverTypeRef();
            return receiverTypeRef == null ? overrideReceiverTypeRef == null : (overrideReceiverTypeRef == null ? false : this.isEqualTypes(receiverTypeRef, overrideReceiverTypeRef, (ConeSubstitutor)ConeSubstitutor.Empty.INSTANCE));
        }
        return false;
    }

    public static final /* synthetic */ FirSession access$getSession$p(JavaOverrideChecker $this) {
        return $this.session;
    }

    public static final /* synthetic */ JavaTypeParameterStack access$getJavaTypeParameterStack$p(JavaOverrideChecker $this) {
        return $this.javaTypeParameterStack;
    }

    public static final /* synthetic */ boolean access$isPrimitiveInJava(JavaOverrideChecker $this, ConeKotlinType $receiver, boolean isReturnType) {
        return $this.isPrimitiveInJava($receiver, isReturnType);
    }
}

