/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.ConstructorDelegationComparator;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007\u001a\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"delegatedThisConstructor", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "getDelegatedThisConstructor", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "collectEnumEntries", "", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "constructors", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "constructorsSortedByDelegation", "primaryConstructorIfAny", "providers"})
public final class DeclarationUtilsKt {
    @NotNull
    public static final List<FirConstructorSymbol> constructors(@NotNull FirClass $this$constructors, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$constructors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        List result2 = new ArrayList();
        FirDeclaredMemberScopeProviderKt.declaredMemberScope(session, $this$constructors).processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)new Function1<FirConstructorSymbol, Unit>((List<FirConstructorSymbol>)result2){
            final /* synthetic */ List<FirConstructorSymbol> $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull FirConstructorSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((Collection)this.$result).add(it);
            }
        }));
        return result2;
    }

    @NotNull
    public static final List<FirConstructorSymbol> constructorsSortedByDelegation(@NotNull FirClass $this$constructorsSortedByDelegation, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$constructorsSortedByDelegation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return CollectionsKt.sortedWith((Iterable)DeclarationUtilsKt.constructors($this$constructorsSortedByDelegation, session), (Comparator)ConstructorDelegationComparator.INSTANCE);
    }

    @Nullable
    public static final FirConstructorSymbol primaryConstructorIfAny(@NotNull FirClass $this$primaryConstructorIfAny, @NotNull FirSession session) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$primaryConstructorIfAny, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Iterable iterable = DeclarationUtilsKt.constructors($this$primaryConstructorIfAny, session);
            for (Object t : iterable) {
                FirConstructorSymbol p0 = (FirConstructorSymbol)t;
                boolean bl = false;
                if (!p0.isPrimary()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<FirEnumEntry> collectEnumEntries(@NotNull FirRegularClass $this$collectEnumEntries) {
        void $this$filterIsInstanceTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$collectEnumEntries, (String)"<this>");
        boolean bl2 = bl = $this$collectEnumEntries.getClassKind() == ClassKind.ENUM_CLASS;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Iterable $this$filterIsInstance$iv = $this$collectEnumEntries.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final FirConstructorSymbol getDelegatedThisConstructor(@NotNull FirConstructorSymbol $this$delegatedThisConstructor) {
        FirConstructorSymbol firConstructorSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$delegatedThisConstructor, (String)"<this>");
        boolean condition$iv = $this$delegatedThisConstructor.getDelegatedConstructorCallIsThis();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            firConstructorSymbol = $this$delegatedThisConstructor.getResolvedDelegatedConstructor();
        } else {
            firConstructorSymbol = null;
        }
        return firConstructorSymbol;
    }
}

