/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/PlatformClassMappedToKotlinImportsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class PlatformClassMappedToKotlinImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final PlatformClassMappedToKotlinImportsChecker INSTANCE = new PlatformClassMappedToKotlinImportsChecker();

    private PlatformClassMappedToKotlinImportsChecker() {
    }

    @Override
    public void check(@NotNull FirFile declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable $this$forEach$iv = declaration.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object classId;
            FqName importedFqName;
            FirImport firImport;
            block8: {
                block7: {
                    firImport = (FirImport)element$iv;
                    boolean bl = false;
                    if (firImport.getImportedFqName() == null) {
                        return;
                    }
                    if (importedFqName.isRoot()) break block7;
                    String string2 = importedFqName.shortName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"importedFqName.shortName().asString()");
                    if (!(((CharSequence)string2).length() == 0)) break block8;
                }
                return;
            }
            Object object = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
            if (object == null || (object = ((FirResolvedImport)object).getResolvedParentClassId()) == null) {
                ClassId classId2 = ClassId.topLevel(importedFqName);
                object = classId2;
                Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(importedFqName)");
            }
            if (!Intrinsics.areEqual((Object)((ClassId)(classId = object)).asSingleFqName(), (Object)importedFqName)) {
                return;
            }
            ClassId kotlinClass = FirPlatformClassMapperKt.getPlatformClassMapper(context2.getSession()).getCorrespondingKotlinClass((ClassId)classId);
            if (kotlinClass == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getPLATFORM_CLASS_MAPPED_TO_KOTLIN(), (Object)importedFqName, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

