/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0016\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J4\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u001e\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"H\u0002J8\u0010#\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0006\u0012\u0004\u0018\u00010%0$*\u00020\u00022\u0006\u0010&\u001a\u00020'2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\f\u0010(\u001a\u00020\u0013*\u00020\u0002H\u0002J\u0014\u0010)\u001a\u00020\u0013*\u00020%2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "BUILTIN_SUSPEND_NAME", "Lorg/jetbrains/kotlin/name/Name;", "KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID", "Lorg/jetbrains/kotlin/name/CallableId;", "getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers", "()Lorg/jetbrains/kotlin/name/CallableId;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkNonLocalReturnUsage", "", "enclosingSuspendFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkRestrictsSuspension", "calledDeclarationSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkSuspendModifierForm", "reference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "symbol", "findEnclosingSuspendFunction", "sameInstanceOfReceiver", "useSiteReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "declarationSiteReceiverOwnerSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "computeReceiversInfo", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasFormOfSuspendModifierForLambda", "isRestrictSuspensionReceiver", "checkers"})
public final class FirSuspendCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuspendCallChecker INSTANCE = new FirSuspendCallChecker();
    @NotNull
    private static final Name BUILTIN_SUSPEND_NAME = StandardClassIds.Callables.INSTANCE.getSuspend().getCallableName();
    @NotNull
    private static final CallableId KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID = new CallableId(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE(), BUILTIN_SUSPEND_NAME);

    private FirSuspendCallChecker() {
    }

    @NotNull
    public final CallableId getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers() {
        return KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID;
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirFunction enclosingSuspendFunction;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirResolvedNamedReference firResolvedNamedReference = UtilsKt.getResolved(expression2.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        FirCallableSymbol firCallableSymbol = reference.getResolvedSymbol();
        FirCallableSymbol firCallableSymbol2 = firCallableSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firCallableSymbol : null;
        if (firCallableSymbol2 == null) {
            return;
        }
        FirCallableSymbol symbol2 = firCallableSymbol2;
        if (Intrinsics.areEqual((Object)reference.getName(), (Object)BUILTIN_SUSPEND_NAME) || symbol2 instanceof FirNamedFunctionSymbol && Intrinsics.areEqual((Object)symbol2.getName(), (Object)BUILTIN_SUSPEND_NAME)) {
            this.checkSuspendModifierForm(expression2, reference, symbol2, context2, reporter);
        }
        if (reference instanceof FirResolvedCallableReference) {
            return;
        }
        FirCallableSymbol firCallableSymbol3 = symbol2;
        if (firCallableSymbol3 instanceof FirNamedFunctionSymbol) {
            FirCallableSymbol $this$isSuspend$iv = symbol2;
            boolean $i$f$isSuspend = false;
            if (!$this$isSuspend$iv.getResolvedStatus().isSuspend()) {
                return;
            }
        } else if (firCallableSymbol3 instanceof FirPropertySymbol) {
            if (!Intrinsics.areEqual((Object)symbol2.getCallableId(), (Object)StandardClassIds.Callables.INSTANCE.getCoroutineContext())) {
                return;
            }
        } else {
            return;
        }
        if ((enclosingSuspendFunction = this.findEnclosingSuspendFunction(context2)) == null) {
            firCallableSymbol = symbol2;
            if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_FUNCTION_CALL(), (Object)symbol2, (DiagnosticContext)context2, null, 16, null);
            } else if (firCallableSymbol instanceof FirPropertySymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_PROPERTY_ACCESS(), (Object)symbol2, (DiagnosticContext)context2, null, 16, null);
            }
        } else {
            if (!this.checkNonLocalReturnUsage(enclosingSuspendFunction, context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getNON_LOCAL_SUSPENSION_POINT(), (DiagnosticContext)context2, null, 8, null);
            }
            if (!this.checkRestrictsSuspension(expression2, enclosingSuspendFunction, symbol2, context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkSuspendModifierForm(FirQualifiedAccessExpression expression2, FirResolvedNamedReference reference, FirCallableSymbol<?> symbol2, CheckerContext context2, DiagnosticReporter reporter) {
        if (Intrinsics.areEqual((Object)symbol2.getCallableId(), (Object)KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID)) {
            if (!Intrinsics.areEqual((Object)reference.getName(), (Object)BUILTIN_SUSPEND_NAME) || expression2.getExplicitReceiver() != null || !this.hasFormOfSuspendModifierForLambda(expression2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getNON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND(), (DiagnosticContext)context2, null, 8, null);
            }
        } else if (Intrinsics.areEqual((Object)reference.getName(), (Object)BUILTIN_SUSPEND_NAME) && this.hasFormOfSuspendModifierForLambda(expression2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean hasFormOfSuspendModifierForLambda(FirQualifiedAccessExpression $this$hasFormOfSuspendModifierForLambda) {
        boolean bl;
        block19: {
            if (!($this$hasFormOfSuspendModifierForLambda instanceof FirFunctionCall)) {
                return false;
            }
            FirNamedReference reference = ((FirFunctionCall)$this$hasFormOfSuspendModifierForLambda).getCalleeReference();
            if (reference instanceof FirResolvedCallableReference) {
                return false;
            }
            Iterable $this$any$iv = $this$hasFormOfSuspendModifierForLambda.getTypeArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirTypeProjection it = (FirTypeProjection)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSource() != null)) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        FirCall $this$arguments$iv = (FirCall)((Object)$this$hasFormOfSuspendModifierForLambda);
        boolean $i$f$getArguments = false;
        if (CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments()) instanceof FirLambdaArgumentExpression) {
            KtSourceElement ktSourceElement;
            KtSourceElement callExpressionSource;
            KtSourceElement ktSourceElement2;
            if ($this$hasFormOfSuspendModifierForLambda.getExplicitReceiver() == null) {
                ktSourceElement2 = $this$hasFormOfSuspendModifierForLambda.getSource();
            } else {
                KtSourceElement ktSourceElement3 = $this$hasFormOfSuspendModifierForLambda.getSource();
                if (ktSourceElement3 != null) {
                    IElementType iElementType = KtNodeTypes.CALL_EXPRESSION;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CALL_EXPRESSION");
                    ktSourceElement2 = FirSourceUtilsKt.getChild$default(ktSourceElement3, iElementType, 1, 1, false, 8, null);
                } else {
                    ktSourceElement2 = null;
                }
            }
            KtSourceElement ktSourceElement4 = callExpressionSource = ktSourceElement2;
            if (ktSourceElement4 != null) {
                IElementType iElementType = KtNodeTypes.VALUE_ARGUMENT_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"VALUE_ARGUMENT_LIST");
                ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement4, iElementType, 0, 1, false, 10, null);
            } else {
                ktSourceElement = null;
            }
            if (ktSourceElement == null) {
                return true;
            }
        }
        if (((FirFunctionCall)$this$hasFormOfSuspendModifierForLambda).getOrigin() == FirFunctionCallOrigin.Infix) {
            FirCall $this$arguments$iv2 = (FirCall)((Object)$this$hasFormOfSuspendModifierForLambda);
            boolean $i$f$getArguments2 = false;
            FirExpression lastArgument = (FirExpression)CollectionsKt.lastOrNull($this$arguments$iv2.getArgumentList().getArguments());
            if (lastArgument instanceof FirAnonymousFunctionExpression) {
                KtSourceElement ktSourceElement;
                KtSourceElement ktSourceElement5 = $this$hasFormOfSuspendModifierForLambda.getSource();
                if (ktSourceElement5 != null) {
                    IElementType iElementType = KtNodeTypes.PARENTHESIZED;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PARENTHESIZED");
                    ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement5, iElementType, 0, 1, false, 10, null);
                } else {
                    ktSourceElement = null;
                }
                if (ktSourceElement == null) {
                    return true;
                }
            }
        }
        return false;
    }

    private final FirFunction findEnclosingSuspendFunction(CheckerContext context2) {
        FirDeclaration firDeclaration;
        block5: {
            List<FirDeclaration> $this$lastOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastOrNull = false;
            ListIterator<FirDeclaration> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                boolean bl;
                FirDeclaration element$iv;
                FirDeclaration it = element$iv = iterator$iv.previous();
                boolean bl2 = false;
                FirDeclaration firDeclaration2 = it;
                if (firDeclaration2 instanceof FirAnonymousFunction) {
                    bl = InferenceUtilsKt.isSuspendFunctionType(FirTypeUtilsKt.getConeType(((FirAnonymousFunction)it).getTypeRef()), context2.getSession());
                } else if (firDeclaration2 instanceof FirSimpleFunction) {
                    FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)it;
                    boolean $i$f$isSuspend = false;
                    bl = $this$isSuspend$iv.getStatus().isSuspend();
                } else {
                    bl = false;
                }
                if (!bl) continue;
                firDeclaration = element$iv;
                break block5;
            }
            firDeclaration = null;
        }
        FirDeclaration firDeclaration3 = firDeclaration;
        return firDeclaration3 instanceof FirFunction ? (FirFunction)firDeclaration3 : null;
    }

    private final boolean checkNonLocalReturnUsage(FirFunction enclosingSuspendFunction, CheckerContext context2) {
        Object v0;
        block6: {
            Iterable $this$lastIsInstanceOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Object element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirFunction)) continue;
                        v0 = element$iv;
                        break block6;
                    } while (0 <= n);
                }
                v0 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirFunction)) continue;
                    v0 = element$iv$iv;
                    break block6;
                }
                v0 = null;
            }
        }
        FirFunction firFunction = v0;
        if (firFunction == null) {
            return false;
        }
        FirFunction containingFunction = firFunction;
        return containingFunction instanceof FirAnonymousFunction && enclosingSuspendFunction != containingFunction ? ((FirAnonymousFunction)containingFunction).getInlineStatus().getReturnAllowed() : enclosingSuspendFunction == containingFunction;
    }

    private final boolean checkRestrictsSuspension(FirQualifiedAccessExpression expression2, FirFunction enclosingSuspendFunction, FirCallableSymbol<?> calledDeclarationSymbol, CheckerContext context2) {
        FirFunction firFunction;
        FirSession session = context2.getSession();
        Triple<FirExpression, FirExpression, ConeKotlinType> triple = enclosingSuspendFunction.getDispatchReceiverType();
        Object object = triple instanceof ConeClassLikeType ? (ConeClassLikeType)triple : null;
        FirRegularClassSymbol enclosingSuspendFunctionDispatchReceiverOwnerSymbol = object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, session) : null;
        FirFunction it = firFunction = enclosingSuspendFunction;
        boolean bl = false;
        FirFunction firFunction2 = it.getReceiverTypeRef() != null ? firFunction : null;
        FirFunctionSymbol<? extends FirFunction> enclosingSuspendFunctionExtensionReceiverOwnerSymbol = firFunction2 != null ? firFunction2.getSymbol() : null;
        triple = this.computeReceiversInfo(expression2, session, calledDeclarationSymbol);
        FirExpression dispatchReceiverExpression = (FirExpression)triple.component1();
        FirExpression extensionReceiverExpression = (FirExpression)triple.component2();
        ConeKotlinType extensionReceiverParameterType = (ConeKotlinType)triple.component3();
        Object[] objectArray = new FirExpression[]{dispatchReceiverExpression, extensionReceiverExpression};
        for (FirExpression receiverExpression : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            if (!this.isRestrictSuspensionReceiver(FirTypeUtilsKt.getConeType(receiverExpression.getTypeRef()), session) || this.sameInstanceOfReceiver(receiverExpression, enclosingSuspendFunctionDispatchReceiverOwnerSymbol) || this.sameInstanceOfReceiver(receiverExpression, (FirBasedSymbol)enclosingSuspendFunctionExtensionReceiverOwnerSymbol)) continue;
            return false;
        }
        FirFunctionSymbol<? extends FirFunction> firFunctionSymbol = enclosingSuspendFunctionExtensionReceiverOwnerSymbol;
        if (!(firFunctionSymbol != null && (firFunctionSymbol = firFunctionSymbol.getResolvedReceiverTypeRef()) != null && (firFunctionSymbol = FirTypeUtilsKt.getConeType((FirTypeRef)((Object)firFunctionSymbol))) != null ? this.isRestrictSuspensionReceiver((ConeKotlinType)((Object)firFunctionSymbol), session) : false)) {
            return true;
        }
        if (this.sameInstanceOfReceiver(dispatchReceiverExpression, (FirBasedSymbol)enclosingSuspendFunctionExtensionReceiverOwnerSymbol)) {
            return true;
        }
        if (this.sameInstanceOfReceiver(extensionReceiverExpression, (FirBasedSymbol)enclosingSuspendFunctionExtensionReceiverOwnerSymbol)) {
            ConeKotlinType coneKotlinType = extensionReceiverParameterType;
            boolean bl2 = coneKotlinType != null ? this.isRestrictSuspensionReceiver(coneKotlinType, session) : false;
            if (bl2) {
                return true;
            }
        }
        return false;
    }

    private final boolean isRestrictSuspensionReceiver(ConeKotlinType $this$isRestrictSuspensionReceiver, FirSession session) {
        ConeKotlinType coneKotlinType = $this$isRestrictSuspensionReceiver;
        if (coneKotlinType instanceof ConeClassLikeType) {
            boolean bl;
            block10: {
                FirRegularClassSymbol firRegularClassSymbol = LookupTagUtilsKt.toFirRegularClassSymbol(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$isRestrictSuspensionReceiver, session, null, 2, null).getLookupTag(), session);
                if (firRegularClassSymbol == null) {
                    return false;
                }
                FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
                if (FirAnnotationUtilsKt.getAnnotationByClassId(regularClassSymbol, StandardClassIds.Annotations.INSTANCE.getRestrictsSuspension()) != null) {
                    return true;
                }
                Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes(regularClassSymbol);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeClassLikeType it = (ConeClassLikeType)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(it, session)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        if (coneKotlinType instanceof ConeTypeParameterType) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = ((ConeTypeParameterType)$this$isRestrictSuspensionReceiver).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                        boolean bl3 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(FirTypeUtilsKt.getConeType(it), session)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean sameInstanceOfReceiver(FirExpression useSiteReceiverExpression, FirBasedSymbol<?> declarationSiteReceiverOwnerSymbol) {
        if (declarationSiteReceiverOwnerSymbol == null || useSiteReceiverExpression == null) {
            return false;
        }
        if (useSiteReceiverExpression instanceof FirThisReceiverExpression) {
            return Intrinsics.areEqual(((FirThisReceiverExpression)useSiteReceiverExpression).getCalleeReference().getBoundSymbol(), declarationSiteReceiverOwnerSymbol);
        }
        return false;
    }

    private final Triple<FirExpression, FirExpression, ConeKotlinType> computeReceiversInfo(FirQualifiedAccessExpression $this$computeReceiversInfo, FirSession session, FirCallableSymbol<?> calledDeclarationSymbol) {
        FirExpression firExpression2;
        if ($this$computeReceiversInfo instanceof FirImplicitInvokeCall) {
            FirTypeRef $this$coneTypeSafe$iv = $this$computeReceiversInfo.getDispatchReceiver().getTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            boolean bl = coneKotlinType != null ? InferenceUtilsKt.isSuspendFunctionType(coneKotlinType, session) : false;
            if (bl) {
                FirExpression variableForInvoke = $this$computeReceiversInfo.getDispatchReceiver();
                ConeKotlinType variableForInvokeType = FirTypeUtilsKt.getConeType(variableForInvoke.getTypeRef());
                if (!CompilerConeAttributesKt.isExtensionFunctionType(variableForInvokeType)) {
                    return new Triple(null, null, null);
                }
                return new Triple(null, CollectionsKt.getOrNull(((FirImplicitInvokeCall)$this$computeReceiversInfo).getArgumentList().getArguments(), (int)0), (Object)(($i$f$coneTypeSafe = ArraysKt.getOrNull((Object[])variableForInvokeType.getTypeArguments(), (int)0)) instanceof ConeKotlinType ? (ConeKotlinType)$i$f$coneTypeSafe : null));
            }
        }
        FirExpression it = firExpression2 = $this$computeReceiversInfo.getDispatchReceiver();
        boolean bl = false;
        FirExpression firExpression3 = !(it instanceof FirNoReceiverExpression) ? firExpression2 : null;
        it = firExpression2 = $this$computeReceiversInfo.getExtensionReceiver();
        FirExpression firExpression4 = firExpression3;
        boolean bl2 = false;
        boolean bl3 = !(it instanceof FirNoReceiverExpression);
        FirResolvedTypeRef firResolvedTypeRef = calledDeclarationSymbol.getResolvedReceiverTypeRef();
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? FirTypeUtilsKt.getConeType(firResolvedTypeRef) : null;
        FirExpression firExpression5 = bl3 ? firExpression2 : null;
        FirExpression firExpression6 = firExpression4;
        return new Triple((Object)firExpression6, (Object)firExpression5, (Object)coneKotlinType);
    }
}

