/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnsupportedDynamicType;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelTypeAliasChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirTopLevelTypeAliasChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirTopLevelTypeAliasChecker INSTANCE = new FirTopLevelTypeAliasChecker();

    private FirTopLevelTypeAliasChecker() {
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirTypeRef expandedTypeRef;
        ConeKotlinType fullyExpandedType2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirFile)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getTOPLEVEL_TYPEALIASES_ONLY(), (DiagnosticContext)context2, null, 8, null);
        }
        if (FirTopLevelTypeAliasChecker.check$containsTypeParameter(context2, fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(expandedTypeRef = declaration.getExpandedTypeRef()), context2.getSession())) || fullyExpandedType2 instanceof ConeClassErrorType && ((ConeClassErrorType)fullyExpandedType2).getDiagnostic() instanceof ConeUnsupportedDynamicType) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getExpandedTypeRef().getSource(), FirErrors.INSTANCE.getTYPEALIAS_SHOULD_EXPAND_TO_CLASS(), (Object)FirTypeUtilsKt.getConeType(expandedTypeRef), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private static final boolean check$containsTypeParameter(CheckerContext $context, ConeKotlinType type2) {
        if (type2 instanceof ConeTypeParameterType) {
            return true;
        }
        if (type2 instanceof ConeClassLikeType && LookupTagUtilsKt.toSymbol(((ConeClassLikeType)type2).getLookupTag(), $context.getSession()) instanceof FirTypeAliasSymbol) {
            for (ConeTypeProjection typeArgument : type2.getTypeArguments()) {
                ConeKotlinType typeArgumentType;
                ConeKotlinType coneKotlinType = typeArgument instanceof ConeKotlinType ? (ConeKotlinType)typeArgument : null;
                if (coneKotlinType == null) {
                    ConeKotlinTypeProjection coneKotlinTypeProjection = typeArgument instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)typeArgument : null;
                    coneKotlinType = coneKotlinTypeProjection != null ? coneKotlinTypeProjection.getType() : null;
                }
                if ((typeArgumentType = coneKotlinType) == null || !FirTopLevelTypeAliasChecker.check$containsTypeParameter($context, typeArgumentType)) continue;
                return true;
            }
        }
        return false;
    }
}

