/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0013*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u0013*\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J,\u0010\u001d\u001a\u00020\u0013*\u00020\u00162\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u001fj\b\u0012\u0004\u0012\u00020\u0016` 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010\u001d\u001a\u00020\u0013*\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\u0013*\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010\u001aH\u0002J\u0014\u0010%\u001a\u00020\u0013*\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "cloneableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "javaLangFqName", "reservedFunctionNames", "", "", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isCloneableId", "", "Lorg/jetbrains/kotlin/name/ClassId;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isInapplicableParameterType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isNotFinalReadOnly", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "primaryConstructorProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isRecursiveInlineClassType", "visited", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isRelatedToParameter", "parameter", "isSubtypeOfCloneable", "checkers"})
public final class FirInlineClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirInlineClassDeclarationChecker INSTANCE = new FirInlineClassDeclarationChecker();
    @NotNull
    private static final Set<String> reservedFunctionNames;
    @NotNull
    private static final FqName javaLangFqName;
    @NotNull
    private static final FqName cloneableFqName;

    private FirInlineClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        CheckerContext context3;
        Object $this$isInterface$iv$iv;
        block57: {
            block56: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (!DeclarationUtilsKt.isInlineOrValueClass(declaration)) {
                    return;
                }
                FirMemberDeclaration $this$isInner$iv = declaration;
                boolean $i$f$isInner = false;
                if ($this$isInner$iv.getStatus().isInner()) break block56;
                FirClassLikeDeclaration $this$isLocal$iv = declaration;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) break block57;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_NOT_TOP_LEVEL(), (DiagnosticContext)context2, null, 8, null);
        }
        FirMemberDeclaration $this$modality$iv = declaration;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() != Modality.FINAL) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_NOT_FINAL(), (DiagnosticContext)context2, null, 8, null);
        }
        for (FirTypeRef supertypeEntry : declaration.getSuperTypeRefs()) {
            boolean bl2;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(supertypeEntry, context2.getSession());
            if (firRegularClassSymbol != null) {
                FirClassSymbol $this$isInterface$iv = firRegularClassSymbol;
                boolean $i$f$isInterface = false;
                $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                boolean $i$f$isInterface2 = false;
                bl2 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            } else {
                bl2 = false;
            }
            if (bl2) continue;
            FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, supertypeEntry, FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_EXTEND_CLASSES(), context2, null, 8, null);
        }
        if (this.isSubtypeOfCloneable(declaration, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_CLONEABLE(), (DiagnosticContext)context2, null, 8, null);
        }
        FirConstructor primaryConstructor2 = null;
        Object primaryConstructorParameter = null;
        FirDeclaration primaryConstructorProperty = null;
        for (FirDeclaration innerDeclaration : declaration.getDeclarations()) {
            $this$isInterface$iv$iv = innerDeclaration;
            if ($this$isInterface$iv$iv instanceof FirConstructor) {
                FirBlock body2;
                if (((FirConstructor)innerDeclaration).isPrimary()) {
                    primaryConstructor2 = (FirConstructor)innerDeclaration;
                    primaryConstructorParameter = CollectionsKt.singleOrNull(((FirConstructor)innerDeclaration).getValueParameters());
                    continue;
                }
                if (((FirConstructor)innerDeclaration).getBody() == null) continue;
                Intrinsics.checkNotNull((Object)((FirConstructor)innerDeclaration).getBody());
                boolean $i$f$withSuppressedDiagnostics = false;
                List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(innerDeclaration);
                if (arguments$iv != null) {
                    DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    if (diagnosticContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext context4 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                    boolean bl3 = false;
                    FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, body2, FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_VALUE_CLASS(), context4, null, 8, null);
                    continue;
                }
                CheckerContext context5 = (CheckerContext)((MutableDiagnosticContext)context2);
                boolean bl4 = false;
                FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, body2, FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_VALUE_CLASS(), context5, null, 8, null);
                continue;
            }
            if ($this$isInterface$iv$iv instanceof FirRegularClass) {
                FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)innerDeclaration;
                boolean $i$f$isInner = false;
                if (!$this$isInner$iv.getStatus().isInner()) continue;
                FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, innerDeclaration, FirErrors.INSTANCE.getINNER_CLASS_INSIDE_VALUE_CLASS(), context2, null, 8, null);
                continue;
            }
            if ($this$isInterface$iv$iv instanceof FirSimpleFunction) {
                String functionName;
                Intrinsics.checkNotNullExpressionValue((Object)((FirSimpleFunction)innerDeclaration).getName().asString(), (String)"innerDeclaration.name.asString()");
                if (!reservedFunctionNames.contains(functionName)) continue;
                FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, innerDeclaration, FirErrors.INSTANCE.getRESERVED_MEMBER_INSIDE_VALUE_CLASS(), functionName, context2, null, 16, null);
                continue;
            }
            if ($this$isInterface$iv$iv instanceof FirField) {
                boolean bl5;
                FirCallableSymbol<?> symbol2;
                FirDeclaration $this$isSynthetic$iv = innerDeclaration;
                boolean $i$f$isSynthetic = false;
                if (!Intrinsics.areEqual((Object)$this$isSynthetic$iv.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) continue;
                FirExpression firExpression2 = ((FirField)innerDeclaration).getInitializer();
                FirCallableSymbol<Object> firCallableSymbol = symbol2 = firExpression2 != null ? FirExpressionUtilKt.toResolvedCallableSymbol(firExpression2) : null;
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClassImplementationByDelegation) && symbol2 != null) {
                    FirValueParameter firValueParameter = (FirValueParameter)primaryConstructorParameter;
                    if (Intrinsics.areEqual(symbol2, (Object)(firValueParameter != null ? firValueParameter.getSymbol() : null))) continue;
                }
                FirTypeRef firTypeRef = ((FirResolvedTypeRef)((FirField)innerDeclaration).getReturnTypeRef()).getDelegatedTypeRef();
                KtSourceElement delegatedTypeRefSource = firTypeRef != null ? firTypeRef.getSource() : null;
                boolean $i$f$withSuppressedDiagnostics = false;
                List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(innerDeclaration);
                if (arguments$iv != null) {
                    DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    if (diagnosticContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext context6 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                    bl5 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)delegatedTypeRefSource, FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), (DiagnosticContext)context6, null, 8, null);
                    continue;
                }
                CheckerContext context7 = (CheckerContext)((MutableDiagnosticContext)context2);
                bl5 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)delegatedTypeRefSource, FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), (DiagnosticContext)context7, null, 8, null);
                continue;
            }
            if (!($this$isInterface$iv$iv instanceof FirProperty)) continue;
            if (this.isRelatedToParameter((FirProperty)innerDeclaration, (FirValueParameter)primaryConstructorParameter)) {
                primaryConstructorProperty = innerDeclaration;
                continue;
            }
            if (((FirProperty)innerDeclaration).getDelegate() != null) {
                CheckerContext context8;
                boolean $i$f$withSuppressedDiagnostics = false;
                List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(innerDeclaration);
                if (arguments$iv != null) {
                    DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    if (diagnosticContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    context8 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                    boolean bl6 = false;
                    FirExpression firExpression3 = ((FirProperty)innerDeclaration).getDelegate();
                    Intrinsics.checkNotNull((Object)firExpression3);
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firExpression3.getSource(), FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_VALUE_CLASS(), (DiagnosticContext)context8, null, 8, null);
                    continue;
                }
                context8 = (CheckerContext)((MutableDiagnosticContext)context2);
                boolean bl7 = false;
                FirExpression firExpression4 = ((FirProperty)innerDeclaration).getDelegate();
                Intrinsics.checkNotNull((Object)firExpression4);
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firExpression4.getSource(), FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_VALUE_CLASS(), (DiagnosticContext)context8, null, 8, null);
                continue;
            }
            if (!DeclarationAttributesKt.getHasBackingField((FirProperty)innerDeclaration)) continue;
            KtSourceElement ktSourceElement = innerDeclaration.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, innerDeclaration, FirErrors.INSTANCE.getPROPERTY_WITH_BACKING_FIELD_INSIDE_VALUE_CLASS(), context2, null, 8, null);
        }
        Object object = primaryConstructor2;
        if (!((object != null && (object = ((FirConstructor)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtRealSourceElementKind)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_VALUE_CLASS(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        if (primaryConstructorParameter == null) {
            FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, primaryConstructor2, FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE(), context2, null, 8, null);
            return;
        }
        boolean $i$f$withSuppressedDiagnostics = false;
        List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(primaryConstructor2);
        if (arguments$iv != null) {
            DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            if (diagnosticContext == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
            }
            context3 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
            boolean bl8 = false;
            FirAnnotationContainer annotationContainer$iv = (FirAnnotationContainer)primaryConstructorParameter;
            boolean $i$f$withSuppressedDiagnostics2 = false;
            List<String> arguments$iv2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(annotationContainer$iv);
            if (arguments$iv2 != null) {
                DiagnosticContext diagnosticContext2 = ((MutableDiagnosticContext)context3).addSuppressedDiagnostics((Collection<String>)arguments$iv2, arguments$iv2.contains("infos"), arguments$iv2.contains("warnings"), arguments$iv2.contains("errors"));
                if (diagnosticContext2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                CheckerContext context9 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext2));
                bl = false;
                if (INSTANCE.isNotFinalReadOnly((FirValueParameter)primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirValueParameter)primaryConstructorParameter).getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), (DiagnosticContext)context9, null, 8, null);
                } else if (INSTANCE.isInapplicableParameterType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirValueParameter)primaryConstructorParameter).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), (DiagnosticContext)context9, null, 16, null);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context9.getSession())) {
                    FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), context9, null, 8, null);
                }
            } else {
                CheckerContext context10 = (CheckerContext)((MutableDiagnosticContext)context3);
                bl = false;
                if (INSTANCE.isNotFinalReadOnly((FirValueParameter)primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirValueParameter)primaryConstructorParameter).getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), (DiagnosticContext)context10, null, 8, null);
                } else if (INSTANCE.isInapplicableParameterType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirValueParameter)primaryConstructorParameter).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), (DiagnosticContext)context10, null, 16, null);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context10.getSession())) {
                    FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), context10, null, 8, null);
                }
            }
        } else {
            context3 = (CheckerContext)((MutableDiagnosticContext)context2);
            boolean bl9 = false;
            FirAnnotationContainer annotationContainer$iv = (FirAnnotationContainer)primaryConstructorParameter;
            boolean $i$f$withSuppressedDiagnostics3 = false;
            List<String> arguments$iv3 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(annotationContainer$iv);
            if (arguments$iv3 != null) {
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context3).addSuppressedDiagnostics((Collection<String>)arguments$iv3, arguments$iv3.contains("infos"), arguments$iv3.contains("warnings"), arguments$iv3.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                CheckerContext context11 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                bl = false;
                if (INSTANCE.isNotFinalReadOnly((FirValueParameter)primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirValueParameter)primaryConstructorParameter).getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), (DiagnosticContext)context11, null, 8, null);
                } else if (INSTANCE.isInapplicableParameterType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirValueParameter)primaryConstructorParameter).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), (DiagnosticContext)context11, null, 16, null);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context11.getSession())) {
                    FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), context11, null, 8, null);
                }
            } else {
                CheckerContext context12 = (CheckerContext)((MutableDiagnosticContext)context3);
                bl = false;
                if (INSTANCE.isNotFinalReadOnly((FirValueParameter)primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirValueParameter)primaryConstructorParameter).getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), (DiagnosticContext)context12, null, 8, null);
                } else if (INSTANCE.isInapplicableParameterType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirValueParameter)primaryConstructorParameter).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), (DiagnosticContext)context12, null, 16, null);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context12.getSession())) {
                    FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), context12, null, 8, null);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelatedToParameter(FirProperty $this$isRelatedToParameter, FirValueParameter parameter) {
        FirValueParameter firValueParameter = parameter;
        if (!Intrinsics.areEqual((Object)$this$isRelatedToParameter.getName(), (Object)(firValueParameter != null ? firValueParameter.getName() : null))) return false;
        KtSourceElement ktSourceElement = $this$isRelatedToParameter.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) return false;
        return true;
    }

    private final boolean isNotFinalReadOnly(FirValueParameter $this$isNotFinalReadOnly, FirProperty primaryConstructorProperty) {
        if (primaryConstructorProperty == null) {
            return true;
        }
        FirElement firElement = $this$isNotFinalReadOnly;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OPEN_KEYWORD");
        boolean isOpen = FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken);
        return $this$isNotFinalReadOnly.isVararg() || !primaryConstructorProperty.isVal() || isOpen;
    }

    private final boolean isInapplicableParameterType(FirTypeRef $this$isInapplicableParameterType) {
        return FirTypeUtilsKt.isUnit($this$isInapplicableParameterType) || FirTypeUtilsKt.isNothing($this$isInapplicableParameterType) || FirTypeUtilsKt.getConeType($this$isInapplicableParameterType) instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(FirTypeUtilsKt.getConeType($this$isInapplicableParameterType));
    }

    private final boolean isGenericArrayOfTypeParameter(ConeKotlinType $this$isGenericArrayOfTypeParameter) {
        if (ArraysKt.firstOrNull((Object[])$this$isGenericArrayOfTypeParameter.getTypeArguments()) instanceof ConeStarProjection || !ArrayUtilsKt.isPotentiallyArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$isGenericArrayOfTypeParameter);
        if (coneKotlinType == null || (coneKotlinType = coneKotlinType.getType()) == null) {
            return false;
        }
        ConeKotlinType arrayElementType = coneKotlinType;
        return arrayElementType instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(arrayElementType);
    }

    private final boolean isRecursiveInlineClassType(ConeKotlinType $this$isRecursiveInlineClassType, FirSession session) {
        return this.isRecursiveInlineClassType($this$isRecursiveInlineClassType, new HashSet<ConeKotlinType>(), session);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRecursiveInlineClassType(ConeKotlinType $this$isRecursiveInlineClassType, HashSet<ConeKotlinType> visited2, FirSession session) {
        ConeKotlinType coneKotlinType;
        Object v1;
        Object object;
        block5: {
            void $this$firstOrNull$iv;
            if (!visited2.add($this$isRecursiveInlineClassType)) {
                return true;
            }
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol($this$isRecursiveInlineClassType, session);
            if (firRegularClassSymbol == null) {
                return false;
            }
            FirRegularClassSymbol asRegularClass = firRegularClassSymbol;
            if (!DeclarationUtilsKt.isInlineOrValueClass(asRegularClass)) {
                return false;
            }
            object = asRegularClass.getDeclarationSymbols();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirBasedSymbol it = (FirBasedSymbol)element$iv;
                boolean bl = false;
                if (!(it instanceof FirConstructorSymbol && ((FirConstructorSymbol)it).isPrimary())) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        FirConstructorSymbol firConstructorSymbol = v1;
        if (firConstructorSymbol == null) {
            return false;
        }
        FirConstructorSymbol primaryConstructor2 = firConstructorSymbol;
        FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)CollectionsKt.firstOrNull(primaryConstructor2.getValueParameterSymbols());
        return firValueParameterSymbol != null && (object = firValueParameterSymbol.getResolvedReturnTypeRef()) != null && (coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? this.isRecursiveInlineClassType(coneKotlinType, visited2, session) : false;
    }

    private final boolean isSubtypeOfCloneable(FirRegularClass $this$isSubtypeOfCloneable, FirSession session) {
        boolean bl;
        block4: {
            if (this.isCloneableId(FirDeclarationUtilKt.getClassId($this$isSubtypeOfCloneable))) {
                return true;
            }
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default($this$isSubtypeOfCloneable, true, true, session, false, null, 32, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType superType2 = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    Object object = superType2 instanceof ConeClassLikeType ? superType2 : null;
                    boolean bl3 = object != null && (object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)object, session, null, 2, null)) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null && (object = ((ConeClassLikeLookupTag)object).getClassId()) != null ? INSTANCE.isCloneableId((ClassId)object) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isCloneableId(ClassId $this$isCloneableId) {
        return Intrinsics.areEqual((Object)$this$isCloneableId.getRelativeClassName(), (Object)cloneableFqName) && Intrinsics.areEqual((Object)$this$isCloneableId.getPackageFqName(), (Object)StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) || Intrinsics.areEqual((Object)$this$isCloneableId.getPackageFqName(), (Object)javaLangFqName);
    }

    static {
        Object[] objectArray = new String[]{"box", "unbox", "equals", "hashCode"};
        reservedFunctionNames = SetsKt.setOf((Object[])objectArray);
        javaLangFqName = new FqName("java.lang");
        cloneableFqName = new FqName("Cloneable");
    }
}

