/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumCompanionInEnumConstructorCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumEntryChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "Visitor", "checkers"})
public final class FirEnumCompanionInEnumConstructorCallChecker
extends FirDeclarationChecker<FirEnumEntry> {
    @NotNull
    public static final FirEnumCompanionInEnumConstructorCallChecker INSTANCE = new FirEnumCompanionInEnumConstructorCallChecker();

    private FirEnumCompanionInEnumConstructorCallChecker() {
    }

    @Override
    public void check(@NotNull FirEnumEntry declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object v0;
        block10: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Iterable $this$lastIsInstanceOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Object element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirRegularClass)) continue;
                        v0 = element$iv;
                        break block10;
                    } while (0 <= n);
                }
                v0 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirRegularClass)) continue;
                    v0 = element$iv$iv;
                    break block10;
                }
                v0 = null;
            }
        }
        FirRegularClass firRegularClass = v0;
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass enumClass2 = firRegularClass;
        if (enumClass2.getClassKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = enumClass2.getCompanionObjectSymbol();
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol companionOfEnumSymbol = firRegularClassSymbol;
        FirExpression $this$firstIsInstanceOrNull$iv$iv = declaration.getInitializer();
        FirPureAbstractElement firPureAbstractElement = $this$firstIsInstanceOrNull$iv$iv instanceof FirAnonymousObjectExpression ? (FirAnonymousObjectExpression)$this$firstIsInstanceOrNull$iv$iv : null;
        if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getAnonymousObject()) == null) {
            return;
        }
        FirPureAbstractElement initializerObject = firPureAbstractElement;
        Object object = DeclarationUtilsKt.primaryConstructorIfAny((FirClass)initializerObject, context2.getSession());
        if (object == null || (object = ((FirConstructorSymbol)object).getResolvedDelegatedConstructorCall()) == null) {
            return;
        }
        Object delegatingConstructorCall = object;
        Visitor visitor2 = new Visitor(context2, reporter, companionOfEnumSymbol);
        ((FirDelegatedConstructorCall)delegatingConstructorCall).getArgumentList().acceptChildren(visitor2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumCompanionInEnumConstructorCallChecker$Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "companionSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)V", "getCompanionSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkQualifiedAccess", "", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "checkers"})
    private static final class Visitor
    extends FirVisitorVoid {
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final DiagnosticReporter reporter;
        @NotNull
        private final FirRegularClassSymbol companionSymbol;

        public Visitor(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClassSymbol companionSymbol) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)companionSymbol, (String)"companionSymbol");
            this.context = context2;
            this.reporter = reporter;
            this.companionSymbol = companionSymbol;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @NotNull
        public final FirRegularClassSymbol getCompanionSymbol() {
            return this.companionSymbol;
        }

        @Override
        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this);
        }

        @Override
        public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                boolean needVisitReceiver = this.checkQualifiedAccess(functionCall);
                functionCall.getArgumentList().acceptChildren(this);
                if (!needVisitReceiver) break block1;
                FirExpression firExpression2 = functionCall.getExplicitReceiver();
                if (firExpression2 != null) {
                    firExpression2.accept(this);
                }
            }
        }

        @Override
        public void visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
                boolean needVisitReceiver = this.checkQualifiedAccess(propertyAccessExpression);
                if (!needVisitReceiver) break block1;
                FirExpression firExpression2 = propertyAccessExpression.getExplicitReceiver();
                if (firExpression2 != null) {
                    firExpression2.accept(this);
                }
            }
        }

        private final boolean checkQualifiedAccess(FirQualifiedAccessExpression expression2) {
            FirRegularClassSymbol firRegularClassSymbol;
            FirResolvedTypeRef firResolvedTypeRef;
            FirExpression extensionReceiver = expression2.getExtensionReceiver();
            if (!(extensionReceiver instanceof FirResolvedQualifier) && !(extensionReceiver instanceof FirThisReceiverExpression)) {
                return true;
            }
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(expression2);
            if (firCallableSymbol == null || (firResolvedTypeRef = firCallableSymbol.getResolvedReceiverTypeRef()) == null || (firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(firResolvedTypeRef, this.context.getSession())) == null) {
                return true;
            }
            FirRegularClassSymbol receiverSymbol = firRegularClassSymbol;
            if (Intrinsics.areEqual((Object)receiverSymbol, (Object)this.companionSymbol)) {
                KtSourceElement ktSourceElement = expression2.getExtensionReceiver().getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = expression2.getSource();
                }
                KtSourceElement source = ktSourceElement;
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNINITIALIZED_ENUM_COMPANION(), (Object)this.companionSymbol, (DiagnosticContext)this.context, null, 16, null);
                return false;
            }
            return true;
        }
    }
}

