/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConstChecksKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationClassMember", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isAllowedArray", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isAllowedClassKind", "cone", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "checkers"})
public final class FirAnnotationClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirAnnotationClassDeclarationChecker INSTANCE = new FirAnnotationClassDeclarationChecker();

    private FirAnnotationClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirClassLikeDeclaration $this$isLocal$iv = declaration;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getLOCAL_ANNOTATION_CLASS_ERROR(), (DiagnosticContext)context2, null, 8, null);
        }
        if (declaration.getSuperTypeRefs().size() != 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getSUPERTYPES_FOR_ANNOTATION_CLASS(), (DiagnosticContext)context2, null, 8, null);
        }
        for (FirDeclaration member2 : declaration.getDeclarations()) {
            this.checkAnnotationClassMember(member2, context2, reporter);
        }
        if (FirAnnotationHelpersKt.getRetention(declaration) != AnnotationRetention.SOURCE && FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration).contains((Object)KotlinTarget.EXPRESSION)) {
            FirElement firElement;
            FirAnnotation firAnnotation = FirAnnotationHelpersKt.getRetentionAnnotation(declaration);
            if (firAnnotation != null) {
                firElement = firAnnotation;
            } else {
                FirAnnotation firAnnotation2 = FirAnnotationHelpersKt.getTargetAnnotation(declaration);
                firElement = firAnnotation2 != null ? (FirElement)firAnnotation2 : (FirElement)declaration;
            }
            FirElement target = firElement;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirPureAbstractElement)target).getSource(), FirErrors.INSTANCE.getRESTRICTED_RETENTION_FOR_EXPRESSION_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkAnnotationClassMember(FirDeclaration member2, CheckerContext context2, DiagnosticReporter reporter) {
        block12: {
            block14: {
                block13: {
                    block11: {
                        if (!(member2 instanceof FirConstructor) || !((FirConstructor)member2).isPrimary()) break block11;
                        for (FirValueParameter parameter : ((FirConstructor)member2).getValueParameters()) {
                            ClassId classId;
                            ConeLookupTagBasedType coneType;
                            FirTypeRef typeRef;
                            KtSourceElement source;
                            if (parameter.getSource() == null) continue;
                            if (!LightTreePositioningStrategiesKt.hasValOrVar(source)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                            } else if (LightTreePositioningStrategiesKt.hasVar(source)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                            }
                            FirExpression defaultValue = parameter.getDefaultValue();
                            if (defaultValue != null && FirConstChecksKt.checkConstantArguments(defaultValue, context2.getSession()) != null) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)defaultValue.getSource(), FirErrors.INSTANCE.getANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT(), (DiagnosticContext)context2, null, 8, null);
                            }
                            FirTypeRef $this$coneTypeSafe$iv = typeRef = parameter.getReturnTypeRef();
                            boolean $i$f$coneTypeSafe = false;
                            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                            if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                                coneKotlinType = null;
                            }
                            ConeLookupTagBasedType coneLookupTagBasedType = coneType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType));
                            ClassId classId2 = classId = coneLookupTagBasedType != null ? ConeTypeUtilsKt.getClassId(coneLookupTagBasedType) : null;
                            if (coneType == null || Intrinsics.areEqual((Object)classId, (Object)ClassId.fromString("<error>"))) continue;
                            if (ConeTypeUtilsKt.isNullable(coneType)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_TYPE_OF_ANNOTATION_MEMBER(), (DiagnosticContext)context2, null, 8, null);
                                continue;
                            }
                            if (ConeTypeUtilsKt.isPrimitiveOrNullablePrimitive(coneType) || ConeTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(coneType) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getKClass()) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getString()) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values(), (Object)classId) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getUnsignedArrayTypeByElementType().values(), (Object)classId)) continue;
                            if (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getArray())) {
                                if (this.isAllowedArray(typeRef, context2.getSession())) continue;
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), (DiagnosticContext)context2, null, 8, null);
                                continue;
                            }
                            if (this.isAllowedClassKind(coneType, context2.getSession())) continue;
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), (DiagnosticContext)context2, null, 8, null);
                        }
                        break block12;
                    }
                    if (member2 instanceof FirRegularClass) break block12;
                    if (!(member2 instanceof FirProperty)) break block13;
                    KtSourceElement ktSourceElement = member2.getSource();
                    if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.VALUE_PARAMETER)) break block12;
                }
                if (!(member2 instanceof FirSimpleFunction)) break block14;
                KtSourceElement ktSourceElement = member2.getSource();
                if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.FUN)) break block12;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)member2.getSource(), FirErrors.INSTANCE.getANNOTATION_CLASS_MEMBER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean isAllowedClassKind(ConeLookupTagBasedType cone, FirSession session) {
        FirRegularClassSymbol firRegularClassSymbol;
        Object object = LookupTagUtilsKt.toSymbol(cone.getLookupTag(), session);
        FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol = object instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)object : null;
        if (firRegularClassSymbol == null || (object = firRegularClassSymbol.getClassKind()) == null) {
            return false;
        }
        Object typeRefClassKind = object;
        return typeRefClassKind == ClassKind.ANNOTATION_CLASS || typeRefClassKind == ClassKind.ENUM_CLASS;
    }

    private final boolean isAllowedArray(FirTypeRef typeRef, FirSession session) {
        ConeKotlinTypeProjection coneKotlinTypeProjection;
        ConeTypeProjection[] typeArguments2 = FirTypeUtilsKt.getConeType(typeRef).getTypeArguments();
        if (typeArguments2.length != 1) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = typeArguments2[0];
        ConeKotlinTypeProjection coneKotlinTypeProjection2 = coneKotlinTypeProjection = coneTypeProjection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)coneTypeProjection : null;
        if (coneKotlinTypeProjection == null || (coneTypeProjection = coneKotlinTypeProjection.getType()) == null) {
            return false;
        }
        ConeTypeProjection arrayType = coneTypeProjection;
        if (ConeTypeUtilsKt.isNullable((ConeKotlinType)arrayType)) {
            return false;
        }
        ClassId arrayTypeClassId = ConeTypeUtilsKt.getClassId((ConeKotlinType)arrayType);
        if (Intrinsics.areEqual((Object)arrayTypeClassId, (Object)StandardClassIds.INSTANCE.getKClass())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)arrayTypeClassId, (Object)StandardClassIds.INSTANCE.getString())) {
            return true;
        }
        return this.isAllowedClassKind((ConeLookupTagBasedType)arrayType, session);
    }
}

