/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J(\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d*\u0006\u0012\u0002\b\u00030\tH\u0002J\f\u0010\u001e\u001a\u00020\u001d*\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/NewSchemeOfIntegerOperatorResolutionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "literalOperatorsFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkArgument", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "argument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "checkArgumentImpl", "Lorg/jetbrains/kotlin/types/SimpleType;", "argumentExpression", "isIntOperator", "", "needReport", "frontend"})
public final class NewSchemeOfIntegerOperatorResolutionChecker
implements CallChecker {
    @NotNull
    public static final NewSchemeOfIntegerOperatorResolutionChecker INSTANCE;
    @NotNull
    private static final Set<FqName> literalOperatorsFqNames;

    private NewSchemeOfIntegerOperatorResolutionChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.needReport(context2.getLanguageVersionSettings())) {
            return;
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> object2 = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(object2, (String)"resolvedCall.valueArguments");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : object2.entrySet()) {
            KotlinType kotlinType;
            ValueParameterDescriptor valueParameter2 = entry.getKey();
            ResolvedValueArgument arguments2 = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)valueParameter2, (String)"valueParameter");
            if (ArgumentsUtilsKt.isVararg(valueParameter2)) {
                KotlinType kotlinType2 = valueParameter2.getVarargElementType();
                if (kotlinType2 == null) continue;
                kotlinType = kotlinType2;
            } else {
                kotlinType = valueParameter2.getType();
            }
            SimpleType expectedType2 = FlexibleTypesKt.lowerIfFlexible(kotlinType.unwrap());
            if (!TypeUtilsKt.isPrimitiveNumberOrNullableType(expectedType2)) continue;
            for (ValueArgument argument2 : arguments2.getArguments()) {
                KtExpression ktExpression;
                KtExpression ktExpression2 = KtPsiUtil.deparenthesize(argument2.getArgumentExpression());
                if (ktExpression2 == null) continue;
                KtExpression expression2 = ktExpression = ktExpression2;
                this.checkArgumentImpl(expectedType2, expression2, context2.getTrace(), context2.getModuleDescriptor());
            }
        }
    }

    private final boolean needReport(LanguageVersionSettings $this$needReport) {
        return $this$needReport.supportsFeature(LanguageFeature.ReportChangingIntegerOperatorResolve) && !$this$needReport.supportsFeature(LanguageFeature.ApproximateIntegerLiteralTypesInReceiverPosition);
    }

    @JvmStatic
    public static final void checkArgument(@NotNull KotlinType expectedType2, @NotNull KtExpression argument2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)expectedType2, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (!INSTANCE.needReport(languageVersionSettings)) {
            return;
        }
        SimpleType type2 = FlexibleTypesKt.lowerIfFlexible(expectedType2);
        if (TypeUtilsKt.isPrimitiveNumberOrNullableType(type2)) {
            KtExpression ktExpression = KtPsiUtil.deparenthesize(argument2);
            Intrinsics.checkNotNull((Object)ktExpression);
            KtExpression ktExpression2 = ktExpression;
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"deparenthesize(argument)!!");
            INSTANCE.checkArgumentImpl(type2, ktExpression2, trace, moduleDescriptor);
        }
    }

    private final void checkArgumentImpl(SimpleType expectedType2, KtExpression argumentExpression, BindingTrace trace, ModuleDescriptor moduleDescriptor) {
        KotlinType kotlinType;
        Object object;
        IElementType token;
        KtExpression ktExpression;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(argumentExpression, bindingContext2);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> callForArgument = resolvedCall2;
        if (!this.isIntOperator(callForArgument)) {
            return;
        }
        KtElement ktElement = callForArgument.getCall().getCallElement();
        KtExpression ktExpression2 = ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
        if (ktExpression == null) {
            return;
        }
        KtExpression callElement = ktExpression;
        KtExpression ktExpression3 = KtPsiUtil.deparenthesize(callElement);
        Intrinsics.checkNotNull((Object)ktExpression3);
        ktElement = ktExpression3;
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"deparenthesize(callElement)!!");
        KtElement deparenthesizedElement = ktElement;
        if (deparenthesizedElement instanceof KtConstantExpression) {
            return;
        }
        if (deparenthesizedElement instanceof KtUnaryExpression && (Intrinsics.areEqual((Object)(token = ((KtUnaryExpression)deparenthesizedElement).getOperationToken()), (Object)((Object)KtTokens.PLUS)) || Intrinsics.areEqual((Object)token, (Object)((Object)KtTokens.MINUS)))) {
            return;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext2.get(BindingContext.COMPILE_TIME_VALUE, argumentExpression);
        if (compileTimeConstant == null) {
            return;
        }
        CompileTimeConstant compileTimeConstant2 = compileTimeConstant;
        CompileTimeConstant compileTimeValue = compileTimeConstant2;
        if ((compileTimeConstant = compileTimeValue) instanceof IntegerValueTypeConstant) {
            TypeConstructor typeConstructor2 = ((IntegerValueTypeConstant)compileTimeValue).getUnknownIntegerType().getConstructor();
            Object object2 = object = typeConstructor2 instanceof IntegerLiteralTypeConstructor ? (IntegerLiteralTypeConstructor)typeConstructor2 : null;
            if (object == null) {
                return;
            }
            Object valueTypeConstructor = object;
            kotlinType = ((IntegerLiteralTypeConstructor)valueTypeConstructor).getApproximatedType();
        } else if (compileTimeConstant instanceof TypedCompileTimeConstant) {
            SimpleType typeFromCall;
            object = callForArgument.getResultingDescriptor().getReturnType();
            SimpleType simpleType2 = typeFromCall = object == null ? null : FlexibleTypesKt.lowerIfFlexible((KotlinType)object);
            if (typeFromCall != null) {
                kotlinType = typeFromCall;
            } else {
                Long l;
                ConstantValue constantValue = ((TypedCompileTimeConstant)compileTimeValue).getConstantValue();
                if (constantValue instanceof ErrorValue) {
                    return;
                }
                Object t = constantValue.getValue();
                Long l2 = l = t instanceof Long ? (Long)t : null;
                if (l == null) {
                    return;
                }
                long value2 = l;
                kotlinType = new IntegerLiteralTypeConstructor(value2, moduleDescriptor, compileTimeValue.getParameters()).getApproximatedType();
            }
        } else {
            return;
        }
        KotlinType expressionType = kotlinType;
        if (!Intrinsics.areEqual((Object)expressionType.getConstructor(), (Object)expectedType2.getConstructor())) {
            trace.report(Errors.INTEGER_OPERATOR_RESOLVE_WILL_CHANGE.on((KtExpression)((PsiElement)argumentExpression), expressionType));
        }
    }

    private final boolean isIntOperator(ResolvedCall<?> $this$isIntOperator) {
        SimpleFunctionDescriptor simpleFunctionDescriptor;
        Object obj = $this$isIntOperator.getResultingDescriptor();
        SimpleFunctionDescriptor simpleFunctionDescriptor2 = simpleFunctionDescriptor = obj instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)obj : null;
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        SimpleFunctionDescriptor descriptor2 = simpleFunctionDescriptor;
        return literalOperatorsFqNames.contains(DescriptorUtilsKt.getFqNameSafe(descriptor2));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void $this$mapTo$iv;
        INSTANCE = new NewSchemeOfIntegerOperatorResolutionChecker();
        Object object = new String[]{"plus", "minus", "times", "div", "rem", "plus", "minus", "times", "div", "rem", "shl", "shr", "ushr", "and", "or", "xor", "unaryPlus", "unaryMinus", "inv"};
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string2 = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{"kotlin", "Int", it};
            FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf((Object[])objectArray));
            collection.add(fqName2);
        }
        literalOperatorsFqNames = (Set)var1_1;
    }
}

