/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J,\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J(\u0010&\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020%H\u0002J \u0010*\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020%H\u0002J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J \u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u00101\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u0007H\u0002J(\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020!2\u0006\u00104\u001a\u0002052\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u00106\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\tH\u0002J(\u0010:\u001a\u00020\u00182\u0006\u0010;\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00104\u001a\u000205H\u0002J\"\u0010<\u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010=\u001a\u00020\u000eH\u0002J\u0010\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010B\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InlineChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "inlinableKtParameters", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "inlinableParameters", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "kotlin.jvm.PlatformType", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "isEffectivelyPrivateApiFunction", "", "<set-?>", "supportDefaultValueInline", "getSupportDefaultValueInline", "()Z", "setSupportDefaultValueInline", "(Z)V", "supportDefaultValueInline$delegate", "Lkotlin/properties/ReadWriteProperty;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallWithReceiver", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkLambdaInvokeOrExtensionCall", "lambdaDescriptor", "callDescriptor", "receiverExpression", "checkNonLocalReturn", "inlinableParameterDescriptor", "parameterUsage", "checkNotInDefaultParameter", "checkPrivateClassMemberAccess", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkRecursion", "checkSuperCalls", "callableDescriptor", "call", "Lorg/jetbrains/kotlin/psi/Call;", "checkValueParameter", "targetArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "targetParameterDescriptor", "checkVisibilityAndAccess", "calledDescriptor", "getCalleeDescriptor", "unwrapVariableAsFunction", "isDefinedInInlineFunction", "startDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "isInsideCall", "isInvokeOrInlineExtension", "frontend"})
public final class InlineChecker
implements CallChecker {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final EffectiveVisibility inlineFunEffectiveVisibility;
    private final boolean isEffectivelyPrivateApiFunction;
    @NotNull
    private final List<ValueParameterDescriptor> inlinableParameters;
    @NotNull
    private final List<KtElement> inlinableKtParameters;
    @NotNull
    private final ReadWriteProperty supportDefaultValueInline$delegate;

    /*
     * WARNING - void declaration
     */
    public InlineChecker(@NotNull FunctionDescriptor descriptor2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List list2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.descriptor = descriptor2;
        boolean bl = InlineUtil.isInline(this.descriptor);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InlineChecker$22 = false;
            String $i$a$-assert-InlineChecker$22 = Intrinsics.stringPlus((String)"This extension should be created only for inline functions: ", (Object)this.descriptor);
            throw new AssertionError((Object)$i$a$-assert-InlineChecker$22);
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = this.descriptor;
        Object object = this.descriptor.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.visibility");
        this.inlineFunEffectiveVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility(declarationDescriptorWithVisibility, (DescriptorVisibility)object, true);
        this.isEffectivelyPrivateApiFunction = DescriptorUtilsKt.isEffectivelyPrivateApi(this.descriptor);
        object = this.descriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.valueParameters");
        object = (Iterable)object;
        InlineChecker inlineChecker = this;
        boolean $i$f$filter = false;
        void var4_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (!InlineUtil.isInlineParameter(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        inlineChecker.inlinableParameters = list2 = (List)destination$iv$iv;
        $this$filter$iv = this.inlinableParameters;
        inlineChecker = this;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtElement ktElement;
            KtElement ktElement2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl4 = false;
            SourceElement sourceElement = it.getSource();
            KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
            KtElement ktElement3 = ktElement2 = kotlinSourceElement == null ? null : kotlinSourceElement.getPsi();
            if (ktElement2 == null) continue;
            KtElement it$iv$iv = ktElement = ktElement2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        inlineChecker.inlinableKtParameters = list2 = (List)destination$iv$iv;
        this.supportDefaultValueInline$delegate = Delegates.INSTANCE.notNull();
    }

    private final boolean getSupportDefaultValueInline() {
        return (Boolean)this.supportDefaultValueInline$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setSupportDefaultValueInline(boolean bl) {
        this.supportDefaultValueInline$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"resolvedCall.call");
        Call call3 = call2;
        KtExpression ktExpression2 = call3.getCalleeExpression();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression expression2 = ktExpression = ktExpression2;
        this.setSupportDefaultValueInline(context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineDefaultFunctionalParameters));
        Object targetDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(targetDescriptor, (String)"targetDescriptor");
        if (PsiContractsUtilsKt.isFromContractDsl((DeclarationDescriptor)targetDescriptor)) {
            return;
        }
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall2.getDispatchReceiver(), expression2);
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall2.getExtensionReceiver(), expression2);
        if (CollectionsKt.contains((Iterable)this.inlinableParameters, targetDescriptor)) {
            if (this.checkNotInDefaultParameter(context2, expression2) && !this.isInsideCall(expression2)) {
                context2.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
            }
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> object2 = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(object2, (String)"resolvedCall.valueArguments");
        for (Map.Entry entry : object2.entrySet()) {
            ValueParameterDescriptor valueDescriptor = (ValueParameterDescriptor)entry.getKey();
            ResolvedValueArgument value2 = (ResolvedValueArgument)entry.getValue();
            if (value2 instanceof DefaultValueArgument) continue;
            for (ValueArgument argument2 : value2.getArguments()) {
                Intrinsics.checkNotNullExpressionValue((Object)argument2, (String)"argument");
                Intrinsics.checkNotNullExpressionValue((Object)valueDescriptor, (String)"valueDescriptor");
                this.checkValueParameter(context2, (CallableDescriptor)targetDescriptor, argument2, valueDescriptor);
            }
        }
        this.checkVisibilityAndAccess((CallableDescriptor)targetDescriptor, expression2, context2, call3);
        this.checkRecursion(context2, (CallableDescriptor)targetDescriptor, expression2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkNotInDefaultParameter(CallCheckerContext context2, KtExpression expression2) {
        boolean allow;
        void $this$getParentOfType$iv;
        if (!this.getSupportDefaultValueInline()) return true;
        PsiElement psiElement = (PsiElement)expression2;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtParameter ktParameter = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtParameter.class, (boolean)strict$iv);
        if (ktParameter == null) {
            return true;
        }
        PsiElement it = psiElement = ktParameter;
        boolean bl = false;
        if (!this.inlinableKtParameters.contains(it)) {
            return true;
        }
        boolean bl2 = allow = false;
        if (!allow) {
            context2.getTrace().report(Errors.NOT_SUPPORTED_INLINE_PARAMETER_IN_INLINE_PARAMETER_DEFAULT_VALUE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
        }
        boolean bl3 = allow;
        if (!bl3) return false;
        return true;
    }

    private final boolean isInsideCall(KtExpression expression2) {
        KtToken token;
        KtExpression parent2 = KtPsiUtil.getParentCallIfPresent(expression2);
        if (parent2 instanceof KtBinaryExpression && ((token = KtPsiUtil.getOperationToken((KtOperationExpression)parent2)) == KtTokens.EQ || token == KtTokens.ANDAND || token == KtTokens.OROR)) {
            return false;
        }
        if (parent2 != null) {
            PsiElement current = (PsiElement)expression2;
            while (current != parent2) {
                if (current instanceof KtBinaryExpressionWithTypeRHS) {
                    return false;
                }
                PsiElement psiElement = current.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"current.parent");
                current = psiElement;
            }
        }
        return parent2 != null;
    }

    private final void checkValueParameter(CallCheckerContext context2, CallableDescriptor targetDescriptor, ValueArgument targetArgument, ValueParameterDescriptor targetParameterDescriptor) {
        KtExpression ktExpression = targetArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        CallableDescriptor argumentCallee = this.getCalleeDescriptor(context2, argumentExpression, false);
        if (argumentCallee != null && CollectionsKt.contains((Iterable)this.inlinableParameters, (Object)argumentCallee)) {
            if (this.checkNotInDefaultParameter(context2, argumentExpression)) {
                if (InlineUtil.isInline(targetDescriptor) && InlineUtil.isInlineParameter(targetParameterDescriptor)) {
                    if (InlineUtil.allowsNonLocalReturns(argumentCallee) && !InlineUtil.allowsNonLocalReturns(targetParameterDescriptor)) {
                        context2.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on((KtElement)((PsiElement)argumentExpression), argumentExpression));
                    } else {
                        this.checkNonLocalReturn(context2, argumentCallee, argumentExpression);
                    }
                } else {
                    context2.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)argumentExpression), argumentExpression, this.descriptor));
                }
            }
        }
    }

    private final void checkCallWithReceiver(CallCheckerContext context2, CallableDescriptor targetDescriptor, ReceiverValue receiver, KtExpression expression2) {
        if (receiver == null) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        KtExpression receiverExpression = null;
        ReceiverValue receiverValue = receiver;
        if (receiverValue instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = this.getCalleeDescriptor(context2, receiverExpression, true);
        } else if (receiverValue instanceof ExtensionReceiver) {
            boolean bl;
            CallableDescriptor callableDescriptor = ((ExtensionReceiver)receiver).getDeclarationDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"receiver.declarationDescriptor");
            CallableDescriptor extension = callableDescriptor;
            varDescriptor = extension.getExtensionReceiverParameter();
            boolean bl2 = bl = varDescriptor != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = Intrinsics.stringPlus((String)"Extension should have receiverParameterDescriptor: ", (Object)extension);
                throw new AssertionError((Object)string2);
            }
            receiverExpression = expression2;
        } else {
            varDescriptor = null;
            receiverExpression = null;
        }
        if (CollectionsKt.contains((Iterable)this.inlinableParameters, (Object)varDescriptor)) {
            CallableDescriptor callableDescriptor = varDescriptor;
            Intrinsics.checkNotNull((Object)callableDescriptor);
            KtExpression ktExpression = receiverExpression;
            Intrinsics.checkNotNull((Object)ktExpression);
            this.checkLambdaInvokeOrExtensionCall(context2, callableDescriptor, targetDescriptor, ktExpression);
        }
    }

    private final CallableDescriptor getCalleeDescriptor(CallCheckerContext context2, KtExpression expression2, boolean unwrapVariableAsFunction) {
        if (!(expression2 instanceof KtSimpleNameExpression) && !(expression2 instanceof KtThisExpression)) {
            return null;
        }
        KtElement ktElement = expression2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"context.trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilKt.getResolvedCall(ktElement, (BindingContext)((Object)resolvedCall2));
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        resolvedCall2 = thisCall;
        return resolvedCall2 == null ? null : (CallableDescriptor)resolvedCall2.getResultingDescriptor();
    }

    private final void checkLambdaInvokeOrExtensionCall(CallCheckerContext context2, CallableDescriptor lambdaDescriptor, CallableDescriptor callDescriptor, KtExpression receiverExpression) {
        boolean inlinableCall = this.isInvokeOrInlineExtension(callDescriptor);
        if (!inlinableCall) {
            context2.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)receiverExpression), receiverExpression, this.descriptor));
        } else {
            this.checkNonLocalReturn(context2, lambdaDescriptor, receiverExpression);
        }
    }

    private final void checkRecursion(CallCheckerContext context2, CallableDescriptor targetDescriptor, KtElement expression2) {
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context2.getTrace().report(Errors.RECURSION_IN_INLINE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInvokeOrInlineExtension(CallableDescriptor descriptor2) {
        if (!(descriptor2 instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.getContainingDeclaration()");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (Intrinsics.areEqual((Object)descriptor2.getName(), (Object)OperatorNameConventions.INVOKE) && containingDeclaration instanceof ClassDescriptor) {
            SimpleType simpleType2 = ((ClassDescriptor)containingDeclaration).getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"containingDeclaration.defaultType");
            if (FunctionTypesKt.isBuiltinFunctionalType(simpleType2)) {
                return true;
            }
        }
        boolean bl = false;
        boolean isInvoke = bl;
        if (isInvoke) return true;
        if (!InlineUtil.isInline(descriptor2)) return false;
        return true;
    }

    private final void checkVisibilityAndAccess(CallableDescriptor calledDescriptor, KtElement expression2, CallCheckerContext context2, Call call2) {
        EffectiveVisibility effectiveVisibility;
        if (this.isDefinedInInlineFunction(calledDescriptor)) {
            effectiveVisibility = EffectiveVisibility.Public.INSTANCE;
        } else {
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = calledDescriptor;
            DescriptorVisibility descriptorVisibility = calledDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"calledDescriptor.visibility");
            effectiveVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility(declarationDescriptorWithVisibility, descriptorVisibility, true);
        }
        EffectiveVisibility calledFunEffectiveVisibility = effectiveVisibility;
        boolean isCalledFunPublicOrPublishedApi = calledFunEffectiveVisibility.getPublicApi();
        boolean isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
        if (isInlineFunPublicOrPublishedApi && !isCalledFunPublicOrPublishedApi && calledDescriptor.getVisibility() != DescriptorVisibilities.LOCAL) {
            context2.getTrace().report(Errors.NON_PUBLIC_CALL_FROM_PUBLIC_INLINE.on((KtElement)((PsiElement)expression2), calledDescriptor, this.descriptor));
        } else {
            this.checkPrivateClassMemberAccess(calledDescriptor, expression2, context2);
            if (isInlineFunPublicOrPublishedApi) {
                this.checkSuperCalls(calledDescriptor, call2, expression2, context2);
            }
        }
        boolean isConstructorCall = calledDescriptor instanceof ConstructorDescriptor;
        if (!(isConstructorCall && expression2 instanceof KtConstructorCalleeExpression || !isInlineFunPublicOrPublishedApi || this.inlineFunEffectiveVisibility.toVisibility() == Visibilities.Protected.INSTANCE || calledFunEffectiveVisibility.toVisibility() != Visibilities.Protected.INSTANCE)) {
            if (isConstructorCall) {
                context2.getTrace().report(Errors.PROTECTED_CONSTRUCTOR_CALL_FROM_PUBLIC_INLINE.on(context2.getLanguageVersionSettings(), (PsiElement)expression2, calledDescriptor));
            } else {
                context2.getTrace().report(Errors.PROTECTED_CALL_FROM_PUBLIC_INLINE.on(context2.getLanguageVersionSettings(), (PsiElement)expression2, calledDescriptor));
            }
        }
    }

    private final void checkPrivateClassMemberAccess(DeclarationDescriptor declarationDescriptor, KtElement expression2, CallCheckerContext context2) {
        if (!this.isEffectivelyPrivateApiFunction && DescriptorUtilsKt.isInsidePrivateClass(declarationDescriptor)) {
            context2.getTrace().report(Errors.PRIVATE_CLASS_MEMBER_FROM_INLINE.on((KtElement)((PsiElement)expression2), declarationDescriptor, this.descriptor));
        }
    }

    private final void checkSuperCalls(CallableDescriptor callableDescriptor, Call call2, KtElement expression2, CallCheckerContext context2) {
        KtSuperExpression superCall = CallResolverUtilKt.getSuperCallExpression(call2);
        if (superCall != null) {
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility;
            KotlinType kotlinType = (KotlinType)context2.getTrace().get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, superCall);
            if (kotlinType == null) {
                return;
            }
            KotlinType thisTypeForSuperCall = kotlinType;
            ClassifierDescriptor classifierDescriptor = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility2 = declarationDescriptorWithVisibility = classifierDescriptor instanceof DeclarationDescriptorWithVisibility ? (DeclarationDescriptorWithVisibility)((Object)classifierDescriptor) : null;
            if (declarationDescriptorWithVisibility == null) {
                return;
            }
            DeclarationDescriptorWithVisibility descriptor2 = declarationDescriptorWithVisibility;
            if (!this.isDefinedInInlineFunction(descriptor2)) {
                context2.getTrace().report(Errors.SUPER_CALL_FROM_PUBLIC_INLINE.on(context2.getLanguageVersionSettings(), (PsiElement)((declarationDescriptorWithVisibility = expression2.getParent().getParent()) == null ? (PsiElement)superCall : declarationDescriptorWithVisibility), callableDescriptor));
            }
        }
    }

    private final boolean isDefinedInInlineFunction(DeclarationDescriptorWithVisibility startDescriptor) {
        DeclarationDescriptorWithVisibility parent2 = startDescriptor;
        while (parent2 != null) {
            if (parent2.getContainingDeclaration() == this.descriptor) {
                return true;
            }
            parent2 = DescriptorUtils.getParentOfType(parent2, DeclarationDescriptorWithVisibility.class);
        }
        return false;
    }

    private final void checkNonLocalReturn(CallCheckerContext context2, CallableDescriptor inlinableParameterDescriptor, KtExpression parameterUsage) {
        if (!InlineUtil.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineUtil.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context2.getResolutionContext())) {
            context2.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on((KtElement)((PsiElement)parameterUsage), parameterUsage));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(InlineChecker.class), "supportDefaultValueInline", "getSupportDefaultValueInline()Z")))};
        $$delegatedProperties = kPropertyArray;
    }
}

