/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.AbstractDeclarationVisitor;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0014J\"\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u001bH\u0016J \u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020!H\u0016J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010%\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor;", "Lorg/jetbrains/kotlin/js/translate/declaration/AbstractDeclarationVisitor;", "containingClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "enumInitializer", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;)V", "enumEntries", "", "getEnumEntries", "()Ljava/util/List;", "enumEntryOrdinal", "", "enumInitializerName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getEnumInitializerName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "initializerStatements", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "getInitializerStatements", "addFunction", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "psi", "Lorg/jetbrains/kotlin/psi/KtElement;", "addInitializerStatement", "statement", "addProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getter", "setter", "generateClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "needCompanionInitializer", "", "getBackingFieldReference", "visitAnonymousInitializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "visitClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "data", "js.translator"})
public final class DeclarationBodyVisitor
extends AbstractDeclarationVisitor {
    @NotNull
    private final ClassDescriptor containingClass;
    @NotNull
    private final TranslationContext context;
    @Nullable
    private final JsFunction enumInitializer;
    private int enumEntryOrdinal;
    @NotNull
    private final List<JsStatement> initializerStatements;
    @NotNull
    private final List<ClassDescriptor> enumEntries;

    public DeclarationBodyVisitor(@NotNull ClassDescriptor containingClass, @NotNull TranslationContext context2, @Nullable JsFunction enumInitializer) {
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.containingClass = containingClass;
        this.context = context2;
        this.enumInitializer = enumInitializer;
        this.initializerStatements = new ArrayList();
        this.enumEntries = new ArrayList();
    }

    @NotNull
    public final List<JsStatement> getInitializerStatements() {
        return this.initializerStatements;
    }

    @NotNull
    public final List<ClassDescriptor> getEnumEntries() {
        return this.enumEntries;
    }

    @Override
    @Nullable
    public JsName getEnumInitializerName() {
        JsFunction jsFunction = this.enumInitializer;
        return jsFunction == null ? null : jsFunction.getName();
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super.visitClassOrObject(classOrObject, context2);
        if (classOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)classOrObject).isCompanion() && this.containingClass.getKind() != ClassKind.ENUM_CLASS) {
            ClassDescriptor descriptor2 = (ClassDescriptor)BindingUtils.getDescriptorForElement(context2.bindingContext(), classOrObject);
            JsStatement jsStatement = ((JsExpression)new JsInvocation((JsExpression)context2.getNameForObjectInstance(descriptor2).makeRef(), new JsExpression[0]).source(classOrObject)).makeStmt();
            Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"JsInvocation(context.get\u2026classOrObject).makeStmt()");
            this.addInitializerStatement(jsStatement);
        }
    }

    public final void generateClassOrObject(@NotNull KtPureClassOrObject classOrObject, @NotNull TranslationContext context2, boolean needCompanionInitializer) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ClassTranslator.Companion.translate(classOrObject, context2);
        Object object = BindingUtils.getClassDescriptor(context2.bindingContext(), classOrObject);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getClassDescriptor(conte\u2026Context(), classOrObject)");
        ClassDescriptor descriptor2 = object;
        context2.export(descriptor2);
        if (needCompanionInitializer) {
            object = ((JsExpression)new JsInvocation((JsExpression)context2.getNameForObjectInstance(descriptor2).makeRef(), new JsExpression[0]).source(classOrObject)).makeStmt();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JsInvocation(context.get\u2026classOrObject).makeStmt()");
            this.addInitializerStatement((JsStatement)object);
        }
    }

    public static /* synthetic */ void generateClassOrObject$default(DeclarationBodyVisitor declarationBodyVisitor, KtPureClassOrObject ktPureClassOrObject, TranslationContext translationContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        declarationBodyVisitor.generateClassOrObject(ktPureClassOrObject, translationContext, bl);
    }

    @Override
    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsFunction jsFunction = this.enumInitializer;
        Intrinsics.checkNotNull((Object)jsFunction);
        JsFunction enumInitializer = jsFunction;
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context2.bindingContext(), enumEntry);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getClassDescriptor(conte\u2026dingContext(), enumEntry)");
        ClassDescriptor descriptor2 = classDescriptor;
        Object object = JsDescriptorUtils.getSupertypesWithoutFakes(descriptor2);
        Intrinsics.checkNotNullExpressionValue(object, (String)"getSupertypesWithoutFakes(descriptor)");
        List<KotlinType> supertypes2 = object;
        object = this;
        Collection<JsStatement> collection = ((DeclarationBodyVisitor)((Object)object)).enumEntries;
        collection.add((JsStatement)((Object)descriptor2));
        if (enumEntry.getBody() != null || supertypes2.size() > 1) {
            object = enumInitializer.getName();
            Intrinsics.checkNotNullExpressionValue(object, (String)"enumInitializer.name");
            ClassTranslator.Companion.translate(enumEntry, context2, (JsName)object, this.enumEntryOrdinal);
            object = enumInitializer.getBody();
            collection = ((JsBlock)object).getStatements();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"enumInitializer.body.statements");
            collection = collection;
            JsStatement jsStatement = ((JsExpression)new JsNew(context2.getInnerReference(descriptor2)).source(enumEntry)).makeStmt();
            collection.add(jsStatement);
        } else {
            boolean bl;
            collection = context2.getInnerNameForDescriptor(descriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"context.getInnerNameForDescriptor(descriptor)");
            List<JsStatement> enumName = collection;
            JsName jsName = JsScope.declareTemporaryName(Intrinsics.stringPlus((String)((JsName)((Object)enumName)).getIdent(), (Object)"_instance"));
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(enumName.ident + \"_instance\")");
            JsName enumInstanceName = jsName;
            boolean bl2 = bl = supertypes2.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22 = false;
                String $i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22 = "Simple Enum entry must have one supertype";
                throw new AssertionError((Object)$i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22);
            }
            SourceInfoAwareJsNode $i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22 = ClassInitializerTranslator.generateEnumEntryInstanceCreation(context2, enumEntry, this.enumEntryOrdinal);
            Intrinsics.checkNotNullExpressionValue((Object)$i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22, (String)"generateEnumEntryInstanc\u2026mEntry, enumEntryOrdinal)");
            JsExpression jsEnumEntryCreation = $i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22;
            context2.addDeclarationStatement(JsAstUtils.newVar(enumInstanceName, null));
            $i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22 = enumInitializer.getBody();
            Object object2 = ((JsBlock)$i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22).getStatements();
            Intrinsics.checkNotNullExpressionValue(object2, (String)"enumInitializer.body.statements");
            object2 = (Collection)object2;
            Collection<JsStatement> collection2 = JsAstUtils.assignment(JsAstUtils.pureFqn(enumInstanceName, null), jsEnumEntryCreation).source(enumEntry).makeStmt();
            object2.add((JsStatement)((Object)collection2));
            object2 = context2.createRootScopedFunction(descriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.createRootScopedFunction(descriptor)");
            Object enumInstanceFunction = object2;
            ((SourceInfoAwareJsNode)enumInstanceFunction).setSource(enumEntry);
            ((JsFunction)enumInstanceFunction).setName(context2.getNameForObjectInstance(descriptor2));
            context2.addDeclarationStatement(((JsExpression)enumInstanceFunction).makeStmt());
            object2 = ((JsFunction)enumInstanceFunction).getBody();
            collection2 = ((JsBlock)object2).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"enumInstanceFunction.body.statements");
            collection2 = collection2;
            JsStatement jsStatement = ((JsExpression)new JsInvocation((JsExpression)JsAstUtils.pureFqn(enumInitializer.getName(), null), new JsExpression[0]).source(enumEntry)).makeStmt();
            collection2.add(jsStatement);
            object2 = ((JsFunction)enumInstanceFunction).getBody();
            collection2 = ((JsBlock)object2).getStatements();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"enumInstanceFunction.body.statements");
            collection2 = collection2;
            JsStatement $this$visitEnumEntry_u24lambda_u2d1 = jsStatement = new JsReturn(enumInstanceName.makeRef().source(enumEntry));
            boolean bl3 = false;
            ((SourceInfoAwareJsNode)((Object)$this$visitEnumEntry_u24lambda_u2d1)).setSource(enumEntry);
            collection2.add(jsStatement);
        }
        context2.export(descriptor2);
        object = this;
        int n = ((DeclarationBodyVisitor)((Object)object)).enumEntryOrdinal;
        ((DeclarationBodyVisitor)((Object)object)).enumEntryOrdinal = n + 1;
    }

    @Override
    public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer expression2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
    }

    @Override
    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, @NotNull TranslationContext data) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
    }

    public final void addInitializerStatement(@NotNull JsStatement statement2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        this.initializerStatements.add(statement2);
    }

    @Override
    public void addFunction(@NotNull FunctionDescriptor descriptor2, @Nullable JsExpression expression2, @Nullable KtElement psi) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!UtilsKt.hasOrInheritsParametersWithDefaultValue(descriptor2) || !ModalityUtilsKt.isOverridableOrOverrides(descriptor2)) {
            if (expression2 != null) {
                this.context.addDeclarationStatement(UtilsKt.addFunctionToPrototype(this.context, this.containingClass, descriptor2, expression2));
            }
        } else {
            Object functionRef;
            JsName jsName = this.context.scope().declareName(Intrinsics.stringPlus((String)this.context.getNameForDescriptor(descriptor2).getIdent(), (Object)"$default"));
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"context.scope().declareN\u2026METER_IMPLEMENTOR_SUFFIX)");
            JsName bodyName = jsName;
            if (expression2 != null) {
                JsExpression jsExpression = JsAstUtils.prototypeOf(this.context.getInnerReference(this.containingClass));
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"prototypeOf(context.getI\u2026ference(containingClass))");
                JsExpression prototypeRef = jsExpression;
                functionRef = new JsNameRef(bodyName, prototypeRef);
                this.context.addDeclarationStatement(JsAstUtils.assignment((JsExpression)functionRef, expression2).makeStmt());
            }
            if (UtilsKt.hasOwnParametersWithDefaultValue(descriptor2)) {
                JsExpression jsExpression;
                JsExpression it;
                Collection collection;
                Iterable<JsExpression> $this$mapTo$iv$iv;
                JsInvocation jsInvocation;
                JsFunction caller = new JsFunction(this.context.getScopeForDescriptor(this.containingClass), new JsBlock(), "");
                functionRef = psi;
                caller.setSource(functionRef == null ? null : UtilsKt.getFinalElement((PsiElement)functionRef));
                Object object = this.context.newDeclaration(descriptor2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context\n                \u2026ewDeclaration(descriptor)");
                TranslationContext translationContext = object;
                object = caller.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"caller.parameters");
                TranslationContext translationContext2 = FunctionTranslatorKt.translateAndAliasParameters(translationContext, descriptor2, (List<JsParameter>)object).innerBlock(caller.getBody());
                Intrinsics.checkNotNullExpressionValue((Object)translationContext2, (String)"context\n                \u2026 .innerBlock(caller.body)");
                TranslationContext callerContext = translationContext2;
                object = JsScope.declareTemporaryName("callback$default");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"declareTemporaryName(\"ca\u2026METER_IMPLEMENTOR_SUFFIX)");
                Object callbackName = object;
                JsExpression callee = new JsNameRef(bodyName, (JsExpression)new JsThisRef()).source(psi);
                JsInvocation $this$addFunction_u24lambda_u2d2 = jsInvocation = new JsInvocation(callee, CollectionsKt.emptyList());
                boolean bl = false;
                $this$addFunction_u24lambda_u2d2.setSource(psi);
                JsInvocation defaultInvocation = jsInvocation;
                $this$addFunction_u24lambda_u2d2 = new JsInvocation((JsExpression)((JsName)callbackName).makeRef(), new JsExpression[0]);
                SourceInfoAwareJsNode $this$addFunction_u24lambda_u2d3 = $this$addFunction_u24lambda_u2d2;
                boolean $i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232 = false;
                $this$addFunction_u24lambda_u2d3.setSource(psi);
                JsInvocation callbackInvocation = $this$addFunction_u24lambda_u2d2;
                JsExpression chosenInvocation = new JsConditional(((JsName)callbackName).makeRef(), callbackInvocation, defaultInvocation).source(psi);
                $this$addFunction_u24lambda_u2d3 = defaultInvocation;
                Object $i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232 = ((JsInvocation)$this$addFunction_u24lambda_u2d3).getArguments();
                Intrinsics.checkNotNullExpressionValue($i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232, (String)"defaultInvocation.arguments");
                $i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232 = (Collection)$i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232;
                Object object2 = caller.getParameters();
                Intrinsics.checkNotNullExpressionValue(object2, (String)"caller.parameters");
                Iterable<JsExpression> $this$map$iv = (List<JsExpression>)object2;
                boolean $i$f$map = false;
                List<JsExpression> list2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv) {
                    JsParameter jsParameter = (JsParameter)t;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    jsExpression = ((JsParameter)((Object)it)).getName().makeRef();
                    collection.add(jsExpression);
                }
                $this$map$iv = (List)destination$iv$iv;
                CollectionsKt.addAll($i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232, (Iterable)$this$map$iv);
                $this$addFunction_u24lambda_u2d3 = callbackInvocation;
                $i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232 = ((JsInvocation)$this$addFunction_u24lambda_u2d3).getArguments();
                Intrinsics.checkNotNullExpressionValue($i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232, (String)"callbackInvocation.arguments");
                $i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232 = (Collection)$i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232;
                $this$map$iv = defaultInvocation.getArguments();
                Intrinsics.checkNotNullExpressionValue($this$map$iv, (String)"defaultInvocation.arguments");
                $this$map$iv = $this$map$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object object3 : $this$mapTo$iv$iv) {
                    it = (JsExpression)object3;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    jsExpression = it.deepCopy();
                    collection.add(jsExpression);
                }
                object2 = (List)destination$iv$iv;
                CollectionsKt.addAll($i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232, object2);
                caller.getParameters().add(new JsParameter((JsName)callbackName));
                $this$addFunction_u24lambda_u2d3 = caller.getBody();
                $i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232 = ((JsBlock)$this$addFunction_u24lambda_u2d3).getStatements();
                Intrinsics.checkNotNullExpressionValue($i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232, (String)"caller.body.statements");
                $i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232 = (Collection)$i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232;
                object2 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, callerContext);
                Intrinsics.checkNotNullExpressionValue(object2, (String)"setDefaultValueForArgume\u2026escriptor, callerContext)");
                object2 = (Iterable)object2;
                CollectionsKt.addAll($i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232, object2);
                KotlinType kotlinType = descriptor2.getReturnType();
                Intrinsics.checkNotNull((Object)kotlinType);
                $i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232 = kotlinType;
                Intrinsics.checkNotNullExpressionValue((Object)$i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232, (String)"descriptor.returnType!!");
                Object returnType2 = $i$a$-apply-DeclarationBodyVisitor$addFunction$callbackInvocation$232;
                object2 = KotlinBuiltIns.isUnit((KotlinType)returnType2) && !descriptor2.isSuspend() ? chosenInvocation.makeStmt() : (JsStatement)new JsReturn(chosenInvocation);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"if (KotlinBuiltIns.isUni\u2026cation)\n                }");
                Object statement2 = object2;
                object2 = caller.getBody();
                Collection<JsStatement> collection2 = ((JsBlock)object2).getStatements();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"caller.body.statements");
                collection2 = collection2;
                collection2.add((JsStatement)statement2);
                this.context.addDeclarationStatement(UtilsKt.addFunctionToPrototype(this.context, this.containingClass, descriptor2, caller));
            }
        }
    }

    @Override
    public void addProperty(@NotNull PropertyDescriptor descriptor2, @NotNull JsExpression getter2, @Nullable JsExpression setter2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)getter2, (String)"getter");
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor2)) {
            JsObjectLiteral jsObjectLiteral;
            JsObjectLiteral $this$addProperty_u24lambda_u2d6 = jsObjectLiteral = new JsObjectLiteral(true);
            boolean bl = false;
            JsObjectLiteral jsObjectLiteral2 = $this$addProperty_u24lambda_u2d6;
            List<JsPropertyInitializer> list2 = jsObjectLiteral2.getPropertyInitializers();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"propertyInitializers");
            ((Collection)list2).add(new JsPropertyInitializer(new JsStringLiteral("configurable"), new JsBooleanLiteral(true)));
            jsObjectLiteral2 = $this$addProperty_u24lambda_u2d6;
            list2 = jsObjectLiteral2.getPropertyInitializers();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"propertyInitializers");
            ((Collection)list2).add(new JsPropertyInitializer(new JsStringLiteral("get"), getter2));
            if (setter2 != null) {
                jsObjectLiteral2 = $this$addProperty_u24lambda_u2d6;
                list2 = jsObjectLiteral2.getPropertyInitializers();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"propertyInitializers");
                ((Collection)list2).add(new JsPropertyInitializer(new JsStringLiteral("set"), setter2));
            }
            JsObjectLiteral literal = jsObjectLiteral;
            UtilsKt.addAccessorsToPrototype(this.context, this.containingClass, descriptor2, literal);
        }
    }

    @Override
    @NotNull
    public JsExpression getBackingFieldReference(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return new JsNameRef(this.context.getNameForBackingField(descriptor2), (JsExpression)new JsThisRef());
    }
}

