/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020#H\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010(\u001a\u00020#J\b\u0010+\u001a\u00020'H\u0016R$\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u0002`\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R.\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\u0013j\u0004\u0018\u0001`\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "value", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "getFields", "()Ljava/util/Map;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Field;", "getOuterClass", "()Lkotlin/Pair;", "setOuterClass", "(Lkotlin/Pair;)V", "receiverClass", "Ljava/lang/Class;", "superWrapperClass", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "getValue", "()Ljava/lang/Object;", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getJavaOriginalName", "", "irFunction", "getMethod", "Ljava/lang/invoke/MethodHandle;", "toString", "Companion", "ir.interpreter"})
public final class Wrapper
implements Complex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object value;
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Pair<? extends IrSymbol, ? extends State> outerClass;
    @NotNull
    private final Class<? extends Object> receiverClass;
    @NotNull
    private static final Map<String, Object> companionObjectValue = MapsKt.mapOf((Pair)TuplesKt.to((Object)"kotlin.text.Regex$Companion", (Object)Regex.Companion));
    @NotNull
    private static final Set<String> intrinsicClasses;
    @NotNull
    private static final Map<String, String> intrinsicFunctionToHandler;

    /*
     * WARNING - void declaration
     */
    public Wrapper(@NotNull Object value2, @NotNull IrClass irClass2, @NotNull IrInterpreterEnvironment environment) {
        IrClass irClass3;
        Object mutableMap;
        Object[] $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.value = value2;
        this.irClass = irClass2;
        this.fields = new LinkedHashMap();
        this.receiverClass = Wrapper.Companion.getClass(IrUtilsKt.getDefaultType(this.getIrClass()), true);
        Class<?> javaClass = this.value.getClass();
        if (Intrinsics.areEqual(javaClass, HashMap.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Pair $this$filterIsInstance$iv;
            IrInterpreterEnvironment $this$single$iv2;
            void $this$mapNotNullTo$iv$iv;
            Object it;
            Class<?>[] classArray = javaClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"javaClass.declaredClasses");
            $this$single$iv = classArray;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv22 = false;
            for (Object element$iv : $this$single$iv) {
                it = (Class)element$iv;
                boolean bl = false;
                String string2 = ((Class)it).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"$Node", (boolean)false, (int)2, null)) continue;
                if (found$iv22) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv22 = true;
            }
            if (!found$iv22) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Class nodeClass = (Class)single$iv;
            Iterable $this$mapNotNull$iv = this.getIrClass().getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable found$iv22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo22 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                IrClass irClass4;
                IrClass irClass5;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl = false;
                IrType it2 = (IrType)element$iv$iv;
                boolean bl2 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it2);
                IrClass irClass6 = irClass5 = irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner();
                if (irClass5 == null) continue;
                IrClass it$iv$iv = irClass4 = irClass5;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$single22 = false;
            Iterable single$iv2 = null;
            boolean found$iv = false;
            Iterator $i$f$mapNotNullTo22 = $this$single$iv2.iterator();
            while ($i$f$mapNotNullTo22.hasNext()) {
                Object element$iv = $i$f$mapNotNullTo22.next();
                IrClass it3 = (IrClass)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it3.getName(), (Object)StandardNames.FqNames.mutableMap.shortName())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv2 = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mutableMap = (IrClass)((Object)single$iv2);
            $this$single$iv2 = environment;
            Map<Class<?>, IrClass> $i$f$single22 = $this$single$iv2.getJavaClassToIrClass$ir_interpreter();
            single$iv2 = mutableMap.getDeclarations();
            Class clazz = nodeClass;
            boolean $i$f$filterIsInstance = false;
            $i$f$mapNotNullTo22 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            $this$filterIsInstance$iv = TuplesKt.to((Object)clazz, (Object)CollectionsKt.single((List)list2));
            $i$f$single22.put((Class<?>)$this$filterIsInstance$iv.getFirst(), (IrClass)$this$filterIsInstance$iv.getSecond());
        } else if (Intrinsics.areEqual(javaClass, LinkedHashMap.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Pair $this$filterIsInstance$iv;
            IrInterpreterEnvironment $this$single$iv3;
            void $this$mapNotNullTo$iv$iv;
            String element$iv$iv;
            mutableMap = javaClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(mutableMap, (String)"javaClass.declaredClasses");
            $this$single$iv = (Object[])mutableMap;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv32 = false;
            for (Object element$iv : $this$single$iv) {
                Class it = (Class)element$iv;
                boolean bl = false;
                element$iv$iv = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv, (String)"it.name");
                if (!StringsKt.contains$default((CharSequence)element$iv$iv, (CharSequence)"$Entry", (boolean)false, (int)2, null)) continue;
                if (found$iv32) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv32 = true;
            }
            if (!found$iv32) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Class entryClass = (Class)single$iv;
            Iterable $this$mapNotNull$iv = this.getIrClass().getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable found$iv32 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo32 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                IrClass irClass7;
                IrClass irClass8;
                element$iv$iv = element$iv$iv$iv;
                boolean bl = false;
                IrType it = (IrType)((Object)element$iv$iv);
                boolean bl4 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it);
                IrClass irClass9 = irClass8 = irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner();
                if (irClass8 == null) continue;
                IrClass it$iv$iv = irClass7 = irClass8;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$single32 = false;
            Iterable single$iv3 = null;
            boolean found$iv = false;
            Iterator $i$f$mapNotNullTo32 = $this$single$iv3.iterator();
            while ($i$f$mapNotNullTo32.hasNext()) {
                Object element$iv = $i$f$mapNotNullTo32.next();
                IrClass it = (IrClass)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)StandardNames.FqNames.mutableMap.shortName())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv3 = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mutableMap = (IrClass)((Object)single$iv3);
            $this$single$iv3 = environment;
            Map<Class<?>, IrClass> $i$f$single32 = $this$single$iv3.getJavaClassToIrClass$ir_interpreter();
            single$iv3 = mutableMap.getDeclarations();
            Class clazz = entryClass;
            boolean $i$f$filterIsInstance = false;
            $i$f$mapNotNullTo32 = $this$filterIsInstance$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof IrClass)) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            List list3 = (List)destination$iv$iv3;
            $this$filterIsInstance$iv = TuplesKt.to((Object)clazz, (Object)CollectionsKt.single((List)list3));
            $i$f$single32.put((Class<?>)$this$filterIsInstance$iv.getFirst(), (IrClass)$this$filterIsInstance$iv.getSecond());
        } else if (Intrinsics.areEqual((Object)javaClass.getCanonicalName(), (Object)"java.util.Collections.SingletonMap")) {
            void $this$filterIsInstanceTo$iv$iv;
            Object $this$filterIsInstance$iv = this.getIrClass().getDeclarations();
            boolean $i$f$filterIsInstance22 = false;
            Iterable $i$f$single32 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            IrClass irClassMapEntry = (IrClass)CollectionsKt.single((List)((List)destination$iv$iv));
            $this$filterIsInstance$iv = environment;
            Map<Class<?>, IrClass> $i$f$filterIsInstance22 = ((IrInterpreterEnvironment)$this$filterIsInstance$iv).getJavaClassToIrClass$ir_interpreter();
            Pair pair = TuplesKt.to(AbstractMap.SimpleEntry.class, (Object)irClassMapEntry);
            $i$f$filterIsInstance22.put((Class<?>)pair.getFirst(), (IrClass)pair.getSecond());
            $this$filterIsInstance$iv = environment;
            $i$f$filterIsInstance22 = ((IrInterpreterEnvironment)$this$filterIsInstance$iv).getJavaClassToIrClass$ir_interpreter();
            pair = TuplesKt.to(AbstractMap.SimpleImmutableEntry.class, (Object)irClassMapEntry);
            $i$f$filterIsInstance22.put((Class<?>)pair.getFirst(), (IrClass)pair.getSecond());
        }
        IrClass it = irClass3 = environment.getJavaClassToIrClass$ir_interpreter().get(this.value.getClass());
        boolean bl = false;
        boolean bl6 = it == null || IrUtilsKt.isSubclassOf(this.getIrClass(), it);
        if (bl6) {
            environment.getJavaClassToIrClass$ir_interpreter().put(this.value.getClass(), this.getIrClass());
        }
    }

    @NotNull
    public final Object getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Pair<IrSymbol, State> getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Pair<? extends IrSymbol, ? extends State> pair) {
        this.outerClass = pair;
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MethodHandle getMethod(@NotNull IrFunction irFunction2) {
        Object object;
        Object v3;
        Object object2;
        block11: {
            void $this$firstOrNull$iv;
            Object object3;
            Object object4;
            String string2;
            IrSimpleFunction irSimpleFunction;
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
            if (irSimpleFunction == null) {
                string2 = null;
            } else {
                object4 = irSimpleFunction.getCorrespondingPropertySymbol();
                if (object4 == null) {
                    string2 = null;
                } else {
                    object3 = (IrProperty)object4.getOwner();
                    object2 = object3.getName();
                    string2 = ((Name)object2).asString();
                }
            }
            String propertyName = string2;
            object4 = new String[2];
            object4[0] = propertyName;
            object3 = propertyName;
            object4[1] = Intrinsics.stringPlus((String)"get", (Object)(object3 == null ? null : CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)object3)));
            object4 = CollectionsKt.listOfNotNull((Object[])object4);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block10: {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Method[] methodArray = this.receiverClass.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"receiverClass.methods");
                    Object[] $this$any$iv = methodArray;
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        Method method = (Method)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)method.getName(), (Object)it)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v3 = element$iv;
                break block11;
            }
            v3 = null;
        }
        String propertyCall = v3;
        String intrinsicName = this.getJavaOriginalName(irFunction2);
        object2 = intrinsicName;
        if (object2 == null) {
            String string3 = propertyCall;
            if (string3 == null) {
                String string4 = irFunction2.getName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"irFunction.name.toString()");
                object = string4;
            } else {
                object = string3;
            }
        } else {
            object = object2;
        }
        Object methodName = object;
        MethodType methodType = Wrapper.Companion.getMethodType(irFunction2);
        return MethodHandles.lookup().findVirtual(this.receiverClass, (String)methodName, methodType);
    }

    private final String getJavaOriginalName(IrFunction irFunction2) {
        String string2;
        switch (UtilsKt.getFqName(UtilsKt.getLastOverridden(irFunction2))) {
            case "kotlin.collections.Map.<get-entries>": {
                string2 = "entrySet";
                break;
            }
            case "kotlin.collections.Map.<get-keys>": {
                string2 = "keySet";
                break;
            }
            case "kotlin.CharSequence.get": {
                string2 = "charAt";
                break;
            }
            case "kotlin.collections.MutableList.removeAt": {
                string2 = "remove";
                break;
            }
            default: {
                string2 = null;
            }
        }
        return string2;
    }

    @NotNull
    public String toString() {
        return this.value.toString();
    }

    @Override
    @Nullable
    public State getField(@NotNull IrSymbol symbol2) {
        return Complex.DefaultImpls.getField(this, symbol2);
    }

    @Override
    @NotNull
    public IrSimpleFunction getRealFunction(@NotNull IrSimpleFunction owner) {
        return Complex.DefaultImpls.getRealFunction(this, owner);
    }

    @Override
    @NotNull
    public String irClassFqName() {
        return Complex.DefaultImpls.irClassFqName(this);
    }

    @Override
    public void loadOuterClassesInto(@NotNull CallStack callStack, @Nullable IrValueSymbol receiver) {
        Complex.DefaultImpls.loadOuterClassesInto(this, callStack, receiver);
    }

    @Override
    public void setField(@NotNull IrSymbol symbol2, @NotNull State state) {
        Complex.DefaultImpls.setField(this, symbol2, state);
    }

    static {
        Object[] objectArray = new String[]{"kotlin.text.StringBuilder", "kotlin.Pair", "kotlin.collections.ArrayList", "kotlin.collections.HashMap", "kotlin.collections.LinkedHashMap", "kotlin.collections.HashSet", "kotlin.collections.LinkedHashSet", "kotlin.text.RegexOption", "kotlin.text.Regex", "kotlin.text.Regex.Companion", "kotlin.text.MatchGroup"};
        intrinsicClasses = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"Array.kotlin.collections.asList()", (Object)"kotlin.collections.ArraysKt"), TuplesKt.to((Object)"kotlin.collections.mutableListOf(Array)", (Object)"kotlin.collections.CollectionsKt"), TuplesKt.to((Object)"kotlin.collections.arrayListOf(Array)", (Object)"kotlin.collections.CollectionsKt"), TuplesKt.to((Object)"Char.kotlin.text.isWhitespace()", (Object)"kotlin.text.CharsKt"), TuplesKt.to((Object)"Array.kotlin.collections.toMutableList()", (Object)"kotlin.collections.ArraysKt"), TuplesKt.to((Object)"Array.kotlin.collections.copyToArrayOfAny(Boolean)", (Object)"kotlin.collections.CollectionsKt")};
        intrinsicFunctionToHandler = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001c\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010 *\u00020!2\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010\u0005*\u00020\u0012H\u0002J\f\u0010$\u001a\u00020%*\u00020\u0012H\u0002J\u0012\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'*\u00020\u0012H\u0002J\f\u0010)\u001a\u00020\u0005*\u00020\u0012H\u0002J\f\u0010*\u001a\u00020\u001c*\u00020\u0012H\u0002J\f\u0010+\u001a\u00020\u001c*\u00020\u0012H\u0002J\u0014\u0010,\u001a\u00020\u001c*\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion;", "", "()V", "companionObjectValue", "", "", "intrinsicClasses", "", "intrinsicFunctionToHandler", "getCompanionObject", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getConstructorMethod", "Ljava/lang/invoke/MethodHandle;", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getEnumEntry", "irEnumClass", "getReflectionMethod", "irFunction", "getStaticGetter", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getStaticMethod", "mustBeHandledWithWrapper", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "getJvmClassName", "getMethodType", "Ljava/lang/invoke/MethodType;", "getOriginalOverriddenSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getSignature", "isExtensionReceiverPrimitive", "isReturnTypePrimitiveAsObject", "isValueParameterPrimitiveAsObject", "index", "", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        private final String getSignature(IrFunction $this$getSignature) {
            String string2;
            IrValueParameter irValueParameter;
            String fqName2 = UtilsKt.getFqName($this$getSignature);
            IrAnnotationContainer irAnnotationContainer = $this$getSignature.getDispatchReceiverParameter();
            IrValueParameter irValueParameter2 = irValueParameter = irAnnotationContainer == null ? $this$getSignature.getExtensionReceiverParameter() : irAnnotationContainer;
            if (irValueParameter == null) {
                string2 = "";
            } else {
                String string3;
                String string4;
                irAnnotationContainer = irValueParameter.getType();
                String it = string4 = (string3 = UtilsKt.getOnlyName((IrType)irAnnotationContainer));
                boolean bl = false;
                string2 = Intrinsics.stringPlus((String)it, (Object)".");
            }
            String receiver = string2;
            return CollectionsKt.joinToString$default((Iterable)$this$getSignature.getValueParameters(), null, (CharSequence)(receiver + fqName2 + '('), (CharSequence)")", (int)0, null, (Function1)getSignature.1.INSTANCE, (int)25, null);
        }

        private final String getJvmClassName(IrFunction $this$getJvmClassName) {
            return (String)intrinsicFunctionToHandler.get(this.getSignature($this$getJvmClassName));
        }

        public final boolean mustBeHandledWithWrapper(@NotNull IrDeclarationWithName declaration) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrDeclarationWithName irDeclarationWithName = declaration;
            if (irDeclarationWithName instanceof IrFunction) {
                Map map = intrinsicFunctionToHandler;
                bl = map.containsKey(this.getSignature((IrFunction)declaration));
            } else {
                String string2;
                String it = string2 = UtilsKt.getFqName(declaration);
                boolean bl2 = false;
                bl = intrinsicClasses.contains(it) || StringsKt.startsWith$default((String)it, (String)"java", (boolean)false, (int)2, null);
            }
            return bl;
        }

        @NotNull
        public final MethodHandle getReflectionMethod(@NotNull IrFunction irFunction2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            Class<? extends Object> receiverClass = this.getClass(irValueParameter.getType(), true);
            MethodType methodType = this.getMethodType(irFunction2);
            Object object2 = irFunction2;
            if (object2 instanceof IrSimpleFunction) {
                Object object3 = ((IrSimpleFunction)irFunction2).getCorrespondingPropertySymbol();
                IrProperty property2 = object3 == null ? null : (IrProperty)object3.getOwner();
                object3 = property2;
                if (Intrinsics.areEqual((Object)(object3 == null ? null : ((IrProperty)object3).getGetter()), (Object)irFunction2)) {
                    object3 = property2.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"property.name.asString()");
                    object = Intrinsics.stringPlus((String)"get", (Object)CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)object3));
                } else {
                    object3 = property2;
                    if (Intrinsics.areEqual((Object)(object3 == null ? null : ((IrProperty)object3).getSetter()), (Object)irFunction2)) {
                        object3 = property2.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"property.name.asString()");
                        object = Intrinsics.stringPlus((String)"set", (Object)CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)object3));
                    } else {
                        object3 = irFunction2.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"irFunction.name.asString()");
                        object = object3;
                    }
                }
            } else {
                String string2 = irFunction2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irFunction.name.asString()");
                object = string2;
            }
            String methodName = object;
            object2 = MethodHandles.lookup().findVirtual(receiverClass, methodName, methodType);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"lookup().findVirtual(rec\u2026, methodName, methodType)");
            return object2;
        }

        @NotNull
        public final Wrapper getCompanionObject(@NotNull IrClass irClass2, @NotNull IrInterpreterEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            String objectName = UtilsKt.internalName(irClass2);
            Object v = companionObjectValue.get(objectName);
            if (v == null) {
                throw new InternalError("Companion object " + objectName + " cannot be interpreted");
            }
            Object objectValue = v;
            return new Wrapper(objectValue, irClass2, environment);
        }

        @Nullable
        public final MethodHandle getConstructorMethod(@NotNull IrFunction irConstructor2) {
            Intrinsics.checkNotNullParameter((Object)irConstructor2, (String)"irConstructor");
            String intrinsicValue = UtilsKt.internalName(IrUtilsKt.getParentAsClass(irConstructor2));
            if (Intrinsics.areEqual((Object)intrinsicValue, (Object)"kotlin.Char") || Intrinsics.areEqual((Object)intrinsicValue, (Object)"kotlin.Long")) {
                return null;
            }
            MethodType methodType = this.getMethodType(irConstructor2);
            return MethodHandles.lookup().findConstructor(this.getClass(irConstructor2.getReturnType(), true), methodType);
        }

        @Nullable
        public final MethodHandle getStaticMethod(@NotNull IrFunction irFunction2) {
            String intrinsicName;
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            String string2 = intrinsicName = this.getJvmClassName(irFunction2);
            if (!(string2 == null ? false : !(((CharSequence)string2).length() == 0))) {
                return null;
            }
            Class<?> jvmClass = Class.forName(intrinsicName);
            MethodType methodType = this.getMethodType(irFunction2);
            return MethodHandles.lookup().findStatic(jvmClass, irFunction2.getName().asString(), methodType);
        }

        @NotNull
        public final MethodHandle getStaticGetter(@NotNull IrField field2) {
            Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
            Class<? extends Object> jvmClass = this.getClass(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(field2)), true);
            Object object = field2.getType();
            IrType it = object;
            boolean bl = false;
            Class<? extends Object> returnType2 = Companion.getClass(it, ((IrSimpleType)it).getHasQuestionMark());
            object = MethodHandles.lookup().findStaticGetter(jvmClass, field2.getName().asString(), returnType2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lookup().findStaticGette\u2026e.asString(), returnType)");
            return object;
        }

        @NotNull
        public final MethodHandle getEnumEntry(@NotNull IrClass irEnumClass) {
            Intrinsics.checkNotNullParameter((Object)irEnumClass, (String)"irEnumClass");
            String intrinsicName = UtilsKt.internalName(irEnumClass);
            Class<?> jvmEnumClass = Class.forName(intrinsicName);
            MethodType methodType = MethodType.methodType(jvmEnumClass, String.class);
            MethodHandle methodHandle = MethodHandles.lookup().findStatic(jvmEnumClass, StandardNames.ENUM_VALUE_OF.getIdentifier(), methodType);
            Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"lookup().findStatic(jvmE\u2026F.identifier, methodType)");
            return methodHandle;
        }

        /*
         * WARNING - void declaration
         */
        private final MethodType getMethodType(IrFunction $this$getMethodType) {
            MethodType methodType;
            MethodType methodType2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$getMethodType.getValueParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Class<? extends Object> clazz = Companion.getClass(it.getType(), Companion.isValueParameterPrimitiveAsObject($this$getMethodType, it.getIndex()));
                collection.add(clazz);
            }
            List argsClasses = (List)destination$iv$iv;
            if ($this$getMethodType instanceof IrSimpleFunction) {
                Class<? extends Object> clazz;
                Class<? extends Object> returnClass = this.getClass($this$getMethodType.getReturnType(), this.isReturnTypePrimitiveAsObject($this$getMethodType));
                IrValueParameter irValueParameter = $this$getMethodType.getExtensionReceiverParameter();
                if (irValueParameter == null) {
                    clazz = null;
                } else {
                    IrType irType = irValueParameter.getType();
                    clazz = this.getClass(irType, this.isExtensionReceiverPrimitive($this$getMethodType));
                }
                Class<? extends Object> extensionClass = clazz;
                methodType2 = MethodType.methodType(returnClass, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(extensionClass), (Iterable)argsClasses));
                Intrinsics.checkNotNullExpressionValue((Object)methodType2, (String)"{\n                // for\u2026rgsClasses)\n            }");
                methodType = methodType2;
            } else {
                methodType2 = MethodType.methodType(Void.TYPE, argsClasses);
                Intrinsics.checkNotNullExpressionValue((Object)methodType2, (String)"{\n                // for\u2026rgsClasses)\n            }");
                methodType = methodType2;
            }
            return methodType;
        }

        private final Class<? extends Object> getClass(IrType $this$getClass, boolean asObject) {
            Class<Object> clazz;
            IrClass owner;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getClass);
            IrClass irClass2 = owner = irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner();
            String fqName2 = irClass2 == null ? null : UtilsKt.getFqName(irClass2);
            IrType notNullType = IrTypesKt.makeNotNull($this$getClass);
            if (IrTypePredicatesKt.isPrimitiveType$default(notNullType, false, 1, null) || IrTypePredicatesKt.isString(notNullType)) {
                Class<?> clazz2 = UtilsKt.getPrimitiveClass(notNullType, asObject);
                clazz = clazz2;
                Intrinsics.checkNotNull(clazz2);
            } else if (IrTypePredicatesKt.isArray(notNullType)) {
                Class clazz3;
                String string2;
                IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)$this$getClass).getArguments()));
                if (irType == null) {
                    string2 = null;
                } else {
                    IrClassSymbol irClassSymbol2 = IrTypesKt.getClassOrNull(irType);
                    if (irClassSymbol2 == null) {
                        string2 = null;
                    } else {
                        IrClass irClass3 = (IrClass)irClassSymbol2.getOwner();
                        string2 = UtilsKt.getFqName(irClass3);
                    }
                }
                String argumentFqName = string2;
                if (argumentFqName != null && !Intrinsics.areEqual(argumentFqName, (Object)"kotlin.Any")) {
                    IrType it = irType = argumentFqName;
                    boolean bl = false;
                    clazz3 = Class.forName("[L" + (String)((Object)it) + ';');
                } else {
                    clazz3 = Object[].class;
                }
                Class<Object[]> clazz4 = clazz3;
                Intrinsics.checkNotNullExpressionValue(clazz4, (String)"{\n                    va\u2026      }\n                }");
                clazz = clazz4;
            } else if (IrTypePredicatesKt.isNothing(notNullType)) {
                clazz = Void.class;
            } else if (IrTypePredicatesKt.isAny(notNullType)) {
                clazz = Object.class;
            } else if (IrTypePredicatesKt.isUnit(notNullType)) {
                if (asObject) {
                    clazz = Void.class;
                } else {
                    Class<Void> clazz5 = Void.TYPE;
                    clazz = clazz5;
                    Intrinsics.checkNotNull(clazz5);
                }
            } else if (IrTypePredicatesKt.isNumber(notNullType)) {
                clazz = Number.class;
            } else if (IrTypePredicatesKt.isCharSequence(notNullType)) {
                clazz = CharSequence.class;
            } else if (IrTypePredicatesKt.isComparable(notNullType)) {
                clazz = Comparable.class;
            } else if (UtilsKt.isThrowable(notNullType)) {
                clazz = Throwable.class;
            } else if (IrTypePredicatesKt.isIterable(notNullType)) {
                clazz = Iterable.class;
            } else if (UtilsKt.isKFunction(notNullType)) {
                Class<?> clazz6 = Class.forName("kotlin.reflect.KFunction");
                Intrinsics.checkNotNullExpressionValue(clazz6, (String)"forName(\"kotlin.reflect.KFunction\")");
                clazz = clazz6;
            } else {
                if (UtilsKt.isFunction(notNullType)) {
                    Class<?> clazz7;
                    Integer n;
                    Object object = fqName2;
                    if (object == null) {
                        n = null;
                    } else {
                        String string3 = StringsKt.removePrefix((String)object, (CharSequence)"kotlin.Function");
                        n = StringsKt.toIntOrNull((String)string3);
                    }
                    Integer arity = n;
                    if (arity == null || arity >= 23) {
                        object = Class.forName("kotlin.jvm.functions.FunctionN");
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forName(\"kotlin.jvm.functions.FunctionN\")");
                        clazz7 = object;
                    } else {
                        object = Class.forName(Intrinsics.stringPlus((String)"kotlin.jvm.functions.", (Object)StringsKt.removePrefix((String)fqName2, (CharSequence)"kotlin.")));
                        Intrinsics.checkNotNullExpressionValue(object, (String)"forName(\"kotlin.jvm.func\u2026emovePrefix(\"kotlin.\")}\")");
                        clazz7 = object;
                    }
                    return clazz7;
                }
                if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.Enum")) {
                    clazz = Enum.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Collection") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableCollection")) {
                    clazz = Collection.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.List") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableList")) {
                    clazz = List.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Set") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableSet")) {
                    clazz = Set.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Map") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableMap")) {
                    clazz = Map.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.ListIterator") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableListIterator")) {
                    clazz = ListIterator.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Iterator") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableIterator")) {
                    clazz = Iterator.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Map.Entry") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableMap.MutableEntry")) {
                    clazz = Map.Entry.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.ArrayList")) {
                    clazz = ArrayList.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.HashMap")) {
                    clazz = HashMap.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.HashSet")) {
                    clazz = HashSet.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.LinkedHashMap")) {
                    clazz = LinkedHashMap.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.LinkedHashSet")) {
                    clazz = LinkedHashSet.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.text.StringBuilder")) {
                    clazz = StringBuilder.class;
                } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.text.Appendable")) {
                    clazz = Appendable.class;
                } else if (fqName2 == null) {
                    clazz = Object.class;
                } else {
                    Class<?> clazz8 = Class.forName(UtilsKt.internalName(owner));
                    Intrinsics.checkNotNullExpressionValue(clazz8, (String)"forName(owner.internalName())");
                    clazz = clazz8;
                }
            }
            return clazz;
        }

        private final List<IrFunctionSymbol> getOriginalOverriddenSymbols(IrFunction $this$getOriginalOverriddenSymbols) {
            List overriddenSymbols2 = new ArrayList();
            if ($this$getOriginalOverriddenSymbols instanceof IrSimpleFunction) {
                Iterator iterator2;
                List pool = CollectionsKt.toMutableList((Collection)((IrSimpleFunction)$this$getOriginalOverriddenSymbols).getOverriddenSymbols());
                ListIterator<IrSimpleFunctionSymbol> iterator3 = pool.listIterator();
                Iterator iterator4 = iterator2 = (Iterator)iterator3;
                while (iterator4.hasNext()) {
                    IrSimpleFunctionSymbol symbol2 = (IrSimpleFunctionSymbol)iterator4.next();
                    if (((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols().isEmpty()) {
                        Collection collection = overriddenSymbols2;
                        collection.add(symbol2);
                        iterator3.remove();
                        continue;
                    }
                    Iterable $this$forEach$iv = ((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl = false;
                        iterator3.add(it);
                    }
                }
            }
            if (overriddenSymbols2.isEmpty()) {
                overriddenSymbols2.add($this$getOriginalOverriddenSymbols.getSymbol());
            }
            return overriddenSymbols2;
        }

        private final boolean isExtensionReceiverPrimitive(IrFunction $this$isExtensionReceiverPrimitive) {
            IrType irType;
            IrValueParameter irValueParameter = $this$isExtensionReceiverPrimitive.getExtensionReceiverParameter();
            return irValueParameter == null ? false : !IrTypePredicatesKt.isPrimitiveType$default(irType = irValueParameter.getType(), false, 1, null);
        }

        private final boolean isReturnTypePrimitiveAsObject(IrFunction $this$isReturnTypePrimitiveAsObject) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isReturnTypePrimitiveAsObject)) {
                if (UtilsKt.isTypeParameter(symbol2.getOwner().getReturnType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getReturnType())) continue;
                return false;
            }
            return true;
        }

        private final boolean isValueParameterPrimitiveAsObject(IrFunction $this$isValueParameterPrimitiveAsObject, int index2) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isValueParameterPrimitiveAsObject)) {
                if (UtilsKt.isTypeParameter(symbol2.getOwner().getValueParameters().get(index2).getType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getValueParameters().get(index2).getType())) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

